/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.SolrException;
import org.apache.solr.update.SolrCmdDistributor;
import org.apache.solr.update.UpdateShardHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingSolrClients {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final int runnerCount = Integer.getInteger("solr.cloud.replication.runners", 1);
    private HttpClient httpClient;
    private Map<String, ConcurrentUpdateSolrClient> solrClients = new HashMap<String, ConcurrentUpdateSolrClient>();
    private List<SolrCmdDistributor.Error> errors = Collections.synchronizedList(new ArrayList());
    private ExecutorService updateExecutor;

    public StreamingSolrClients(UpdateShardHandler updateShardHandler) {
        this.updateExecutor = updateShardHandler.getUpdateExecutor();
        this.httpClient = updateShardHandler.getHttpClient();
    }

    public List<SolrCmdDistributor.Error> getErrors() {
        return this.errors;
    }

    public void clearErrors() {
        this.errors.clear();
    }

    public synchronized SolrClient getSolrClient(SolrCmdDistributor.Req req) {
        String url = this.getFullUrl(req.node.getUrl());
        ConcurrentUpdateSolrClient client = this.solrClients.get(url);
        if (client == null) {
            client = new ErrorReportingConcurrentUpdateSolrClient(url, this.httpClient, 100, this.runnerCount, this.updateExecutor, true, req);
            client.setParser((ResponseParser)new BinaryResponseParser());
            client.setRequestWriter((RequestWriter)new BinaryRequestWriter());
            client.setPollQueueTime(req.pollQueueTime);
            HashSet<String> queryParams = new HashSet<String>(2);
            queryParams.add("distrib.from");
            queryParams.add("update.distrib");
            client.setQueryParams(queryParams);
            this.solrClients.put(url, client);
        }
        return client;
    }

    public synchronized void blockUntilFinished() {
        for (ConcurrentUpdateSolrClient client : this.solrClients.values()) {
            client.blockUntilFinished();
        }
    }

    public synchronized void shutdown() {
        for (ConcurrentUpdateSolrClient client : this.solrClients.values()) {
            client.close();
        }
    }

    private String getFullUrl(String url) {
        String fullUrl = !url.startsWith("http://") && !url.startsWith("https://") ? "http://" + url : url;
        return fullUrl;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public ExecutorService getUpdateExecutor() {
        return this.updateExecutor;
    }

    class ErrorReportingConcurrentUpdateSolrClient
    extends ConcurrentUpdateSolrClient {
        private final SolrCmdDistributor.Req req;

        public ErrorReportingConcurrentUpdateSolrClient(String solrServerUrl, HttpClient client, int queueSize, int threadCount, ExecutorService es, boolean streamDeletes, SolrCmdDistributor.Req req) {
            super(solrServerUrl, client, queueSize, threadCount, es, streamDeletes);
            this.req = req;
        }

        public void handleError(Throwable ex) {
            this.req.trackRequestResult(null, false);
            log.error("error", ex);
            SolrCmdDistributor.Error error = new SolrCmdDistributor.Error();
            error.e = (Exception)ex;
            if (ex instanceof SolrException) {
                error.statusCode = ((SolrException)ex).code();
            }
            error.req = this.req;
            StreamingSolrClients.this.errors.add(error);
        }

        public void onSuccess(HttpResponse resp) {
            this.req.trackRequestResult(resp, true);
        }
    }
}

