/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.analysis.AnalysisException;
import org.alfresco.repo.search.impl.lucene.analysis.MLTokenDuplicator;
import org.alfresco.solr.AlfrescoAnalyzerWrapper;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.springframework.extensions.surf.util.I18NUtil;

public class MLAnalayser
extends Analyzer {
    private static Log s_logger = LogFactory.getLog(MLAnalayser.class);
    private MLAnalysisMode mlAnalaysisMode;
    private IndexSchema schema;
    private AlfrescoAnalyzerWrapper.Mode mode;

    public MLAnalayser(MLAnalysisMode mlAnalaysisMode, IndexSchema schema, AlfrescoAnalyzerWrapper.Mode mode) {
        super(Analyzer.PER_FIELD_REUSE_STRATEGY);
        this.mlAnalaysisMode = mlAnalaysisMode;
        this.schema = schema;
        this.mode = mode;
    }

    public MLAnalayser(MLAnalysisMode mlAnalaysisMode) {
        super(Analyzer.PER_FIELD_REUSE_STRATEGY);
        this.mlAnalaysisMode = mlAnalaysisMode;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        MLTokenizer mltokenizer = new MLTokenizer(fieldName, this.schema, this.mlAnalaysisMode, this.mode);
        return new LocaleAwareTokenStreamComponents(mltokenizer);
    }

    private static class MLTokenizer
    extends Tokenizer {
        TokenStream ts;
        String fieldName;
        private IndexSchema schema;
        MLAnalysisMode mlAnalaysisMode;
        private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
        private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
        private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
        private AlfrescoAnalyzerWrapper.Mode mode;

        MLTokenizer(String fieldName, IndexSchema schema, MLAnalysisMode mlAnalaysisMode, AlfrescoAnalyzerWrapper.Mode mode) {
            this.fieldName = fieldName;
            this.schema = schema;
            this.mlAnalaysisMode = mlAnalaysisMode;
            this.mode = mode;
        }

        public Reader setLocaleAndPositionReaderAfterLocaleEncoding(Reader reader) {
            Pair<Locale, Reader> pair = this.getLocaleAndPositioReaderAfterLocaleEncoding(this.fieldName, reader);
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("Created ML analyser token stream for " + this.fieldName + " with locale " + String.valueOf(pair.getFirst())));
            }
            TokenStream source = this.getAnalyser(this.fieldName, (Locale)pair.getFirst()).tokenStream(this.fieldName, (Reader)pair.getSecond());
            this.ts = new MLTokenDuplicator(source, (Locale)pair.getFirst(), (Reader)pair.getSecond(), this.mlAnalaysisMode);
            return (Reader)pair.getSecond();
        }

        public void close() throws IOException {
            this.ts.close();
            super.close();
        }

        public void reset() throws IOException {
            this.ts.reset();
            super.reset();
        }

        public void end() throws IOException {
            this.ts.end();
            super.end();
        }

        public boolean incrementToken() throws IOException {
            this.clearAttributes();
            if (this.ts.incrementToken()) {
                this.ts.copyTo((AttributeSource)this);
                return true;
            }
            this.ts.end();
            this.ts.close();
            return false;
        }

        public Pair<Locale, Reader> getLocaleAndPositioReaderAfterLocaleEncoding(String fieldName, Reader reader) {
            BufferedReader breader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            try {
                if (!breader.markSupported()) {
                    throw new AnalysisException("Multilingual tokenisation requires a reader that supports marks and reset");
                }
                breader.mark(100);
                StringBuilder builder = new StringBuilder();
                if (breader.read() == 0) {
                    char c;
                    String language = "";
                    String country = "";
                    String varient = "";
                    int count = 0;
                    while ((c = (char)breader.read()) != '\u0000') {
                        if (count++ > 99) {
                            breader.reset();
                            return new Pair((Object)I18NUtil.getLocale(), (Object)breader);
                        }
                        if (c == '_') {
                            if (language.length() == 0) {
                                language = builder.toString();
                            } else if (country.length() == 0) {
                                country = builder.toString();
                            } else if (varient.length() == 0) {
                                varient = builder.toString();
                            } else {
                                breader.reset();
                                return new Pair((Object)I18NUtil.getLocale(), (Object)breader);
                            }
                            builder = new StringBuilder();
                            continue;
                        }
                        builder.append(c);
                    }
                    if (builder.length() > 0) {
                        if (language.length() == 0) {
                            language = builder.toString();
                        } else if (country.length() == 0) {
                            country = builder.toString();
                        } else if (varient.length() == 0) {
                            varient = builder.toString();
                        } else {
                            breader.reset();
                            return new Pair((Object)I18NUtil.getLocale(), (Object)breader);
                        }
                    }
                    Locale locale = new Locale(language, country, varient);
                    return new Pair((Object)locale, (Object)breader);
                }
                breader.reset();
                return new Pair((Object)I18NUtil.getLocale(), (Object)breader);
            }
            catch (IOException io) {
                try {
                    breader.reset();
                }
                catch (IOException e) {
                    throw new AnalysisException("Failed to reset buffered reader - token stream will be invalid", e);
                }
                return null;
            }
        }

        private Analyzer getAnalyser(String fieldName, Locale locale) {
            if (this.schema != null) {
                if (fieldName.contains("l_@{")) {
                    FieldType fieldType = this.schema.getFieldTypeByName("identifier");
                    return this.selectAnalyzer(fieldType);
                }
                if (fieldName.contains("lt@{")) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("text_");
                    builder.append(locale.getLanguage());
                    FieldType fieldType = this.schema.getFieldTypeByName(builder.toString());
                    if (fieldType == null) {
                        fieldType = this.schema.getFieldTypeByName("text_en");
                    }
                    return this.selectAnalyzer(fieldType);
                }
                return null;
            }
            return null;
        }

        private Analyzer selectAnalyzer(FieldType fieldType) {
            if (this.mode == AlfrescoAnalyzerWrapper.Mode.INDEX) {
                return fieldType.getIndexAnalyzer();
            }
            if (this.mode == AlfrescoAnalyzerWrapper.Mode.QUERY) {
                return fieldType.getQueryAnalyzer();
            }
            return null;
        }
    }

    private static class LocaleAwareTokenStreamComponents
    extends Analyzer.TokenStreamComponents {
        MLTokenizer mltokenizer;

        public LocaleAwareTokenStreamComponents(MLTokenizer source) {
            super((Tokenizer)source);
            this.mltokenizer = source;
        }

        protected void setReader(Reader reader) {
            super.setReader(this.mltokenizer.setLocaleAndPositionReaderAfterLocaleEncoding(reader));
        }
    }
}

