/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.service.cmr.repository.datatype.Duration;
import org.alfresco.solr.AclReport;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.NodeReport;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.AbstractTracker;
import org.alfresco.solr.tracker.AclTracker;
import org.alfresco.solr.tracker.CascadeTracker;
import org.alfresco.solr.tracker.ContentTracker;
import org.alfresco.solr.tracker.IndexHealthReport;
import org.alfresco.solr.tracker.MetadataTracker;
import org.alfresco.solr.tracker.ModelTracker;
import org.alfresco.solr.tracker.ShardStatePublisher;
import org.alfresco.solr.tracker.TrackerRegistry;
import org.alfresco.util.CachingDateFormat;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.json.JSONException;

class HandlerReportHelper {
    HandlerReportHelper() {
    }

    static NamedList<Object> buildAclReport(AclTracker tracker, Long aclid) throws JSONException {
        AclReport aclReport = tracker.checkAcl(aclid);
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("Acl Id", (Object)aclReport.getAclId());
        nr.add("Acl doc in index", (Object)aclReport.getIndexAclDoc());
        if (aclReport.getIndexAclDoc() != null) {
            nr.add("Acl tx in Index", (Object)aclReport.getIndexAclTx());
        }
        return nr;
    }

    static NamedList<Object> buildTxReport(TrackerRegistry trackerRegistry, InformationServer srv, String coreName, MetadataTracker tracker, Long txid) throws JSONException {
        SimpleOrderedMap nr = new SimpleOrderedMap();
        nr.add("TXID", (Object)txid);
        nr.add("transaction", HandlerReportHelper.buildTrackerReport(trackerRegistry, srv, coreName, txid, txid, 0L, 0L, null, null));
        SimpleOrderedMap nodes = new SimpleOrderedMap();
        List<Node> dbNodes = tracker.getFullNodesForDbTransaction(txid);
        for (Node node : dbNodes) {
            nodes.add("DBID " + node.getId(), HandlerReportHelper.buildNodeReport((AbstractTracker)tracker, node));
        }
        nr.add("txDbNodeCount", (Object)dbNodes.size());
        nr.add("nodes", (Object)nodes);
        return nr;
    }

    static NamedList<Object> buildAclTxReport(TrackerRegistry trackerRegistry, InformationServer srv, String coreName, AclTracker tracker, Long acltxid) throws JSONException {
        try {
            SimpleOrderedMap nr = new SimpleOrderedMap();
            nr.add("TXID", (Object)acltxid);
            nr.add("transaction", HandlerReportHelper.buildTrackerReport(trackerRegistry, srv, coreName, 0L, 0L, acltxid, acltxid, null, null));
            SimpleOrderedMap nodes = new SimpleOrderedMap();
            List<Long> dbAclIds = tracker.getAclsForDbAclTransaction(acltxid);
            for (Long aclid : dbAclIds) {
                nodes.add("ACLID " + aclid, HandlerReportHelper.buildAclReport(tracker, aclid));
            }
            nr.add("aclTxDbAclCount", (Object)dbAclIds.size());
            nr.add("nodes", (Object)nodes);
            return nr;
        }
        catch (Exception exception) {
            throw new AlfrescoRuntimeException("", (Throwable)exception);
        }
    }

    static NamedList<Object> buildNodeReport(AbstractTracker tracker, Node node) throws JSONException {
        return HandlerReportHelper.buildNodeReport(tracker, node.getId());
    }

    static NamedList<Object> buildNodeReport(AbstractTracker tracker, long dbid) throws JSONException {
        boolean isOnMasterOrStandaloneMode;
        NodeReport nodeReport = tracker.checkNode(dbid);
        SimpleOrderedMap payload = new SimpleOrderedMap();
        payload.add("Node DBID", (Object)nodeReport.getDbid());
        boolean bl = isOnMasterOrStandaloneMode = tracker instanceof MetadataTracker || tracker instanceof ShardStatePublisher && ((ShardStatePublisher)tracker).isOnMasterOrStandalone();
        if (isOnMasterOrStandaloneMode) {
            Optional.ofNullable(nodeReport.getDbTx()).ifPresent(arg_0 -> HandlerReportHelper.lambda$buildNodeReport$0((NamedList)payload, arg_0));
            Optional.ofNullable(nodeReport.getDbNodeStatus()).map(Object::toString).ifPresent(arg_0 -> HandlerReportHelper.lambda$buildNodeReport$1((NamedList)payload, arg_0));
            Optional.ofNullable(nodeReport.getIndexLeafTx()).ifPresent(arg_0 -> HandlerReportHelper.lambda$buildNodeReport$2((NamedList)payload, arg_0));
            Optional.ofNullable(nodeReport.getIndexAuxDoc()).ifPresent(arg_0 -> HandlerReportHelper.lambda$buildNodeReport$3((NamedList)payload, arg_0));
        } else {
            payload.add("WARNING", (Object)"This response comes from a slave core and it contains minimal information about the node. Please consider to re-submit the same request to the corresponding Master, in order to get more information.");
        }
        Optional.ofNullable(nodeReport.getIndexedNodeDocCount()).ifPresent(arg_0 -> HandlerReportHelper.lambda$buildNodeReport$4((NamedList)payload, arg_0));
        return payload;
    }

    static NamedList<Object> buildTrackerReport(TrackerRegistry trackerRegistry, InformationServer srv, String coreName, Long fromTx, Long toTx, Long fromAclTx, Long toAclTx, Long fromTime, Long toTime) throws JSONException {
        try {
            AclTracker aclTracker = trackerRegistry.getTrackerForCore(coreName, AclTracker.class);
            IndexHealthReport aclReport = aclTracker.checkIndex(toAclTx, fromTime, toTime);
            SimpleOrderedMap ihr = new SimpleOrderedMap();
            ihr.add("ACL Tracker", (Object)(aclTracker.isEnabled() ? "enabled" : "disabled"));
            ihr.add("DB acl transaction count", (Object)aclReport.getDbAclTransactionCount());
            ihr.add("Count of duplicated acl transactions in the index", (Object)aclReport.getDuplicatedAclTxInIndex().cardinality());
            if (aclReport.getDuplicatedAclTxInIndex().cardinality() > 0L) {
                ihr.add("First duplicate acl tx", (Object)aclReport.getDuplicatedAclTxInIndex().nextSetBit(0L));
            }
            ihr.add("Count of acl transactions in the index but not the DB", (Object)aclReport.getAclTxInIndexButNotInDb().cardinality());
            if (aclReport.getAclTxInIndexButNotInDb().cardinality() > 0L) {
                ihr.add("First acl transaction in the index but not the DB", (Object)aclReport.getAclTxInIndexButNotInDb().nextSetBit(0L));
            }
            ihr.add("Count of missing acl transactions from the Index", (Object)aclReport.getMissingAclTxFromIndex().cardinality());
            if (aclReport.getMissingAclTxFromIndex().cardinality() > 0L) {
                ihr.add("First acl transaction missing from the Index", (Object)aclReport.getMissingAclTxFromIndex().nextSetBit(0L));
            }
            ihr.add("Index acl transaction count", (Object)aclReport.getAclTransactionDocsInIndex());
            ihr.add("Index unique acl transaction count", (Object)aclReport.getAclTransactionDocsInIndex());
            TrackerState aclState = aclTracker.getTrackerState();
            ihr.add("Last indexed change set commit time", (Object)aclState.getLastIndexedChangeSetCommitTime());
            Date lastChangeSetDate = new Date(aclState.getLastIndexedChangeSetCommitTime());
            ihr.add("Last indexed change set commit date", (Object)CachingDateFormat.getDateFormat().format(lastChangeSetDate));
            ihr.add("Last changeset id before holes", (Object)aclState.getLastIndexedChangeSetIdBeforeHoles());
            MetadataTracker metadataTracker = trackerRegistry.getTrackerForCore(coreName, MetadataTracker.class);
            IndexHealthReport metaReport = metadataTracker.checkIndex(toTx, fromTime, toTime);
            ihr.add("Metadata Tracker", (Object)(metadataTracker.isEnabled() ? "enabled" : "disabled"));
            ihr.add("DB transaction count", (Object)metaReport.getDbTransactionCount());
            ihr.add("Count of duplicated transactions in the index", (Object)metaReport.getDuplicatedTxInIndex().cardinality());
            if (metaReport.getDuplicatedTxInIndex().cardinality() > 0L) {
                ihr.add("First duplicate", (Object)metaReport.getDuplicatedTxInIndex().nextSetBit(0L));
            }
            ihr.add("Count of transactions in the index but not the DB", (Object)metaReport.getTxInIndexButNotInDb().cardinality());
            if (metaReport.getTxInIndexButNotInDb().cardinality() > 0L) {
                ihr.add("First transaction in the index but not the DB", (Object)metaReport.getTxInIndexButNotInDb().nextSetBit(0L));
            }
            ihr.add("Count of missing transactions from the Index", (Object)metaReport.getMissingTxFromIndex().cardinality());
            if (metaReport.getMissingTxFromIndex().cardinality() > 0L) {
                ihr.add("First transaction missing from the Index", (Object)metaReport.getMissingTxFromIndex().nextSetBit(0L));
            }
            ihr.add("Index transaction count", (Object)metaReport.getTransactionDocsInIndex());
            ihr.add("Index unique transaction count", (Object)metaReport.getTransactionDocsInIndex());
            ihr.add("Index node count", (Object)metaReport.getLeafDocCountInIndex());
            ihr.add("Count of duplicate nodes in the index", (Object)metaReport.getDuplicatedLeafInIndex().cardinality());
            if (metaReport.getDuplicatedLeafInIndex().cardinality() > 0L) {
                ihr.add("First duplicate node id in the index", (Object)metaReport.getDuplicatedLeafInIndex().nextSetBit(0L));
            }
            ihr.add("Index error count", (Object)metaReport.getErrorDocCountInIndex());
            ihr.add("Count of duplicate error docs in the index", (Object)metaReport.getDuplicatedErrorInIndex().cardinality());
            if (metaReport.getDuplicatedErrorInIndex().cardinality() > 0L) {
                ihr.add("First duplicate error in the index", (Object)("ERROR-" + metaReport.getDuplicatedErrorInIndex().nextSetBit(0L)));
            }
            ihr.add("Index unindexed count", (Object)metaReport.getUnindexedDocCountInIndex());
            ihr.add("Count of duplicate unindexed docs in the index", (Object)metaReport.getDuplicatedUnindexedInIndex().cardinality());
            if (metaReport.getDuplicatedUnindexedInIndex().cardinality() > 0L) {
                ihr.add("First duplicate unindexed in the index", (Object)metaReport.getDuplicatedUnindexedInIndex().nextSetBit(0L));
            }
            TrackerState metaState = metadataTracker.getTrackerState();
            ihr.add("Last indexed transaction commit time", (Object)metaState.getLastIndexedTxCommitTime());
            Date lastTxDate = new Date(metaState.getLastIndexedTxCommitTime());
            ihr.add("Last indexed transaction commit date", (Object)CachingDateFormat.getDateFormat().format(lastTxDate));
            ihr.add("Last TX id before holes", (Object)metaState.getLastIndexedTxIdBeforeHoles());
            srv.addContentOutdatedAndUpdatedCounts((NamedList<Object>)ihr);
            return ihr;
        }
        catch (Exception exception) {
            throw new AlfrescoRuntimeException("", (Throwable)exception);
        }
    }

    static void addSlaveCoreSummary(TrackerRegistry trackerRegistry, String cname, boolean detail, boolean hist, boolean values, InformationServer srv, NamedList<Object> report) throws IOException {
        long txLagSeconds;
        long contentYetToSee;
        SimpleOrderedMap coreSummary = new SimpleOrderedMap();
        coreSummary.addAll((NamedList)((SimpleOrderedMap)srv.getCoreStats()));
        ShardStatePublisher statePublisher = trackerRegistry.getTrackerForCore(cname, ShardStatePublisher.class);
        TrackerState trackerState = statePublisher.getTrackerState();
        long lastIndexTxCommitTime = trackerState.getLastIndexedTxCommitTime();
        long lastIndexedTxId = trackerState.getLastIndexedTxId();
        long lastTxCommitTimeOnServer = trackerState.getLastTxCommitTimeOnServer();
        long lastTxIdOnServer = trackerState.getLastTxIdOnServer();
        Date lastIndexTxCommitDate = new Date(lastIndexTxCommitTime);
        Date lastTxOnServerDate = new Date(lastTxCommitTimeOnServer);
        long transactionsToDo = lastTxIdOnServer - lastIndexedTxId;
        if (transactionsToDo < 0L) {
            transactionsToDo = 0L;
        }
        long nodesToDo = 0L;
        long remainingTxTimeMillis = 0L;
        if (transactionsToDo > 0L) {
            double meanDocsPerTx = srv.getTrackerStats().getMeanDocsPerTx();
            double meanNodeElaspedIndexTime = srv.getTrackerStats().getMeanNodeElapsedIndexTime();
            nodesToDo = (long)((double)transactionsToDo * meanDocsPerTx);
            remainingTxTimeMillis = (long)((double)nodesToDo * meanNodeElaspedIndexTime);
        }
        Date now = new Date();
        Date end = new Date(now.getTime() + remainingTxTimeMillis);
        Duration remainingTx = new Duration(now, end);
        SimpleOrderedMap ftsSummary = new SimpleOrderedMap();
        long remainingContentTimeMillis = 0L;
        srv.addContentOutdatedAndUpdatedCounts((NamedList<Object>)ftsSummary);
        long cleanCount = Optional.ofNullable(ftsSummary.get("Node count with FTSStatus Clean")).map(Number.class::cast).map(Number::longValue).orElse(0L);
        long dirtyCount = Optional.ofNullable(ftsSummary.get("Node count with FTSStatus Dirty")).map(Number.class::cast).map(Number::longValue).orElse(0L);
        long newCount = Optional.ofNullable(ftsSummary.get("Node count with FTSStatus New")).map(Number.class::cast).map(Number::longValue).orElse(0L);
        long nodesInIndex = Optional.ofNullable(coreSummary.get("Alfresco Nodes in Index")).map(Number.class::cast).map(Number::longValue).orElse(0L);
        long l = contentYetToSee = nodesInIndex > 0L ? nodesToDo * (cleanCount + dirtyCount + newCount) / nodesInIndex : 0L;
        if (dirtyCount + newCount + contentYetToSee > 0L) {
            double meanContentElapsedIndexTime = srv.getTrackerStats().getMeanContentElapsedIndexTime();
            remainingContentTimeMillis = (long)((double)(dirtyCount + newCount + contentYetToSee) * meanContentElapsedIndexTime);
        }
        now = new Date();
        end = new Date(now.getTime() + remainingContentTimeMillis);
        Duration remainingContent = new Duration(now, end);
        coreSummary.add("FTS", (Object)ftsSummary);
        Duration txLag = new Duration(lastIndexTxCommitDate, lastTxOnServerDate);
        if (lastIndexTxCommitDate.compareTo(lastTxOnServerDate) > 0) {
            txLag = new Duration();
        }
        if ((txLagSeconds = (lastTxCommitTimeOnServer - lastIndexTxCommitTime) / 1000L) < 0L) {
            txLagSeconds = 0L;
        }
        ModelTracker modelTrkr = trackerRegistry.getModelTracker();
        TrackerState modelTrkrState = modelTrkr.getTrackerState();
        coreSummary.add("ModelTracker Active", (Object)modelTrkrState.isRunning());
        coreSummary.add("NodeState Publisher Active", (Object)trackerState.isRunning());
        coreSummary.add("Last Index TX Commit Time", (Object)lastIndexTxCommitTime);
        coreSummary.add("Last Index TX Commit Date", (Object)lastIndexTxCommitDate);
        coreSummary.add("TX Lag", (Object)(txLagSeconds + " s"));
        coreSummary.add("TX Duration", (Object)txLag.toString());
        coreSummary.add("Timestamp for last TX on server", (Object)lastTxCommitTimeOnServer);
        coreSummary.add("Date for last TX on server", (Object)lastTxOnServerDate);
        coreSummary.add("Id for last TX on server", (Object)lastTxIdOnServer);
        coreSummary.add("Id for last TX in index", (Object)lastIndexedTxId);
        coreSummary.add("Approx transactions remaining", (Object)transactionsToDo);
        coreSummary.add("Approx transaction indexing time remaining", (Object)remainingTx.largestComponentformattedString());
        coreSummary.add("Model sync times (ms)", (Object)srv.getTrackerStats().getModelTimes().getNamedList(detail, hist, values));
        coreSummary.add("Docs/Tx", (Object)srv.getTrackerStats().getTxDocs().getNamedList(detail, hist, values));
        Map<String, Set<String>> modelErrors = srv.getModelErrors();
        if (modelErrors.size() > 0) {
            SimpleOrderedMap errorList = new SimpleOrderedMap();
            for (Map.Entry<String, Set<String>> modelNameToErrors : modelErrors.entrySet()) {
                errorList.add(modelNameToErrors.getKey(), modelNameToErrors.getValue());
            }
            coreSummary.add("Model changes are not compatible with the existing data model and have not been applied", (Object)errorList);
        }
        report.add(cname, (Object)coreSummary);
    }

    static void addMasterOrStandaloneCoreSummary(TrackerRegistry trackerRegistry, String cname, boolean detail, boolean hist, boolean values, InformationServer srv, NamedList<Object> report) throws IOException {
        long txLagSeconds;
        long contentYetToSee;
        SimpleOrderedMap coreSummary = new SimpleOrderedMap();
        coreSummary.addAll((NamedList)((SimpleOrderedMap)srv.getCoreStats()));
        MetadataTracker metaTrkr = trackerRegistry.getTrackerForCore(cname, MetadataTracker.class);
        TrackerState metadataTrkrState = metaTrkr.getTrackerState();
        long lastIndexTxCommitTime = metadataTrkrState.getLastIndexedTxCommitTime();
        long lastIndexedTxId = metadataTrkrState.getLastIndexedTxId();
        long lastTxCommitTimeOnServer = metadataTrkrState.getLastTxCommitTimeOnServer();
        long lastTxIdOnServer = metadataTrkrState.getLastTxIdOnServer();
        Date lastIndexTxCommitDate = new Date(lastIndexTxCommitTime);
        Date lastTxOnServerDate = new Date(lastTxCommitTimeOnServer);
        long transactionsToDo = lastTxIdOnServer - lastIndexedTxId;
        if (transactionsToDo < 0L) {
            transactionsToDo = 0L;
        }
        AclTracker aclTrkr = trackerRegistry.getTrackerForCore(cname, AclTracker.class);
        TrackerState aclTrkrState = aclTrkr.getTrackerState();
        long lastIndexChangeSetCommitTime = aclTrkrState.getLastIndexedChangeSetCommitTime();
        long lastIndexedChangeSetId = aclTrkrState.getLastIndexedChangeSetId();
        long lastChangeSetCommitTimeOnServer = aclTrkrState.getLastChangeSetCommitTimeOnServer();
        long lastChangeSetIdOnServer = aclTrkrState.getLastChangeSetIdOnServer();
        Date lastIndexChangeSetCommitDate = new Date(lastIndexChangeSetCommitTime);
        Date lastChangeSetOnServerDate = new Date(lastChangeSetCommitTimeOnServer);
        long changeSetsToDo = lastChangeSetIdOnServer - lastIndexedChangeSetId;
        if (changeSetsToDo < 0L) {
            changeSetsToDo = 0L;
        }
        long nodesToDo = 0L;
        long remainingTxTimeMillis = 0L;
        if (transactionsToDo > 0L) {
            double meanDocsPerTx = srv.getTrackerStats().getMeanDocsPerTx();
            double meanNodeElaspedIndexTime = srv.getTrackerStats().getMeanNodeElapsedIndexTime();
            nodesToDo = (long)((double)transactionsToDo * meanDocsPerTx);
            remainingTxTimeMillis = (long)((double)nodesToDo * meanNodeElaspedIndexTime);
        }
        Date now = new Date();
        Date end = new Date(now.getTime() + remainingTxTimeMillis);
        Duration remainingTx = new Duration(now, end);
        long remainingChangeSetTimeMillis = 0L;
        if (changeSetsToDo > 0L) {
            double meanAclsPerChangeSet = srv.getTrackerStats().getMeanAclsPerChangeSet();
            double meanAclElapsedIndexTime = srv.getTrackerStats().getMeanAclElapsedIndexTime();
            remainingChangeSetTimeMillis = (long)((double)changeSetsToDo * meanAclsPerChangeSet * meanAclElapsedIndexTime);
        }
        now = new Date();
        end = new Date(now.getTime() + remainingChangeSetTimeMillis);
        Duration remainingChangeSet = new Duration(now, end);
        SimpleOrderedMap ftsSummary = new SimpleOrderedMap();
        long remainingContentTimeMillis = 0L;
        srv.addContentOutdatedAndUpdatedCounts((NamedList<Object>)ftsSummary);
        long cleanCount = Optional.ofNullable(ftsSummary.get("Node count whose content is in sync")).map(Number.class::cast).map(Number::longValue).orElse(0L);
        long dirtyCount = Optional.ofNullable(ftsSummary.get("Node count whose content needs to be updated")).map(Number.class::cast).map(Number::longValue).orElse(0L);
        long nodesInIndex = Optional.ofNullable(coreSummary.get("Alfresco Nodes in Index")).map(Number.class::cast).map(Number::longValue).orElse(0L);
        long l = contentYetToSee = nodesInIndex > 0L ? nodesToDo * (cleanCount + dirtyCount) / nodesInIndex : 0L;
        if (dirtyCount + contentYetToSee > 0L) {
            double meanContentElapsedIndexTime = srv.getTrackerStats().getMeanContentElapsedIndexTime();
            remainingContentTimeMillis = (long)((double)(dirtyCount + contentYetToSee) * meanContentElapsedIndexTime);
        }
        now = new Date();
        end = new Date(now.getTime() + remainingContentTimeMillis);
        Duration remainingContent = new Duration(now, end);
        coreSummary.add("FTS", (Object)ftsSummary);
        Duration txLag = new Duration(lastIndexTxCommitDate, lastTxOnServerDate);
        if (lastIndexTxCommitDate.compareTo(lastTxOnServerDate) > 0) {
            txLag = new Duration();
        }
        if ((txLagSeconds = (lastTxCommitTimeOnServer - lastIndexTxCommitTime) / 1000L) < 0L) {
            txLagSeconds = 0L;
        }
        Duration changeSetLag = new Duration(lastIndexChangeSetCommitDate, lastChangeSetOnServerDate);
        if (lastIndexChangeSetCommitDate.compareTo(lastChangeSetOnServerDate) > 0) {
            changeSetLag = new Duration();
        }
        long changeSetLagSeconds = (lastChangeSetCommitTimeOnServer - lastIndexChangeSetCommitTime) / 1000L;
        if (txLagSeconds < 0L) {
            txLagSeconds = 0L;
        }
        ContentTracker contentTrkr = trackerRegistry.getTrackerForCore(cname, ContentTracker.class);
        CascadeTracker cascadeTracker = trackerRegistry.getTrackerForCore(cname, CascadeTracker.class);
        TrackerState contentTrkrState = contentTrkr.getTrackerState();
        boolean aTrackerIsRunning = aclTrkrState.isRunning() || metadataTrkrState.isRunning() || contentTrkrState.isRunning();
        coreSummary.add("Active", (Object)aTrackerIsRunning);
        ModelTracker modelTrkr = trackerRegistry.getModelTracker();
        TrackerState modelTrkrState = modelTrkr.getTrackerState();
        coreSummary.add("ModelTracker Active", (Object)modelTrkrState.isRunning());
        coreSummary.add("ContentTracker Active", (Object)contentTrkrState.isRunning());
        coreSummary.add("MetadataTracker Active", (Object)metadataTrkrState.isRunning());
        coreSummary.add("AclTracker Active", (Object)aclTrkrState.isRunning());
        coreSummary.add("ContentTracker Enabled", (Object)contentTrkr.isEnabled());
        coreSummary.add("MetadataTracker Enabled", (Object)metaTrkr.isEnabled());
        coreSummary.add("AclTracker Enabled", (Object)aclTrkr.isEnabled());
        if (cascadeTracker != null) {
            coreSummary.add("CascadeTracker Enabled", (Object)cascadeTracker.isEnabled());
        }
        coreSummary.add("Last Index TX Commit Time", (Object)lastIndexTxCommitTime);
        coreSummary.add("Last Index TX Commit Date", (Object)lastIndexTxCommitDate);
        coreSummary.add("TX Lag", (Object)(txLagSeconds + " s"));
        coreSummary.add("TX Duration", (Object)txLag.toString());
        coreSummary.add("Timestamp for last TX on server", (Object)lastTxCommitTimeOnServer);
        coreSummary.add("Date for last TX on server", (Object)lastTxOnServerDate);
        coreSummary.add("Id for last TX on server", (Object)lastTxIdOnServer);
        coreSummary.add("Id for last TX in index", (Object)lastIndexedTxId);
        coreSummary.add("Approx transactions remaining", (Object)transactionsToDo);
        coreSummary.add("Approx transaction indexing time remaining", (Object)remainingTx.largestComponentformattedString());
        coreSummary.add("Last Index Change Set Commit Time", (Object)lastIndexChangeSetCommitTime);
        coreSummary.add("Last Index Change Set Commit Date", (Object)lastIndexChangeSetCommitDate);
        coreSummary.add("Change Set Lag", (Object)(changeSetLagSeconds + " s"));
        coreSummary.add("Change Set Duration", (Object)changeSetLag.toString());
        coreSummary.add("Timestamp for last Change Set on server", (Object)lastChangeSetCommitTimeOnServer);
        coreSummary.add("Date for last Change Set on server", (Object)lastChangeSetOnServerDate);
        coreSummary.add("Id for last Change Set on server", (Object)lastChangeSetIdOnServer);
        coreSummary.add("Id for last Change Set in index", (Object)lastIndexedChangeSetId);
        coreSummary.add("Approx change sets remaining", (Object)changeSetsToDo);
        coreSummary.add("Approx change set indexing time remaining", (Object)remainingChangeSet.largestComponentformattedString());
        coreSummary.add("Approx content indexing time remaining", (Object)remainingContent.largestComponentformattedString());
        coreSummary.add("Model sync times (ms)", (Object)srv.getTrackerStats().getModelTimes().getNamedList(detail, hist, values));
        coreSummary.add("Acl index time (ms)", (Object)srv.getTrackerStats().getAclTimes().getNamedList(detail, hist, values));
        coreSummary.add("Node index time (ms)", (Object)srv.getTrackerStats().getNodeTimes().getNamedList(detail, hist, values));
        coreSummary.add("Docs/Tx", (Object)srv.getTrackerStats().getTxDocs().getNamedList(detail, hist, values));
        coreSummary.add("Doc Transformation time (ms)", (Object)srv.getTrackerStats().getDocTransformationTimes().getNamedList(detail, hist, values));
        Map<String, Set<String>> modelErrors = srv.getModelErrors();
        if (modelErrors.size() > 0) {
            SimpleOrderedMap errorList = new SimpleOrderedMap();
            for (Map.Entry<String, Set<String>> modelNameToErrors : modelErrors.entrySet()) {
                errorList.add(modelNameToErrors.getKey(), modelNameToErrors.getValue());
            }
            coreSummary.add("Model changes are not compatible with the existing data model and have not been applied", (Object)errorList);
        }
        report.add(cname, (Object)coreSummary);
    }

    private static /* synthetic */ void lambda$buildNodeReport$4(NamedList payload, Long value) {
        payload.add("Indexed Node Doc Count", (Object)value);
    }

    private static /* synthetic */ void lambda$buildNodeReport$3(NamedList payload, Long value) {
        payload.add("Aux tx in Index", (Object)value);
    }

    private static /* synthetic */ void lambda$buildNodeReport$2(NamedList payload, Long value) {
        payload.add("Leaf tx in Index", (Object)value);
    }

    private static /* synthetic */ void lambda$buildNodeReport$1(NamedList payload, String value) {
        payload.add("DB TX Status", (Object)value);
    }

    private static /* synthetic */ void lambda$buildNodeReport$0(NamedList payload, Long value) {
        payload.add("DB TX", (Object)value);
    }
}

