/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.util.BitDocIdSet;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitsFilteredDocIdSet;
import org.apache.solr.search.Filter;

public class BitsFilter
extends Filter {
    private final List<FixedBitSet> bitSets;

    public BitsFilter(List<FixedBitSet> bitSets) {
        if (bitSets == null) {
            throw new IllegalStateException("bitSets cannot be null");
        }
        this.bitSets = bitSets;
    }

    public void or(BitsFilter bitsFilter) {
        List<FixedBitSet> andSets = bitsFilter.bitSets;
        for (int i = 0; i < this.bitSets.size(); ++i) {
            FixedBitSet a = this.bitSets.get(i);
            FixedBitSet b = andSets.get(i);
            a.or(b);
        }
    }

    public void and(BitsFilter bitsFilter) {
        List<FixedBitSet> andSets = bitsFilter.bitSets;
        for (int i = 0; i < this.bitSets.size(); ++i) {
            FixedBitSet a = this.bitSets.get(i);
            FixedBitSet b = andSets.get(i);
            a.and(b);
        }
    }

    public List<FixedBitSet> getBitSets() {
        return this.bitSets;
    }

    public String toString(String s) {
        return s;
    }

    public DocIdSet getDocIdSet(LeafReaderContext context, Bits bits) {
        return BitsFilteredDocIdSet.wrap((DocIdSet)new BitDocIdSet((BitSet)this.bitSets.get(context.ord)), (Bits)bits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BitsFilter)) {
            return false;
        }
        BitsFilter that = (BitsFilter)((Object)o);
        return this.bitSets.equals(that.bitSets);
    }

    public int hashCode() {
        return this.bitSets.hashCode();
    }
}

