/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.security;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.config.ConfigUtil;
import org.alfresco.solr.security.SecretSharedPropertyHelper;

public class SecretSharedPropertyCollector {
    public static final String SECRET_SHARED_METHOD_KEY = "secret";
    static final String SECURE_COMMS_PROPERTY = "alfresco.secureComms";
    static final String SHARED_SECRET = "alfresco.secureComms.secret";
    static final String ALLOW_UNAUTHENTICATED_SOLR_PROPERTY = "alfresco.allowUnauthenticatedSolrEndpoint";
    private static final String SHARED_SECRET_HEADER = "alfresco.secureComms.secret.header";
    static final Map<String, String> PROPS_CACHE = new ConcurrentHashMap<String, String>();
    private static final ArrayList<BiFunction<String, String, Set<String>>> PROPERTY_LOCATORS = new ArrayList();

    public static boolean isCommsSecretShared() {
        return Objects.equals(SecretSharedPropertyCollector.getCommsMethod(), SECRET_SHARED_METHOD_KEY);
    }

    public static boolean isAllowUnauthenticatedSolrEndpoint() {
        return Boolean.parseBoolean(PROPS_CACHE.computeIfAbsent(ALLOW_UNAUTHENTICATED_SOLR_PROPERTY, key -> SecretSharedPropertyCollector.getProperty(key, "false")));
    }

    static String getCommsMethod() {
        return PROPS_CACHE.computeIfAbsent(SECURE_COMMS_PROPERTY, key -> SecretSharedPropertyCollector.getProperty(key, "none", SecretSharedPropertyCollector.uniqueSecureCommsValidator()));
    }

    private static String getProperty(String name, String defaultValue) {
        return SecretSharedPropertyCollector.getProperty(name, defaultValue, null);
    }

    private static String getProperty(String name, String defaultValue, Consumer<Set<String>> propertySetValidator) {
        Set propertySet = PROPERTY_LOCATORS.stream().map(propertyLocator -> (Set)propertyLocator.apply(name, defaultValue)).filter(Predicate.not(Set::isEmpty)).findFirst().orElse(Set.of());
        if (propertySetValidator != null) {
            propertySetValidator.accept(propertySet);
        }
        return propertySet.isEmpty() ? null : (String)propertySet.iterator().next();
    }

    private static Consumer<Set<String>> uniqueSecureCommsValidator() {
        return secureCommsSet -> {
            if (secureCommsSet.size() > 1 && secureCommsSet.contains(SECRET_SHARED_METHOD_KEY)) {
                throw new RuntimeException("No valid secure comms values: all the cores must be using \"secret\" communication method but found: " + String.valueOf(secureCommsSet));
            }
        };
    }

    public static String getSecret() {
        String secret = ConfigUtil.locateProperty(SHARED_SECRET, null);
        if (secret == null || secret.length() == 0) {
            throw new RuntimeException("Missing value for alfresco.secureComms.secret configuration property. Make sure to pass this property as a JVM Argument (eg. -Dalfresco.secureComms.secret=my-secret-value).");
        }
        return secret;
    }

    public static String getSecretHeader() {
        String secretHeader = ConfigUtil.locateProperty(SHARED_SECRET_HEADER, null);
        if (secretHeader != null) {
            return secretHeader;
        }
        return "X-Alfresco-Search-Secret";
    }

    public static Properties completeCoreProperties(Properties properties) {
        if (SecretSharedPropertyCollector.isCommsSecretShared()) {
            properties.setProperty(SECURE_COMMS_PROPERTY, SecretSharedPropertyCollector.getCommsMethod());
            properties.setProperty(SHARED_SECRET, SecretSharedPropertyCollector.getSecret());
            properties.setProperty(SHARED_SECRET_HEADER, SecretSharedPropertyCollector.getSecretHeader());
        }
        return properties;
    }

    private static Set<String> toSet(String value) {
        HashSet<String> propertySet = new HashSet<String>();
        if (value != null) {
            propertySet.add(value);
        }
        return propertySet;
    }

    static {
        PROPERTY_LOCATORS.add((name, defaultValue) -> SecretSharedPropertyCollector.toSet(ConfigUtil.locateProperty(name, null)));
        PROPERTY_LOCATORS.add((name, defaultValue) -> SecretSharedPropertyCollector.toSet(AlfrescoSolrDataModel.getCommonConfig().getProperty((String)name)));
        PROPERTY_LOCATORS.add(SecretSharedPropertyHelper::getPropertyFromCores);
    }
}

