/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public abstract class BooleanEvaluator
extends ComplexEvaluator {
    protected static final long serialVersionUID = 1L;

    public BooleanEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
    }

    @Override
    public abstract Boolean evaluate(Tuple var1) throws IOException;

    public List<Object> evaluateAll(Tuple tuple) throws IOException {
        ArrayList<Object> results = new ArrayList<Object>();
        for (StreamEvaluator subEvaluator : this.subEvaluators) {
            results.add(subEvaluator.evaluate(tuple));
        }
        return results;
    }

    public static interface StringChecker
    extends Checker {
        @Override
        default public boolean isCorrectType(Object value) {
            return value instanceof String;
        }
    }

    public static interface NumberChecker
    extends Checker {
        @Override
        default public boolean isCorrectType(Object value) {
            return value instanceof Number;
        }
    }

    public static interface BooleanChecker
    extends Checker {
        @Override
        default public boolean isCorrectType(Object value) {
            return value instanceof Boolean;
        }
    }

    public static interface NullChecker
    extends Checker {
        @Override
        default public boolean isNullAllowed() {
            return true;
        }

        @Override
        default public boolean isCorrectType(Object value) {
            return true;
        }

        @Override
        default public boolean test(Object left, Object right) {
            return null == left && null == right;
        }
    }

    public static interface Checker {
        default public boolean isNullAllowed() {
            return false;
        }

        public boolean isCorrectType(Object var1);

        public boolean test(Object var1, Object var2);
    }
}

