/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.Locale;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ComplexEvaluator;
import org.apache.solr.client.solrj.io.eval.EvaluatorException;
import org.apache.solr.client.solrj.io.eval.StreamEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class ConversionEvaluator
extends ComplexEvaluator {
    private LENGTH_CONSTANT from;
    private LENGTH_CONSTANT to;
    private Convert convert;

    public ConversionEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (3 != this.subEvaluators.size()) {
            throw new EvaluatorException(new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting 3 value but found %d", expression, this.subEvaluators.size())));
        }
        try {
            this.from = LENGTH_CONSTANT.valueOf(((StreamEvaluator)this.subEvaluators.get(0)).toExpression(factory).toString().toUpperCase(Locale.ROOT));
            this.to = LENGTH_CONSTANT.valueOf(((StreamEvaluator)this.subEvaluators.get(1)).toExpression(factory).toString().toUpperCase(Locale.ROOT));
            this.convert = this.getConvert(this.from, this.to);
        }
        catch (IllegalArgumentException e) {
            throw new EvaluatorException(e);
        }
    }

    private String listParams() {
        StringBuffer buf = new StringBuffer();
        for (LENGTH_CONSTANT lc : LENGTH_CONSTANT.values()) {
            if (buf.length() > 0) {
                buf.append(", ");
            }
            buf.append(lc.toString());
        }
        return buf.toString();
    }

    @Override
    public Object evaluate(Tuple tuple) throws IOException {
        StreamEvaluator streamEvaluator = (StreamEvaluator)this.subEvaluators.get(2);
        Object tupleValue = streamEvaluator.evaluate(tuple);
        if (tupleValue == null) {
            return null;
        }
        Number number = (Number)tupleValue;
        double d = number.doubleValue();
        return this.convert.convert(d);
    }

    private Convert getConvert(LENGTH_CONSTANT from, LENGTH_CONSTANT to) throws IOException {
        switch (from) {
            case INCHES: {
                switch (to) {
                    case MILLIMETERS: {
                        return d -> d * 25.4;
                    }
                    case CENTIMETERS: {
                        return d -> d * 2.54;
                    }
                    case METERS: {
                        return d -> d * 0.0254;
                    }
                }
                throw new EvaluatorException("No conversion available from " + (Object)((Object)from) + " to " + (Object)((Object)to));
            }
            case FEET: {
                switch (to) {
                    case METERS: {
                        return d -> d * 0.3;
                    }
                }
            }
            case YARDS: {
                switch (to) {
                    case METERS: {
                        return d -> d * 0.91;
                    }
                    case KILOMETERS: {
                        return d -> d * 9.1E-4;
                    }
                }
                throw new EvaluatorException("No conversion available from " + (Object)((Object)from) + " to " + (Object)((Object)to));
            }
            case MILES: {
                switch (to) {
                    case KILOMETERS: {
                        return d -> d * 1.61;
                    }
                }
                throw new EvaluatorException("No conversion available from " + (Object)((Object)from) + " to " + (Object)((Object)to));
            }
            case MILLIMETERS: {
                switch (to) {
                    case INCHES: {
                        return d -> d * 0.039;
                    }
                }
                throw new EvaluatorException("No conversion available from " + (Object)((Object)from) + " to " + (Object)((Object)to));
            }
            case CENTIMETERS: {
                switch (to) {
                    case INCHES: {
                        return d -> d * 0.39;
                    }
                }
                throw new EvaluatorException("No conversion available from " + (Object)((Object)from) + " to " + (Object)((Object)to));
            }
            case METERS: {
                switch (to) {
                    case FEET: {
                        return d -> d * 3.28;
                    }
                }
                throw new EvaluatorException("No conversion available from " + (Object)((Object)from) + " to " + (Object)((Object)to));
            }
            case KILOMETERS: {
                switch (to) {
                    case MILES: {
                        return d -> d * 0.62;
                    }
                    case FEET: {
                        return d -> d * 3280.8;
                    }
                }
            }
        }
        throw new EvaluatorException("No conversion available from " + (Object)((Object)from));
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        for (StreamEvaluator evaluator : this.subEvaluators) {
            expression.addParameter(evaluator.toExpression(factory));
        }
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        return new Explanation(this.nodeId.toString()).withExpressionType("evaluator").withImplementingClass(this.getClass().getName()).withExpression(this.toExpression(factory).toString());
    }

    private static interface Convert {
        public double convert(double var1);
    }

    static enum LENGTH_CONSTANT {
        MILES,
        YARDS,
        FEET,
        INCHES,
        MILLIMETERS,
        CENTIMETERS,
        METERS,
        KILOMETERS;

    }
}

