/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import org.alfresco.encryption.AbstractEncryptor;
import org.alfresco.encryption.KeyProvider;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.PropertyCheck;

public class DefaultEncryptor
extends AbstractEncryptor {
    private boolean cacheCiphers = true;
    private final ThreadLocal<Map<CipherKey, CachedCipher>> threadCipher = new ThreadLocal();

    public DefaultEncryptor() {
    }

    DefaultEncryptor(KeyProvider keyProvider, String cipherAlgorithm, String cipherProvider) {
        this();
        this.setKeyProvider(keyProvider);
        this.setCipherAlgorithm(cipherAlgorithm);
        this.setCipherProvider(cipherProvider);
    }

    @Override
    public void init() {
        super.init();
        PropertyCheck.mandatory(this, "cipherAlgorithm", this.cipherAlgorithm);
    }

    public void setCacheCiphers(boolean cacheCiphers) {
        this.cacheCiphers = cacheCiphers;
    }

    protected Cipher createCipher(int mode, String algorithm, String provider, Key key, AlgorithmParameters params) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidKeyException, InvalidAlgorithmParameterException {
        Cipher cipher = null;
        cipher = this.cipherProvider == null ? Cipher.getInstance(algorithm) : Cipher.getInstance(algorithm, provider);
        cipher.init(mode, key, params);
        return cipher;
    }

    protected Cipher getCachedCipher(String keyAlias, int mode, AlgorithmParameters params, Key key) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, InvalidAlgorithmParameterException {
        CachedCipher cipherInfo = null;
        Cipher cipher = null;
        Map<CipherKey, CachedCipher> ciphers = this.threadCipher.get();
        if (ciphers == null) {
            ciphers = new HashMap<CipherKey, CachedCipher>(5);
            this.threadCipher.set(ciphers);
        }
        if ((cipherInfo = ciphers.get(new CipherKey(keyAlias, mode))) == null) {
            cipher = this.createCipher(mode, this.cipherAlgorithm, this.cipherProvider, key, params);
            ciphers.put(new CipherKey(keyAlias, mode), new CachedCipher(cipher, key));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cipher constructed: alias=" + keyAlias + "; mode=" + mode + ": " + cipher));
            }
        } else if (cipherInfo.getKey() != key) {
            cipher = this.createCipher(mode, this.cipherAlgorithm, this.cipherProvider, key, params);
            ciphers.put(new CipherKey(keyAlias, mode), new CachedCipher(cipher, key));
        } else {
            cipher = cipherInfo.getCipher();
        }
        return cipher;
    }

    @Override
    public Cipher getCipher(String keyAlias, AlgorithmParameters params, int mode) {
        Cipher cipher = null;
        Key key = this.keyProvider.getKey(keyAlias);
        if (key == null) {
            return null;
        }
        try {
            cipher = this.cacheCiphers ? this.getCachedCipher(keyAlias, mode, params, key) : this.createCipher(mode, this.cipherAlgorithm, this.cipherProvider, key, params);
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Failed to construct cipher: alias=" + keyAlias + "; mode=" + mode, e);
        }
        return cipher;
    }

    @Override
    public boolean keyAvailable(String keyAlias) {
        return this.keyProvider.getKey(keyAlias) != null;
    }

    private static class CipherKey {
        private String keyAlias;
        private int mode;

        public CipherKey(String keyAlias, int mode) {
            this.keyAlias = keyAlias;
            this.mode = mode;
        }

        public String getKeyAlias() {
            return this.keyAlias;
        }

        public int getMode() {
            return this.mode;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.keyAlias == null ? 0 : this.keyAlias.hashCode());
            result = 31 * result + this.mode;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CipherKey)) {
                return false;
            }
            CipherKey other = (CipherKey)obj;
            if (this.keyAlias == null ? other.keyAlias != null : !this.keyAlias.equals(other.keyAlias)) {
                return false;
            }
            return this.mode == other.mode;
        }
    }

    private static class CachedCipher {
        private Key key;
        private Cipher cipher;

        public CachedCipher(Cipher cipher, Key key) {
            this.cipher = cipher;
            this.key = key;
        }

        public Cipher getCipher() {
            return this.cipher;
        }

        public Key getKey() {
            return this.key;
        }
    }
}

