/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

public class FileFilterMode {
    private static ThreadLocal<Client> client = new ThreadLocal<Client>(){

        @Override
        protected Client initialValue() {
            return null;
        }
    };

    public static void clearClient() {
        client.set(null);
    }

    public static Client setClient(Client newClient) {
        Client oldClient = client.get();
        client.set(newClient);
        return oldClient;
    }

    public static Mode getMode() {
        Client client = FileFilterMode.getClient();
        if (client == null) {
            return Mode.BASIC;
        }
        switch (client) {
            case cifs: 
            case nfs: 
            case ftp: 
            case webdav: 
            case cmis: 
            case admin: {
                return Mode.ENHANCED;
            }
        }
        return Mode.BASIC;
    }

    public static Client getClient() {
        return client.get();
    }

    public static enum Client {
        cifs,
        imap,
        webdav,
        nfs,
        script,
        webclient,
        ftp,
        cmis,
        admin;


        @Deprecated
        public static Client getClient(String clientStr) {
            if (clientStr.equals("cifs")) {
                return cifs;
            }
            if (clientStr.equals("imap")) {
                return imap;
            }
            if (clientStr.equals("webdav")) {
                return webdav;
            }
            if (clientStr.equals("nfs")) {
                return nfs;
            }
            if (clientStr.equals("ftp")) {
                return ftp;
            }
            if (clientStr.equals("script")) {
                return script;
            }
            if (clientStr.equals("webclient")) {
                return webclient;
            }
            if (clientStr.equals("cmis")) {
                return cmis;
            }
            if (clientStr.equals("admin")) {
                return admin;
            }
            throw new IllegalArgumentException();
        }
    }

    public static enum Mode {
        BASIC,
        ENHANCED;

    }
}

