/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.security.SecureRandom;
import java.util.Random;
import org.alfresco.api.AlfrescoPublicApi;
import org.safehaus.uuid.UUIDGenerator;

@AlfrescoPublicApi
public final class GUID {
    private static final SecureRandom[] SECURE_RANDOM_POOL = GUID.initSecureRandomArray();
    private static final int SECURE_RANDOM_POOL_MAX_ITEMS = 256;
    private static final Random RANDOM = new Random();

    private GUID() {
    }

    private static SecureRandom[] initSecureRandomArray() {
        SecureRandom[] array = new SecureRandom[256];
        for (int i = 0; i < 256; ++i) {
            array[i] = new SecureRandom();
        }
        return array;
    }

    public static String generate() {
        int randomInt = RANDOM.nextInt(256);
        return UUIDGenerator.getInstance().generateRandomBasedUUID((Random)SECURE_RANDOM_POOL[randomInt]).toString();
    }
}

