/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.shard;

import java.util.LinkedList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;

public class ExplicitShardingPolicy {
    private int numShards;
    private int replicationFactor;
    private int numNodes;

    public ExplicitShardingPolicy(int numShards, int replicationFactor, int numNodes) {
        this.numShards = numShards;
        this.replicationFactor = replicationFactor;
        this.numNodes = numNodes;
    }

    public boolean configurationIsValid() {
        if (this.numShards * this.replicationFactor % this.numNodes != 0) {
            return false;
        }
        int shardsPerNode = this.numShards * this.replicationFactor / this.numNodes;
        return shardsPerNode <= this.numShards && shardsPerNode >= 1;
    }

    public List<Integer> getShardIdsForNode(int nodeInstance) {
        LinkedList<Integer> shardIds = new LinkedList<Integer>();
        int test = 0;
        for (int replica = 0; replica < this.replicationFactor; ++replica) {
            for (int shard = replica; shard < this.numShards + replica; ++shard) {
                if (test % this.numNodes == nodeInstance - 1) {
                    if (shardIds.contains(shard % this.numShards)) {
                        throw new AlfrescoRuntimeException("Sharding configuration not supported - unable to create shard list for node " + nodeInstance + " (shards:" + this.numShards + ", replication:" + this.replicationFactor + ", nodes:" + this.numNodes + "). Please set up the shards manually or use a different sharding configuration.");
                    }
                    shardIds.add(shard % this.numShards);
                }
                ++test;
            }
        }
        return shardIds;
    }

    public List<Integer> getNodeInstancesForShardId(int shardId) {
        LinkedList<Integer> nodeInstances = new LinkedList<Integer>();
        for (int nodeInstance = 1; nodeInstance <= this.numNodes; ++nodeInstance) {
            int test = 0;
            for (int replica = 0; replica < this.replicationFactor; ++replica) {
                for (int shard = replica; shard < this.numShards + replica; ++shard) {
                    if (test % this.numNodes == nodeInstance - 1 && shard % this.numShards == shardId) {
                        nodeInstances.add(nodeInstance);
                    }
                    ++test;
                }
            }
        }
        return nodeInstances;
    }
}

