/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.web.scripts.servlet;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Set;
import java.util.regex.Pattern;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import javax.management.Query;
import javax.management.QueryExp;
import javax.security.auth.x500.X500Principal;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class X509ServletFilterBase
implements Filter {
    protected boolean enforce;
    private String httpsPort;
    private String certContains;
    private static final Pattern PATTERN_CRLF = Pattern.compile("(\\r|\\n)");
    private static Log logger = LogFactory.getLog(X509ServletFilterBase.class);

    public void init(FilterConfig config) throws ServletException {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Initializing X509ServletFilter");
            }
            this.handleClientAuth();
            this.enforce = this.checkEnforce(config.getServletContext());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Enforcing X509 Authentication:" + this.enforce));
            }
            if (this.enforce) {
                this.certContains = config.getInitParameter("cert-contains");
                if (logger.isDebugEnabled()) {
                    if (this.certContains == null) {
                        logger.debug((Object)"Not enforcing cert-contains");
                    } else {
                        logger.debug((Object)("Enforcing cert-contains:" + this.certContains));
                    }
                }
            }
        }
        catch (Exception e) {
            throw new ServletException((Throwable)e);
        }
    }

    public void setHttpsPort(int port) {
        this.httpsPort = Integer.toString(port);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        if (this.enforce) {
            X509Certificate[] certs;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Enforcing X509 request");
            }
            if (this.validCert(certs = (X509Certificate[])httpRequest.getAttribute("javax.servlet.request.X509Certificate"))) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Cert is valid");
                }
                chain.doFilter(request, response);
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Cert is invalid");
                }
                if (!httpRequest.isSecure() && this.httpsPort != null) {
                    Object redirectUrl = httpRequest.getRequestURL().toString();
                    int port = httpRequest.getLocalPort();
                    String httpPort = Integer.toString(port);
                    redirectUrl = ((String)redirectUrl).replace(httpPort, this.httpsPort);
                    redirectUrl = ((String)redirectUrl).replace("http", "https");
                    String query = httpRequest.getQueryString();
                    if (query != null) {
                        redirectUrl = (String)redirectUrl + "?" + query;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Redirecting to:" + (String)redirectUrl));
                    }
                    redirectUrl = this.sanitize((String)redirectUrl);
                    httpResponse.sendRedirect((String)redirectUrl);
                    return;
                }
                httpResponse.sendError(403, "X509 Authentication failure");
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    protected abstract boolean checkEnforce(ServletContext var1) throws IOException;

    private boolean validCert(X509Certificate[] certs) {
        if (certs == null) {
            return false;
        }
        X509Certificate cert = certs[0];
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Checking cert is valid");
            }
            cert.checkValidity();
        }
        catch (Exception e) {
            logger.error((Object)"Cert is invalid", (Throwable)e);
            return false;
        }
        X500Principal x500Principal = cert.getSubjectX500Principal();
        String name = x500Principal.getName();
        if (this.certContains == null) {
            return true;
        }
        if (name.contains(this.certContains)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cert: " + name + "  contains:  " + this.certContains));
            }
            return true;
        }
        logger.error((Object)("Cert: " + name + "  does not contain:  " + this.certContains));
        return false;
    }

    private String sanitize(String redirectUrl) {
        if (redirectUrl != null) {
            return PATTERN_CRLF.matcher(redirectUrl).replaceAll("");
        }
        return null;
    }

    public void destroy() {
    }

    private void handleClientAuth() {
        try {
            MBeanServer mBeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
            ObjectName catalina = new ObjectName("Catalina", "type", "Engine");
            Set<ObjectName> objectNames = mBeanServer.queryNames(catalina, null);
            if (objectNames == null || objectNames.size() == 0) {
                return;
            }
            QueryExp query = Query.or(Query.eq(Query.attr("clientAuth"), Query.value("want")), Query.eq(Query.attr("clientAuth"), Query.value(true)));
            objectNames = mBeanServer.queryNames(null, query);
            if (objectNames != null && objectNames.size() == 0) {
                logger.warn((Object)"clientAuth does not appear to be set for Tomcat. clientAuth must be set to 'want' for X509 Authentication");
                logger.warn((Object)"Attempting to set clientAuth=want through JMX...");
                query = Query.eq(Query.attr("secure"), Query.value(true));
                Set<ObjectName> objectNames1 = mBeanServer.queryNames(null, query);
                if (objectNames1 != null) {
                    for (ObjectName objectName : objectNames1) {
                        if (!objectName.toString().contains("ProtocolHandler")) continue;
                        logger.warn((Object)("Setting clientAuth=want on MBean:" + objectName.toString()));
                        mBeanServer.setAttribute(objectName, new Attribute("clientAuth", "want"));
                        return;
                    }
                }
                logger.warn((Object)"Unable to set clientAuth=want through JMX.");
            }
        }
        catch (Throwable t) {
            logger.warn((Object)"An error occurred while checking for clientAuth. Turn on debug logging to see the stacktrace.");
            logger.debug((Object)"Error while handling clientAuth", t);
        }
    }
}

