/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config.element;

import java.util.List;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.ConfigElementAdapter;

public class GenericConfigElement
extends ConfigElementAdapter {
    private static final long serialVersionUID = -5475753714486623797L;

    public GenericConfigElement(String name) {
        super(name);
    }

    @Override
    public ConfigElement combine(ConfigElement configElement) {
        ConfigElement ce;
        List<ConfigElement> kids;
        String attrValue;
        GenericConfigElement combined = new GenericConfigElement(this.name);
        combined.setValue(configElement.getValue());
        if (this.attributes != null) {
            for (String attrName : this.getAttributes().keySet()) {
                attrValue = configElement.getAttribute(attrName);
                combined.addAttribute(attrName, attrValue);
            }
        }
        if (configElement.getAttributes() != null) {
            for (String attrName : configElement.getAttributes().keySet()) {
                attrValue = configElement.getAttribute(attrName);
                combined.addAttribute(attrName, attrValue);
            }
        }
        if ((kids = this.getChildren()) != null) {
            for (int x = 0; x < kids.size(); ++x) {
                ce = kids.get(x);
                combined.addChild(ce);
            }
        }
        if ((kids = configElement.getChildren()) != null) {
            for (int x = 0; x < kids.size(); ++x) {
                ce = kids.get(x);
                combined.addChild(ce);
            }
        }
        return combined;
    }

    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    public void addChild(ConfigElement configElement) {
        this.children.add(configElement);
    }
}

