/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.CMISUtils;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.BasePropertyDefintionWrapper;
import org.alfresco.opencmis.dictionary.CMISDictionaryRegistry;
import org.alfresco.opencmis.dictionary.PropertyAccessorMapping;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.PropertyLuceneBuilderMapping;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ISO9075;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.AbstractTypeDefinition;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyTypeDefinitionImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PolicyTypeDefintionWrapper
extends AbstractTypeDefinitionWrapper {
    private static final long serialVersionUID = 1L;
    protected static final Log logger = LogFactory.getLog(PolicyTypeDefintionWrapper.class);
    private PolicyTypeDefinitionImpl typeDef;
    private PolicyTypeDefinitionImpl typeDefInclProperties;
    private DictionaryService dictionaryService;

    public PolicyTypeDefintionWrapper(CMISMapping cmisMapping, PropertyAccessorMapping propertyAccessorMapping, PropertyLuceneBuilderMapping luceneBuilderMapping, String typeId, DictionaryService dictionaryService, ClassDefinition cmisClassDef) {
        this.dictionaryService = dictionaryService;
        this.alfrescoName = cmisClassDef.getName();
        this.alfrescoClass = cmisMapping.getAlfrescoClass(this.alfrescoName);
        this.typeDef = new PolicyTypeDefinitionImpl();
        this.typeDef.setBaseTypeId(BaseTypeId.CMIS_POLICY);
        this.typeDef.setId(typeId);
        this.typeDef.setLocalName(this.alfrescoName.getLocalName());
        this.typeDef.setLocalNamespace(this.alfrescoName.getNamespaceURI());
        if (BaseTypeId.CMIS_POLICY.value().equals(typeId)) {
            this.typeDef.setQueryName(ISO9075.encodeSQL(typeId));
            this.typeDef.setParentTypeId(null);
        } else {
            this.typeDef.setQueryName(ISO9075.encodeSQL(cmisMapping.buildPrefixEncodedString(this.alfrescoName)));
            QName parentQName = cmisMapping.getCmisType(cmisClassDef.getParentName());
            if (parentQName == null) {
                this.typeDef.setParentTypeId(cmisMapping.getCmisTypeId(CMISMapping.ASPECTS_QNAME));
            } else if (cmisMapping.isValidCmisPolicy(parentQName)) {
                this.typeDef.setParentTypeId(cmisMapping.getCmisTypeId(BaseTypeId.CMIS_POLICY, parentQName));
            } else {
                throw new IllegalStateException("The CMIS type model should ignore aspects that inherit from excluded aspects");
            }
        }
        this.typeDef.setDisplayName(null);
        this.typeDef.setDescription(null);
        this.typeDef.setIsCreatable(Boolean.valueOf(false));
        this.typeDef.setIsQueryable(Boolean.valueOf(true));
        this.typeDef.setIsFulltextIndexed(Boolean.valueOf(true));
        this.typeDef.setIsControllablePolicy(Boolean.valueOf(false));
        this.typeDef.setIsControllableAcl(Boolean.valueOf(false));
        this.typeDef.setIsIncludedInSupertypeQuery(cmisClassDef.getIncludedInSuperTypeQuery());
        this.typeDef.setIsFileable(Boolean.valueOf(false));
        this.typeDefInclProperties = CMISUtils.copy(this.typeDef);
        this.setTypeDefinition((AbstractTypeDefinition)this.typeDef, (AbstractTypeDefinition)this.typeDefInclProperties);
        this.createOwningPropertyDefinitions(cmisMapping, propertyAccessorMapping, luceneBuilderMapping, dictionaryService, cmisClassDef);
        this.createActionEvaluators(propertyAccessorMapping, BaseTypeId.CMIS_POLICY);
    }

    @Override
    public List<TypeDefinitionWrapper> connectParentAndSubTypes(CMISMapping cmisMapping, CMISDictionaryRegistry registry, DictionaryService dictionaryService) {
        String parentTypeId = this.typeDef.getParentTypeId();
        if (this.typeDef.getParentTypeId() != null) {
            this.parent = registry.getTypeDefByTypeId(parentTypeId);
        } else {
            if (!this.isBaseType()) {
                throw new AlfrescoRuntimeException("Type " + this.typeDef.getId() + " has no parent!");
            }
            this.parent = null;
        }
        Collection<Object> childrenNames = null;
        if (this.isBaseType()) {
            childrenNames = new ArrayList<QName>();
            childrenNames.add(CMISMapping.ASPECTS_QNAME);
        } else if (this.getAlfrescoName().equals(CMISMapping.ASPECTS_QNAME)) {
            childrenNames = new ArrayList();
            String aspectsTypeId = cmisMapping.getCmisTypeId(CMISMapping.ASPECTS_QNAME);
            for (AbstractTypeDefinitionWrapper abstractTypeDefinitionWrapper : registry.getTypeDefs(false)) {
                String parentId = abstractTypeDefinitionWrapper.getTypeDefinition(false).getParentTypeId();
                if (parentId == null || !parentId.equals(aspectsTypeId)) continue;
                childrenNames.add(abstractTypeDefinitionWrapper.getAlfrescoName());
            }
        } else {
            childrenNames = dictionaryService.getSubAspects(cmisMapping.getAlfrescoClass(this.getAlfrescoName()), false);
        }
        LinkedList<TypeDefinitionWrapper> children = new LinkedList<TypeDefinitionWrapper>();
        for (QName qName : childrenNames) {
            if (cmisMapping.isValidCmisPolicy(qName)) {
                TypeDefinitionWrapper child = registry.getTypeDefByQName(qName);
                if (child == null) {
                    throw new AlfrescoRuntimeException("Failed to retrieve sub type for type id " + qName + " for parent type " + this.getAlfrescoName() + "!");
                }
                children.add(child);
                continue;
            }
            logger.info((Object)("Not a policy: " + qName));
        }
        return children;
    }

    @Override
    public void resolveInheritance(CMISMapping cmisMapping, CMISDictionaryRegistry registry, DictionaryService dictionaryService) {
        if (this.parent != null) {
            for (PropertyDefinitionWrapper propDef : this.parent.getProperties(false)) {
                if (this.propertiesById.containsKey(propDef.getPropertyId())) continue;
                PropertyDefinition alfrescoPropDef = dictionaryService.getProperty(propDef.getOwningType().getAlfrescoName(), propDef.getAlfrescoName());
                org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition<?> propertyDefintion = this.createPropertyDefinition(cmisMapping, propDef.getPropertyId(), alfrescoPropDef.getName(), dictionaryService, alfrescoPropDef, true);
                if (propertyDefintion == null) continue;
                this.registerProperty(new BasePropertyDefintionWrapper(propertyDefintion, alfrescoPropDef.getName(), propDef.getOwningType(), propDef.getPropertyAccessor(), propDef.getPropertyLuceneBuilder()));
            }
        }
        List<TypeDefinitionWrapper> children = registry.getChildren(this.typeDef.getId());
        for (TypeDefinitionWrapper child : children) {
            if (!(child instanceof AbstractTypeDefinitionWrapper)) continue;
            ((AbstractTypeDefinitionWrapper)child).resolveInheritance(cmisMapping, registry, dictionaryService);
        }
    }

    @Override
    public void updateDefinition(DictionaryService dictionaryService) {
        AspectDefinition aspectDef = dictionaryService.getAspect(this.alfrescoName);
        if (aspectDef != null) {
            this.setTypeDefDisplayName(aspectDef.getTitle(dictionaryService));
            this.setTypeDefDescription(aspectDef.getDescription(dictionaryService));
        } else {
            super.updateDefinition(dictionaryService);
        }
        this.updateTypeDefInclProperties();
    }

    @Override
    public PropertyDefinitionWrapper getPropertyById(String propertyId) {
        this.updateProperty(this.dictionaryService, (PropertyDefinitionWrapper)this.propertiesById.get(propertyId));
        return (PropertyDefinitionWrapper)this.propertiesById.get(propertyId);
    }

    @Override
    public Collection<PropertyDefinitionWrapper> getProperties() {
        this.updateProperties(this.dictionaryService);
        return this.propertiesById.values();
    }

    @Override
    public Collection<PropertyDefinitionWrapper> getProperties(boolean update) {
        if (update) {
            return this.getProperties();
        }
        return this.propertiesById.values();
    }
}

