/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene.functions;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.search.adaptor.QueryParserAdaptor;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.ListArgument;
import org.alfresco.repo.search.impl.querymodel.LiteralArgument;
import org.alfresco.repo.search.impl.querymodel.PredicateMode;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.impl.functions.In;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.QueryBuilderContext;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;

public class LuceneIn<Q, S, E extends Throwable>
extends In
implements LuceneQueryBuilderComponent<Q, S, E> {
    @Override
    public Q addComponent(Set<String> selectors, Map<String, Argument> functionArgs, QueryBuilderContext<Q, S, E> luceneContext, FunctionEvaluationContext functionContext) throws E {
        QueryParserAdaptor<Q, S, E> lqpa = luceneContext.getLuceneQueryParserAdaptor();
        PropertyArgument propertyArgument = (PropertyArgument)functionArgs.get("Property");
        Argument inverseArgument = functionArgs.get("Not");
        Boolean not = DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)inverseArgument.getValue(functionContext));
        LiteralArgument modeArgument = (LiteralArgument)functionArgs.get("Mode");
        String modeString = DefaultTypeConverter.INSTANCE.convert(String.class, (Object)modeArgument.getValue(functionContext));
        PredicateMode mode = PredicateMode.valueOf(modeString);
        ListArgument listArgument = (ListArgument)functionArgs.get("List");
        Collection collection = (Collection)((Object)listArgument.getValue(functionContext));
        Q query = functionContext.buildLuceneIn(lqpa, propertyArgument.getPropertyName(), collection, not, mode);
        if (query == null) {
            throw new QueryModelException("No query time mapping for property  " + propertyArgument.getPropertyName() + ", it should not be allowed in predicates");
        }
        return query;
    }
}

