/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AclReaders {
    private final long id;
    private List<String> readers;
    private final List<String> denied;
    private final long aclChangeSetId;
    private final String tenantDomain;

    public AclReaders(long id, List<String> readers, List<String> denied, long aclChangeSetId, String tenantDomain) {
        this.id = id;
        this.readers = readers == null ? null : new ArrayList<String>(readers);
        this.denied = denied == null ? null : new ArrayList<String>(denied);
        this.aclChangeSetId = aclChangeSetId;
        this.tenantDomain = tenantDomain;
    }

    public String toString() {
        return "AclReaders [id=" + this.id + ", readers=" + String.valueOf(this.readers) + ", denied=" + String.valueOf(this.denied) + ", tenantDomain=" + this.tenantDomain + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.id ^ this.id >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AclReaders other = (AclReaders)obj;
        return this.id == other.id;
    }

    public long getId() {
        return this.id;
    }

    public List<String> getReaders() {
        return Collections.unmodifiableList(this.readers);
    }

    public void setReaders(List readers) {
        this.readers = new ArrayList<String>(readers);
    }

    public List<String> getDenied() {
        return Collections.unmodifiableList(this.denied);
    }

    public long getAclChangeSetId() {
        return this.aclChangeSetId;
    }

    public String getTenantDomain() {
        return this.tenantDomain;
    }
}

