/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.encryption;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.AlgorithmParameters;
import java.util.Arrays;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.encryption.EncryptionUtils;
import org.alfresco.encryption.Encryptor;
import org.alfresco.encryption.MACUtils;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.util.IPUtils;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.Base64;
import org.springframework.util.FileCopyUtils;

public class DefaultEncryptionUtils
implements EncryptionUtils {
    protected static Log logger = LogFactory.getLog(Encryptor.class);
    protected static String HEADER_ALGORITHM_PARAMETERS = "XAlfresco-algorithmParameters";
    protected static String HEADER_MAC = "XAlfresco-mac";
    protected static String HEADER_TIMESTAMP = "XAlfresco-timestamp";
    protected Encryptor encryptor;
    protected MACUtils macUtils;
    protected long messageTimeout;
    protected String remoteIP;
    protected String localIP;

    public DefaultEncryptionUtils() {
        try {
            this.localIP = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Unable to initialise EncryptionUtils", e);
        }
    }

    public String getRemoteIP() {
        return this.remoteIP;
    }

    public void setRemoteIP(String remoteIP) {
        try {
            this.remoteIP = IPUtils.getRealIPAddress(remoteIP);
        }
        catch (UnknownHostException e) {
            throw new AlfrescoRuntimeException("Failed to get server IP address", e);
        }
    }

    protected String getLocalIPAddress() {
        return this.localIP;
    }

    public void setMessageTimeout(long messageTimeout) {
        this.messageTimeout = messageTimeout;
    }

    public void setEncryptor(Encryptor encryptor) {
        this.encryptor = encryptor;
    }

    public void setMacUtils(MACUtils macUtils) {
        this.macUtils = macUtils;
    }

    protected void setRequestMac(HttpMethod method, byte[] mac) {
        if (mac == null) {
            throw new AlfrescoRuntimeException("Mac cannot be null");
        }
        method.setRequestHeader(HEADER_MAC, Base64.encodeBytes((byte[])mac));
    }

    protected void setMac(HttpServletResponse response, byte[] mac) {
        if (mac == null) {
            throw new AlfrescoRuntimeException("Mac cannot be null");
        }
        response.setHeader(HEADER_MAC, Base64.encodeBytes((byte[])mac));
    }

    protected byte[] getMac(HttpServletRequest req) throws IOException {
        String header = req.getHeader(HEADER_MAC);
        if (header != null) {
            return Base64.decode((String)header);
        }
        return null;
    }

    protected byte[] getResponseMac(HttpMethod res) throws IOException {
        Header header = res.getResponseHeader(HEADER_MAC);
        if (header != null) {
            return Base64.decode((String)header.getValue());
        }
        return null;
    }

    protected void setRequestTimestamp(HttpMethod method, long timestamp) {
        method.setRequestHeader(HEADER_TIMESTAMP, String.valueOf(timestamp));
    }

    protected void setTimestamp(HttpServletResponse res, long timestamp) {
        res.setHeader(HEADER_TIMESTAMP, String.valueOf(timestamp));
    }

    protected Long getResponseTimestamp(HttpMethod method) throws IOException {
        Header header = method.getResponseHeader(HEADER_TIMESTAMP);
        if (header != null) {
            return Long.valueOf(header.getValue());
        }
        return null;
    }

    protected Long getTimestamp(HttpServletRequest method) throws IOException {
        String header = method.getHeader(HEADER_TIMESTAMP);
        if (header != null) {
            return Long.valueOf(header);
        }
        return null;
    }

    @Override
    public void setRequestAlgorithmParameters(HttpMethod method, AlgorithmParameters params) throws IOException {
        if (params != null) {
            method.setRequestHeader(HEADER_ALGORITHM_PARAMETERS, Base64.encodeBytes((byte[])params.getEncoded()));
        }
    }

    protected void setAlgorithmParameters(HttpServletResponse response, AlgorithmParameters params) throws IOException {
        if (params != null) {
            response.setHeader(HEADER_ALGORITHM_PARAMETERS, Base64.encodeBytes((byte[])params.getEncoded()));
        }
    }

    protected AlgorithmParameters decodeAlgorithmParameters(HttpMethod method) throws IOException {
        Header header = method.getResponseHeader(HEADER_ALGORITHM_PARAMETERS);
        if (header != null) {
            byte[] algorithmParams = Base64.decode((String)header.getValue());
            AlgorithmParameters algorithmParameters = this.encryptor.decodeAlgorithmParameters(algorithmParams);
            return algorithmParameters;
        }
        return null;
    }

    protected AlgorithmParameters decodeAlgorithmParameters(HttpServletRequest req) throws IOException {
        String header = req.getHeader(HEADER_ALGORITHM_PARAMETERS);
        if (header != null) {
            byte[] algorithmParams = Base64.decode((String)header);
            AlgorithmParameters algorithmParameters = this.encryptor.decodeAlgorithmParameters(algorithmParams);
            return algorithmParameters;
        }
        return null;
    }

    @Override
    public byte[] decryptResponseBody(HttpMethod method) throws IOException {
        InputStream body = method.getResponseBodyAsStream();
        if (body != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            FileCopyUtils.copy((InputStream)body, (OutputStream)out);
            AlgorithmParameters params = this.decodeAlgorithmParameters(method);
            if (params != null) {
                byte[] decrypted = this.encryptor.decrypt("solr", params, out.toByteArray());
                return decrypted;
            }
            throw new AlfrescoRuntimeException("Unable to decrypt response body, missing encryption algorithm parameters");
        }
        return null;
    }

    @Override
    public byte[] decryptBody(HttpServletRequest req) throws IOException {
        if (req.getMethod().equals("POST")) {
            ServletInputStream bodyStream = req.getInputStream();
            if (bodyStream != null) {
                AlgorithmParameters p = this.decodeAlgorithmParameters(req);
                InputStream in = this.encryptor.decrypt("solr", p, (InputStream)bodyStream);
                return IOUtils.toByteArray((InputStream)in);
            }
            return null;
        }
        return null;
    }

    @Override
    public boolean authenticateResponse(HttpMethod method, String remoteIP, byte[] decryptedBody) {
        try {
            byte[] expectedMAC = this.getResponseMac(method);
            Long timestamp = this.getResponseTimestamp(method);
            if (timestamp == null) {
                return false;
            }
            remoteIP = IPUtils.getRealIPAddress(remoteIP);
            return this.authenticate(expectedMAC, new MACUtils.MACInput(decryptedBody, timestamp, remoteIP));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to authenticate HTTP response", e);
        }
    }

    @Override
    public boolean authenticate(HttpServletRequest req, byte[] decryptedBody) {
        try {
            byte[] expectedMAC = this.getMac(req);
            Long timestamp = this.getTimestamp(req);
            if (timestamp == null) {
                return false;
            }
            String ipAddress = IPUtils.getRealIPAddress(req.getRemoteAddr());
            return this.authenticate(expectedMAC, new MACUtils.MACInput(decryptedBody, timestamp, ipAddress));
        }
        catch (Exception e) {
            throw new AlfrescoRuntimeException("Unable to authenticate HTTP request", e);
        }
    }

    @Override
    public void setRequestAuthentication(HttpMethod method, byte[] message) throws IOException {
        long requestTimestamp = System.currentTimeMillis();
        byte[] mac = this.macUtils.generateMAC("solr", new MACUtils.MACInput(message, requestTimestamp, this.getLocalIPAddress()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting MAC " + Arrays.toString(mac) + " on HTTP request " + method.getPath()));
            logger.debug((Object)("Setting timestamp " + requestTimestamp + " on HTTP request " + method.getPath()));
        }
        this.setRequestMac(method, mac);
        this.setRequestTimestamp(method, requestTimestamp);
    }

    @Override
    public void setResponseAuthentication(HttpServletRequest httpRequest, HttpServletResponse httpResponse, byte[] responseBody, AlgorithmParameters params) throws IOException {
        long responseTimestamp = System.currentTimeMillis();
        byte[] mac = this.macUtils.generateMAC("solr", new MACUtils.MACInput(responseBody, responseTimestamp, this.getLocalIPAddress()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Setting MAC " + Arrays.toString(mac) + " on HTTP response to request " + httpRequest.getRequestURI()));
            logger.debug((Object)("Setting timestamp " + responseTimestamp + " on HTTP response to request " + httpRequest.getRequestURI()));
        }
        this.setAlgorithmParameters(httpResponse, params);
        this.setMac(httpResponse, mac);
        this.setTimestamp(httpResponse, responseTimestamp);
    }

    protected boolean authenticate(byte[] expectedMAC, MACUtils.MACInput macInput) {
        boolean authorized = this.macUtils.validateMAC("solr", expectedMAC, macInput) && this.validateTimestamp(macInput.getTimestamp());
        return authorized;
    }

    protected boolean validateTimestamp(long timestamp) {
        long currentTime = System.currentTimeMillis();
        return currentTime - timestamp < this.messageTimeout;
    }
}

