/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.query;

import org.alfresco.query.PagingRequest;

public class CannedQueryPageDetails {
    public static final int DEFAULT_SKIP_RESULTS = 0;
    public static final int DEFAULT_PAGE_SIZE = Integer.MAX_VALUE;
    public static final int DEFAULT_PAGE_NUMBER = 1;
    public static final int DEFAULT_PAGE_COUNT = 1;
    private final int skipResults;
    private final int pageSize;
    private final int pageNumber;
    private final int pageCount;

    public CannedQueryPageDetails() {
        this(0, Integer.MAX_VALUE, 1, 1);
    }

    public CannedQueryPageDetails(int skipResults, int pageSize) {
        this(skipResults, pageSize, 1, 1);
    }

    public CannedQueryPageDetails(int skipResults, int pageSize, int pageNumber, int pageCount) {
        this.skipResults = skipResults;
        this.pageSize = pageSize;
        this.pageNumber = pageNumber;
        this.pageCount = pageCount;
        if (skipResults < 0) {
            throw new IllegalArgumentException("Cannot skip fewer than 0 results.");
        }
        if (pageSize < 1) {
            throw new IllegalArgumentException("pageSize must be greater than zero.");
        }
        if (pageNumber < 1) {
            throw new IllegalArgumentException("pageNumber must be greater than zero.");
        }
        if (pageCount < 1) {
            throw new IllegalArgumentException("pageCount must be greater than zero.");
        }
    }

    public CannedQueryPageDetails(PagingRequest pagingRequest) {
        this(pagingRequest.getSkipCount(), pagingRequest.getMaxItems());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("NamedQueryPageDetails ").append("[skipResults=").append(this.skipResults).append(", pageSize=").append(this.pageSize).append(", pageCount=").append(this.pageCount).append(", pageNumber=").append(this.pageNumber).append("]");
        return sb.toString();
    }

    public int getSkipResults() {
        return this.skipResults;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getResultsRequiredForPaging() {
        int tmp = this.skipResults + this.pageCount * this.pageSize;
        if (tmp < 0) {
            return Integer.MAX_VALUE;
        }
        return tmp;
    }
}

