/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.query;

import org.alfresco.api.AlfrescoPublicApi;

@AlfrescoPublicApi
public class PagingRequest {
    private int skipCount = 0;
    private int maxItems;
    private int requestTotalCountMax = 0;
    private String queryExecutionId;

    public PagingRequest(int maxItems) {
        this.maxItems = maxItems;
    }

    public PagingRequest(int skipCount, int maxItems) {
        this.skipCount = skipCount;
        this.maxItems = maxItems;
    }

    public PagingRequest(int maxItems, String queryExecutionId) {
        this.setMaxItems(maxItems);
        this.queryExecutionId = queryExecutionId;
    }

    public PagingRequest(int skipCount, int maxItems, String queryExecutionId) {
        this.setSkipCount(skipCount);
        this.setMaxItems(maxItems);
        this.queryExecutionId = queryExecutionId;
    }

    public int getSkipCount() {
        return this.skipCount;
    }

    protected void setSkipCount(int skipCount) {
        this.skipCount = skipCount < 0 ? 0 : skipCount;
    }

    public int getMaxItems() {
        return this.maxItems;
    }

    protected void setMaxItems(int maxItems) {
        this.maxItems = maxItems < 0 ? Integer.MAX_VALUE : maxItems;
    }

    public int getRequestTotalCountMax() {
        return this.requestTotalCountMax;
    }

    public void setRequestTotalCountMax(int requestTotalCountMax) {
        this.requestTotalCountMax = requestTotalCountMax;
    }

    public String getQueryExecutionId() {
        return this.queryExecutionId;
    }

    protected void setQueryExecutionId(String queryExecutionId) {
        this.queryExecutionId = queryExecutionId;
    }
}

