/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.HashMap;
import java.util.Map;

public class ArgumentHelper {
    private String usage;
    private Map<String, String> args;

    public static Map<String, String> ripArgs(String ... args) {
        HashMap<String, String> argsMap = new HashMap<String, String>(5);
        for (String arg : args) {
            int index = arg.indexOf(61);
            if (!arg.startsWith("--") || index < 0 || index == arg.length() - 1) continue;
            String name = arg.substring(2, index);
            String value = arg.substring(index + 1, arg.length());
            argsMap.put(name, value);
        }
        return argsMap;
    }

    public ArgumentHelper(String usage, String[] args) {
        this.usage = usage;
        this.args = ArgumentHelper.ripArgs(args);
    }

    public String getStringValue(String arg, boolean mandatory, boolean nonEmpty) {
        String value = this.args.get(arg);
        if (value == null && mandatory) {
            throw new IllegalArgumentException("Argument '" + arg + "' is required.");
        }
        if (value != null && value.length() == 0 && nonEmpty) {
            throw new IllegalArgumentException("Argument '" + arg + "' may not be empty.");
        }
        return value;
    }

    public int getIntegerValue(String arg, boolean mandatory, int minValue, int maxValue) {
        String valueStr = this.args.get(arg);
        if (valueStr == null) {
            if (mandatory) {
                throw new IllegalArgumentException("Argument '" + arg + "' is required.");
            }
            return minValue;
        }
        try {
            int value = Integer.parseInt(valueStr);
            if (value < minValue || value > maxValue) {
                throw new IllegalArgumentException("Argument '" + arg + "' must be in range " + minValue + " to " + maxValue + ".");
            }
            return value;
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Argument '" + arg + "' must be a valid integer.");
        }
    }

    public void printUsage() {
        System.out.println(this.usage);
    }
}

