/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.WeakHashMap;
import org.alfresco.util.Pair;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class CachingDateFormat
extends SimpleDateFormat {
    private static final long serialVersionUID = 3258415049197565235L;
    public static final String UTC = "UTC";
    public static final String FORMAT_FULL_GENERIC = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String FORMAT_CMIS_SQL = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    public static final String FORMAT_SOLR = "yyyy-MM-dd'T'HH:mm:ss.SSSX";
    public static final String UTC_WITHOUT_MSECS = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    public static final String FORMAT_DATE_GENERIC = "yyyy-MM-dd";
    public static final String FORMAT_TIME_GENERIC = "HH:mm:ss";
    public static final StringAndResolution[] LENIENT_FORMATS = new StringAndResolution[]{new StringAndResolution("yyyy-MM-dd'T'HH:mm:ss.SSSZ", 14), new StringAndResolution("yyyy-MM-dd'T'HH:mm:ss.SSS", 14), new StringAndResolution("yyyy-MM-dd'T'HH:mm:ssZ", 13), new StringAndResolution("yyyy-MM-dd'T'HH:mm:ss", 13), new StringAndResolution("yyyy-MM-dd'T'HH:mmZ", 12), new StringAndResolution("yyyy-MM-dd'T'HH:mm", 12), new StringAndResolution("yyyy-MM-dd'T'HHZ", 11), new StringAndResolution("yyyy-MM-dd'T'HH", 11), new StringAndResolution("yyyy-MM-dd'T'Z", 5), new StringAndResolution("yyyy-MM-dd'T'", 5), new StringAndResolution("yyyy-MM-ddZ", 5), new StringAndResolution("yyyy-MM-dd", 5), new StringAndResolution("yyyy-MMZ", 2), new StringAndResolution("yyyy-MM", 2), new StringAndResolution("yyyy-MMM-dd'T'HH:mm:ss.SSSZ", 14), new StringAndResolution("yyyy-MMM-dd'T'HH:mm:ss.SSS", 14), new StringAndResolution("yyyy-MMM-dd'T'HH:mm:ssZ", 13), new StringAndResolution("yyyy-MMM-dd'T'HH:mm:ss", 13), new StringAndResolution("yyyy-MMM-dd'T'HH:mmZ", 12), new StringAndResolution("yyyy-MMM-dd'T'HH:mm", 12), new StringAndResolution("yyyy-MMM-dd'T'HHZ", 11), new StringAndResolution("yyyy-MMM-dd'T'HH", 11), new StringAndResolution("yyyy-MMM-dd'T'Z", 5), new StringAndResolution("yyyy-MMM-dd'T'", 5), new StringAndResolution("yyyy-MMM-ddZ", 5), new StringAndResolution("yyyy-MMM-dd", 5), new StringAndResolution("yyyy-MMMZ", 2), new StringAndResolution("yyyy-MMM", 2), new StringAndResolution("yyyyZ", 1), new StringAndResolution("yyyy", 1)};
    static ThreadLocal<SimpleDateFormat> S_LOCAL_DATE_FORMAT = ThreadLocal.withInitial(() -> CachingDateFormat.newDateFormat(FORMAT_FULL_GENERIC));
    static ThreadLocal<SimpleDateFormat> S_LOCAL_DATEONLY_FORMAT = ThreadLocal.withInitial(() -> CachingDateFormat.newDateFormat(FORMAT_DATE_GENERIC));
    static ThreadLocal<SimpleDateFormat> S_LOCAL_TIMEONLY_FORMAT = ThreadLocal.withInitial(() -> CachingDateFormat.newDateFormat(FORMAT_TIME_GENERIC));
    static ThreadLocal<SimpleDateFormat> S_LOCAL_CMIS_SQL_DATETIME = ThreadLocal.withInitial(() -> CachingDateFormat.newDateFormat(FORMAT_CMIS_SQL));
    static ThreadLocal<SimpleDateFormat> S_LOCAL_SOLR_DATETIME = ThreadLocal.withInitial(() -> {
        CachingDateFormat formatter = CachingDateFormat.newDateFormatWithLocale(FORMAT_SOLR, Locale.ENGLISH);
        formatter.setTimeZone(TimeZone.getTimeZone(UTC));
        return formatter;
    });
    static ThreadLocal<SimpleDateFormat> S_UTC_DATETIME_WITHOUT_MSECS = ThreadLocal.withInitial(() -> {
        CachingDateFormat formatter = CachingDateFormat.newDateFormatWithLocale(UTC_WITHOUT_MSECS, Locale.ENGLISH);
        formatter.setTimeZone(TimeZone.getTimeZone(UTC));
        return formatter;
    });
    static ThreadLocal<SimpleDateFormatAndResolution[]> S_LENIENT_PARSERS = ThreadLocal.withInitial(() -> (SimpleDateFormatAndResolution[])Arrays.stream(LENIENT_FORMATS).map(format -> {
        CachingDateFormat formatter = new CachingDateFormat(format.string);
        formatter.setLenient(false);
        return new SimpleDateFormatAndResolution(formatter, format.resolution);
    }).toArray(SimpleDateFormatAndResolution[]::new));
    private Map<String, Date> cacheDates = new WeakHashMap<String, Date>(89);

    private CachingDateFormat(String pattern, Locale locale) {
        super(pattern, locale);
    }

    private CachingDateFormat(String pattern) {
        super(pattern);
    }

    public String toString() {
        return this.toPattern();
    }

    public static SimpleDateFormat getDateFormat(int length, Locale locale, boolean lenient) {
        SimpleDateFormat dateFormat = (SimpleDateFormat)CachingDateFormat.getDateInstance(length, locale);
        String pattern = dateFormat.toPattern();
        return CachingDateFormat.getDateFormat(pattern, lenient);
    }

    public static SimpleDateFormat getDateTimeFormat(int dateLength, int timeLength, Locale locale, boolean lenient) {
        SimpleDateFormat dateFormat = (SimpleDateFormat)CachingDateFormat.getDateTimeInstance(dateLength, timeLength, locale);
        String pattern = dateFormat.toPattern();
        return CachingDateFormat.getDateFormat(pattern, lenient);
    }

    public static SimpleDateFormat getDateFormat(String pattern, boolean lenient) {
        CachingDateFormat dateFormat = new CachingDateFormat(pattern);
        dateFormat.setLenient(lenient);
        return dateFormat;
    }

    public static SimpleDateFormat getDateFormat() {
        return S_LOCAL_DATE_FORMAT.get();
    }

    public static SimpleDateFormat getCmisSqlDatetimeFormat() {
        return S_LOCAL_CMIS_SQL_DATETIME.get();
    }

    public static SimpleDateFormat getSolrDatetimeFormatWithoutMsecs() {
        return S_UTC_DATETIME_WITHOUT_MSECS.get();
    }

    public static SimpleDateFormat getSolrDatetimeFormat() {
        return S_LOCAL_SOLR_DATETIME.get();
    }

    public static SimpleDateFormat getDateOnlyFormat() {
        return S_LOCAL_DATEONLY_FORMAT.get();
    }

    public static SimpleDateFormat getTimeOnlyFormat() {
        return S_LOCAL_TIMEONLY_FORMAT.get();
    }

    @Override
    public Date parse(String text, ParsePosition pos) {
        Date cached = this.cacheDates.get(text);
        if (cached == null) {
            Date date = super.parse(text, pos);
            if (date != null && pos.getIndex() == text.length()) {
                this.cacheDates.put(text, date);
                return (Date)date.clone();
            }
            return date;
        }
        pos.setIndex(text.length());
        return (Date)cached.clone();
    }

    public static Pair<Date, Integer> lenientParse(String text, int minimumResolution) throws ParseException {
        DateTimeFormatter fmt = ISODateTimeFormat.dateTime();
        try {
            Date parsed = fmt.parseDateTime(text).toDate();
            return new Pair<Date, Integer>(parsed, 14);
        }
        catch (IllegalArgumentException parsed) {
            SimpleDateFormatAndResolution[] formatters;
            for (SimpleDateFormatAndResolution formatter : formatters = CachingDateFormat.getLenientFormatters()) {
                if (formatter.resolution < minimumResolution) continue;
                ParsePosition pp = new ParsePosition(0);
                Date parsed2 = formatter.simpleDateFormat.parse(text, pp);
                if (pp.getIndex() < text.length() || parsed2 == null) continue;
                return new Pair<Date, Integer>(parsed2, formatter.resolution);
            }
            throw new ParseException("Unknown date format", 0);
        }
    }

    public static SimpleDateFormatAndResolution[] getLenientFormatters() {
        return S_LENIENT_PARSERS.get();
    }

    private static CachingDateFormat newDateFormat(String pattern) {
        CachingDateFormat formatter = new CachingDateFormat(pattern);
        formatter.setLenient(false);
        return formatter;
    }

    private static CachingDateFormat newDateFormatWithLocale(String pattern, Locale locale) {
        CachingDateFormat formatter = new CachingDateFormat(pattern, locale);
        formatter.setLenient(false);
        return formatter;
    }

    public static class SimpleDateFormatAndResolution {
        SimpleDateFormat simpleDateFormat;
        int resolution;

        SimpleDateFormatAndResolution(SimpleDateFormat simpleDateFormat, int resolution) {
            this.simpleDateFormat = simpleDateFormat;
            this.resolution = resolution;
        }

        public SimpleDateFormat getSimpleDateFormat() {
            return this.simpleDateFormat;
        }

        public int getResolution() {
            return this.resolution;
        }
    }

    public static class StringAndResolution {
        String string;
        int resolution;

        public int getResolution() {
            return this.resolution;
        }

        public void setResolution(int resolution) {
            this.resolution = resolution;
        }

        StringAndResolution(String string, int resolution) {
            this.string = string;
            this.resolution = resolution;
        }
    }
}

