/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.analysis.MLAnalayser;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.solr.schema.IndexSchema;

public class AlfrescoAnalyzerWrapper
extends AnalyzerWrapper {
    IndexSchema schema;
    Mode mode;

    public AlfrescoAnalyzerWrapper(IndexSchema schema, Mode mode) {
        super(Analyzer.PER_FIELD_REUSE_STRATEGY);
        this.schema = schema;
        this.mode = mode;
    }

    public int getPositionIncrementGap(String fieldName) {
        return 100;
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        if (fieldName.contains("l_@{")) {
            return new MLAnalayser(MLAnalysisMode.EXACT_LANGUAGE, this.schema, this.mode);
        }
        if (fieldName.contains("lt@{")) {
            return new MLAnalayser(MLAnalysisMode.EXACT_LANGUAGE, this.schema, this.mode);
        }
        if (this.mode == Mode.INDEX) {
            return this.schema.getFieldTypeByName("text___").getIndexAnalyzer();
        }
        if (this.mode == Mode.QUERY) {
            return this.schema.getFieldTypeByName("text___").getQueryAnalyzer();
        }
        throw new IllegalStateException();
    }

    public static enum Mode {
        INDEX,
        QUERY;

    }
}

