/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr;

import com.carrotsearch.hppc.IntArrayList;
import com.carrotsearch.hppc.LongHashSet;
import com.carrotsearch.hppc.cursors.LongCursor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.IsoFields;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.zip.GZIPInputStream;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.AclReport;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.Cloud;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.InformationServerCollectionProvider;
import org.alfresco.solr.NodeReport;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.TrackerStateException;
import org.alfresco.solr.adapters.IOpenBitSet;
import org.alfresco.solr.adapters.ISimpleOrderedMap;
import org.alfresco.solr.adapters.SolrOpenBitSetAdapter;
import org.alfresco.solr.adapters.SolrSimpleOrderedMap;
import org.alfresco.solr.client.AclChangeSet;
import org.alfresco.solr.client.AclChangeSets;
import org.alfresco.solr.client.AclReaders;
import org.alfresco.solr.client.AlfrescoModel;
import org.alfresco.solr.client.ContentPropertyValue;
import org.alfresco.solr.client.MLTextPropertyValue;
import org.alfresco.solr.client.MultiPropertyValue;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.NodeMetaData;
import org.alfresco.solr.client.NodeMetaDataParameters;
import org.alfresco.solr.client.PropertyValue;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.StringPropertyValue;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.config.ConfigUtil;
import org.alfresco.solr.logging.Log;
import org.alfresco.solr.tracker.IndexHealthReport;
import org.alfresco.solr.tracker.TrackerStats;
import org.alfresco.solr.utils.Utils;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.apache.commons.io.input.BoundedInputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.LegacyNumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.common.SolrInputField;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.IndexDeletionPolicyWrapper;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrInfoMBean;
import org.apache.solr.request.LocalSolrQueryRequest;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.response.BasicResultContext;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DelegatingCollector;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.QueryWrapperFilter;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.AddUpdateCommand;
import org.apache.solr.update.CommitUpdateCommand;
import org.apache.solr.update.DeleteUpdateCommand;
import org.apache.solr.update.RollbackUpdateCommand;
import org.apache.solr.update.processor.UpdateRequestProcessor;
import org.apache.solr.util.ConcurrentLRUCache;
import org.apache.solr.util.RefCounted;
import org.json.JSONException;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.util.FileCopyUtils;

public class SolrInformationServer
implements InformationServer {
    private static final Log LOGGER = new Log(SolrInformationServer.class);
    private static final String NO_SITE = "_REPOSITORY_";
    private static final String SHARED_FILES = "_SHARED_FILES_";
    private static final Set<String> REQUEST_ONLY_ID_FIELD = new HashSet<String>(Collections.singletonList("id"));
    private static final String LATEST_APPLIED_CONTENT_VERSION_ID = "LATEST_APPLIED_CONTENT_VERSION_ID";
    private static final String LAST_INCOMING_CONTENT_VERSION_ID = "LAST_INCOMING_CONTENT_VERSION_ID";
    private static final long CONTENT_OUTDATED_MARKER = -10L;
    private static final long CONTENT_UPDATED_MARKER = -20L;
    private static final String CONTENT_FIELD_NAME = "contentFieldName";
    private static final String CONTENT_LOCALE = "contentLocale";
    private static final String CONTENT_LOCALE_FIELD = "content@s__locale@{http://www.alfresco.org/model/content/1.0}content";
    private static final Set<String> ID_AND_CONTENT_VERSION_ID_AND_CONTENT_LOCALE = new HashSet<String>(Arrays.asList("id", "LATEST_APPLIED_CONTENT_VERSION_ID", "content@s__locale@{http://www.alfresco.org/model/content/1.0}content"));
    private static final String INDEX_CAP_ID = "TRACKER!STATE!CAP";
    private static final Pattern CAPTURE_SITE = Pattern.compile("^/\\{http\\://www\\.alfresco\\.org/model/application/1\\.0\\}company\\_home/\\{http\\://www\\.alfresco\\.org/model/site/1\\.0\\}sites/\\{http\\://www\\.alfresco\\.org/model/content/1\\.0}([^/]*)/.*");
    private static final Pattern CAPTURE_TAG = Pattern.compile("^/\\{http\\://www\\.alfresco\\.org/model/content/1\\.0\\}taggable/\\{http\\://www\\.alfresco\\.org/model/content/1\\.0\\}([^/]*)/\\{\\}member");
    private static final Pattern CAPTURE_SHARED_FILES = Pattern.compile("^/\\{http\\://www\\.alfresco\\.org/model/application/1\\.0\\}company\\_home/\\{http\\://www\\.alfresco\\.org/model/application/1\\.0\\}shared/.*");
    public static final String AND = " AND ";
    public static final String OR = " OR ";
    static final String REQUEST_HANDLER_NATIVE = "/native";
    static final String REQUEST_HANDLER_GET = "/get";
    static final String RESPONSE_DEFAULT_ID = "doc";
    static final String RESPONSE_DEFAULT_IDS = "response";
    static final String PREFIX_ERROR = "ERROR-";
    public static final String DOC_TYPE_NODE = "Node";
    private static final String DOC_TYPE_UNINDEXED_NODE = "UnindexedNode";
    private static final String DOC_TYPE_ERROR_NODE = "ErrorNode";
    public static final String DOC_TYPE_ACL = "Acl";
    public static final String DOC_TYPE_TX = "Tx";
    public static final String DOC_TYPE_ACL_TX = "AclTx";
    private static final String DOC_TYPE_STATE = "State";
    public static final String SOLR_HOST = "solr.host";
    public static final String SOLR_PORT = "solr.port";
    public static final String SOLR_BASEURL = "solr.baseurl";
    private static final int BATCH_FACET_TXS = 4096;
    private static final String FINGERPRINT_FIELD = "MINHASH";
    public static final String CASCADE_TRACKER_ENABLED = "alfresco.cascade.tracker.enabled";
    private static final String UNIT_OF_TIME_FIELD_INFIX = "_unit_of_time";
    public static final String UNIT_OF_TIME_YEAR_FIELD_SUFFIX = "_unit_of_time_year";
    public static final String UNIT_OF_TIME_QUARTER_FIELD_SUFFIX = "_unit_of_time_quarter";
    public static final String UNIT_OF_TIME_MONTH_FIELD_SUFFIX = "_unit_of_time_month";
    public static final String UNIT_OF_TIME_DAY_FIELD_SUFFIX = "_unit_of_time_day_of_month";
    public static final String UNIT_OF_TIME_DAY_OF_WEEK_FIELD_SUFFIX = "_unit_of_time_day_of_week";
    public static final String UNIT_OF_TIME_DAY_OF_YEAR_FIELD_SUFFIX = "_unit_of_time_day_of_year";
    public static final String UNIT_OF_TIME_HOUR_FIELD_SUFFIX = "_unit_of_time_hour";
    public static final String UNIT_OF_TIME_MINUTE_FIELD_SUFFIX = "_unit_of_time_minute";
    public static final String UNIT_OF_TIME_SECOND_FIELD_SUFFIX = "_unit_of_time_second";
    private static final Function<String, List<Object>> LAZY_EMPTY_MUTABLE_LIST = key -> new ArrayList();
    private final AlfrescoCoreAdminHandler adminHandler;
    private final SolrCore core;
    private final SolrRequestHandler nativeRequestHandler;
    private final Cloud cloud;
    private final TrackerStats trackerStats = new TrackerStats((InformationServerCollectionProvider)this);
    private final AlfrescoSolrDataModel dataModel;
    private final boolean contentIndexingHasBeenEnabledOnThisInstance;
    private final boolean recordUnindexedNodes;
    private final long lag;
    private final long holeRetention;
    private final boolean fingerprintHasBeenEnabledOnThisInstance;
    private final int contentStreamLimit;
    private final int statsFacetLimit;
    private long cleanContentLastPurged;
    private final boolean getPathsInNodeBatches;
    private boolean skipDescendantDocsForSpecificTypes;
    private boolean skipDescendantDocsForSpecificAspects;
    private final Set<QName> typesForSkippingDescendantDocs = new HashSet<QName>();
    private final Set<QName> aspectsForSkippingDescendantDocs = new HashSet<QName>();
    private final SOLRAPIClient repositoryClient;
    private final ConcurrentLRUCache<String, Boolean> isIdIndexCache = new ConcurrentLRUCache(360000, 180000);
    private final ReentrantReadWriteLock activeTrackerThreadsLock = new ReentrantReadWriteLock();
    private final HashSet<Long> activeTrackerThreads = new HashSet();
    private final ReentrantReadWriteLock commitAndRollbackLock = new ReentrantReadWriteLock();
    private final String hostName;
    private final Properties props;
    private final LRU txnIdCache = new LRU(250000);
    private final LRU aclChangeSetCache = new LRU(250000);
    private final Map<Long, Long> cleanContentCache = Collections.synchronizedMap(new LRU(250000));
    private final LRU cleanCascadeCache = new LRU(250000);
    private final int port;
    private final String baseUrl;
    private String skippingDocsQueryString;
    private boolean isSkippingDocsInitialized;
    private final boolean dateFieldDestructuringHasBeenEnabledOnThisInstance;
    private final boolean enabledIndexCustomContent;

    public SolrInformationServer(AlfrescoCoreAdminHandler adminHandler, SolrCore core, SOLRAPIClient repositoryClient) {
        this.adminHandler = adminHandler;
        this.core = core;
        this.nativeRequestHandler = core.getRequestHandler(REQUEST_HANDLER_NATIVE);
        this.cloud = new Cloud();
        this.repositoryClient = Objects.requireNonNull(repositoryClient);
        Properties coreConfiguration = core.getResourceLoader().getCoreProperties();
        this.contentIndexingHasBeenEnabledOnThisInstance = Boolean.parseBoolean(coreConfiguration.getProperty("alfresco.index.transformContent", "true"));
        LOGGER.info("Content Indexing (AKA Transformation) has been {} on this instance.", this.contentIndexingHasBeenEnabledOnThisInstance ? "enabled" : "disabled");
        this.recordUnindexedNodes = Boolean.parseBoolean(coreConfiguration.getProperty("alfresco.recordUnindexedNodes", "true"));
        this.lag = Integer.parseInt(coreConfiguration.getProperty("alfresco.lag", "1000"));
        this.holeRetention = Integer.parseInt(coreConfiguration.getProperty("alfresco.hole.retention", "3600000"));
        this.fingerprintHasBeenEnabledOnThisInstance = Boolean.parseBoolean(coreConfiguration.getProperty("alfresco.fingerprint", "true"));
        LOGGER.info("Fingerprint has been {} on this instance.", this.fingerprintHasBeenEnabledOnThisInstance ? "enabled" : "disabled");
        this.dataModel = AlfrescoSolrDataModel.getInstance();
        this.contentStreamLimit = Integer.parseInt(coreConfiguration.getProperty("alfresco.contentStreamLimit", "10000000"));
        this.getPathsInNodeBatches = Boolean.parseBoolean(coreConfiguration.getProperty("alfresco.metadata.getPathsInNodeBatches", "true"));
        this.statsFacetLimit = Integer.parseInt(coreConfiguration.getProperty("alfresco.stats.facetLimit", "100"));
        this.props = AlfrescoSolrDataModel.getCommonConfig();
        this.hostName = ConfigUtil.locateProperty(SOLR_HOST, this.props.getProperty(SOLR_HOST));
        this.port = this.portNumber(this.props);
        this.baseUrl = this.baseUrl(this.props);
        this.enabledIndexCustomContent = Boolean.parseBoolean(coreConfiguration.getProperty("solr.enableIndexingCustomContent", "false"));
        this.dateFieldDestructuringHasBeenEnabledOnThisInstance = Boolean.parseBoolean(coreConfiguration.getProperty("alfresco.destructureDateFields", "true"));
        LOGGER.info("Date fields destructuring has been {} on this instance.", this.dateFieldDestructuringHasBeenEnabledOnThisInstance ? "enabled" : "disabled");
    }

    @Override
    public AlfrescoCoreAdminHandler getAdminHandler() {
        return this.adminHandler;
    }

    @Override
    public boolean cascadeTrackingEnabled() {
        return Optional.ofNullable((String)this.props.get(CASCADE_TRACKER_ENABLED)).map(Boolean::parseBoolean).orElse(true);
    }

    @Override
    public synchronized void initSkippingDescendantDocs() {
        if (this.isSkippingDocsInitialized) {
            return;
        }
        Properties p = this.core.getResourceLoader().getCoreProperties();
        this.skipDescendantDocsForSpecificTypes = Boolean.parseBoolean(p.getProperty("alfresco.metadata.skipDescendantDocsForSpecificTypes", "false"));
        if (this.skipDescendantDocsForSpecificTypes) {
            this.initSkippingDescendantDocs(p, this.typesForSkippingDescendantDocs, "alfresco.metadata.ignore.datatype.", "TYPE", qName -> null != this.dataModel.getDictionaryService("DEFAULT_DICTIONARY").getType(qName));
        }
        this.skipDescendantDocsForSpecificAspects = Boolean.parseBoolean(p.getProperty("alfresco.metadata.skipDescendantDocsForSpecificAspects", "false"));
        if (this.skipDescendantDocsForSpecificAspects) {
            this.initSkippingDescendantDocs(p, this.aspectsForSkippingDescendantDocs, "alfresco.metadata.ignore.aspect.", "ASPECT", qName -> null != this.dataModel.getDictionaryService("DEFAULT_DICTIONARY").getAspect(qName));
        }
        this.isSkippingDocsInitialized = true;
    }

    @Override
    public void addContentOutdatedAndUpdatedCounts(NamedList<Object> report) {
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            ModifiableSolrParams params = new ModifiableSolrParams(request.getParams()).set("q", new String[]{"DOC_TYPE:Node AND TYPE:\"{http://www.alfresco.org/model/content/1.0}content\""}).set("rows", 0).set("facet", new String[]{"on"}).add("facet.query", new String[]{"{!key='OUTDATED'}LAST_INCOMING_CONTENT_VERSION_ID:\"-10\""});
            SolrQueryResponse response = this.cloud.getResponse(this.nativeRequestHandler, (SolrQueryRequest)request, (SolrParams)params);
            long numFound = Optional.ofNullable(response).map(SolrQueryResponse::getValues).map(NamedList.class::cast).map(facets -> facets.get(RESPONSE_DEFAULT_IDS)).map(BasicResultContext.class::cast).map(BasicResultContext::getDocList).map(DocList::matches).orElse(0).intValue();
            long outdated = Optional.ofNullable(response).map(SolrQueryResponse::getValues).map(NamedList.class::cast).map(facets -> facets.get("facet_counts")).map(NamedList.class::cast).map(facetCounts -> facetCounts.get("facet_queries")).map(NamedList.class::cast).map(facetQueries -> facetQueries.get("OUTDATED")).map(Number.class::cast).map(Number::longValue).orElse(0L);
            report.add("Node count whose content is in sync", (Object)(numFound - outdated));
            report.add("Node count whose content needs to be updated", (Object)outdated);
        }
    }

    @Override
    public void afterInitModels() {
        this.dataModel.afterInitModels();
    }

    @Override
    public AclReport checkAclInIndex(Long aclid, AclReport aclReport) {
        String query = "ACLID:" + aclid + " AND DOC_TYPE:Acl";
        long count = this.getDocListSize(query);
        aclReport.setIndexedAclDocCount(Long.valueOf(count));
        return aclReport;
    }

    @Override
    public IndexHealthReport reportIndexTransactions(Long minTxId, IOpenBitSet txIdsInDb, long maxTxId) {
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            NamedList<Integer> docTypeCounts = this.getFacets((SolrQueryRequest)request, "*:*", "DOC_TYPE", 0);
            IndexHealthReport report = new IndexHealthReport((InformationServerCollectionProvider)this);
            TransactionInfoReporter txReporter = new TransactionInfoReporter(report){

                @Override
                void reportIdInIndexButNotInDb(long txid) {
                    this.report.setTxInIndexButNotInDb(txid);
                }

                @Override
                void reportIdInDbButNotInIndex(long id) {
                    this.report.setMissingTxFromIndex(id);
                }

                @Override
                void reportDuplicatedIdInIndex(long id) {
                    this.report.setDuplicatedTxInIndex(id);
                }

                @Override
                void reportUniqueIdsInIndex(long count) {
                    this.report.setUniqueTransactionDocsInIndex(count);
                }
            };
            this.reportTransactionInfo(txReporter, minTxId, maxTxId, txIdsInDb, (SolrQueryRequest)request, "TXID");
            long transactionDocsInIndex = this.getSafeCount(docTypeCounts, DOC_TYPE_TX);
            report.setTransactionDocsInIndex(transactionDocsInIndex);
            report.setDbTransactionCount(txIdsInDb.cardinality());
            this.setDuplicates(report, (SolrQueryRequest)request, DOC_TYPE_NODE, IndexHealthReport::setDuplicatedLeafInIndex);
            long leafDocCountInIndex = this.getSafeCount(docTypeCounts, DOC_TYPE_NODE);
            report.setLeafDocCountInIndex(leafDocCountInIndex);
            this.setDuplicates(report, (SolrQueryRequest)request, DOC_TYPE_ERROR_NODE, IndexHealthReport::setDuplicatedErrorInIndex);
            long errorCount = this.getSafeCount(docTypeCounts, DOC_TYPE_ERROR_NODE);
            report.setErrorDocCountInIndex(errorCount);
            this.setDuplicates(report, (SolrQueryRequest)request, DOC_TYPE_UNINDEXED_NODE, IndexHealthReport::setDuplicatedUnindexedInIndex);
            long unindexedDocCountInIndex = this.getSafeCount(docTypeCounts, DOC_TYPE_UNINDEXED_NODE);
            report.setUnindexedDocCountInIndex(unindexedDocCountInIndex);
            IndexHealthReport indexHealthReport = report;
            return indexHealthReport;
        }
    }

    @Override
    public IndexHealthReport reportAclTransactionsInIndex(Long minAclTxId, IOpenBitSet aclTxIdsInDb, long maxAclTxId) {
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            NamedList<Integer> docTypeCounts = this.getFacets((SolrQueryRequest)request, "*:*", "DOC_TYPE", 0);
            IndexHealthReport report = new IndexHealthReport((InformationServerCollectionProvider)this);
            TransactionInfoReporter aclTxReporter = new TransactionInfoReporter(report){

                @Override
                void reportIdInIndexButNotInDb(long txid) {
                    this.report.setAclTxInIndexButNotInDb(txid);
                }

                @Override
                void reportIdInDbButNotInIndex(long id) {
                    this.report.setMissingAclTxFromIndex(id);
                }

                @Override
                void reportDuplicatedIdInIndex(long id) {
                    this.report.setDuplicatedAclTxInIndex(id);
                }

                @Override
                void reportUniqueIdsInIndex(long count) {
                    this.report.setUniqueAclTransactionDocsInIndex(count);
                }
            };
            this.reportTransactionInfo(aclTxReporter, minAclTxId, maxAclTxId, aclTxIdsInDb, (SolrQueryRequest)request, "ACLTXID");
            long aclTransactionDocsInIndex = this.getSafeCount(docTypeCounts, DOC_TYPE_ACL_TX);
            report.setAclTransactionDocsInIndex(aclTransactionDocsInIndex);
            report.setDbAclTransactionCount(aclTxIdsInDb.cardinality());
            IndexHealthReport indexHealthReport = report;
            return indexHealthReport;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AlfrescoSolrDataModel.TenantDbId> getDocsWithUncleanContent() throws IOException {
        RefCounted refCounted = null;
        try {
            ArrayList<AlfrescoSolrDataModel.TenantDbId> docIds = new ArrayList<AlfrescoSolrDataModel.TenantDbId>();
            refCounted = this.core.getSearcher();
            SolrIndexSearcher searcher = (SolrIndexSearcher)refCounted.get();
            long purgeTime = System.currentTimeMillis();
            if (purgeTime - this.cleanContentLastPurged > 120000L) {
                Iterator<Map.Entry<Long, Long>> entries = this.cleanContentCache.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<Long, Long> entry = entries.next();
                    long txnTime = entry.getValue();
                    if (purgeTime - txnTime <= 1200000L) continue;
                    entries.remove();
                }
                this.cleanContentLastPurged = purgeTime;
            }
            Sort sort = new Sort(new SortField("INTXID", SortField.Type.LONG));
            sort = sort.rewrite((IndexSearcher)searcher);
            TopFieldCollector collector = TopFieldCollector.create((Sort)sort, (int)1, null, (boolean)false, (boolean)false, (boolean)false);
            TxnCacheFilter delegatingCollector = new TxnCacheFilter(this.cleanContentCache);
            delegatingCollector.setLastDelegate((Collector)collector);
            searcher.search(this.documentsWithOutdatedContentQuery(), (Collector)delegatingCollector);
            LOGGER.debug("{}-[CORE {}] Processing {} documents with content to be indexed", Thread.currentThread().getId(), this.core.getName(), collector.getTotalHits());
            if (collector.getTotalHits() == 0) {
                LOGGER.debug("No documents with outdated text content have been found.", new Object[0]);
                ArrayList<AlfrescoSolrDataModel.TenantDbId> arrayList = docIds;
                return arrayList;
            }
            LOGGER.debug("Found {} documents with outdated text content.", collector.getTotalHits());
            ScoreDoc[] scoreDocs = collector.topDocs().scoreDocs;
            List leaves = searcher.getTopReaderContext().leaves();
            int index = ReaderUtil.subIndex((int)scoreDocs[0].doc, (List)leaves);
            LeafReaderContext context = (LeafReaderContext)leaves.get(index);
            NumericDocValues longs = context.reader().getNumericDocValues("INTXID");
            long txnFloor = longs.get(scoreDocs[0].doc - context.docBase);
            TxnCollector txnCollector = new TxnCollector(txnFloor);
            searcher.search(this.documentsWithOutdatedContentQuery(), (Collector)txnCollector);
            LongHashSet txnSet = txnCollector.getTxnSet();
            if (txnSet.size() == 0) {
                ArrayList<AlfrescoSolrDataModel.TenantDbId> arrayList = docIds;
                return arrayList;
            }
            FieldType fieldType = searcher.getSchema().getField("INTXID").getType();
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (LongCursor cursor : txnSet) {
                long txnID = cursor.value;
                TermQuery txnIDQuery = new TermQuery(new Term("INTXID", fieldType.readableToIndexed(Long.toString(txnID))));
                builder.add(new BooleanClause((Query)txnIDQuery, BooleanClause.Occur.SHOULD));
            }
            BooleanQuery txnFilterQuery = builder.build();
            DocListCollector docListCollector = new DocListCollector();
            BooleanQuery.Builder builder2 = new BooleanQuery.Builder();
            builder2.add(this.documentsWithOutdatedContentQuery(), BooleanClause.Occur.MUST);
            builder2.add((Query)new QueryWrapperFilter((Query)txnFilterQuery), BooleanClause.Occur.MUST);
            searcher.search((Query)builder2.build(), (Collector)docListCollector);
            IntArrayList docList = docListCollector.getDocs();
            int size = docList.size();
            ArrayList<Long> processedTxns = new ArrayList<Long>();
            for (int i = 0; i < size; ++i) {
                int doc = docList.get(i);
                Document document = searcher.doc(doc, ID_AND_CONTENT_VERSION_ID_AND_CONTENT_LOCALE);
                index = ReaderUtil.subIndex((int)doc, (List)leaves);
                context = (LeafReaderContext)leaves.get(index);
                longs = context.reader().getNumericDocValues("INTXID");
                long txnId = longs.get(doc - context.docBase);
                if (this.cleanContentCache.containsKey(txnId)) continue;
                processedTxns.add(txnId);
                IndexableField id = document.getField("id");
                String idString = id.stringValue();
                AlfrescoSolrDataModel.TenantDbId tenantAndDbId = AlfrescoSolrDataModel.decodeNodeDocumentId(idString);
                tenantAndDbId.addContentPropertiesSpecs(this.enabledIndexCustomContent ? document.getFields().stream().filter(field -> field.name().startsWith("content@s__locale@")).map(field -> new AlfrescoSolrDataModel.ContentPropertySpecs(field.name(), field.stringValue())).collect(Collectors.toList()) : Optional.ofNullable(document.getField(CONTENT_LOCALE_FIELD)).map(IndexableField::stringValue).map(value -> new AlfrescoSolrDataModel.ContentPropertySpecs(CONTENT_LOCALE_FIELD, (String)value)).map(Collections::singletonList).orElse(Collections.emptyList()));
                tenantAndDbId.setProperty(LATEST_APPLIED_CONTENT_VERSION_ID, Optional.ofNullable(document.getField(LATEST_APPLIED_CONTENT_VERSION_ID)).map(IndexableField::stringValue).orElse(null));
                docIds.add(tenantAndDbId);
            }
            long txnTime = System.currentTimeMillis();
            for (Long l : processedTxns) {
                this.cleanContentCache.put(l, txnTime);
            }
            ArrayList<AlfrescoSolrDataModel.TenantDbId> arrayList = docIds;
            return arrayList;
        }
        finally {
            Optional.ofNullable(refCounted).ifPresent(RefCounted::decref);
        }
    }

    @Override
    public void addCommonNodeReportInfo(NodeReport nodeReport) {
        long dbId = nodeReport.getDbid();
        String query = "DBID:" + dbId + " AND DOC_TYPE:Node";
        long count = this.getDocListSize(query);
        nodeReport.setIndexedNodeDocCount(Long.valueOf(count));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() throws IOException {
        this.commitAndRollbackLock.writeLock().lock();
        try {
            this.canUpdate();
            UpdateRequestProcessor processor = null;
            try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
                processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
                processor.processCommit(new CommitUpdateCommand((SolrQueryRequest)request, false));
            }
            finally {
                if (processor != null) {
                    processor.finish();
                }
            }
        }
        finally {
            this.commitAndRollbackLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void hardCommit() throws IOException {
        this.commitAndRollbackLock.writeLock().lock();
        try {
            UpdateRequestProcessor processor = null;
            try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
                processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
                CommitUpdateCommand commitUpdateCommand = new CommitUpdateCommand((SolrQueryRequest)request, false);
                commitUpdateCommand.openSearcher = false;
                commitUpdateCommand.softCommit = false;
                commitUpdateCommand.waitSearcher = false;
                processor.processCommit(commitUpdateCommand);
            }
            finally {
                if (processor != null) {
                    processor.finish();
                }
            }
        }
        finally {
            this.commitAndRollbackLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean commit(boolean openSearcher) throws IOException {
        this.canUpdate();
        UpdateRequestProcessor processor = null;
        boolean searcherOpened = false;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            CommitUpdateCommand command = new CommitUpdateCommand((SolrQueryRequest)request, false);
            if (openSearcher) {
                RefCounted active = null;
                RefCounted newest = null;
                try {
                    active = this.core.getSearcher();
                    newest = this.core.getNewestSearcher(false);
                    if (active.get() == newest.get()) {
                        command.openSearcher = true;
                        searcherOpened = true;
                        command.waitSearcher = false;
                    } else {
                        command.openSearcher = false;
                        searcherOpened = false;
                    }
                }
                finally {
                    Optional.ofNullable(active).ifPresent(RefCounted::decref);
                    Optional.ofNullable(newest).ifPresent(RefCounted::decref);
                }
            }
            processor.processCommit(command);
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
        }
        return searcherOpened;
    }

    @Override
    public void deleteByAclChangeSetId(Long aclChangeSetId) throws IOException {
        this.deleteById("INACLTXID", aclChangeSetId);
    }

    @Override
    public void deleteByAclId(Long aclId) throws IOException {
        this.isIdIndexCache.clear();
        this.deleteById("ACLID", aclId);
    }

    @Override
    public void deleteByNodeId(Long nodeId) throws IOException {
        this.deleteById("DBID", nodeId);
    }

    @Override
    public void deleteByTransactionId(Long transactionId) throws IOException {
        this.isIdIndexCache.clear();
        this.deleteById("INTXID", transactionId);
    }

    @Override
    public List<AlfrescoModel> getAlfrescoModels() {
        return this.dataModel.getAlfrescoModels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterable<Map.Entry<String, Object>> getCoreStats() throws IOException {
        SimpleOrderedMap coreSummary = new SimpleOrderedMap();
        RefCounted refCounted = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            NamedList<Integer> docTypeCounts = this.getFacets((SolrQueryRequest)request, "*:*", "DOC_TYPE", 0);
            long aclCount = this.getSafeCount(docTypeCounts, DOC_TYPE_ACL);
            coreSummary.add("Alfresco Acls in Index", (Object)aclCount);
            long nodeCount = this.getSafeCount(docTypeCounts, DOC_TYPE_NODE);
            coreSummary.add("Alfresco Nodes in Index", (Object)nodeCount);
            long txCount = this.getSafeCount(docTypeCounts, DOC_TYPE_TX);
            coreSummary.add("Alfresco Transactions in Index", (Object)txCount);
            long aclTxCount = this.getSafeCount(docTypeCounts, DOC_TYPE_ACL_TX);
            coreSummary.add("Alfresco Acl Transactions in Index", (Object)aclTxCount);
            long stateCount = this.getSafeCount(docTypeCounts, DOC_TYPE_STATE);
            coreSummary.add("Alfresco States in Index", (Object)stateCount);
            long unindexedNodeCount = this.getSafeCount(docTypeCounts, DOC_TYPE_UNINDEXED_NODE);
            coreSummary.add("Alfresco Unindexed Nodes", (Object)unindexedNodeCount);
            long errorNodeCount = this.getSafeCount(docTypeCounts, DOC_TYPE_ERROR_NODE);
            coreSummary.add("Alfresco Error Nodes in Index", (Object)errorNodeCount);
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            coreSummary.add("Searcher", (Object)solrIndexSearcher.getStatistics());
            Map infoRegistry = this.core.getInfoRegistry();
            for (Map.Entry infos : infoRegistry.entrySet()) {
                SolrInfoMBean infoMBean = (SolrInfoMBean)infos.getValue();
                String key = (String)infos.getKey();
                if (key.equals("/alfresco")) {
                    coreSummary.add("/alfresco", this.fixStats((NamedList<Object>)infoMBean.getStatistics()));
                }
                if (key.equals("/afts")) {
                    coreSummary.add("/afts", this.fixStats((NamedList<Object>)infoMBean.getStatistics()));
                }
                if (key.equals("/cmis")) {
                    coreSummary.add("/cmis", this.fixStats((NamedList<Object>)infoMBean.getStatistics()));
                }
                if (key.equals("filterCache")) {
                    coreSummary.add("/filterCache", (Object)infoMBean.getStatistics());
                }
                if (key.equals("queryResultCache")) {
                    coreSummary.add("/queryResultCache", (Object)infoMBean.getStatistics());
                }
                if (key.equals("alfrescoAuthorityCache")) {
                    coreSummary.add("/alfrescoAuthorityCache", (Object)infoMBean.getStatistics());
                }
                if (!key.equals("alfrescoPathCache")) continue;
                coreSummary.add("/alfrescoPathCache", (Object)infoMBean.getStatistics());
            }
            int searcherIndex = 0;
            List<SolrIndexSearcher> searchers = this.getRegisteredSearchers();
            for (SolrIndexSearcher searcher : searchers) {
                SimpleOrderedMap details = new SimpleOrderedMap();
                details.add("Searcher", (Object)searcher.getStatistics());
                coreSummary.add("Searcher-" + searcherIndex, (Object)details);
                ++searcherIndex;
            }
            coreSummary.add("Number of Searchers", (Object)searchers.size());
            coreSummary.add("Total Searcher Cache (GB)", (Object)0);
            IndexDeletionPolicyWrapper delPolicy = this.core.getDeletionPolicy();
            IndexCommit indexCommit = delPolicy.getLatestCommit();
            if (indexCommit == null) {
                indexCommit = solrIndexSearcher.getIndexReader().getIndexCommit();
            }
            if (indexCommit != null) {
                delPolicy.setReserveDuration(Long.valueOf(solrIndexSearcher.getIndexReader().getVersion()), 20000L);
                long fileSize = 0L;
                File dir = new File(solrIndexSearcher.getPath());
                for (String name : indexCommit.getFileNames()) {
                    File file = new File(dir, name);
                    if (!file.exists()) continue;
                    fileSize += file.length();
                }
                DecimalFormat df = new DecimalFormat("###,###.######");
                coreSummary.add("On disk (GB)", (Object)df.format((float)fileSize / 1024.0f / 1024.0f / 1024.0f));
                coreSummary.add("Per node B", (Object)(nodeCount > 0L ? fileSize / nodeCount : 0L));
            }
        }
        finally {
            Optional.ofNullable(refCounted).ifPresent(RefCounted::decref);
        }
        return coreSummary;
    }

    @Override
    public DictionaryComponent getDictionaryService(String alternativeDictionary) {
        return this.dataModel.getDictionaryService(alternativeDictionary);
    }

    @Override
    public int getTxDocsSize(String targetTxId, String targetTxCommitTime) {
        return this.getDocListSize("TXID:" + targetTxId + " AND TXCOMMITTIME:" + targetTxCommitTime);
    }

    @Override
    public int getAclTxDocsSize(String aclTxId, String aclTxCommitTime) {
        return this.getDocListSize("ACLTXID:" + aclTxId + " AND ACLTXCOMMITTIME:" + aclTxCommitTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Long> getErrorDocIds() throws IOException {
        HashSet<Long> errorDocIds = new HashSet<Long>();
        RefCounted refCounted = null;
        try {
            refCounted = this.core.getSearcher();
            SolrIndexSearcher searcher = (SolrIndexSearcher)refCounted.get();
            TermQuery errorQuery = new TermQuery(new Term("DOC_TYPE", DOC_TYPE_ERROR_NODE));
            DocListCollector docListCollector = new DocListCollector();
            searcher.search((Query)errorQuery, (Collector)docListCollector);
            IntArrayList docList = docListCollector.getDocs();
            int size = docList.size();
            for (int i = 0; i < size; ++i) {
                int doc = docList.get(i);
                Document document = searcher.doc(doc, REQUEST_ONLY_ID_FIELD);
                IndexableField id = document.getField("id");
                String idString = id.stringValue();
                if (idString.startsWith(PREFIX_ERROR)) {
                    idString = idString.substring(PREFIX_ERROR.length());
                }
                errorDocIds.add(Long.valueOf(idString));
            }
        }
        finally {
            Optional.ofNullable(refCounted).ifPresent(RefCounted::decref);
        }
        return errorDocIds;
    }

    @Override
    public long getHoleRetention() {
        return this.holeRetention;
    }

    @Override
    public M2Model getM2Model(QName modelQName) {
        return this.dataModel.getM2Model(modelQName);
    }

    @Override
    public Map<String, Set<String>> getModelErrors() {
        return this.dataModel.getModelErrors();
    }

    @Override
    public NamespaceDAO getNamespaceDAO() {
        return this.dataModel.getNamespaceDAO();
    }

    public IOpenBitSet getOpenBitSetInstance() {
        return new SolrOpenBitSetAdapter();
    }

    @Override
    public int getRegisteredSearcherCount() {
        return this.getRegisteredSearchers().size();
    }

    public <T> ISimpleOrderedMap<T> getSimpleOrderedMapInstance() {
        return new SolrSimpleOrderedMap();
    }

    @Override
    public TrackerStats getTrackerStats() {
        return this.trackerStats;
    }

    @Override
    public TrackerState getTrackerInitialState() {
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            TrackerState state = new TrackerState();
            SolrRequestHandler handler = this.core.getRequestHandler(REQUEST_HANDLER_GET);
            ModifiableSolrParams newParams = new ModifiableSolrParams(request.getParams()).set("ids", new String[]{"TRACKER!STATE!ACLTX,TRACKER!STATE!TX"});
            request.setParams((SolrParams)newParams);
            SolrDocumentList response = this.executeQueryRequest((SolrQueryRequest)request, this.newSolrQueryResponse(), handler);
            if (response == null) {
                LOGGER.error("Got no response from a tracker initial state request.", new Object[0]);
                TrackerState trackerState = state;
                return trackerState;
            }
            int i = 0;
            while ((long)i < response.getNumFound()) {
                SolrDocument current = (SolrDocument)response.get(i);
                if (current.getFieldValue("S_ACLTXCOMMITTIME") != null) {
                    if (state.getLastIndexedChangeSetCommitTime() == 0L) {
                        state.setLastIndexedChangeSetCommitTime(this.getFieldValueLong(current, "S_ACLTXCOMMITTIME"));
                    }
                    if (state.getLastIndexedChangeSetId() == 0L) {
                        state.setLastIndexedChangeSetId(this.getFieldValueLong(current, "S_ACLTXID"));
                    }
                }
                if (current.getFieldValue("S_TXCOMMITTIME") != null) {
                    if (state.getLastIndexedTxCommitTime() == 0L) {
                        state.setLastIndexedTxCommitTime(this.getFieldValueLong(current, "S_TXCOMMITTIME"));
                    }
                    if (state.getLastIndexedTxId() == 0L) {
                        state.setLastIndexedTxId(this.getFieldValueLong(current, "S_TXID"));
                    }
                }
                ++i;
            }
            long startTime = System.currentTimeMillis();
            state.setLastStartTime(startTime);
            state.setTimeToStopIndexing(startTime - this.lag);
            state.setTimeBeforeWhichThereCanBeNoHoles(startTime - this.holeRetention);
            long timeBeforeWhichThereCanBeNoTxHolesInIndex = state.getLastIndexedTxCommitTime() - this.holeRetention;
            state.setLastGoodTxCommitTimeInIndex(timeBeforeWhichThereCanBeNoTxHolesInIndex > 0L ? timeBeforeWhichThereCanBeNoTxHolesInIndex : 0L);
            long timeBeforeWhichThereCanBeNoChangeSetHolesInIndex = state.getLastIndexedChangeSetCommitTime() - this.holeRetention;
            state.setLastGoodChangeSetCommitTimeInIndex(timeBeforeWhichThereCanBeNoChangeSetHolesInIndex > 0L ? timeBeforeWhichThereCanBeNoChangeSetHolesInIndex : 0L);
            LOGGER.debug("The tracker initial state was created: " + String.valueOf(state), new Object[0]);
            TrackerState trackerState = state;
            return trackerState;
        }
    }

    @Override
    public void continueState(TrackerState state) {
        long startTime = System.currentTimeMillis();
        long lastStartTime = state.getLastStartTime();
        state.setTimeToStopIndexing(startTime - this.lag);
        state.setTimeBeforeWhichThereCanBeNoHoles(startTime - this.holeRetention);
        long timeBeforeWhichThereCanBeNoTxHolesInIndex = state.getLastIndexedTxCommitTime() - this.holeRetention;
        long lastStartTimeWhichThereCanBeNoTxHolesInIndex = lastStartTime - this.holeRetention;
        timeBeforeWhichThereCanBeNoTxHolesInIndex = Math.max(timeBeforeWhichThereCanBeNoTxHolesInIndex, lastStartTimeWhichThereCanBeNoTxHolesInIndex);
        state.setLastGoodTxCommitTimeInIndex(timeBeforeWhichThereCanBeNoTxHolesInIndex > 0L ? timeBeforeWhichThereCanBeNoTxHolesInIndex : 0L);
        long timeBeforeWhichThereCanBeNoChangeSetHolesInIndex = state.getLastIndexedChangeSetCommitTime() - this.holeRetention;
        long lastStartTimeWhichThereCanBeNoChangeSetHolesInIndex = lastStartTime - this.holeRetention;
        timeBeforeWhichThereCanBeNoChangeSetHolesInIndex = Math.max(timeBeforeWhichThereCanBeNoChangeSetHolesInIndex, lastStartTimeWhichThereCanBeNoChangeSetHolesInIndex);
        state.setLastGoodChangeSetCommitTimeInIndex(timeBeforeWhichThereCanBeNoChangeSetHolesInIndex > 0L ? timeBeforeWhichThereCanBeNoChangeSetHolesInIndex : 0L);
        state.setLastStartTime(startTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long indexAcl(List<AclReaders> aclReaderList, boolean overwrite) throws IOException {
        long start = System.nanoTime();
        UpdateRequestProcessor processor = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            for (AclReaders aclReaders : Utils.notNullOrEmpty(aclReaderList)) {
                SolrInputDocument acl = new SolrInputDocument(new String[0]);
                acl.addField("id", (Object)AlfrescoSolrDataModel.getAclDocumentId(aclReaders.getTenantDomain(), aclReaders.getId()));
                acl.addField("_version_", (Object)"0");
                acl.addField("ACLID", (Object)aclReaders.getId());
                acl.addField("INACLTXID", (Object)aclReaders.getAclChangeSetId());
                String tenant = aclReaders.getTenantDomain();
                for (String reader : Utils.notNullOrEmpty(aclReaders.getReaders())) {
                    reader = this.addTenantToAuthority(reader, tenant);
                    acl.addField("READER", (Object)reader);
                }
                for (String denied : aclReaders.getDenied()) {
                    denied = this.addTenantToAuthority(denied, tenant);
                    acl.addField("DENIED", (Object)denied);
                }
                acl.addField("DOC_TYPE", (Object)DOC_TYPE_ACL);
                AddUpdateCommand cmd = new AddUpdateCommand((SolrQueryRequest)request);
                cmd.overwrite = overwrite;
                cmd.solrDoc = acl;
                processor.processAdd(cmd);
            }
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
        }
        return System.nanoTime() - start;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexAclTransaction(AclChangeSet changeSet, boolean overwrite) throws IOException {
        this.canUpdate();
        UpdateRequestProcessor processor = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            SolrInputDocument aclTx = new SolrInputDocument(new String[0]);
            aclTx.addField("id", (Object)AlfrescoSolrDataModel.getAclChangeSetDocumentId(changeSet.getId()));
            aclTx.addField("_version_", (Object)"0");
            aclTx.addField("ACLTXID", (Object)changeSet.getId());
            aclTx.addField("INACLTXID", (Object)changeSet.getId());
            aclTx.addField("ACLTXCOMMITTIME", (Object)changeSet.getCommitTimeMs());
            aclTx.addField("DOC_TYPE", (Object)DOC_TYPE_ACL_TX);
            AddUpdateCommand cmd = new AddUpdateCommand((SolrQueryRequest)request);
            cmd.overwrite = overwrite;
            cmd.solrDoc = aclTx;
            processor.processAdd(cmd);
            this.putAclTransactionState(processor, (SolrQueryRequest)request, changeSet);
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
        }
    }

    @Override
    public AclChangeSet getMaxAclChangeSetIdAndCommitTimeInIndex() {
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            SolrDocument aclState = this.getState(this.core, (SolrQueryRequest)request, "TRACKER!STATE!ACLTX");
            if (aclState != null) {
                long id = this.getFieldValueLong(aclState, "S_ACLTXID");
                long commitTime = this.getFieldValueLong(aclState, "S_ACLTXCOMMITTIME");
                int aclCount = -1;
                AclChangeSet aclChangeSet = new AclChangeSet(id, commitTime, aclCount);
                return aclChangeSet;
            }
            AclChangeSet aclChangeSet = new AclChangeSet(0L, 0L, -1);
            return aclChangeSet;
        }
    }

    @Override
    public void dirtyTransaction(long txnId) {
        this.cleanContentCache.remove(txnId);
        if (this.cascadeTrackingEnabled()) {
            this.cleanCascadeCache.remove(txnId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void capIndex(long dbid) throws IOException {
        UpdateRequestProcessor processor = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            SolrInputDocument input = new SolrInputDocument(new String[0]);
            input.addField("id", (Object)INDEX_CAP_ID);
            input.addField("_version_", (Object)0);
            input.addField("DBID", (Object)(-dbid));
            input.addField("DOC_TYPE", (Object)DOC_TYPE_STATE);
            AddUpdateCommand cmd = new AddUpdateCommand((SolrQueryRequest)request);
            cmd.overwrite = true;
            cmd.solrDoc = input;
            processor.processAdd(cmd);
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
        }
    }

    @Override
    public void maintainCap(long dbid) throws IOException {
        this.deleteByQuery("DBID:{" + dbid + " TO *}");
    }

    @Override
    public long nodeCount() {
        return this.getDocListSize("DOC_TYPE:Node");
    }

    @Override
    public long maxNodeId() {
        return this.topNodeId(SolrQuery.ORDER.desc);
    }

    @Override
    public long minNodeId() {
        return this.topNodeId(SolrQuery.ORDER.asc);
    }

    @Override
    public long getIndexCap() {
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            ModifiableSolrParams params = new ModifiableSolrParams(request.getParams()).set("q", new String[]{"id:TRACKER!STATE!CAP"}).set("rows", 1).set("fl", new String[]{"DBID"});
            SolrDocumentList docs = this.cloud.getSolrDocumentList(this.nativeRequestHandler, (SolrQueryRequest)request, params);
            long l = docs.stream().findFirst().map(doc -> this.getFieldValueLong((SolrDocument)doc, "DBID")).map(Math::abs).orElse(-1L);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexNode(Node node, boolean overwrite) throws IOException, JSONException {
        long start = System.nanoTime();
        LocalSolrQueryRequest request = this.newSolrQueryRequest();
        UpdateRequestProcessor processor = null;
        try {
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            LOGGER.debug("Incoming Node {} with Status {}", node.getId(), node.getStatus());
            if (node.getStatus() == Node.SolrApiNodeStatus.DELETED || node.getStatus() == Node.SolrApiNodeStatus.UNKNOWN || this.cascadeTrackingEnabled() && (node.getStatus() == Node.SolrApiNodeStatus.NON_SHARD_DELETED || node.getStatus() == Node.SolrApiNodeStatus.NON_SHARD_UPDATED)) {
                this.deleteNode(processor, (SolrQueryRequest)request, node);
            }
            if (node.getStatus() == Node.SolrApiNodeStatus.UPDATED || node.getStatus() == Node.SolrApiNodeStatus.UNKNOWN || this.cascadeTrackingEnabled() && node.getStatus() == Node.SolrApiNodeStatus.NON_SHARD_UPDATED) {
                LOGGER.debug("Node {} is being updated", node.getId());
                NodeMetaDataParameters nmdp = new NodeMetaDataParameters();
                nmdp.setFromNodeId(Long.valueOf(node.getId()));
                nmdp.setToNodeId(Long.valueOf(node.getId()));
                nmdp.setMaxResults(Integer.MAX_VALUE);
                Optional<Collection<NodeMetaData>> nodeMetaDatas = this.getNodesMetaDataFromRepository(nmdp);
                if (nodeMetaDatas.isEmpty() || nodeMetaDatas.get().isEmpty()) {
                    throw new Exception("Error loading node metadata from repository.");
                }
                NodeMetaData nodeMetaData = nodeMetaDatas.get().iterator().next();
                if (node.getTxnId() == Long.MAX_VALUE) {
                    LOGGER.debug("Node {} index request is part of a re-index.", node.getId());
                    this.cleanContentCache.remove(nodeMetaData.getTxnId());
                }
                if (node.getStatus() == Node.SolrApiNodeStatus.UPDATED || node.getStatus() == Node.SolrApiNodeStatus.UNKNOWN) {
                    AddUpdateCommand addDocCmd = new AddUpdateCommand((SolrQueryRequest)request);
                    addDocCmd.overwrite = overwrite;
                    this.deleteErrorNode(processor, (SolrQueryRequest)request, node);
                    Map properties = nodeMetaData.getProperties();
                    StringPropertyValue pValue = (StringPropertyValue)properties.get(ContentModel.PROP_IS_INDEXED);
                    boolean isIndexed = Optional.ofNullable(pValue).map(StringPropertyValue::getValue).map(Boolean::parseBoolean).orElse(true);
                    SolrInputDocument solrInputDocument = isIndexed ? this.populateWithMetadata(this.basicDocument(nodeMetaData, DOC_TYPE_NODE, PartialSolrInputDocument::new), nodeMetaData, nmdp) : (addDocCmd.solrDoc = this.recordUnindexedNodes ? this.basicDocument(nodeMetaData, DOC_TYPE_UNINDEXED_NODE, () -> new SolrInputDocument(new String[0])) : null);
                    if (addDocCmd.solrDoc != null) {
                        processor.processAdd(addDocCmd);
                    }
                }
            }
        }
        catch (Exception exception) {
            LOGGER.error("Node {} index failed and skipped in Tx {}. See the stacktrace below for further details.", node.getId(), node.getTxnId(), exception);
            processor = Optional.ofNullable(processor).orElseGet(() -> this.lambda$indexNode$12((SolrQueryRequest)request));
            AddUpdateCommand addDocCmd = new AddUpdateCommand((SolrQueryRequest)request);
            addDocCmd.overwrite = overwrite;
            SolrInputDocument errorNodeDocument = new SolrInputDocument(new String[0]);
            errorNodeDocument.addField("id", (Object)(PREFIX_ERROR + node.getId()));
            errorNodeDocument.addField("_version_", (Object)"0");
            errorNodeDocument.addField("DBID", (Object)node.getId());
            errorNodeDocument.addField("INTXID", (Object)node.getTxnId());
            errorNodeDocument.addField("EXCEPTIONMESSAGE", (Object)exception.getMessage());
            errorNodeDocument.addField("DOC_TYPE", (Object)DOC_TYPE_ERROR_NODE);
            StringWriter stringWriter = new StringWriter(4096);
            try (PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);){
                exception.printStackTrace(printWriter);
                String stack = stringWriter.toString();
                errorNodeDocument.addField("EXCEPTIONSTACK", (Object)(stack.length() < 32766 ? stack : stack.substring(0, 32765)));
            }
            addDocCmd.solrDoc = errorNodeDocument;
            processor.processAdd(addDocCmd);
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
            if (request != null) {
                request.close();
            }
            this.trackerStats.addNodeTime(System.nanoTime() - start);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<NodeMetaData> getCascadeNodes(List<Long> txnIds) throws IOException, JSONException {
        List<AlfrescoSolrDataModel.FieldInstance> list = this.dataModel.getIndexedFieldNamesForProperty(ContentModel.PROP_CASCADE_TX).getFields();
        AlfrescoSolrDataModel.FieldInstance fieldInstance = list.get(0);
        RefCounted refCounted = null;
        HashSet<Long> parentNodesId = new HashSet<Long>();
        try {
            refCounted = this.core.getSearcher();
            SolrIndexSearcher searcher = (SolrIndexSearcher)refCounted.get();
            String field = fieldInstance.getField();
            SchemaField schemaField = searcher.getSchema().getField(field);
            FieldType fieldType = schemaField.getType();
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            for (Long l : txnIds) {
                BytesRefBuilder bytesRefBuilder = new BytesRefBuilder();
                fieldType.readableToIndexed((CharSequence)l.toString(), bytesRefBuilder);
                TermQuery termQuery = new TermQuery(new Term(field, bytesRefBuilder.toBytesRef()));
                BooleanClause booleanClause = new BooleanClause((Query)termQuery, BooleanClause.Occur.SHOULD);
                builder.add(booleanClause);
            }
            BooleanQuery booleanQuery = builder.build();
            DocListCollector collector = new DocListCollector();
            searcher.search((Query)booleanQuery, (Collector)collector);
            IntArrayList docList = collector.getDocs();
            int size = docList.size();
            for (int i = 0; i < size; ++i) {
                int docId = docList.get(i);
                Document document = searcher.doc(docId, REQUEST_ONLY_ID_FIELD);
                IndexableField indexableField = document.getField("id");
                String id = indexableField.stringValue();
                AlfrescoSolrDataModel.TenantDbId ids = AlfrescoSolrDataModel.decodeNodeDocumentId(id);
                parentNodesId.add(ids.dbId);
            }
        }
        finally {
            Optional.ofNullable(refCounted).ifPresent(RefCounted::decref);
        }
        ArrayList<NodeMetaData> allNodeMetaDatas = new ArrayList<NodeMetaData>();
        for (Long parentNodeId : parentNodesId) {
            NodeMetaDataParameters nmdp = new NodeMetaDataParameters();
            nmdp.setFromNodeId(parentNodeId);
            nmdp.setToNodeId(parentNodeId);
            nmdp.setIncludeAclId(true);
            nmdp.setIncludeChildAssociations(false);
            nmdp.setIncludeChildIds(true);
            nmdp.setIncludeOwner(false);
            nmdp.setIncludeParentAssociations(false);
            nmdp.setIncludePaths(true);
            nmdp.setIncludeProperties(false);
            nmdp.setIncludeTxnId(true);
            nmdp.setMaxResults(1);
            Optional<Collection<NodeMetaData>> nodeMetaDatas = this.getNodesMetaDataFromRepository(nmdp);
            allNodeMetaDatas.addAll(nodeMetaDatas.orElse(Collections.emptyList()));
        }
        return allNodeMetaDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cascadeNodes(List<NodeMetaData> nodeMetaDatas, boolean overwrite) throws IOException, JSONException {
        UpdateRequestProcessor processor = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            for (NodeMetaData nodeMetaData : nodeMetaDatas) {
                if (!this.mayHaveChildren(nodeMetaData)) continue;
                this.cascadeUpdateV2(nodeMetaData, overwrite, (SolrQueryRequest)request, processor);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Exception while processing cascading updates from the parent nodes. See the stacktrace below for further details.", exception);
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateContent(AlfrescoSolrDataModel.TenantDbId docRef) throws Exception {
        LOGGER.debug("Text content of Document DBID={} is going to be updated.", docRef.dbId);
        UpdateRequestProcessor processor = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            PartialSolrInputDocument doc = new PartialSolrInputDocument();
            doc.removeField("DBID");
            doc.addField("DBID", docRef.dbId);
            doc.setField("id", AlfrescoSolrDataModel.getNodeDocumentId(docRef.tenant, docRef.dbId));
            if (docRef.hasAtLeastOneContentProperty()) {
                this.addContentToDoc(docRef, doc, docRef.dbId);
            }
            LOGGER.debug("Text content of Document DBID={} has been updated (not yet indexed)", docRef.dbId);
            Long latestAppliedVersionId = Optional.ofNullable(docRef.optionalBag.get(LATEST_APPLIED_CONTENT_VERSION_ID)).map(String.class::cast).map(Long::parseLong).orElse(-20L);
            this.markAsContentInSynch((SolrInputDocument)doc, latestAppliedVersionId);
            AddUpdateCommand addDocCmd = new AddUpdateCommand((SolrQueryRequest)request);
            addDocCmd.overwrite = true;
            addDocCmd.solrDoc = doc;
            processor.processAdd(addDocCmd);
            LOGGER.debug("Text content of Document DBID={} has been marked as updated (latest content version ID = {})", docRef.dbId, latestAppliedVersionId == -20L ? "N.A." : latestAppliedVersionId);
        }
        catch (Exception exception) {
            LOGGER.error("Unable to update the text content of node {}. See the stacktrace below for further details.", docRef.dbId, exception);
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexNodes(List<Node> nodes, boolean overwrite) throws IOException, JSONException {
        UpdateRequestProcessor processor = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            Optional<Collection<NodeMetaData>> nodesMetaDataFromRepository;
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            HashMap<Long, Node> nodeIdsToNodes = new HashMap<Long, Node>();
            EnumMap<Node.SolrApiNodeStatus, List<Long>> nodeStatusToNodeIds = new EnumMap<Node.SolrApiNodeStatus, List<Long>>(Node.SolrApiNodeStatus.class);
            this.categorizeNodes(nodes, nodeIdsToNodes, nodeStatusToNodeIds);
            List<Long> deletedNodeIds = Utils.notNullOrEmpty(nodeStatusToNodeIds.get(Node.SolrApiNodeStatus.DELETED));
            List<Object> shardDeletedNodeIds = Collections.emptyList();
            List<Object> shardUpdatedNodeIds = Collections.emptyList();
            if (this.cascadeTrackingEnabled()) {
                shardDeletedNodeIds = Utils.notNullOrEmpty(nodeStatusToNodeIds.get(Node.SolrApiNodeStatus.NON_SHARD_DELETED));
                shardUpdatedNodeIds = Utils.notNullOrEmpty(nodeStatusToNodeIds.get(Node.SolrApiNodeStatus.NON_SHARD_UPDATED));
            }
            List<Long> unknownNodeIds = Utils.notNullOrEmpty(nodeStatusToNodeIds.get(Node.SolrApiNodeStatus.UNKNOWN));
            List<Long> updatedNodeIds = Utils.notNullOrEmpty(nodeStatusToNodeIds.get(Node.SolrApiNodeStatus.UPDATED));
            if (!(deletedNodeIds.isEmpty() && shardDeletedNodeIds.isEmpty() && shardUpdatedNodeIds.isEmpty() && unknownNodeIds.isEmpty())) {
                Node node;
                ArrayList<NodeMetaData> nodeMetaDatas = new ArrayList<NodeMetaData>();
                for (Long deletedNodeId : deletedNodeIds) {
                    node = (Node)nodeIdsToNodes.get(deletedNodeId);
                    NodeMetaData nodeMetaData = this.createDeletedNodeMetaData(node);
                    nodeMetaDatas.add(nodeMetaData);
                }
                if (!unknownNodeIds.isEmpty()) {
                    NodeMetaDataParameters nmdp = new NodeMetaDataParameters();
                    nmdp.setNodeIds(unknownNodeIds);
                    nmdp.setIncludeChildIds(false);
                    nmdp.setIncludeChildAssociations(false);
                    nmdp.setIncludeAspects(false);
                    nmdp.setIncludePaths(false);
                    nmdp.setIncludeParentAssociations(false);
                    nmdp.setMaxResults(Integer.MAX_VALUE);
                    nodesMetaDataFromRepository = this.getNodesMetaDataFromRepository(nmdp);
                    if (nodesMetaDataFromRepository.isEmpty()) {
                        throw new Exception("Error loading node metadata from repository for bulk delete.");
                    }
                    nodeMetaDatas.addAll(nodesMetaDataFromRepository.get());
                }
                for (NodeMetaData nodeMetaData : nodeMetaDatas) {
                    node = (Node)nodeIdsToNodes.get(nodeMetaData.getId());
                    if (nodeMetaData.getTxnId() <= node.getTxnId()) continue;
                }
                LOGGER.debug("Deleting", new Object[0]);
                DeleteUpdateCommand delDocCmd = new DeleteUpdateCommand((SolrQueryRequest)request);
                String query = this.cloud.getQuery("DBID", OR, deletedNodeIds, shardDeletedNodeIds, shardUpdatedNodeIds, unknownNodeIds);
                delDocCmd.setQuery(query);
                processor.processDelete(delDocCmd);
            }
            if (!(updatedNodeIds.isEmpty() && unknownNodeIds.isEmpty() && shardUpdatedNodeIds.isEmpty())) {
                NodeMetaDataParameters nmdp = new NodeMetaDataParameters();
                LinkedList<Object> nodeIds = new LinkedList<Object>();
                nodeIds.addAll(updatedNodeIds);
                nodeIds.addAll(unknownNodeIds);
                nodeIds.addAll(shardUpdatedNodeIds);
                nmdp.setNodeIds(nodeIds);
                nmdp.setIncludeChildIds(false);
                nmdp.setIncludeChildAssociations(false);
                nmdp.setIncludePaths(this.getPathsInNodeBatches);
                nmdp.setMaxResults(Integer.MAX_VALUE);
                nodesMetaDataFromRepository = this.getNodesMetaDataFromRepository(nmdp);
                if (nodesMetaDataFromRepository.isEmpty()) {
                    throw new Exception("Error loading node metadata from repository for bulk update.");
                }
                for (NodeMetaData nodeMetaData : nodesMetaDataFromRepository.get()) {
                    boolean isIndexed;
                    long start = System.nanoTime();
                    Node node = (Node)nodeIdsToNodes.get(nodeMetaData.getId());
                    if (nodeMetaData.getTxnId() > node.getTxnId()) continue;
                    if (this.cascadeTrackingEnabled() && ((Node)nodeIdsToNodes.get(nodeMetaData.getId())).getStatus() == Node.SolrApiNodeStatus.NON_SHARD_UPDATED) {
                        if (nodeMetaData.getProperties().get(ContentModel.PROP_CASCADE_TX) == null) continue;
                        this.indexNonShardCascade(nodeMetaData);
                        continue;
                    }
                    AddUpdateCommand addDocCmd = new AddUpdateCommand((SolrQueryRequest)request);
                    addDocCmd.overwrite = overwrite;
                    Map properties = nodeMetaData.getProperties();
                    StringPropertyValue pValue = (StringPropertyValue)properties.get(ContentModel.PROP_IS_INDEXED);
                    if (pValue != null && !(isIndexed = Boolean.parseBoolean(pValue.getValue()))) {
                        this.deleteNode(processor, (SolrQueryRequest)request, node);
                        addDocCmd.solrDoc = this.basicDocument(nodeMetaData, DOC_TYPE_UNINDEXED_NODE, () -> new SolrInputDocument(new String[0]));
                        if (this.recordUnindexedNodes) {
                            processor.processAdd(addDocCmd);
                        }
                        this.trackerStats.addNodeTime(System.nanoTime() - start);
                        continue;
                    }
                    this.deleteErrorNode(processor, (SolrQueryRequest)request, node);
                    addDocCmd.solrDoc = this.populateWithMetadata(this.basicDocument(nodeMetaData, DOC_TYPE_NODE, PartialSolrInputDocument::new), nodeMetaData, nmdp);
                    processor.processAdd(addDocCmd);
                    this.trackerStats.addNodeTime(System.nanoTime() - start);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Bulk indexing failed, do one node at a time. See the stacktrace below for further details.", e);
            for (Node node : nodes) {
                this.indexNode(node, true);
            }
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
        }
    }

    private PartialSolrInputDocument populateWithMetadata(PartialSolrInputDocument document, NodeMetaData metadata, NodeMetaDataParameters nmdp) {
        this.populateFields(metadata, document, nmdp);
        LOGGER.debug("Document size (fields) after getting fields from node {} metadata: {}", metadata.getId(), document.size());
        this.populateProperties(metadata.getProperties(), this.isContentIndexedForNode(metadata.getProperties()), document, this.contentIndexingHasBeenEnabledOnThisInstance);
        if (this.isContentIndexedForNode(metadata.getProperties())) {
            this.keepContentFields(document);
        } else {
            this.deleteContentField(document);
        }
        LOGGER.debug("Document size (fields) after getting properties from node {} metadata: {}", metadata.getId(), document.size());
        return document;
    }

    private void populateFields(NodeMetaData metadata, SolrInputDocument doc, NodeMetaDataParameters nmdp) {
        doc.setField("TYPE", (Object)metadata.getType().toString());
        if (nmdp.isIncludeAspects()) {
            doc.removeField("ASPECT");
            Utils.notNullOrEmpty(metadata.getAspects()).stream().filter(Objects::nonNull).forEach(aspect -> {
                doc.addField("ASPECT", (Object)aspect.toString());
                if (aspect.equals((Object)ContentModel.ASPECT_GEOGRAPHIC)) {
                    Optional<Double> latitude = Optional.ofNullable((PropertyValue)metadata.getProperties().get(ContentModel.PROP_LATITUDE)).map(StringPropertyValue.class::cast).map(StringPropertyValue::getValue).map(Utils::doubleOrNull).filter(value -> -90.0 <= value && value <= 90.0);
                    Optional<Double> longitude = Optional.ofNullable((PropertyValue)metadata.getProperties().get(ContentModel.PROP_LONGITUDE)).map(StringPropertyValue.class::cast).map(StringPropertyValue::getValue).map(Utils::doubleOrNull).filter(value -> -180.0 <= value && value <= 180.0);
                    if (latitude.isPresent() && longitude.isPresent()) {
                        doc.setField("GEO", (Object)(String.valueOf(latitude.get()) + ", " + String.valueOf(longitude.get())));
                    } else {
                        LOGGER.warning("Skipping missing geo data on node {}", metadata.getId());
                    }
                }
            });
        }
        doc.setField("ISNODE", (Object)"T");
        doc.setField("TENANT", (Object)AlfrescoSolrDataModel.getTenantId(metadata.getTenantDomain()));
        if (this.cascadeTrackingEnabled()) {
            NodeMetaData extendedMetadata = metadata;
            if (!this.getPathsInNodeBatches) {
                extendedMetadata = this.getNodeMetaDataWithPathInfo(metadata.getId());
            }
            this.updatePathRelatedFields(extendedMetadata, doc);
            this.updateNamePathRelatedFields(extendedMetadata, doc);
            this.updateAncestorRelatedFields(extendedMetadata, doc);
            doc.setField("PARENTASSOCCRC", (Object)extendedMetadata.getParentAssocsCrc());
        }
        Optional.ofNullable(metadata.getOwner()).ifPresent(owner -> doc.setField("OWNER", owner));
        StringBuilder qNameBuffer = new StringBuilder();
        StringBuilder assocTypeQNameBuffer = new StringBuilder();
        if (nmdp.isIncludeParentAssociations()) {
            doc.removeField("PARENT");
            Utils.notNullOrEmpty(metadata.getParentAssocs()).forEach(childAssocRef -> {
                if (qNameBuffer.length() > 0) {
                    qNameBuffer.append(";/");
                    assocTypeQNameBuffer.append(";/");
                }
                qNameBuffer.append(ISO9075.getXPathName((QName)childAssocRef.getQName()));
                assocTypeQNameBuffer.append(ISO9075.getXPathName((QName)childAssocRef.getTypeQName()));
                doc.addField("PARENT", (Object)childAssocRef.getParentRef().toString());
                if (childAssocRef.isPrimary()) {
                    if (doc.getField("PRIMARYPARENT") == null) {
                        doc.setField("PRIMARYPARENT", (Object)childAssocRef.getParentRef().toString());
                        doc.setField("PRIMARYASSOCTYPEQNAME", (Object)ISO9075.getXPathName((QName)childAssocRef.getTypeQName()));
                        doc.setField("PRIMARYASSOCQNAME", (Object)ISO9075.getXPathName((QName)childAssocRef.getQName()));
                    } else {
                        LOGGER.warning("Duplicate primary parent for node id {}", metadata.getId());
                    }
                }
            });
        }
        Optional.ofNullable(metadata.getParentAssocs()).ifPresent(parents -> {
            doc.addField("ASSOCTYPEQNAME", (Object)assocTypeQNameBuffer.toString());
            doc.addField("QNAME", (Object)qNameBuffer.toString());
        });
    }

    private NodeMetaData getNodeMetaDataWithPathInfo(long nodeId) {
        NodeMetaDataParameters nmdp = new NodeMetaDataParameters();
        nmdp.setFromNodeId(Long.valueOf(nodeId));
        nmdp.setToNodeId(Long.valueOf(nodeId));
        nmdp.setIncludePaths(true);
        nmdp.setMaxResults(1);
        return this.getNodesMetaDataFromRepository(nmdp).get().iterator().next();
    }

    private void updateAncestorRelatedFields(NodeMetaData nodeMetaData, SolrInputDocument doc) {
        doc.removeField("ANCESTOR");
        Utils.notNullOrEmpty(nodeMetaData.getAncestors()).stream().map(Object::toString).forEach(ancestor -> doc.addField("ANCESTOR", ancestor));
    }

    private void updateNamePathRelatedFields(NodeMetaData nodeMetaData, SolrInputDocument doc) {
        this.clearFields(doc, "NPATH", "PNAME");
        for (List namePath : nodeMetaData.getNamePaths()) {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (String element : namePath) {
                builder.append('/').append(element);
                doc.addField("NPATH", (Object)(i++ + String.valueOf(builder)));
            }
            if (builder.length() > 0) {
                doc.addField("NPATH", (Object)("F" + String.valueOf(builder)));
            }
            builder = new StringBuilder();
            for (int j = 0; j < namePath.size() - 1; ++j) {
                String element;
                element = (String)namePath.get(namePath.size() - 2 - j);
                builder.insert(0, element);
                builder.insert(0, '/');
                doc.addField("PNAME", (Object)(j + String.valueOf(builder)));
            }
            if (builder.length() <= 0) continue;
            doc.addField("PNAME", (Object)("F" + String.valueOf(builder)));
        }
    }

    void mltextProperty(QName propertyQName, MLTextPropertyValue value, BiConsumer<String, Object> valueHolder, boolean merge) {
        AlfrescoSolrDataModel dataModel = AlfrescoSolrDataModel.getInstance();
        List<AlfrescoSolrDataModel.FieldInstance> fields = dataModel.getIndexedFieldNamesForProperty(propertyQName).getFields();
        String storedFieldName = dataModel.getStoredMLTextField(propertyQName);
        List<String> localisedValues = this.getLocalisedValues(value);
        if (merge) {
            localisedValues.forEach(val -> valueHolder.accept(storedFieldName, val));
        } else {
            valueHolder.accept(storedFieldName, localisedValues);
        }
        fields.stream().filter(AlfrescoSolrDataModel.FieldInstance::isSort).forEach(field -> this.addMLTextProperty(valueHolder, (AlfrescoSolrDataModel.FieldInstance)field, value));
    }

    void stringProperty(QName propertyQName, StringPropertyValue value, PropertyValue locale, BiConsumer<String, Object> valueHolder) {
        PropertyDefinition definition;
        AlfrescoSolrDataModel dataModel = AlfrescoSolrDataModel.getInstance();
        if (dataModel.isTextField(definition = dataModel.getPropertyDefinition(propertyQName))) {
            String storedFieldName = dataModel.getStoredTextField(propertyQName);
            valueHolder.accept(storedFieldName, this.getLocalisedValue(value, locale));
            dataModel.getIndexedFieldNamesForProperty(propertyQName).getFields().stream().filter(field -> field.getField().startsWith("text@sd___@") || field.getField().startsWith("text@md___@")).forEach(field -> this.addStringProperty(valueHolder, (AlfrescoSolrDataModel.FieldInstance)field, value, locale));
        } else {
            dataModel.getIndexedFieldNamesForProperty(propertyQName).getFields().forEach(field -> {
                if (this.canBeDestructured(definition, field.getField())) {
                    this.setUnitOfTimeFields(valueHolder, field.getField(), value.getValue(), definition.getDataType());
                }
                this.addStringProperty(valueHolder, (AlfrescoSolrDataModel.FieldInstance)field, value, locale);
            });
        }
    }

    void populateProperties(Map<QName, PropertyValue> properties, boolean contentIndexingHasBeenRequestedForThisNode, SolrInputDocument document, boolean contentIndexingHasBeenEnabledOnThisInstance) {
        boolean contentIndexingIsEnabled;
        boolean bl = contentIndexingIsEnabled = contentIndexingHasBeenEnabledOnThisInstance && contentIndexingHasBeenRequestedForThisNode;
        if (!contentIndexingIsEnabled) {
            this.markAsContentInSynch(document);
        }
        BiConsumer<String, Object> setValue = (arg_0, arg_1) -> ((SolrInputDocument)document).setField(arg_0, arg_1);
        BiConsumer<String, Object> addValue = (arg_0, arg_1) -> ((SolrInputDocument)document).addField(arg_0, arg_1);
        BiConsumer<String, Object> collectName = (name, value) -> this.addFieldIfNotSet(document, (String)name);
        BiConsumer<String, Object> setAndCollect = setValue.andThen(collectName);
        BiConsumer<String, Object> addAndCollect = addValue.andThen(collectName);
        for (Map.Entry<QName, PropertyValue> property : properties.entrySet()) {
            QName propertyQName = property.getKey();
            PropertyDefinition propertyDefinition = this.dataModel.getPropertyDefinition(propertyQName);
            if (propertyDefinition != null && propertyDefinition.isIndexed()) {
                document.addField("PROPERTIES", (Object)propertyQName.toString());
                document.addField("PROPERTIES", (Object)propertyQName.getPrefixString());
                PropertyValue value2 = property.getValue();
                if (value2 != null) {
                    if (value2 instanceof StringPropertyValue) {
                        this.stringProperty(propertyQName, (StringPropertyValue)value2, properties.get(ContentModel.PROP_LOCALE), setAndCollect);
                        continue;
                    }
                    if (value2 instanceof MLTextPropertyValue) {
                        this.mltextProperty(propertyQName, (MLTextPropertyValue)value2, setAndCollect, false);
                        continue;
                    }
                    if (value2 instanceof ContentPropertyValue) {
                        this.addContentProperty(setAndCollect, document, propertyQName, (ContentPropertyValue)value2, contentIndexingIsEnabled);
                        continue;
                    }
                    if (!(value2 instanceof MultiPropertyValue)) continue;
                    MultiPropertyValue typedValue = (MultiPropertyValue)value2;
                    AlfrescoSolrDataModel dataModel = AlfrescoSolrDataModel.getInstance();
                    this.clearFields(document, dataModel.getIndexedFieldNamesForProperty(propertyQName).getFields().stream().map(AlfrescoSolrDataModel.FieldInstance::getField).collect(Collectors.toList()));
                    for (PropertyValue singleValue : typedValue.getValues()) {
                        if (singleValue instanceof StringPropertyValue) {
                            this.stringProperty(propertyQName, (StringPropertyValue)singleValue, properties.get(ContentModel.PROP_LOCALE), addAndCollect);
                            continue;
                        }
                        if (singleValue instanceof MLTextPropertyValue) {
                            boolean merge = document instanceof PartialSolrInputDocument;
                            this.mltextProperty(propertyQName, (MLTextPropertyValue)singleValue, addAndCollect, merge);
                            continue;
                        }
                        if (!(singleValue instanceof ContentPropertyValue)) continue;
                        this.addContentProperty(addAndCollect, document, propertyQName, (ContentPropertyValue)singleValue, contentIndexingIsEnabled);
                    }
                    continue;
                }
                document.addField("NULLPROPERTIES", (Object)propertyQName.toString());
                continue;
            }
            LOGGER.debug("Field '" + String.valueOf(propertyQName) + "' has not been indexed " + (propertyDefinition != null ? "as property definition is not found." : "as it has been declared as not indexable in the Content Model."), new Object[0]);
        }
    }

    private void deleteErrorNode(UpdateRequestProcessor processor, SolrQueryRequest request, Node node) throws IOException {
        String errorDocId = PREFIX_ERROR + node.getId();
        if (this.getDocListSize("id:" + errorDocId) > 0) {
            DeleteUpdateCommand delErrorDocCmd = new DeleteUpdateCommand(request);
            delErrorDocCmd.setId(errorDocId);
            processor.processDelete(delErrorDocCmd);
        }
    }

    private void deleteNode(UpdateRequestProcessor processor, SolrQueryRequest request, long dbid) throws IOException {
        if (this.getDocListSize("DBID:" + dbid) > 0) {
            DeleteUpdateCommand delDocCmd = new DeleteUpdateCommand(request);
            delDocCmd.setQuery("DBID:" + dbid);
            processor.processDelete(delDocCmd);
        }
    }

    private void deleteNode(UpdateRequestProcessor processor, SolrQueryRequest request, Node node) throws IOException {
        LOGGER.debug("Node {} is being deleted", node.getId());
        this.deleteErrorNode(processor, request, node);
        this.deleteNode(processor, request, node.getId());
        LOGGER.debug("Node {} deletion correctly sent", node.getId());
    }

    private boolean isContentIndexedForNode(Map<QName, PropertyValue> properties) {
        return Optional.ofNullable(properties).map(map -> (PropertyValue)map.get(ContentModel.PROP_IS_CONTENT_INDEXED)).map(StringPropertyValue.class::cast).map(StringPropertyValue::getValue).map(Boolean::parseBoolean).orElse(true);
    }

    private void categorizeNodes(List<Node> nodes, Map<Long, Node> nodeIdsToNodes, EnumMap<Node.SolrApiNodeStatus, List<Long>> nodeStatusToNodeIds) {
        for (Node node : nodes) {
            nodeIdsToNodes.put(node.getId(), node);
            List nodeIds = nodeStatusToNodeIds.computeIfAbsent(node.getStatus(), k -> new LinkedList());
            nodeIds.add(node.getId());
        }
    }

    private void addContentPropertyMetadata(SolrInputDocument doc, QName propertyQName, AlfrescoSolrDataModel.SpecializedFieldType type, SOLRAPIClient.GetTextContentResponse textContentResponse) {
        AlfrescoSolrDataModel.IndexedField indexedField = this.dataModel.getIndexedFieldForSpecializedPropertyMetadata(propertyQName, type);
        for (AlfrescoSolrDataModel.FieldInstance fieldInstance : indexedField.getFields()) {
            switch (type) {
                case TRANSFORMATION_EXCEPTION: {
                    doc.setField(fieldInstance.getField(), (Object)textContentResponse.getTransformException());
                    break;
                }
                case TRANSFORMATION_STATUS: {
                    doc.setField(fieldInstance.getField(), (Object)textContentResponse.getStatus().name());
                    break;
                }
                case TRANSFORMATION_TIME: {
                    doc.setField(fieldInstance.getField(), (Object)textContentResponse.getTransformDuration());
                    break;
                }
            }
        }
    }

    private void addContentPropertyMetadata(BiConsumer<String, Object> consumer, QName propertyQName, ContentPropertyValue contentPropertyValue, AlfrescoSolrDataModel.SpecializedFieldType type) {
        AlfrescoSolrDataModel.IndexedField indexedField = AlfrescoSolrDataModel.getInstance().getIndexedFieldForSpecializedPropertyMetadata(propertyQName, type);
        for (AlfrescoSolrDataModel.FieldInstance fieldInstance : indexedField.getFields()) {
            switch (type) {
                case CONTENT_DOCID: {
                    consumer.accept(fieldInstance.getField(), contentPropertyValue.getId());
                    break;
                }
                case CONTENT_ENCODING: {
                    consumer.accept(fieldInstance.getField(), contentPropertyValue.getEncoding());
                    break;
                }
                case CONTENT_LOCALE: {
                    consumer.accept(fieldInstance.getField(), contentPropertyValue.getLocale().toString());
                    break;
                }
                case CONTENT_MIMETYPE: {
                    consumer.accept(fieldInstance.getField(), contentPropertyValue.getMimetype());
                    break;
                }
                case CONTENT_SIZE: {
                    consumer.accept(fieldInstance.getField(), contentPropertyValue.getLength());
                    break;
                }
            }
        }
    }

    private void markAsContentInSynch(SolrInputDocument document) {
        this.markAsContentInSynch(document, (ContentPropertyValue)null);
    }

    private void markAsContentInSynch(SolrInputDocument document, ContentPropertyValue value) {
        Optional.ofNullable(value).map(ContentPropertyValue::getId).ifPresentOrElse(id -> this.markAsContentInSynch(document, (Long)id), () -> this.markAsContentInSynch(document, -20L));
    }

    private void markAsContentInSynch(SolrInputDocument document, Long id) {
        long contentVersionId = Optional.ofNullable(id).orElse(-20L);
        document.setField(LATEST_APPLIED_CONTENT_VERSION_ID, (Object)contentVersionId);
        document.setField(LAST_INCOMING_CONTENT_VERSION_ID, (Object)contentVersionId);
    }

    private void insertContentUpdateMarker(SolrInputDocument document, ContentPropertyValue value) {
        Optional.ofNullable(value).map(ContentPropertyValue::getId).ifPresent(id -> document.setField(LATEST_APPLIED_CONTENT_VERSION_ID, id));
        document.setField(LAST_INCOMING_CONTENT_VERSION_ID, (Object)-10L);
    }

    private void addContentProperty(BiConsumer<String, Object> consumer, SolrInputDocument document, QName propertyName, ContentPropertyValue propertyValue, boolean contentIndexingEnabled) {
        this.addContentPropertyMetadata(consumer, propertyName, propertyValue, AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_DOCID);
        this.addContentPropertyMetadata(consumer, propertyName, propertyValue, AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_SIZE);
        this.addContentPropertyMetadata(consumer, propertyName, propertyValue, AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_LOCALE);
        this.addContentPropertyMetadata(consumer, propertyName, propertyValue, AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_MIMETYPE);
        this.addContentPropertyMetadata(consumer, propertyName, propertyValue, AlfrescoSolrDataModel.SpecializedFieldType.CONTENT_ENCODING);
        if (contentIndexingEnabled) {
            this.insertContentUpdateMarker(document, propertyValue);
        }
    }

    private void addContentToDoc(AlfrescoSolrDataModel.TenantDbId docRef, SolrInputDocument doc, long dbId) {
        docRef.contentPropertySpecsStream().forEach(propertySpecs -> {
            try {
                QName propertyQName = QName.createQName((String)propertySpecs.fieldName.substring("content@s__locale@".length()));
                this.addContentPropertyToDocUsingAlfrescoRepository(doc, propertyQName, dbId, propertySpecs.locale);
            }
            catch (IOException | AuthenticationException exception) {
                throw new RuntimeException(exception);
            }
        });
    }

    private String textContentFrom(SOLRAPIClient.GetTextContentResponse response) throws IOException {
        try {
            String string;
            block13: {
                InputStream ris;
                block11: {
                    String string2;
                    block12: {
                        ris = Optional.ofNullable(response.getContentEncoding()).map(c -> c.equals("gzip")).orElse(false) != false ? new GZIPInputStream(response.getContent()) : response.getContent();
                        try {
                            if (ris == null) break block11;
                            byte[] bytes = FileCopyUtils.copyToByteArray((InputStream)new BoundedInputStream(ris, (long)this.contentStreamLimit));
                            string2 = new String(bytes, StandardCharsets.UTF_8);
                            if (ris == null) break block12;
                        }
                        catch (Throwable throwable) {
                            if (ris != null) {
                                try {
                                    ris.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        ris.close();
                    }
                    return string2;
                }
                string = "";
                if (ris == null) break block13;
                ris.close();
            }
            return string;
        }
        finally {
            response.release();
        }
    }

    private void addContentPropertyToDocUsingAlfrescoRepository(SolrInputDocument doc, QName propertyQName, long dbId, String locale) throws AuthenticationException, IOException {
        long start = System.nanoTime();
        try (SOLRAPIClient.GetTextContentResponse response = this.repositoryClient.getTextContent(Long.valueOf(dbId), propertyQName, null);){
            this.addContentPropertyMetadata(doc, propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.TRANSFORMATION_STATUS, response);
            this.addContentPropertyMetadata(doc, propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.TRANSFORMATION_EXCEPTION, response);
            this.addContentPropertyMetadata(doc, propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.TRANSFORMATION_TIME, response);
            String textContent = this.textContentFrom(response);
            if (this.fingerprintHasBeenEnabledOnThisInstance && !textContent.isBlank()) {
                Analyzer analyzer = this.core.getLatestSchema().getFieldType("min_hash").getIndexAnalyzer();
                TokenStream ts = analyzer.tokenStream("dummy_field", textContent);
                CharTermAttribute termAttribute = (CharTermAttribute)ts.getAttribute(CharTermAttribute.class);
                ts.reset();
                doc.removeField(FINGERPRINT_FIELD);
                while (ts.incrementToken()) {
                    StringBuilder tokenBuff = new StringBuilder();
                    char[] buff = termAttribute.buffer();
                    for (int i = 0; i < termAttribute.length(); ++i) {
                        tokenBuff.append(Integer.toHexString(buff[i]));
                    }
                    doc.addField(FINGERPRINT_FIELD, (Object)tokenBuff.toString());
                }
                ts.end();
                ts.close();
            }
            this.getTrackerStats().addDocTransformationTime(System.nanoTime() - start);
            String storedField = this.dataModel.getStoredContentField(propertyQName);
            doc.setField(storedField, (Object)("\u0000" + this.languageFrom(locale) + "\u0000" + textContent));
            this.dataModel.getIndexedFieldNamesForProperty(propertyQName).getFields().forEach(field -> this.addFieldIfNotSet(doc, field.getField()));
        }
    }

    private void applyContentFields(PartialSolrInputDocument doc, BiConsumer<PartialSolrInputDocument, String> consumer) {
        String qNamePart = CONTENT_LOCALE_FIELD.substring("content@s__locale@".length());
        QName propertyQName = QName.createQName((String)qNamePart);
        this.dataModel.getIndexedFieldForSpecializedPropertyMetadata(propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.TRANSFORMATION_STATUS).getFields().stream().forEach(field -> consumer.accept(doc, field.getField()));
        this.dataModel.getIndexedFieldForSpecializedPropertyMetadata(propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.TRANSFORMATION_EXCEPTION).getFields().stream().forEach(field -> consumer.accept(doc, field.getField()));
        this.dataModel.getIndexedFieldForSpecializedPropertyMetadata(propertyQName, AlfrescoSolrDataModel.SpecializedFieldType.TRANSFORMATION_TIME).getFields().stream().forEach(field -> consumer.accept(doc, field.getField()));
        consumer.accept(doc, FINGERPRINT_FIELD);
        List contentProperties = doc.getFieldNames().stream().filter(field -> field.startsWith("content@s__locale@")).map(field -> {
            String part = field.substring("content@s__locale@".length());
            QName property = QName.createQName((String)part);
            return this.dataModel.getStoredContentField(property);
        }).collect(Collectors.toList());
        for (String contentProperty : contentProperties) {
            consumer.accept(doc, contentProperty);
        }
    }

    private void deleteContentField(PartialSolrInputDocument doc) {
        this.applyContentFields(doc, (doc2, field) -> doc2.removeField((String)field));
    }

    private void keepContentFields(PartialSolrInputDocument doc) {
        this.applyContentFields(doc, (doc2, field) -> doc2.keepField((String)field));
    }

    private String languageFrom(String locale) {
        int indexOfSeparator = locale.indexOf("_");
        return indexOfSeparator == -1 ? locale : locale.substring(0, indexOfSeparator);
    }

    private List<String> getLocalisedValues(MLTextPropertyValue mlTextPropertyValue) {
        if (mlTextPropertyValue == null) {
            return Collections.emptyList();
        }
        ArrayList<String> values = new ArrayList<String>();
        for (Locale locale : mlTextPropertyValue.getLocales()) {
            String propValue = mlTextPropertyValue.getValue(locale);
            if (locale == null || propValue == null) continue;
            values.add("\u0000" + locale.getLanguage() + "\u0000" + propValue);
        }
        return values;
    }

    private void addMLTextProperty(BiConsumer<String, Object> consumer, AlfrescoSolrDataModel.FieldInstance field, MLTextPropertyValue mlTextPropertyValue) {
        if (mlTextPropertyValue == null) {
            return;
        }
        if (field.isLocalised()) {
            StringBuilder sort = new StringBuilder();
            for (Locale locale : mlTextPropertyValue.getLocales()) {
                String propValue = mlTextPropertyValue.getValue(locale);
                if (locale == null || propValue == null) continue;
                StringBuilder builder = new StringBuilder(propValue.length() + 16);
                builder.append("\u0000").append(locale.toString()).append("\u0000").append(propValue);
                if (!field.isSort()) {
                    consumer.accept(field.getField(), builder.toString());
                }
                if (sort.length() > 0) {
                    sort.append("\u0000");
                }
                sort.append(builder.toString());
            }
            if (field.isSort()) {
                consumer.accept(field.getField(), sort.toString());
            }
        } else {
            List localisedValues = Utils.notNullOrEmpty(mlTextPropertyValue.getLocales()).stream().filter(Objects::nonNull).map(arg_0 -> ((MLTextPropertyValue)mlTextPropertyValue).getValue(arg_0)).collect(Collectors.toList());
            if (!localisedValues.isEmpty()) {
                consumer.accept(field.getField(), localisedValues);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTransaction(Transaction txn) throws IOException {
        this.canUpdate();
        UpdateRequestProcessor processor = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            AddUpdateCommand cmd = new AddUpdateCommand((SolrQueryRequest)request);
            cmd.overwrite = true;
            SolrInputDocument input = new SolrInputDocument(new String[0]);
            input.addField("id", (Object)AlfrescoSolrDataModel.getTransactionDocumentId(txn.getId()));
            input.addField("_version_", (Object)1);
            input.addField("TXID", (Object)txn.getId());
            input.addField("INTXID", (Object)txn.getId());
            input.addField("TXCOMMITTIME", (Object)txn.getCommitTimeMs());
            input.addField("DOC_TYPE", (Object)DOC_TYPE_TX);
            if (this.cascadeTrackingEnabled()) {
                input.addField("int@s_@cascade", (Object)0);
            }
            cmd.solrDoc = input;
            processor.processAdd(cmd);
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void indexTransaction(Transaction info, boolean overwrite) throws IOException {
        this.canUpdate();
        UpdateRequestProcessor processor = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            AddUpdateCommand cmd = new AddUpdateCommand((SolrQueryRequest)request);
            cmd.overwrite = overwrite;
            SolrInputDocument input = new SolrInputDocument(new String[0]);
            input.addField("id", (Object)AlfrescoSolrDataModel.getTransactionDocumentId(info.getId()));
            input.addField("_version_", (Object)0);
            input.addField("TXID", (Object)info.getId());
            input.addField("INTXID", (Object)info.getId());
            input.addField("TXCOMMITTIME", (Object)info.getCommitTimeMs());
            input.addField("DOC_TYPE", (Object)DOC_TYPE_TX);
            input.addField("S_TXID", (Object)info.getId());
            input.addField("S_TXCOMMITTIME", (Object)info.getCommitTimeMs());
            if (this.cascadeTrackingEnabled()) {
                input.addField("int@s_@cascade", (Object)1);
            }
            cmd.solrDoc = input;
            processor.processAdd(cmd);
            this.putTransactionState(processor, (SolrQueryRequest)request, info);
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexNonShardCascade(NodeMetaData nodeMetaData) throws IOException {
        UpdateRequestProcessor processor = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            StringPropertyValue stringPropertyValue = (StringPropertyValue)nodeMetaData.getProperties().get(ContentModel.PROP_CASCADE_TX);
            List<AlfrescoSolrDataModel.FieldInstance> fieldInstances = AlfrescoSolrDataModel.getInstance().getIndexedFieldNamesForProperty(ContentModel.PROP_CASCADE_TX).getFields();
            AlfrescoSolrDataModel.FieldInstance fieldInstance = fieldInstances.get(0);
            AddUpdateCommand cmd = new AddUpdateCommand((SolrQueryRequest)request);
            SolrInputDocument input = new SolrInputDocument(new String[0]);
            input.addField("id", (Object)AlfrescoSolrDataModel.getNodeDocumentId(nodeMetaData.getTenantDomain(), nodeMetaData.getId()));
            input.addField("_version_", (Object)0);
            input.addField(fieldInstance.getField(), (Object)stringPropertyValue.getValue());
            cmd.solrDoc = input;
            processor.processAdd(cmd);
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
        }
    }

    @Override
    public Transaction getMaxTransactionIdAndCommitTimeInIndex() {
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            Transaction maxTransaction;
            SolrDocument txState = this.getState(this.core, (SolrQueryRequest)request, "TRACKER!STATE!TX");
            if (txState != null) {
                long id = this.getFieldValueLong(txState, "S_TXID");
                long commitTime = this.getFieldValueLong(txState, "S_TXCOMMITTIME");
                maxTransaction = new Transaction();
                maxTransaction.setId(id);
                maxTransaction.setCommitTimeMs(commitTime);
            } else {
                maxTransaction = new Transaction();
            }
            Transaction transaction = maxTransaction;
            return transaction;
        }
    }

    @Override
    public boolean isInIndex(String id) {
        Boolean found = (Boolean)this.isIdIndexCache.get((Object)id);
        if (found != null) {
            return found;
        }
        boolean isInIndex = this.isInIndexImpl(id);
        if (isInIndex) {
            this.isIdIndexCache.put((Object)id, (Object)Boolean.TRUE);
        }
        return isInIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Transaction> getCascades(int num) throws IOException {
        RefCounted refCounted = null;
        try {
            TopFieldCollector topFieldCollector;
            refCounted = this.core.getSearcher();
            SolrIndexSearcher searcher = (SolrIndexSearcher)refCounted.get();
            Object collector = topFieldCollector = TopFieldCollector.create((Sort)new Sort(new SortField("TXID", SortField.Type.LONG)), (int)num, null, (boolean)false, (boolean)false, (boolean)false);
            LegacyNumericRangeQuery q = LegacyNumericRangeQuery.newIntRange((String)"int@s_@cascade", (Integer)1, (Integer)1, (boolean)true, (boolean)true);
            TxnCacheFilter delegatingCollector = new TxnCacheFilter(this.cleanCascadeCache);
            delegatingCollector.setLastDelegate((Collector)collector);
            collector = delegatingCollector;
            searcher.search((Query)q, (Collector)collector);
            ScoreDoc[] scoreDocs = topFieldCollector.topDocs().scoreDocs;
            HashSet<String> fields = new HashSet<String>();
            fields.add("S_TXID");
            fields.add("S_TXCOMMITTIME");
            ArrayList<Transaction> transactions = new ArrayList<Transaction>(scoreDocs.length);
            for (ScoreDoc scoreDoc : scoreDocs) {
                Transaction transaction = new Transaction();
                Document doc = searcher.doc(scoreDoc.doc, fields);
                IndexableField txID = doc.getField("S_TXID");
                long txnID = txID.numericValue().longValue();
                this.cleanCascadeCache.put(txnID, null);
                transaction.setId(txnID);
                IndexableField txnCommitTime = doc.getField("S_TXCOMMITTIME");
                transaction.setCommitTimeMs(txnCommitTime.numericValue().longValue());
                transactions.add(transaction);
            }
            ArrayList<Transaction> arrayList = transactions;
            return arrayList;
        }
        finally {
            Optional.ofNullable(refCounted).ifPresent(RefCounted::decref);
        }
    }

    @Override
    public boolean txnInIndex(long txnId, boolean populateCache) throws IOException {
        return this.isInIndex(txnId, this.txnIdCache, "TXID", populateCache, this.core);
    }

    @Override
    public boolean aclChangeSetInIndex(long changeSetId, boolean populateCache) throws IOException {
        return this.isInIndex(changeSetId, this.aclChangeSetCache, "ACLTXID", populateCache, this.core);
    }

    @Override
    public void clearProcessedTransactions() {
        this.txnIdCache.clear();
    }

    @Override
    public void clearProcessedAclChangeSets() {
        this.aclChangeSetCache.clear();
    }

    @Override
    public boolean putModel(M2Model model) {
        return this.dataModel.putModel(model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback() throws IOException {
        this.commitAndRollbackLock.writeLock().lock();
        try {
            this.activeTrackerThreadsLock.writeLock().lock();
            try {
                this.activeTrackerThreads.clear();
                UpdateRequestProcessor processor = null;
                try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
                    processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
                    processor.processRollback(new RollbackUpdateCommand((SolrQueryRequest)request));
                }
                finally {
                    if (processor != null) {
                        processor.finish();
                    }
                }
            }
            finally {
                this.activeTrackerThreadsLock.writeLock().unlock();
            }
        }
        finally {
            this.commitAndRollbackLock.writeLock().unlock();
        }
    }

    @Override
    public void registerTrackerThread() {
        this.activeTrackerThreadsLock.writeLock().lock();
        try {
            this.activeTrackerThreads.add(Thread.currentThread().getId());
        }
        finally {
            this.activeTrackerThreadsLock.writeLock().unlock();
        }
    }

    @Override
    public void unregisterTrackerThread() {
        this.activeTrackerThreadsLock.writeLock().lock();
        try {
            this.activeTrackerThreads.remove(Thread.currentThread().getId());
        }
        finally {
            this.activeTrackerThreadsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reindexNodeByQuery(String query) throws IOException, JSONException {
        RefCounted refCounted = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            refCounted = this.core.getSearcher(false, true, null);
            SolrIndexSearcher solrIndexSearcher = (SolrIndexSearcher)refCounted.get();
            NumericDocValues dbidDocValues = solrIndexSearcher.getSlowAtomicReader().getNumericDocValues("DBID");
            ArrayList<Node> batch = new ArrayList<Node>(200);
            DocList docList = this.cloud.getDocList(this.nativeRequestHandler, (SolrQueryRequest)request, (String)(query.startsWith("{") ? query : "{!afts}" + query));
            DocIterator it = docList.iterator();
            while (it.hasNext()) {
                int docID = it.nextDoc();
                long dbid = dbidDocValues.get(docID);
                Node node = new Node();
                node.setId(dbid);
                node.setStatus(Node.SolrApiNodeStatus.UNKNOWN);
                node.setTxnId(Long.MAX_VALUE);
                batch.add(node);
                if (batch.size() < 200) continue;
                this.indexNodes(batch, true);
                batch.clear();
            }
            if (batch.size() > 0) {
                this.indexNodes(batch, true);
                batch.clear();
            }
        }
        finally {
            Optional.ofNullable(refCounted).ifPresent(RefCounted::decref);
        }
    }

    @Override
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public void setCleanContentTxnFloor(long cleanContentTxnFloor) {
    }

    @Override
    public void setCleanCascadeTxnFloor(long cleanCascadeTxnFloor) {
    }

    public Properties getProps() {
        return this.props;
    }

    private void putTransactionState(UpdateRequestProcessor processor, SolrQueryRequest request, Transaction tx) throws IOException {
        SolrDocument txState = this.getState(this.core, request, "TRACKER!STATE!TX");
        String version = this.version(txState, "S_TXCOMMITTIME", "S_TXID", tx.getCommitTimeMs(), tx.getId());
        if (version != null) {
            SolrInputDocument input = new SolrInputDocument(new String[0]);
            input.addField("id", (Object)"TRACKER!STATE!TX");
            input.addField("_version_", (Object)version);
            input.addField("S_TXID", (Object)tx.getId());
            input.addField("S_INTXID", (Object)tx.getId());
            input.addField("S_TXCOMMITTIME", (Object)tx.getCommitTimeMs());
            input.addField("DOC_TYPE", (Object)DOC_TYPE_STATE);
            AddUpdateCommand cmd = new AddUpdateCommand(request);
            cmd.overwrite = true;
            cmd.solrDoc = input;
            processor.processAdd(cmd);
        }
    }

    private boolean isInIndexImpl(String ids) {
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            SolrRequestHandler handler = this.core.getRequestHandler(REQUEST_HANDLER_GET);
            ModifiableSolrParams newParams = new ModifiableSolrParams(request.getParams()).set("ids", new String[]{ids});
            request.setParams((SolrParams)newParams);
            boolean bl = this.executeQueryRequest((SolrQueryRequest)request, this.newSolrQueryResponse(), handler).getNumFound() > 0L;
            return bl;
        }
    }

    private void canUpdate() {
        this.activeTrackerThreadsLock.readLock().lock();
        try {
            if (!this.activeTrackerThreads.contains(Thread.currentThread().getId())) {
                throw new TrackerStateException("The trackers work was rolled back by another tracker error. The original cause has been dumped previously in the log.");
            }
        }
        finally {
            this.activeTrackerThreadsLock.readLock().unlock();
        }
    }

    private String baseUrl(Properties properties) {
        return Optional.ofNullable(ConfigUtil.locateProperty(SOLR_BASEURL, properties.getProperty(SOLR_BASEURL))).map(value -> (value.startsWith("/") ? "" : "/") + value + "/" + this.core.getName() + "/").orElse(null);
    }

    private int portNumber(Properties properties) {
        String portNumber = Optional.ofNullable(ConfigUtil.locateProperty(SOLR_PORT, properties.getProperty(SOLR_PORT))).filter(value -> value.trim().length() > 0).orElseGet(() -> {
            String jettyPort = System.getProperty("jetty.port");
            LOGGER.debug("Using jetty.port ", jettyPort);
            return jettyPort;
        });
        return Optional.ofNullable(portNumber).map(value -> {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException exception) {
                LOGGER.error("Failed to find a valid solr.port number, the default value is in shared.properties", new Object[0]);
                throw exception;
            }
        }).orElse(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isInIndex(long id, LRU cache, String fieldName, boolean populateCache, SolrCore core) throws IOException {
        if (cache.containsKey(id)) {
            return true;
        }
        RefCounted refCounted = null;
        try {
            if (populateCache) {
                cache.put(id, null);
            }
            refCounted = core.getSearcher();
            SolrIndexSearcher searcher = (SolrIndexSearcher)refCounted.get();
            FieldType fieldType = searcher.getSchema().getField(fieldName).getType();
            TermQuery q = new TermQuery(new Term(fieldName, fieldType.readableToIndexed(Long.toString(id))));
            TopDocs topDocs = searcher.search((Query)q, 1);
            boolean bl = topDocs.totalHits > 0;
            return bl;
        }
        finally {
            Optional.ofNullable(refCounted).ifPresent(RefCounted::decref);
        }
    }

    private SolrDocumentList executeQueryRequest(SolrQueryRequest request, SolrQueryResponse response, SolrRequestHandler handler) {
        handler.handleRequest(request, response);
        NamedList values = response.getValues();
        return (SolrDocumentList)values.get(RESPONSE_DEFAULT_IDS);
    }

    private String addTenantToAuthority(String authority, String tenant) {
        AuthorityType authorityType = AuthorityType.getAuthorityType((String)authority);
        if (!(authorityType != AuthorityType.GROUP && authorityType != AuthorityType.EVERYONE && authorityType != AuthorityType.GUEST || tenant.isEmpty())) {
            return authority + "@" + tenant;
        }
        return authority;
    }

    private <T extends SolrInputDocument> T basicDocument(NodeMetaData metadata, String docType, Supplier<T> initialEmptyDocumentSupplier) {
        SolrInputDocument doc = (SolrInputDocument)initialEmptyDocumentSupplier.get();
        doc.setField("id", (Object)AlfrescoSolrDataModel.getNodeDocumentId(metadata.getTenantDomain(), metadata.getId()));
        doc.setField("_version_", (Object)0);
        doc.removeField("DBID");
        doc.addField("DBID", (Object)metadata.getId());
        doc.setField("LID", (Object)metadata.getNodeRef().toString());
        doc.setField("INTXID", (Object)metadata.getTxnId());
        doc.setField("DOC_TYPE", (Object)docType);
        doc.setField("ACLID", (Object)metadata.getAclId());
        return (T)doc;
    }

    protected void updatePathRelatedFields(NodeMetaData nodeMetaData, SolrInputDocument doc) {
        this.clearFields(doc, "PATH", "SITE", "TAG", "suggest_TAG", "APATH", "ANAME");
        boolean repoOnly = true;
        for (Pair path : nodeMetaData.getPaths()) {
            doc.addField("PATH", path.getFirst());
            Matcher matcher = CAPTURE_SITE.matcher((CharSequence)path.getFirst());
            if (matcher.find()) {
                repoOnly = false;
                doc.addField("SITE", (Object)ISO9075.decode((String)matcher.group(1)));
            }
            if ((matcher = CAPTURE_SHARED_FILES.matcher((CharSequence)path.getFirst())).find()) {
                repoOnly = false;
                doc.addField("SITE", (Object)SHARED_FILES);
            }
            if (!(matcher = CAPTURE_TAG.matcher((CharSequence)path.getFirst())).find()) continue;
            String tag = ISO9075.decode((String)matcher.group(1));
            doc.addField("TAG", (Object)tag);
            doc.addField("suggest_TAG", (Object)tag);
        }
        if (repoOnly) {
            doc.addField("SITE", (Object)NO_SITE);
        }
        HashSet addedAPaths = new HashSet();
        HashSet addedANames = new HashSet();
        Utils.notNullOrEmpty(nodeMetaData.getAncestorPaths()).forEach(ancestorPath -> {
            String[] elements = (String[])Arrays.stream(Utils.notNullOrEmpty(ancestorPath.length() > 0 && ancestorPath.startsWith("/") ? ancestorPath.substring(1).split("/") : ancestorPath.split("/"))).map(String::trim).toArray(String[]::new);
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (String element : elements) {
                builder.append('/').append(element);
                String apath = i++ + String.valueOf(builder);
                if (addedAPaths.contains(apath)) continue;
                doc.addField("APATH", (Object)apath);
                addedAPaths.add(apath);
            }
            if (builder.length() > 0) {
                doc.addField("APATH", (Object)("F" + String.valueOf(builder)));
            }
            builder = new StringBuilder();
            for (int j = 0; j < elements.length; ++j) {
                String element = elements[elements.length - 1 - j];
                builder.insert(0, element);
                builder.insert(0, '/');
                String aname = j + String.valueOf(builder);
                if (addedANames.contains(aname)) continue;
                doc.addField("ANAME", (Object)aname);
                addedANames.add(aname);
            }
            if (builder.length() > 0) {
                doc.addField("ANAME", (Object)("F" + String.valueOf(builder)));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cascadeUpdateV2(NodeMetaData parentNodeMetaData, boolean overwrite, SolrQueryRequest request, UpdateRequestProcessor processor) throws IOException, JSONException {
        RefCounted refCounted = null;
        HashSet<Long> childIds = new HashSet<Long>();
        try {
            refCounted = this.core.getSearcher();
            SolrIndexSearcher searcher = (SolrIndexSearcher)refCounted.get();
            BooleanQuery.Builder builder = new BooleanQuery.Builder();
            TermQuery termQuery = new TermQuery(new Term("ANCESTOR", parentNodeMetaData.getNodeRef().toString()));
            BooleanClause booleanClause = new BooleanClause((Query)termQuery, BooleanClause.Occur.MUST);
            builder.add(booleanClause);
            BooleanQuery booleanQuery = builder.build();
            DocListCollector collector = new DocListCollector();
            searcher.search((Query)booleanQuery, (Collector)collector);
            IntArrayList docList = collector.getDocs();
            int size = docList.size();
            for (int i = 0; i < size; ++i) {
                int docId = docList.get(i);
                Document document = searcher.doc(docId, REQUEST_ONLY_ID_FIELD);
                IndexableField indexableField = document.getField("id");
                String id = indexableField.stringValue();
                AlfrescoSolrDataModel.TenantDbId ids = AlfrescoSolrDataModel.decodeNodeDocumentId(id);
                childIds.add(ids.dbId);
            }
        }
        finally {
            Optional.ofNullable(refCounted).ifPresent(RefCounted::decref);
        }
        for (Long childId : childIds) {
            NodeMetaData nodeMetaData;
            NodeMetaDataParameters nmdp = new NodeMetaDataParameters();
            nmdp.setFromNodeId(childId);
            nmdp.setToNodeId(childId);
            nmdp.setIncludeAclId(true);
            nmdp.setIncludeAspects(false);
            nmdp.setIncludeChildAssociations(false);
            nmdp.setIncludeChildIds(true);
            nmdp.setIncludeNodeRef(true);
            nmdp.setIncludeOwner(false);
            nmdp.setIncludeParentAssociations(false);
            nmdp.setIncludePaths(true);
            nmdp.setIncludeProperties(false);
            nmdp.setIncludeType(true);
            nmdp.setIncludeTxnId(true);
            nmdp.setMaxResults(1);
            Optional<Collection<NodeMetaData>> nodeMetaDatas = this.getNodesMetaDataFromRepository(nmdp);
            if (!nodeMetaDatas.isPresent() || nodeMetaDatas.get().isEmpty() || (nodeMetaData = nodeMetaDatas.get().iterator().next()).getTxnId() >= parentNodeMetaData.getTxnId()) continue;
            LOGGER.debug("Cascade update child doc {}", childId);
            PartialSolrInputDocument document = this.basicDocument(nodeMetaData, DOC_TYPE_NODE, PartialSolrInputDocument::new);
            AddUpdateCommand addDocCmd = new AddUpdateCommand(request);
            addDocCmd.overwrite = overwrite;
            addDocCmd.solrDoc = document;
            if (this.cascadeTrackingEnabled()) {
                this.updatePathRelatedFields(nodeMetaData, document);
                this.updateNamePathRelatedFields(nodeMetaData, document);
                this.updateAncestorRelatedFields(nodeMetaData, document);
            }
            processor.processAdd(addDocCmd);
        }
    }

    private long topNodeId(SolrQuery.ORDER order) {
        String sortDir = order.name();
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            ModifiableSolrParams queryParams = new ModifiableSolrParams(request.getParams()).set("q", new String[]{"*:*"}).set("fq", new String[]{"DOC_TYPE:Node"}).set("rows", 1).set("sort", new String[]{"DBID " + sortDir}).set("fl", new String[]{"DBID"});
            long l = Utils.notNullOrEmpty(this.cloud.getSolrDocumentList(this.nativeRequestHandler, (SolrQueryRequest)request, queryParams)).stream().findFirst().map(doc -> this.getFieldValueLong((SolrDocument)doc, "DBID")).orElse(0L);
            return l;
        }
    }

    private void initSkippingDescendantDocs(Properties p, Set<QName> dataForSkippingDescendantDocs, String propPrefixParent, String skipByField, DefinitionExistChecker dec) {
        int i = 0;
        String key = propPrefixParent + i;
        while (p.containsKey(key)) {
            String qNameInString = p.getProperty(key);
            if (null != qNameInString && !qNameInString.isEmpty()) {
                QName qName = QName.resolveToQName((NamespacePrefixResolver)this.dataModel.getNamespaceDAO(), (String)qNameInString);
                LOGGER.warning("QName was not found for {}", qNameInString);
                if (dec.isDefinitionExists(qName)) {
                    dataForSkippingDescendantDocs.add(qName);
                }
            }
            key = propPrefixParent + ++i;
        }
        this.skippingDocsQueryString = null == this.skippingDocsQueryString ? this.cloud.getQuery(skipByField, OR, dataForSkippingDescendantDocs) : this.skippingDocsQueryString + OR + this.cloud.getQuery(skipByField, OR, dataForSkippingDescendantDocs);
    }

    private void reportTransactionInfo(TransactionInfoReporter reporter, Long minId, long maxId, IOpenBitSet idsInDb, SolrQueryRequest request, String field) {
        if (minId != null) {
            IOpenBitSet idsInIndex = this.getOpenBitSetInstance();
            long batchStartId = minId;
            long batchEndId = Math.min(batchStartId + 4096L, maxId);
            long idInIndex = 0L;
            while (batchStartId <= maxId) {
                Map.Entry idCount;
                long iterationStart = batchStartId;
                NamedList<Integer> idCounts = this.getFacets(request, field + ":[" + batchStartId + " TO " + batchEndId + "]", field, 1, maxId);
                Iterator iterator = idCounts.iterator();
                while (iterator.hasNext() && batchStartId <= (idInIndex = Long.parseLong((String)(idCount = (Map.Entry)iterator.next()).getKey())) && idInIndex <= batchEndId) {
                    idsInIndex.set(idInIndex);
                    for (long id2 = iterationStart; id2 <= idInIndex; ++id2) {
                        if (id2 == idInIndex) {
                            iterationStart = idInIndex + 1L;
                            if (idsInDb.get(id2)) continue;
                            reporter.reportIdInIndexButNotInDb(id2);
                            continue;
                        }
                        if (!idsInDb.get(id2)) continue;
                        reporter.reportIdInDbButNotInIndex(id2);
                    }
                    if ((Integer)idCount.getValue() <= 1) continue;
                    reporter.reportDuplicatedIdInIndex(idInIndex);
                }
                LongStream.rangeClosed(iterationStart, batchEndId).filter(id -> idsInDb.get(id)).forEach(reporter::reportIdInDbButNotInIndex);
                batchStartId = batchEndId + 1L;
                batchEndId = Math.min(batchStartId + 4096L, maxId);
            }
            if (idInIndex != 0L && idInIndex < batchEndId) {
                try {
                    AclChangeSets changesets = this.repositoryClient.getAclChangeSets(null, Long.valueOf(idInIndex), null, Long.valueOf(idInIndex + 1L), 1);
                    Long changeSetCommitTimeMs = changesets.getAclChangeSets().size() > 0 ? ((AclChangeSet)changesets.getAclChangeSets().get(0)).getCommitTimeMs() : 0L;
                    LOGGER.warning("Not all items processed. Last acl changeset (id {} ) with commit time evaluated: {}", idInIndex, changeSetCommitTimeMs);
                }
                catch (IOException | AuthenticationException | JSONException e) {
                    LOGGER.warning("Not all items processed. Last acl changeset evaluated: {}", idInIndex);
                }
            }
            reporter.reportUniqueIdsInIndex(idsInIndex.cardinality());
        }
    }

    private void setDuplicates(IndexHealthReport report, SolrQueryRequest request, String docType, SetDuplicatesCommand cmd) {
        NamedList<Integer> dbIdCounts = this.getFacets(request, "DOC_TYPE:" + docType, "DBID", 2);
        for (Map.Entry dbId : dbIdCounts) {
            long duplicatedDbId = Long.parseLong((String)dbId.getKey());
            cmd.execute(report, duplicatedDbId);
        }
    }

    private NamedList<Integer> getFacets(SolrQueryRequest request, String query, String field, int minCount) {
        ModifiableSolrParams params = new ModifiableSolrParams(request.getParams()).set("q", new String[]{query}).set("rows", 0).set("facet", true).set("facet.field", new String[]{field}).set("facet.limit", this.statsFacetLimit).set("facet.mincount", minCount);
        SolrQueryResponse response = this.cloud.getResponse(this.nativeRequestHandler, request, (SolrParams)params);
        NamedList facetCounts = (NamedList)response.getValues().get("facet_counts");
        NamedList facetFields = (NamedList)facetCounts.get("facet_fields");
        return (NamedList)facetFields.get(field);
    }

    NamedList<Integer> getFacets(SolrQueryRequest request, String query, String field, int minCount, long maxCount) {
        ModifiableSolrParams params = new ModifiableSolrParams(request.getParams()).set("q", new String[]{query}).set("rows", 0).set("facet", true).set("facet.field", new String[]{field}).set("facet.limit", Math.toIntExact(Math.min(maxCount, Integer.MAX_VALUE))).set("facet.mincount", minCount);
        SolrQueryResponse response = this.cloud.getResponse(this.nativeRequestHandler, request, (SolrParams)params);
        NamedList facetCounts = (NamedList)response.getValues().get("facet_counts");
        NamedList facetFields = (NamedList)facetCounts.get("facet_fields");
        return (NamedList)facetFields.get(field);
    }

    public int getDocListSize(String query) {
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            ModifiableSolrParams params = new ModifiableSolrParams(request.getParams()).set("q", new String[]{query}).set("rows", 0);
            ResultContext resultContext = this.cloud.getResultContext(this.nativeRequestHandler, (SolrQueryRequest)request, (SolrParams)params);
            int n = resultContext.getDocList().matches();
            return n;
        }
    }

    private String getFieldValueString(SolrDocument doc, String fieldName) {
        IndexableField field = (IndexableField)doc.getFieldValue(fieldName);
        String value = null;
        if (field != null) {
            value = field.stringValue();
        }
        return value;
    }

    private long getFieldValueLong(SolrDocument doc, String fieldName) {
        return Long.parseLong(this.getFieldValueString(doc, fieldName));
    }

    private Query documentsWithOutdatedContentQuery() {
        LegacyNumericRangeQuery onlyDocumentsWhoseContentNeedsToBeUpdated = LegacyNumericRangeQuery.newLongRange((String)LAST_INCOMING_CONTENT_VERSION_ID, (Long)-10L, (Long)-10L, (boolean)true, (boolean)true);
        TermQuery onlyDocumentsThatRepresentNodes = new TermQuery(new Term("DOC_TYPE", DOC_TYPE_NODE));
        return new BooleanQuery.Builder().add((Query)onlyDocumentsWhoseContentNeedsToBeUpdated, BooleanClause.Occur.MUST).add((Query)onlyDocumentsThatRepresentNodes, BooleanClause.Occur.MUST).build();
    }

    private void deleteById(String field, Long id) throws IOException {
        String query = field + ":" + id;
        this.deleteByQuery(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteByQuery(String query) throws IOException {
        UpdateRequestProcessor processor = null;
        try (LocalSolrQueryRequest request = this.newSolrQueryRequest();){
            processor = this.core.getUpdateProcessingChain(null).createProcessor((SolrQueryRequest)request, this.newSolrQueryResponse());
            DeleteUpdateCommand delDocCmd = new DeleteUpdateCommand((SolrQueryRequest)request);
            delDocCmd.setQuery(query);
            processor.processDelete(delDocCmd);
        }
        finally {
            if (processor != null) {
                processor.finish();
            }
        }
    }

    SolrDocument getState(SolrCore core, SolrQueryRequest request, String id) {
        ModifiableSolrParams newParams = new ModifiableSolrParams(request.getParams()).set("id", new String[]{id});
        request.setParams((SolrParams)newParams);
        SolrQueryResponse response = this.newSolrQueryResponse();
        core.getRequestHandler(REQUEST_HANDLER_GET).handleRequest(request, response);
        NamedList values = response.getValues();
        return (SolrDocument)values.get(RESPONSE_DEFAULT_ID);
    }

    SolrQueryResponse newSolrQueryResponse() {
        return new SolrQueryResponse();
    }

    LocalSolrQueryRequest newSolrQueryRequest() {
        return new LocalSolrQueryRequest(this.core, new NamedList());
    }

    private String version(SolrDocument stateDoc, String txCommitTimeField, String txIdField, long commitTime, long id) {
        if (stateDoc == null) {
            return "0";
        }
        long txCommitTime = this.getFieldValueLong(stateDoc, txCommitTimeField);
        long txId = this.getFieldValueLong(stateDoc, txIdField);
        return commitTime >= txCommitTime && id > txId ? this.getFieldValueString(stateDoc, "_version_") : null;
    }

    private void putAclTransactionState(UpdateRequestProcessor processor, SolrQueryRequest request, AclChangeSet changeSet) throws IOException {
        SolrDocument aclState = this.getState(this.core, request, "TRACKER!STATE!ACLTX");
        String version = this.version(aclState, "S_ACLTXCOMMITTIME", "S_ACLTXID", changeSet.getCommitTimeMs(), changeSet.getId());
        if (version != null) {
            SolrInputDocument input = new SolrInputDocument(new String[0]);
            input.addField("id", (Object)"TRACKER!STATE!ACLTX");
            input.addField("_version_", (Object)version);
            input.addField("S_ACLTXID", (Object)changeSet.getId());
            input.addField("S_INACLTXID", (Object)changeSet.getId());
            input.addField("S_ACLTXCOMMITTIME", (Object)changeSet.getCommitTimeMs());
            input.addField("DOC_TYPE", (Object)DOC_TYPE_STATE);
            AddUpdateCommand cmd = new AddUpdateCommand(request);
            cmd.overwrite = true;
            cmd.solrDoc = input;
            processor.processAdd(cmd);
        }
    }

    private String getLocalisedValue(StringPropertyValue property, PropertyValue localeProperty) {
        Locale locale = Optional.ofNullable(localeProperty).map(StringPropertyValue.class::cast).map(StringPropertyValue::getValue).map(value -> (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, value)).orElse(I18NUtil.getLocale());
        return "\u0000" + locale.getLanguage() + "\u0000" + property.getValue();
    }

    private void addStringProperty(BiConsumer<String, Object> consumer, AlfrescoSolrDataModel.FieldInstance field, StringPropertyValue property, PropertyValue localeProperty) {
        consumer.accept(field.getField(), field.isLocalised() ? this.getLocalisedValue(property, localeProperty) : property.getValue());
    }

    boolean canBeDestructured(PropertyDefinition definition, String fieldName) {
        return !definition.isMultiValued() && fieldName != null && fieldName.contains("@") && this.dateFieldDestructuringHasBeenEnabledOnThisInstance && (definition.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME) || definition.getDataType().getName().equals((Object)DataTypeDefinition.DATE));
    }

    void setUnitOfTimeFields(BiConsumer<String, Object> consumer, String sourceFieldName, String value, DataTypeDefinition dataType) {
        try {
            String fieldNamePrefix = this.dataModel.destructuredDateTimePartFieldNamePrefix(sourceFieldName);
            ZonedDateTime dateTime = ZonedDateTime.parse(value, DateTimeFormatter.ISO_ZONED_DATE_TIME);
            consumer.accept(fieldNamePrefix + UNIT_OF_TIME_YEAR_FIELD_SUFFIX, dateTime.getYear());
            consumer.accept(fieldNamePrefix + UNIT_OF_TIME_QUARTER_FIELD_SUFFIX, dateTime.get(IsoFields.QUARTER_OF_YEAR));
            consumer.accept(fieldNamePrefix + UNIT_OF_TIME_MONTH_FIELD_SUFFIX, dateTime.getMonth().getValue());
            consumer.accept(fieldNamePrefix + UNIT_OF_TIME_DAY_FIELD_SUFFIX, dateTime.getDayOfMonth());
            consumer.accept(fieldNamePrefix + UNIT_OF_TIME_DAY_OF_WEEK_FIELD_SUFFIX, dateTime.getDayOfWeek().getValue());
            consumer.accept(fieldNamePrefix + UNIT_OF_TIME_DAY_OF_YEAR_FIELD_SUFFIX, dateTime.getDayOfYear());
            if (DataTypeDefinition.DATETIME.equals((Object)dataType.getName()) && ISO8601DateFormat.isTimeComponentDefined((String)value)) {
                consumer.accept(fieldNamePrefix + UNIT_OF_TIME_MINUTE_FIELD_SUFFIX, dateTime.getMinute());
                consumer.accept(fieldNamePrefix + UNIT_OF_TIME_HOUR_FIELD_SUFFIX, dateTime.getHour());
                consumer.accept(fieldNamePrefix + UNIT_OF_TIME_SECOND_FIELD_SUFFIX, dateTime.getSecond());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Unable to destructure date/datetime value {} (Field was {})", value, sourceFieldName, exception);
        }
    }

    private void addFieldIfNotSet(SolrInputDocument doc, String name) {
        doc.addField("FIELDS", (Object)name);
    }

    private boolean mayHaveChildren(NodeMetaData nodeMetaData) {
        return Optional.ofNullable(nodeMetaData).map(metadata -> this.nodeTypeSupportsChildren((NodeMetaData)metadata) || this.atLeastOneAspectSupportsChildren(metadata.getAspects())).orElse(false);
    }

    private boolean nodeTypeSupportsChildren(NodeMetaData metadata) {
        return Optional.ofNullable(this.dataModel.getDictionaryService("DEFAULT_DICTIONARY")).map(comp -> comp.getType(metadata.getType())).map(ClassDefinition::getChildAssociations).map(associations -> !associations.isEmpty()).orElse(false);
    }

    private boolean atLeastOneAspectSupportsChildren(Set<QName> aspects) {
        return Utils.notNullOrEmpty(aspects).stream().map(aspect -> this.dataModel.getDictionaryService("DEFAULT_DICTIONARY").getAspect(aspect)).filter(Objects::nonNull).map(ClassDefinition::getChildAssociations).filter(Objects::nonNull).anyMatch(associations -> !associations.isEmpty());
    }

    private long getSafeCount(NamedList<Integer> counts, String countType) {
        return Optional.ofNullable(counts).map(container -> (Integer)container.get(countType)).orElse(0).intValue();
    }

    private NamedList<Object> fixStats(NamedList<Object> namedList) {
        int sz = namedList.size();
        for (int i = 0; i < sz; ++i) {
            Number number;
            Object value = namedList.getVal(i);
            if (!(value instanceof Number) || !Float.isInfinite((number = (Number)value).floatValue()) && !Float.isNaN(number.floatValue()) && !Double.isInfinite(number.doubleValue()) && !Double.isNaN(number.doubleValue())) continue;
            namedList.setVal(i, null);
        }
        return namedList;
    }

    private List<SolrIndexSearcher> getRegisteredSearchers() {
        ArrayList<SolrIndexSearcher> searchers = new ArrayList<SolrIndexSearcher>();
        for (Map.Entry entry : this.core.getInfoRegistry().entrySet()) {
            if (entry.getValue() == null || !((SolrInfoMBean)entry.getValue()).getName().equals(SolrIndexSearcher.class.getName()) || ((String)entry.getKey()).equals("searcher")) continue;
            searchers.add((SolrIndexSearcher)entry.getValue());
        }
        return searchers;
    }

    private void clearFields(SolrInputDocument document, List<String> fields) {
        Utils.notNullOrEmpty(fields).forEach(arg_0 -> ((SolrInputDocument)document).removeField(arg_0));
    }

    private void clearFields(SolrInputDocument document, String ... fields) {
        Arrays.stream(Utils.notNullOrEmpty(fields)).forEach(arg_0 -> ((SolrInputDocument)document).removeField(arg_0));
    }

    private NodeMetaData createDeletedNodeMetaData(Node node) {
        NodeMetaData nodeMetaData = new NodeMetaData();
        nodeMetaData.setId(node.getId());
        nodeMetaData.setType(ContentModel.TYPE_DELETED);
        nodeMetaData.setNodeRef(new NodeRef(node.getNodeRef()));
        nodeMetaData.setTxnId(node.getTxnId());
        return nodeMetaData;
    }

    private Optional<Collection<NodeMetaData>> getNodesMetaDataFromRepository(NodeMetaDataParameters parameters) {
        try {
            return Optional.of(Utils.notNullOrEmpty(this.repositoryClient.getNodesMetaData(parameters)));
        }
        catch (JSONException exception) {
            LOGGER.debug("JSON exception swallowed by SolrInformationServer.", new Object[0]);
            return Optional.empty();
        }
        catch (Exception exception) {
            LOGGER.error("Unable to get nodes metadata from repository using fromNodeId=" + parameters.getFromNodeId() + ", toNodeId=" + parameters.getToNodeId() + ", nodeIds=" + String.valueOf(parameters.getNodeIds()) + ", fromTxId=" + parameters.getFromTxnId() + ", toTxId=" + parameters.getToTxnId() + ", txIds=" + String.valueOf(parameters.getTransactionIds()) + ". See the stacktrace below for further details.", exception);
            return Optional.empty();
        }
    }

    private /* synthetic */ UpdateRequestProcessor lambda$indexNode$12(SolrQueryRequest request) {
        return this.core.getUpdateProcessingChain(null).createProcessor(request, this.newSolrQueryResponse());
    }

    static class LRU
    extends LinkedHashMap<Long, Long> {
        private final int maxSize;

        LRU(int maxSize) {
            super((int)((double)maxSize * 1.35));
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }
    }

    @FunctionalInterface
    static interface DefinitionExistChecker {
        public boolean isDefinitionExists(QName var1);
    }

    static abstract class TransactionInfoReporter {
        protected final IndexHealthReport report;

        TransactionInfoReporter(IndexHealthReport report) {
            this.report = report;
        }

        abstract void reportIdInIndexButNotInDb(long var1);

        abstract void reportIdInDbButNotInIndex(long var1);

        abstract void reportDuplicatedIdInIndex(long var1);

        abstract void reportUniqueIdsInIndex(long var1);
    }

    static interface SetDuplicatesCommand {
        public void execute(IndexHealthReport var1, long var2);
    }

    static class TxnCacheFilter
    extends DelegatingCollector {
        private NumericDocValues currentLongs;
        private final Map<Long, Long> txnLRU;

        TxnCacheFilter(Map<Long, Long> txnLRU) {
            this.txnLRU = txnLRU;
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            super.doSetNextReader(context);
            this.currentLongs = context.reader().getNumericDocValues("INTXID");
        }

        public void collect(int doc) throws IOException {
            long txnId = this.currentLongs.get(doc);
            if (!this.txnLRU.containsKey(txnId)) {
                this.leafDelegate.collect(doc);
            }
        }
    }

    static class TxnCollector
    extends DelegatingCollector {
        private NumericDocValues currentLongs;
        private final LongHashSet txnSet = new LongHashSet(1000);
        private final long txnFloor;
        private final long txnCeil;

        TxnCollector(long txnFloor) {
            this.txnFloor = txnFloor;
            this.txnCeil = txnFloor + 500L;
        }

        public void doSetNextReader(LeafReaderContext context) throws IOException {
            this.currentLongs = context.reader().getNumericDocValues("INTXID");
        }

        public boolean needsScores() {
            return false;
        }

        public void collect(int doc) {
            long txnId = this.currentLongs.get(doc);
            if (txnId >= this.txnFloor && txnId < this.txnCeil) {
                this.txnSet.add(txnId);
            }
        }

        LongHashSet getTxnSet() {
            return this.txnSet;
        }
    }

    static class DocListCollector
    implements Collector,
    LeafCollector {
        private final IntArrayList docs = new IntArrayList();
        private int docBase;

        DocListCollector() {
        }

        public IntArrayList getDocs() {
            return this.docs;
        }

        public boolean needsScores() {
            return false;
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) {
            this.docBase = context.docBase;
            return this;
        }

        public void setScorer(Scorer scorer) {
        }

        public void collect(int doc) {
            this.docs.add(doc + this.docBase);
        }
    }

    static class PartialSolrInputDocument
    extends SolrInputDocument {
        private static final Map<String, String> KEEP_MAP = Map.of("keep", "");

        PartialSolrInputDocument() {
            super(new String[0]);
        }

        public void keepField(String name) {
            this.setField(name, KEEP_MAP);
        }

        public void addField(String name, Object value) {
            Map fieldModifier = (Map)((SolrInputField)this.computeIfAbsent(name, k -> {
                this.remove(name);
                this.setField(name, this.newFieldModifier("set"));
                return this.getField(name);
            })).getValue();
            Optional.ofNullable(value).ifPresent(v -> fieldModifier.computeIfAbsent((String)fieldModifier.keySet().iterator().next(), LAZY_EMPTY_MUTABLE_LIST).add(v));
        }

        public SolrInputField removeField(String name) {
            this.setField(name, this.newFieldModifier("set"));
            return this.getField(name);
        }

        private Map<String, List<String>> newFieldModifier(final String op) {
            return new HashMap<String, List<String>>(){
                {
                    this.put(op, null);
                }
            };
        }
    }
}

