/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component;

import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.solr.component.TempFileWarningLogger;
import org.alfresco.util.cache.AbstractAsynchronouslyRefreshedCache;
import org.alfresco.util.cache.AsynchronouslyRefreshedCacheRegistry;
import org.alfresco.util.cache.DefaultAsynchronouslyRefreshedCacheRegistry;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.CharsRef;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrEventListener;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.spelling.suggest.SolrSuggester;
import org.apache.solr.spelling.suggest.SuggesterOptions;
import org.apache.solr.spelling.suggest.SuggesterParams;
import org.apache.solr.spelling.suggest.SuggesterResult;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncBuildSuggestComponent
extends SearchComponent
implements SolrCoreAware,
SuggesterParams,
Accountable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String COMPONENT_NAME = "suggest";
    private static final String DEFAULT_DICT_NAME = "default";
    private static final String CONFIG_PARAM_LABEL = "suggester";
    private static final String BUILD_ON_COMMIT_LABEL = "buildOnCommit";
    private static final String BUILD_ON_OPTIMIZE_LABEL = "buildOnOptimize";
    private static final String BUILD_ON_STARTUP_LABEL = "buildOnStartup";
    private static final String ENABLED_LABEL = "enabled";
    private static final String ASYNC_CACHE_KEY = "suggester";
    private static final String MIN_SECS_BETWEEN_BUILDS = "solr.suggester.minSecsBetweenBuilds";
    private static File offlineSorterTempDir;
    protected static TempFileWarningLogger tempFileWarningLogger;
    protected NamedList initParams;
    protected Map<String, SuggesterCache> suggesters = new ConcurrentHashMap<String, SuggesterCache>();

    public void init(NamedList args) {
        super.init(args);
        this.initParams = args;
    }

    public void inform(SolrCore core) {
        if (this.initParams != null) {
            LOG.info("Initializing SuggestComponent");
            boolean hasDefault = false;
            for (int i = 0; i < this.initParams.size(); ++i) {
                File storeFile;
                if (!this.initParams.getName(i).equals("suggester")) continue;
                NamedList suggesterParams = (NamedList)this.initParams.getVal(i);
                SolrSuggester suggester = new SolrSuggester();
                Object buildOnStartupObj = suggesterParams.get(BUILD_ON_STARTUP_LABEL);
                boolean buildOnStartup = buildOnStartupObj == null ? (storeFile = suggester.getStoreFile()) == null || !storeFile.exists() : Boolean.parseBoolean((String)buildOnStartupObj);
                boolean buildOnCommit = Boolean.parseBoolean((String)suggesterParams.get(BUILD_ON_COMMIT_LABEL));
                boolean buildOnOptimize = Boolean.parseBoolean((String)suggesterParams.get(BUILD_ON_OPTIMIZE_LABEL));
                boolean enabled = Boolean.parseBoolean((String)suggesterParams.get(ENABLED_LABEL));
                long minSecsBetweenBuilds = Long.parseLong(core.getCoreDescriptor().getCoreProperty(MIN_SECS_BETWEEN_BUILDS, "-1"));
                SuggesterCache suggesterCache = new SuggesterCache(core, suggesterParams, enabled, buildOnCommit, buildOnOptimize, buildOnStartup);
                String dictionary = suggester.init(suggesterParams, core);
                if (dictionary != null) {
                    boolean isDefault = dictionary.equals(DEFAULT_DICT_NAME);
                    if (isDefault && !hasDefault) {
                        hasDefault = true;
                    } else if (isDefault) {
                        throw new RuntimeException("More than one dictionary is missing name.");
                    }
                    suggesterCache.setBeanName(dictionary);
                    this.suggesters.put(dictionary, suggesterCache);
                } else if (!hasDefault) {
                    suggesterCache.setBeanName(DEFAULT_DICT_NAME);
                    this.suggesters.put(DEFAULT_DICT_NAME, suggesterCache);
                    hasDefault = true;
                } else {
                    throw new RuntimeException("More than one dictionary is missing name.");
                }
                try {
                    suggesterCache.afterPropertiesSet();
                }
                catch (Exception e) {
                    LOG.error("Unable to initialise SuggesterCache.", (Throwable)e);
                    throw new RuntimeException("Unable to initialise SuggesterCache.", e);
                }
                core.registerFirstSearcherListener((SolrEventListener)new SuggesterListener(suggesterCache, minSecsBetweenBuilds));
                if (!buildOnCommit && !buildOnOptimize) continue;
                LOG.debug("Registering newSearcher listener for suggester: " + suggester.getName());
                core.registerNewSearcherListener((SolrEventListener)new SuggesterListener(suggesterCache, minSecsBetweenBuilds));
            }
        }
    }

    public void prepare(ResponseBuilder rb) throws IOException {
        Collection<Object> querysuggesters;
        SolrParams params = rb.req.getParams();
        LOG.debug("SuggestComponent prepare with : " + String.valueOf(params));
        if (!params.getBool(COMPONENT_NAME, false)) {
            return;
        }
        boolean buildAll = params.getBool("suggest.buildAll", false);
        boolean reloadAll = params.getBool("suggest.reloadAll", false);
        if (buildAll || reloadAll) {
            Collection<SuggesterCache> suggesterCaches = this.suggesters.values();
            querysuggesters = new ArrayList(suggesterCaches.size());
            for (SuggesterCache cache : suggesterCaches) {
                querysuggesters.add(cache.get("suggester"));
            }
        } else {
            querysuggesters = this.getSuggesters(params);
        }
        if (params.getBool("suggest.build", false) || buildAll) {
            for (SolrSuggester solrSuggester : querysuggesters) {
                solrSuggester.build(rb.req.getCore(), rb.req.getSearcher());
            }
            rb.rsp.add("command", (Object)(!buildAll ? "build" : "buildAll"));
        } else if (params.getBool("suggest.reload", false) || reloadAll) {
            for (SolrSuggester solrSuggester : querysuggesters) {
                this.reloadSuggester(solrSuggester, rb.req.getCore(), rb.req.getSearcher());
            }
            rb.rsp.add("command", (Object)(!reloadAll ? "reload" : "reloadAll"));
        }
    }

    private void reloadSuggester(SolrSuggester suggester, SolrCore core, SolrIndexSearcher searcher) throws IOException {
        File storeFile = suggester.getStoreFile();
        if (storeFile == null || !storeFile.exists()) {
            suggester.build(core, searcher);
        } else {
            suggester.reload(core, searcher);
        }
    }

    public int distributedProcess(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        LOG.debug("SuggestComponent distributedProcess with : " + String.valueOf(params));
        if (rb.stage < ResponseBuilder.STAGE_EXECUTE_QUERY) {
            return ResponseBuilder.STAGE_EXECUTE_QUERY;
        }
        if (rb.stage == ResponseBuilder.STAGE_EXECUTE_QUERY) {
            ShardRequest sreq = new ShardRequest();
            sreq.purpose = 4;
            sreq.params = new ModifiableSolrParams(rb.req.getParams());
            sreq.params.remove("shards");
            rb.addRequest((SearchComponent)this, sreq);
            return ResponseBuilder.STAGE_GET_FIELDS;
        }
        return ResponseBuilder.STAGE_DONE;
    }

    public void process(ResponseBuilder rb) throws IOException {
        Set<SolrSuggester> querySuggesters;
        SolrParams params = rb.req.getParams();
        LOG.debug("SuggestComponent process with : " + String.valueOf(params));
        if (!params.getBool(COMPONENT_NAME, false) || this.suggesters.isEmpty()) {
            return;
        }
        boolean buildAll = params.getBool("suggest.buildAll", false);
        boolean reloadAll = params.getBool("suggest.reloadAll", false);
        try {
            querySuggesters = this.getSuggesters(params);
        }
        catch (IllegalArgumentException ex) {
            if (!buildAll && !reloadAll) {
                throw ex;
            }
            querySuggesters = new HashSet<SolrSuggester>();
        }
        String query = params.get("suggest.q");
        if (query == null && (query = rb.getQueryString()) == null) {
            query = params.get("q");
        }
        if (query != null) {
            int count = params.getInt("suggest.count", 1);
            boolean highlight = params.getBool("suggest.highlight", false);
            boolean allTermsRequired = params.getBool("suggest.allTermsRequired", true);
            String contextFilter = params.get("suggest.cfq");
            if (contextFilter != null && (contextFilter = contextFilter.trim()).length() == 0) {
                contextFilter = null;
            }
            SuggesterOptions options = new SuggesterOptions(new CharsRef(query), count, contextFilter, allTermsRequired, highlight);
            HashMap<String, SimpleOrderedMap<NamedList<Object>>> namedListResults = new HashMap<String, SimpleOrderedMap<NamedList<Object>>>();
            for (SolrSuggester suggester : querySuggesters) {
                SuggesterResult suggesterResult = suggester.getSuggestions(options);
                this.toNamedList(suggesterResult, namedListResults);
            }
            rb.rsp.add(COMPONENT_NAME, namedListResults);
        }
    }

    public void finishStage(ResponseBuilder rb) {
        SolrParams params = rb.req.getParams();
        LOG.debug("SuggestComponent finishStage with : " + String.valueOf(params));
        if (!params.getBool(COMPONENT_NAME, false) || rb.stage != ResponseBuilder.STAGE_GET_FIELDS) {
            return;
        }
        int count = params.getInt("suggest.count", 1);
        ArrayList<SuggesterResult> suggesterResults = new ArrayList<SuggesterResult>();
        for (ShardRequest sreq : rb.finished) {
            for (ShardResponse srsp : sreq.responses) {
                NamedList resp = srsp.getSolrResponse().getResponse();
                if (resp == null) continue;
                Map namedList = (Map)resp.get(COMPONENT_NAME);
                LOG.debug(srsp.getShard() + " : " + String.valueOf(namedList));
                suggesterResults.add(this.toSuggesterResult(namedList));
            }
        }
        SuggesterResult suggesterResult = AsyncBuildSuggestComponent.merge(suggesterResults, count);
        HashMap<String, SimpleOrderedMap<NamedList<Object>>> namedListResults = new HashMap<String, SimpleOrderedMap<NamedList<Object>>>();
        this.toNamedList(suggesterResult, namedListResults);
        rb.rsp.add(COMPONENT_NAME, namedListResults);
    }

    private static SuggesterResult merge(List<SuggesterResult> suggesterResults, int count) {
        SuggesterResult result = new SuggesterResult();
        HashSet allTokens = new HashSet();
        HashSet<String> suggesterNames = new HashSet<String>();
        for (SuggesterResult shardResult : suggesterResults) {
            for (String suggesterName : shardResult.getSuggesterNames()) {
                allTokens.addAll(shardResult.getTokens(suggesterName));
                suggesterNames.add(suggesterName);
            }
        }
        for (String suggesterName : suggesterNames) {
            for (String token : allTokens) {
                Lookup.LookupPriorityQueue resultQueue = new Lookup.LookupPriorityQueue(count);
                for (SuggesterResult shardResult : suggesterResults) {
                    List suggests = shardResult.getLookupResult(suggesterName, token);
                    if (suggests == null) continue;
                    for (Lookup.LookupResult res : suggests) {
                        resultQueue.insertWithOverflow((Object)res);
                    }
                }
                LinkedList sortedSuggests = new LinkedList();
                Collections.addAll(sortedSuggests, resultQueue.getResults());
                result.add(suggesterName, token, sortedSuggests);
            }
        }
        return result;
    }

    public String getDescription() {
        return "Suggester component";
    }

    public String getSource() {
        return "$URL: https://svn.apache.org/repos/asf/lucene/dev/branches/lucene_solr_4_9/solr/core/src/java/org/apache/solr/handler/component/SuggestComponent.java $";
    }

    public NamedList<String> getStatistics() {
        SimpleOrderedMap stats = new SimpleOrderedMap();
        stats.add("totalSizeInBytes", (Object)String.valueOf(this.ramBytesUsed()));
        for (Map.Entry<String, SuggesterCache> entry : this.suggesters.entrySet()) {
            SolrSuggester suggester = entry.getValue().get(entry.getKey());
            stats.add(entry.getKey(), (Object)suggester.toString());
        }
        return stats;
    }

    public long ramBytesUsed() {
        return this.suggesters.values().stream().mapToLong(value -> value.get("suggester").ramBytesUsed()).sum();
    }

    private Set<SolrSuggester> getSuggesters(SolrParams params) {
        HashSet<SolrSuggester> solrSuggesters = new HashSet<SolrSuggester>();
        for (String suggesterName : this.getSuggesterNames(params)) {
            SolrSuggester curSuggester = this.suggesters.get(suggesterName).get("suggester");
            if (curSuggester != null) {
                solrSuggesters.add(curSuggester);
                continue;
            }
            throw new IllegalArgumentException("No suggester named " + suggesterName + " was configured");
        }
        if (solrSuggesters.size() == 0) {
            throw new IllegalArgumentException("No default suggester was configured");
        }
        return solrSuggesters;
    }

    private Set<String> getSuggesterNames(SolrParams params) {
        HashSet<String> suggesterNames = new HashSet<String>();
        String[] suggesterNamesFromParams = params.getParams("suggest.dictionary");
        if (suggesterNamesFromParams == null) {
            suggesterNames.add(DEFAULT_DICT_NAME);
        } else {
            for (String name : suggesterNamesFromParams) {
                suggesterNames.add(name);
            }
        }
        return suggesterNames;
    }

    private void toNamedList(SuggesterResult suggesterResult, Map<String, SimpleOrderedMap<NamedList<Object>>> resultObj) {
        for (String suggesterName : suggesterResult.getSuggesterNames()) {
            SimpleOrderedMap results = new SimpleOrderedMap();
            for (String token : suggesterResult.getTokens(suggesterName)) {
                SimpleOrderedMap suggestionBody = new SimpleOrderedMap();
                List lookupResults = suggesterResult.getLookupResult(suggesterName, token);
                suggestionBody.add("numFound", (Object)lookupResults.size());
                ArrayList<SimpleOrderedMap> suggestEntriesNamedList = new ArrayList<SimpleOrderedMap>();
                for (Lookup.LookupResult lookupResult : lookupResults) {
                    String suggestionString = lookupResult.key.toString();
                    long weight = lookupResult.value;
                    String payload = lookupResult.payload != null ? lookupResult.payload.utf8ToString() : "";
                    SimpleOrderedMap suggestEntryNamedList = new SimpleOrderedMap();
                    suggestEntryNamedList.add("term", (Object)suggestionString);
                    suggestEntryNamedList.add("weight", (Object)weight);
                    suggestEntryNamedList.add("payload", (Object)payload);
                    suggestEntriesNamedList.add(suggestEntryNamedList);
                }
                suggestionBody.add("suggestions", suggestEntriesNamedList);
                results.add(token, (Object)suggestionBody);
            }
            resultObj.put(suggesterName, (SimpleOrderedMap<NamedList<Object>>)results);
        }
    }

    private SuggesterResult toSuggesterResult(Map<String, SimpleOrderedMap<NamedList<Object>>> suggestionsMap) {
        SuggesterResult result = new SuggesterResult();
        if (suggestionsMap == null) {
            return result;
        }
        for (Map.Entry<String, SimpleOrderedMap<NamedList<Object>>> entry : suggestionsMap.entrySet()) {
            String suggesterName = entry.getKey();
            for (Map.Entry suggestions : entry.getValue()) {
                String tokenString = (String)suggestions.getKey();
                ArrayList<Lookup.LookupResult> lookupResults = new ArrayList<Lookup.LookupResult>();
                NamedList suggestion = (NamedList)suggestions.getValue();
                for (int j = 0; j < suggestion.size(); ++j) {
                    String property = suggestion.getName(j);
                    if (property.equals("suggestions")) {
                        List suggestionEntries = (List)suggestion.getVal(j);
                        for (NamedList suggestionEntry : suggestionEntries) {
                            String term = (String)suggestionEntry.get("term");
                            Long weight = (Long)suggestionEntry.get("weight");
                            String payload = (String)suggestionEntry.get("payload");
                            Lookup.LookupResult res = new Lookup.LookupResult((CharSequence)new CharsRef(term), weight.longValue(), new BytesRef((CharSequence)payload));
                            lookupResults.add(res);
                        }
                    }
                    result.add(suggesterName, tokenString, lookupResults);
                }
            }
        }
        return result;
    }

    public Collection<Accountable> getChildResources() {
        return Collections.emptyList();
    }

    static {
        try {
            String tempDirPath = System.getProperty("java.io.tmpdir");
            Path tempDirectory = Paths.get(tempDirPath, new String[0]);
            if (!Files.exists(tempDirectory, new LinkOption[0]) && !tempDirectory.toFile().mkdirs()) {
                throw new RuntimeException("No OfflineSorter temp directory");
            }
            if (!Files.isDirectory(tempDirectory, new LinkOption[0]) || Files.isHidden(tempDirectory) || !Files.isReadable(tempDirectory)) {
                throw new RuntimeException("No OfflineSorter temp directory");
            }
            offlineSorterTempDir = tempDirectory.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException("No OfflineSorter temp directory", e);
        }
        tempFileWarningLogger = new TempFileWarningLogger(LOG, "WFSTInputIterator*", new String[]{"input", "sorted"}, offlineSorterTempDir.toPath());
    }

    static class SuggesterCache
    extends AbstractAsynchronouslyRefreshedCache<SolrSuggester> {
        private final SolrCore core;
        private final AtomicBoolean isNewSearcher = new AtomicBoolean(false);
        private final NamedList suggesterParams;
        private final boolean buildOnCommit;
        private final boolean buildOnOptimize;
        private final boolean buildOnStartup;
        private final boolean enabled;
        private final SolrSuggester initialSuggester;
        private long lastBuild = 0L;

        public SuggesterCache(SolrCore core, NamedList suggesterParams, boolean enabled, boolean buildOnCommit, boolean buildOnOptimize, boolean buildOnStartup) {
            this.core = core;
            this.suggesterParams = suggesterParams;
            this.enabled = enabled;
            this.buildOnCommit = buildOnCommit;
            this.buildOnOptimize = buildOnOptimize;
            this.buildOnStartup = buildOnStartup;
            this.setRegistry((AsynchronouslyRefreshedCacheRegistry)new DefaultAsynchronouslyRefreshedCacheRegistry());
            LinkedBlockingQueue<Runnable> threadPool = new LinkedBlockingQueue<Runnable>();
            final ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, threadPool, this.getThreadFactory(core));
            this.setThreadPoolExecutor(executor);
            core.addCloseHook(new CloseHook(){

                public void preClose(SolrCore core) {
                    executor.shutdown();
                }

                public void postClose(SolrCore core) {
                }
            });
            this.initialSuggester = new SolrSuggester();
            this.initialSuggester.init(suggesterParams, core);
        }

        private ThreadFactory getThreadFactory(SolrCore core) {
            return new SuggestorThreadFactory("Suggestor-" + core.getName() + "-");
        }

        public SolrSuggester get(String key) {
            this.liveLock.readLock().lock();
            try {
                if (this.live.get(key) == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Cache has no live suggester yet, return empty one while we wait.");
                    }
                    SolrSuggester solrSuggester = this.initialSuggester;
                    return solrSuggester;
                }
                SolrSuggester solrSuggester = (SolrSuggester)super.get(key);
                return solrSuggester;
            }
            finally {
                this.liveLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SolrSuggester buildCache(String key) {
            if (!this.enabled) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Disabled suggester builder, returning empty suggester: " + this.core.getName());
                }
                return this.initialSuggester;
            }
            if (tempFileWarningLogger.checkFiles()) {
                tempFileWarningLogger.removeFiles();
            }
            RefCounted refCountedSearcher = this.core.getSearcher();
            try {
                SolrIndexSearcher searcher = (SolrIndexSearcher)refCountedSearcher.get();
                SolrSuggester suggester = new SolrSuggester();
                suggester.init(this.suggesterParams, this.core);
                if (!this.isNewSearcher.getAndSet(true)) {
                    try {
                        LOG.info("Loading suggester index for: " + suggester.getName());
                        long startMillis = System.currentTimeMillis();
                        if (this.buildOnStartup) {
                            this.buildSuggesterIndex(suggester, searcher);
                        } else {
                            suggester.reload(this.core, searcher);
                        }
                        long timeTakenMillis = System.currentTimeMillis() - startMillis;
                        LOG.info("Loaded suggester " + suggester.getName() + ", took " + timeTakenMillis + " ms");
                    }
                    catch (IOException e) {
                        LOG.error("Exception in reloading suggester index for: " + suggester.getName(), (Throwable)e);
                    }
                } else if (this.buildOnCommit) {
                    this.buildSuggesterIndex(suggester, searcher);
                } else if (this.buildOnOptimize) {
                    if (searcher.getIndexReader().leaves().size() == 1) {
                        this.buildSuggesterIndex(suggester, searcher);
                    } else {
                        LOG.info("Index is not optimized therefore skipping building suggester index for: " + suggester.getName());
                    }
                }
                this.lastBuild = System.currentTimeMillis();
                SolrSuggester solrSuggester = suggester;
                return solrSuggester;
            }
            finally {
                refCountedSearcher.decref();
            }
        }

        public long getLastBuild() {
            return this.lastBuild;
        }

        private void buildSuggesterIndex(SolrSuggester suggester, SolrIndexSearcher newSearcher) {
            try {
                LOG.info("Building suggester index for: " + suggester.getName());
                long startMillis = System.currentTimeMillis();
                suggester.build(this.core, newSearcher);
                long timeTakenMillis = System.currentTimeMillis() - startMillis;
                LOG.info("Built suggester " + suggester.getName() + ", took " + timeTakenMillis + " ms");
            }
            catch (Exception e) {
                LOG.error("Exception in building suggester index for: " + suggester.getName(), (Throwable)e);
            }
        }
    }

    private static class SuggesterListener
    implements SolrEventListener {
        private final SuggesterCache suggesterCache;
        private final long minSecsBetweenBuilds;

        public SuggesterListener(SuggesterCache suggesterCache, long minSecsBetweenBuilds) {
            this.suggesterCache = suggesterCache;
            this.minSecsBetweenBuilds = minSecsBetweenBuilds;
        }

        public void init(NamedList args) {
        }

        public void newSearcher(SolrIndexSearcher newSearcher, SolrIndexSearcher currentSearcher) {
            if (currentSearcher == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling first searcher's suggester build, core: " + newSearcher.getCore().getName());
                }
                this.suggesterCache.refresh("suggester");
            } else {
                long elapsedTimeSecs;
                long now = System.currentTimeMillis();
                long lastBuild = this.suggesterCache.getLastBuild();
                long elapsedTimeMillis = lastBuild == 0L ? 0L : now - lastBuild;
                long l = elapsedTimeSecs = lastBuild == 0L ? 0L : elapsedTimeMillis / 1000L;
                if (elapsedTimeSecs > this.minSecsBetweenBuilds) {
                    if (LOG.isDebugEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Scheduling async suggester build");
                        if (lastBuild > 0L) {
                            sb.append(", time since last build: ").append(elapsedTimeSecs).append("s (").append(elapsedTimeMillis).append("ms)");
                        }
                        sb.append(", core: ").append(newSearcher.getCore().getName());
                        LOG.debug(sb.toString());
                    }
                    this.suggesterCache.refresh("suggester");
                } else if (LOG.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Skipping async suggester build");
                    if (lastBuild > 0L) {
                        sb.append(", time since last build: ").append(elapsedTimeSecs).append("s (").append(elapsedTimeMillis).append("ms)");
                    }
                    sb.append(", core: ").append(newSearcher.getCore().getName());
                    LOG.debug(sb.toString());
                }
            }
        }

        public void postCommit() {
        }

        public void postSoftCommit() {
        }
    }

    private static class SuggesterResultLabels {
        static final String SUGGEST = "suggest";
        static final String SUGGESTIONS = "suggestions";
        static final String SUGGESTION_NUM_FOUND = "numFound";
        static final String SUGGESTION_TERM = "term";
        static final String SUGGESTION_WEIGHT = "weight";
        static final String SUGGESTION_PAYLOAD = "payload";

        private SuggesterResultLabels() {
        }
    }

    static class SuggestorThreadFactory
    implements ThreadFactory {
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        SuggestorThreadFactory(String namePrefix) {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = namePrefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            return t;
        }
    }
}

