/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.component;

import com.google.common.collect.HashBiMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.query.MimetypeGroupingQParserPlugin;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteFacetParametersComponent
extends SearchComponent {
    private static final Logger log = LoggerFactory.getLogger(RewriteFacetParametersComponent.class);

    public void prepare(ResponseBuilder rb) throws IOException {
        SolrQueryRequest req = rb.req;
        SolrParams params = req.getParams();
        ModifiableSolrParams fixed = new ModifiableSolrParams();
        ModifiableSolrParams allParamsWithFix = new ModifiableSolrParams(params);
        this.fixFilterQueries(fixed, params, rb);
        this.fixFacetParams(fixed, params, rb);
        this.fixRows(fixed, params, rb);
        Set fixedParameterNames = fixed.getParameterNames();
        for (String fixedParam : fixedParameterNames) {
            allParamsWithFix.set(fixedParam, fixed.getParams(fixedParam));
        }
        if (allParamsWithFix.get("sort") != null) {
            allParamsWithFix.remove("rq");
        }
        req.setParams((SolrParams)allParamsWithFix);
    }

    private void fixRows(ModifiableSolrParams fixed, SolrParams params, ResponseBuilder rb) {
        Integer row;
        String rows = params.get("rows");
        if (rows != null && !rows.isEmpty() && (row = Integer.valueOf(rows)) > 1000000) {
            fixed.remove("rows");
            fixed.add("rows", new String[]{"1000000"});
        }
    }

    private void fixFilterQueries(ModifiableSolrParams fixed, SolrParams params, ResponseBuilder rb) {
        Iterator it = params.getParameterNamesIterator();
        while (it.hasNext()) {
            String[] values;
            String name = (String)it.next();
            if (!name.equals("fq") || (values = params.getParams(name)) == null) continue;
            String[] fixedValues = new String[values.length];
            for (int i = 0; i < values.length; ++i) {
                Object value = values[i];
                if (((String)value).startsWith("{!")) {
                    fixedValues[i] = value;
                    continue;
                }
                if (((String)value).startsWith("contentSize():")) {
                    value = "cm:content.size:" + this.removeQuotes(((String)value).substring("contentSize():".length()));
                } else if (((String)value).startsWith("mimetype():")) {
                    value = this.removeQuotes(((String)value).substring("mimetype():".length()));
                    ArrayList<String> expand = MimetypeGroupingQParserPlugin.getReverseMappings().get(value);
                    if (expand == null) {
                        value = "cm:content.mimetype:\"" + (String)value + "\"";
                    } else {
                        StringBuilder builder = new StringBuilder();
                        builder.append("cm:content.mimetype:(");
                        for (int j = 0; j < expand.size(); ++j) {
                            if (j > 0) {
                                builder.append(" OR ");
                            }
                            builder.append('\"');
                            builder.append(expand.get(j));
                            builder.append('\"');
                        }
                        builder.append(')');
                        value = builder.toString();
                    }
                }
                fixedValues[i] = "{!afts}" + (String)value;
            }
            fixed.add(name, fixedValues);
        }
    }

    private String removeQuotes(String quoted) {
        if (quoted.startsWith("\"") && quoted.endsWith("\"")) {
            return quoted.substring(1, quoted.length() - 1);
        }
        return quoted;
    }

    private SolrParams fixFacetParams(ModifiableSolrParams fixed, SolrParams params, ResponseBuilder rb) {
        HashBiMap fieldMappings = HashBiMap.create();
        HashBiMap dateMappings = HashBiMap.create();
        HashBiMap rangeMappings = HashBiMap.create();
        HashBiMap pivotMappings = HashBiMap.create();
        HashBiMap intervalMappings = HashBiMap.create();
        HashBiMap statsFieldMappings = HashBiMap.create();
        HashBiMap statsFacetMappings = HashBiMap.create();
        HashBiMap functionMappings = HashBiMap.create();
        this.rewriteFacetFieldList(fixed, params, "facet.field", (Map<String, String>)fieldMappings, rb.req);
        this.rewriteFacetFieldList(fixed, params, "facet.date", (Map<String, String>)dateMappings, rb.req);
        this.rewriteFacetFieldList(fixed, params, "facet.range", (Map<String, String>)rangeMappings, rb.req);
        this.rewriteFacetFieldList(fixed, params, "facet.pivot", (Map<String, String>)pivotMappings, rb.req);
        this.rewriteFacetFieldList(fixed, params, "facet.interval", (Map<String, String>)intervalMappings, rb.req);
        this.rewriteFacetFieldList(fixed, params, "stats.field", (Map<String, String>)statsFieldMappings, rb.req);
        this.rewriteFacetFieldList(fixed, params, "stats.facet", (Map<String, String>)statsFacetMappings, rb.req);
        this.mapFacetFunctions(fixed, params, "facet.field", (Map<String, String>)functionMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.prefix", (Map<String, String>)fieldMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.contains", (Map<String, String>)fieldMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.contains.ignoreCase", (Map<String, String>)fieldMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.sort", (Map<String, String>)fieldMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.limit", (Map<String, String>)fieldMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.offset", (Map<String, String>)fieldMappings);
        this.rewriteMincountFacetFieldOption(fixed, params, "facet.mincount", (Map<String, String>)fieldMappings, rb.req);
        this.rewriteFacetFieldOptions(fixed, params, "facet.missing", (Map<String, String>)fieldMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.method", (Map<String, String>)fieldMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.enum.cache.minDF", (Map<String, String>)fieldMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.enum.cache.minDF", (Map<String, String>)fieldMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.range.start", (Map<String, String>)rangeMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.range.end", (Map<String, String>)rangeMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.range.gap", (Map<String, String>)rangeMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.range.hardend", (Map<String, String>)rangeMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.range.include", (Map<String, String>)rangeMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.range.other", (Map<String, String>)rangeMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.range.method", (Map<String, String>)rangeMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.range.limit", (Map<String, String>)rangeMappings);
        this.rewriteMincountFacetFieldOption(fixed, params, "facet.pivot.mincount", (Map<String, String>)pivotMappings, rb.req);
        this.rewriteFacetFieldOptions(fixed, params, "facet.sort", (Map<String, String>)pivotMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.limit", (Map<String, String>)pivotMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.offset", (Map<String, String>)pivotMappings);
        this.rewriteFacetFieldOptions(fixed, params, "facet.interval.set", (Map<String, String>)intervalMappings);
        rb.rsp.add("_original_parameters_", (Object)params);
        rb.rsp.add("_field_mappings_", (Object)fieldMappings);
        rb.rsp.add("_date_mappings_", (Object)dateMappings);
        rb.rsp.add("_range_mappings_", (Object)rangeMappings);
        rb.rsp.add("_pivot_mappings_", (Object)pivotMappings);
        rb.rsp.add("_interval_mappings_", (Object)intervalMappings);
        rb.rsp.add("_stats_field_mappings_", (Object)statsFieldMappings);
        rb.rsp.add("_stats_facet_mappings_", (Object)statsFacetMappings);
        rb.rsp.add("_facet_function_mappings_", (Object)functionMappings);
        return fixed;
    }

    private void mapFacetFunctions(ModifiableSolrParams fixed, SolrParams params, String paramName, Map<String, String> facetFunctionMappings) {
        String[] facetFieldsOrig = params.getParams(paramName);
        if (facetFieldsOrig != null) {
            for (String facetFields : facetFieldsOrig) {
                String[] fields;
                for (String field : fields = facetFields.split(",")) {
                    String function;
                    if (!(field = field.trim()).endsWith("()")) continue;
                    if (this.isMimetypeAndHasFQ(params, field)) {
                        function = "{!" + field.substring(0, field.length() - 2) + " group=false }";
                        fixed.add("fq", new String[]{function});
                        facetFunctionMappings.put(field, function);
                        continue;
                    }
                    function = "{!" + field.substring(0, field.length() - 2) + " group=true}";
                    fixed.add("fq", new String[]{function});
                    facetFunctionMappings.put(field, function);
                }
            }
        }
    }

    private boolean isMimetypeAndHasFQ(SolrParams params, String field) {
        if (!field.equals("mimetype()")) {
            return false;
        }
        String[] filterQueries = params.getParams("fq");
        if (filterQueries != null) {
            for (String fq : filterQueries) {
                if (!fq.startsWith("mimetype():")) continue;
                return true;
            }
        }
        return false;
    }

    protected void rewriteMincountFacetFieldOption(ModifiableSolrParams fixed, SolrParams params, String paramName, Map<String, String> fieldMappings, SolrQueryRequest req) {
        boolean isInitialDistributedRequest;
        this.rewriteFacetFieldOptions(fixed, params, paramName, fieldMappings);
        String shardPurpose = req.getParams().get("shards.purpose");
        boolean bl = isInitialDistributedRequest = shardPurpose == null;
        if (isInitialDistributedRequest) {
            HashMap<String, Integer> updatedValues = new HashMap<String, Integer>();
            Iterator renamedParameters = fixed.getParameterNamesIterator();
            while (renamedParameters.hasNext()) {
                String solrParameter = (String)renamedParameters.next();
                if (!solrParameter.endsWith("." + paramName)) continue;
                int value = Integer.valueOf(fixed.get(solrParameter));
                updatedValues.put(solrParameter, Math.max(value, 1));
            }
            for (Map.Entry updatedParameterValues : updatedValues.entrySet()) {
                fixed.set((String)updatedParameterValues.getKey(), ((Integer)updatedParameterValues.getValue()).intValue());
            }
            String paramValue = params.get(paramName);
            int value = 0;
            if (paramValue != null) {
                value = Integer.valueOf(paramValue);
            }
            fixed.set(paramName, Math.max(value, 1));
        }
    }

    private void rewriteFacetFieldOptions(ModifiableSolrParams fixed, SolrParams params, String paramName, Map<String, String> fieldMappings) {
        Iterator originalParamsIterator = params.getParameterNamesIterator();
        while (originalParamsIterator.hasNext()) {
            String originalSolrParam = (String)originalParamsIterator.next();
            if (!originalSolrParam.startsWith("f.") || !originalSolrParam.endsWith("." + paramName)) continue;
            String originalAlfrescoFieldName = originalSolrParam.substring(2, originalSolrParam.length() - paramName.length() - 1);
            if (fieldMappings.containsKey(originalAlfrescoFieldName)) {
                String solrFieldName = fieldMappings.get(originalAlfrescoFieldName);
                fixed.set("f." + solrFieldName + "." + paramName, params.getParams(originalSolrParam));
                continue;
            }
            fixed.set(originalSolrParam, params.getParams(originalSolrParam));
        }
    }

    public static String[] parseFacetField(String line) {
        if (StringUtils.isEmpty((CharSequence)line)) {
            throw new RuntimeException("String input is requried");
        }
        String[] tokens = line.split(",(?=(?:[^'|\"]*\"[^'|\"]*\")*[^'|\"]*$)", -1);
        return tokens;
    }

    private List<String> rewriteFacetFieldList(ModifiableSolrParams fixed, SolrParams params, String paramName, Map<String, String> fieldMappings, SolrQueryRequest req) {
        String shardPurpose = req.getParams().get("shards.purpose");
        boolean isRefinementRequest = false;
        if (shardPurpose != null) {
            int shardPurposeCode = Integer.parseInt(shardPurpose);
            log.debug("ShardPurpose: " + shardPurpose);
            isRefinementRequest = (shardPurposeCode & 0x20) != 0 || (shardPurposeCode & 0x2000) != 0;
        }
        String[] facetFieldsOrig = params.getParams(paramName);
        ArrayList<String> facetFieldList = new ArrayList<String>();
        if (facetFieldsOrig != null) {
            ArrayList<String> newFacetFields = new ArrayList<String>();
            for (String facetFields : facetFieldsOrig) {
                String[] fields;
                StringBuilder commaSeparated = new StringBuilder();
                StringBuilder mapping = new StringBuilder();
                StringBuilder unmapped = new StringBuilder();
                for (String field : fields = RewriteFacetParametersComponent.parseFacetField(facetFields)) {
                    boolean noMappingIsRequired;
                    int index;
                    String prefix = "";
                    if ((field = field.trim()).endsWith("()")) continue;
                    if (field.startsWith("{!") && !isRefinementRequest && (index = field.indexOf("}")) > 0 && index < field.length() - 1) {
                        prefix = field.substring(0, index + 1);
                        field = field.substring(index + 1);
                    }
                    boolean bl = noMappingIsRequired = req.getSchema().getFieldOrNull(field) != null || isRefinementRequest;
                    if (noMappingIsRequired) {
                        if (commaSeparated.length() > 0) {
                            commaSeparated.append(",");
                            mapping.append(",");
                            unmapped.append(",");
                        }
                        commaSeparated.append(prefix).append(field);
                        mapping.append(field);
                        unmapped.append(field);
                        facetFieldList.add(field);
                        continue;
                    }
                    String mappedField = AlfrescoSolrDataModel.getInstance().mapProperty(field, AlfrescoSolrDataModel.FieldUse.FACET, req);
                    if (commaSeparated.length() > 0) {
                        commaSeparated.append(",");
                        mapping.append(",");
                        unmapped.append(",");
                    }
                    commaSeparated.append(prefix).append(mappedField);
                    mapping.append(mappedField);
                    unmapped.append(field);
                    facetFieldList.add(mappedField);
                }
                if (!facetFields.equals(commaSeparated.toString())) {
                    fieldMappings.put(unmapped.toString(), mapping.toString());
                }
                if (commaSeparated.length() <= 0) continue;
                newFacetFields.add(commaSeparated.toString());
            }
            fixed.set(paramName, newFacetFields.toArray(new String[newFacetFields.size()]));
        }
        return facetFieldList;
    }

    public void process(ResponseBuilder rb) throws IOException {
    }

    public String getDescription() {
        return "RewriteFacetParameters";
    }

    public String getSource() {
        return "";
    }
}

