/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.solr.query.BitsFilter;
import org.alfresco.solr.query.DocValuesCache;
import org.alfresco.solr.query.EmptyHybridBitSet;
import org.alfresco.solr.query.HybridBitSet;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;

public abstract class AbstractAuthoritySetQuery
extends Query {
    protected final String authorities;

    public AbstractAuthoritySetQuery(String authorities) {
        if (authorities == null) {
            throw new IllegalStateException("authorities cannot be null");
        }
        this.authorities = authorities;
    }

    public abstract Weight createWeight(IndexSearcher var1, boolean var2) throws IOException;

    public String toString(String field) {
        return this.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractAuthoritySetQuery)) {
            return false;
        }
        AbstractAuthoritySetQuery that = (AbstractAuthoritySetQuery)((Object)o);
        return this.authorities.equals(that.authorities);
    }

    public int hashCode() {
        return this.authorities.hashCode();
    }

    protected HybridBitSet getACLSet(String[] auths, String field, SolrIndexSearcher searcher) throws IOException {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        for (String current : auths) {
            queryBuilder.add((Query)new TermQuery(new Term(field, current)), BooleanClause.Occur.SHOULD);
        }
        DocSet docSet = searcher.getDocSet((Query)queryBuilder.build());
        DocIterator iterator = docSet.iterator();
        if (!iterator.hasNext()) {
            return new EmptyHybridBitSet();
        }
        HybridBitSet hybridBitSet = new HybridBitSet(60000000);
        List leaves = searcher.getTopReaderContext().leaves();
        LeafReaderContext context = (LeafReaderContext)leaves.get(0);
        NumericDocValues aclValues = DocValuesCache.getNumericDocValues("ACLID", context.reader());
        LeafReader reader = context.reader();
        int ceil = reader.maxDoc();
        int base = 0;
        int ord = 0;
        while (iterator.hasNext()) {
            int doc = iterator.nextDoc();
            if (doc >= ceil) {
                do {
                    context = (LeafReaderContext)leaves.get(++ord);
                    reader = context.reader();
                    base = context.docBase;
                    ceil = base + reader.maxDoc();
                    aclValues = DocValuesCache.getNumericDocValues("ACLID", reader);
                } while (doc >= ceil);
            }
            if (aclValues == null) continue;
            long aclId = aclValues.get(doc - base);
            hybridBitSet.set(aclId);
        }
        return hybridBitSet;
    }

    protected BitsFilter getACLFilter(String[] auths, String field, SolrIndexSearcher searcher) throws IOException {
        HybridBitSet aclBits = this.getACLSet(auths, field, searcher);
        List leaves = searcher.getTopReaderContext().leaves();
        ArrayList<FixedBitSet> bitSets = new ArrayList<FixedBitSet>(leaves.size());
        for (LeafReaderContext readerContext : leaves) {
            LeafReader reader = readerContext.reader();
            int maxDoc = reader.maxDoc();
            FixedBitSet bits = new FixedBitSet(maxDoc);
            bitSets.add(bits);
            NumericDocValues fieldValues = DocValuesCache.getNumericDocValues("ACLID", reader);
            if (fieldValues == null) continue;
            for (int i = 0; i < maxDoc; ++i) {
                long aclID = fieldValues.get(i);
                if (!aclBits.get(aclID)) continue;
                bits.set(i);
            }
        }
        return new BitsFilter(bitSets);
    }
}

