/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import com.carrotsearch.hppc.IntFloatHashMap;
import com.carrotsearch.hppc.IntIntHashMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryRescorer;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.MergeStrategy;
import org.apache.solr.handler.component.QueryElevationComponent;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QParserPlugin;
import org.apache.solr.search.QueryCommand;
import org.apache.solr.search.RankQuery;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.SyntaxError;

public class AlfrescoReRankQParserPlugin
extends QParserPlugin {
    public static final String NAME = "rerank";
    private static Query defaultQuery = new MatchAllDocsQuery();

    public void init(NamedList args) {
    }

    public QParser createParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        return new ReRankQParser(query, localParams, params, req);
    }

    private void scaleScores(TopDocs topDocs, Map<Integer, Float> scoreMap) {
        float maxScore = topDocs.getMaxScore();
        float newMax = -3.4028235E38f;
        for (ScoreDoc scoreDoc : topDocs.scoreDocs) {
            float score = scoreDoc.score;
            Float oldScore = scoreMap.get(scoreDoc.doc);
            boolean rescored = oldScore != null && score != oldScore.floatValue();
            scoreDoc.score = score / (maxScore != 0.0f ? maxScore : 1.0f);
            if (rescored) {
                scoreDoc.score += 1.0f;
            }
            if (!(scoreDoc.score > newMax)) continue;
            newMax = scoreDoc.score;
        }
        assert (newMax <= 2.0f);
        topDocs.setMaxScore(newMax);
    }

    private Map<Integer, Float> getScoreMap(ScoreDoc[] scoreDocs, int num) {
        HashMap<Integer, Float> scoreMap = new HashMap<Integer, Float>();
        for (int i = 0; i < num; ++i) {
            ScoreDoc doc = scoreDocs[i];
            scoreMap.put(doc.doc, Float.valueOf(doc.score));
        }
        return scoreMap;
    }

    private class ReRankQParser
    extends QParser {
        public ReRankQParser(String query, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
            super(query, localParams, params, req);
        }

        public Query parse() throws SyntaxError {
            String reRankQueryString = this.localParams.get("reRankQuery");
            boolean scale = this.localParams.getBool("scale", false);
            QParser reRankParser = QParser.getParser((String)reRankQueryString, null, (SolrQueryRequest)this.req);
            Query reRankQuery = reRankParser.parse();
            int reRankDocs = this.localParams.getInt("reRankDocs", 200);
            reRankDocs = Math.max(1, reRankDocs);
            double reRankWeight = this.localParams.getDouble("reRankWeight", 2.0);
            int start = this.params.getInt("start", 0);
            int rows = this.params.getInt("rows", 10);
            int length = start + rows;
            return new ReRankQuery(reRankQuery, reRankDocs, reRankWeight, length, scale);
        }
    }

    public class BoostedComp
    implements Comparator {
        IntFloatHashMap boostedMap;

        public BoostedComp(IntIntHashMap boostedDocs, ScoreDoc[] scoreDocs, float maxScore) {
            this.boostedMap = new IntFloatHashMap(boostedDocs.size() * 2);
            for (int i = 0; i < scoreDocs.length && boostedDocs.containsKey(scoreDocs[i].doc); ++i) {
                this.boostedMap.put(scoreDocs[i].doc, maxScore + (float)boostedDocs.get(scoreDocs[i].doc));
            }
        }

        public int compare(Object o1, Object o2) {
            ScoreDoc doc1 = (ScoreDoc)o1;
            ScoreDoc doc2 = (ScoreDoc)o2;
            float score1 = doc1.score;
            float score2 = doc2.score;
            if (this.boostedMap.containsKey(doc1.doc)) {
                score1 = this.boostedMap.get(doc1.doc);
            }
            if (this.boostedMap.containsKey(doc2.doc)) {
                score2 = this.boostedMap.get(doc2.doc);
            }
            if (score1 > score2) {
                return -1;
            }
            if (score1 < score2) {
                return 1;
            }
            return 0;
        }
    }

    private class ReRankCollector
    extends TopDocsCollector {
        private Query reRankQuery;
        private TopDocsCollector mainCollector;
        private IndexSearcher searcher;
        private int reRankDocs;
        private int length;
        private double reRankWeight;
        private Map<BytesRef, Integer> boostedPriority;
        private float minScore;
        private float maxScore;
        private Scorer localScorer;
        private boolean scale;

        public ReRankCollector(int reRankDocs, int length, Query reRankQuery, double reRankWeight, QueryCommand cmd, IndexSearcher searcher, Map<BytesRef, Integer> boostedPriority, boolean scale) throws IOException {
            super(null);
            this.minScore = Float.MAX_VALUE;
            this.maxScore = -3.4028235E38f;
            this.reRankQuery = reRankQuery;
            this.reRankDocs = reRankDocs;
            this.length = length;
            this.boostedPriority = boostedPriority;
            this.scale = scale;
            Sort sort = cmd.getSort();
            if (sort == null) {
                this.mainCollector = TopScoreDocCollector.create((int)Math.max(this.reRankDocs, length), null);
            } else {
                sort = sort.rewrite(searcher);
                this.mainCollector = TopFieldCollector.create((Sort)sort, (int)Math.max(this.reRankDocs, length), null, (boolean)false, (boolean)true, (boolean)true);
            }
            this.searcher = searcher;
            this.reRankWeight = reRankWeight;
        }

        public int getTotalHits() {
            return this.mainCollector.getTotalHits();
        }

        public TopDocs topDocs(int start, int howMany) {
            try {
                TopDocs mainDocs = this.mainCollector.topDocs(0, Math.max(this.reRankDocs, this.length));
                if (mainDocs.totalHits == 0 || mainDocs.scoreDocs.length == 0) {
                    return mainDocs;
                }
                if (this.reRankDocs == 0) {
                    AlfrescoReRankQParserPlugin.this.scaleScores(mainDocs, new HashMap<Integer, Float>());
                    return mainDocs;
                }
                if (this.boostedPriority != null) {
                    SolrRequestInfo info = SolrRequestInfo.getRequestInfo();
                    Map requestContext = null;
                    if (info != null) {
                        requestContext = info.getReq().getContext();
                    }
                    IntIntHashMap boostedDocs = QueryElevationComponent.getBoostDocs((SolrIndexSearcher)((SolrIndexSearcher)this.searcher), this.boostedPriority, (Map)requestContext);
                    ScoreDoc[] mainScoreDocs = mainDocs.scoreDocs;
                    ScoreDoc[] reRankScoreDocs = new ScoreDoc[Math.min(mainScoreDocs.length, this.reRankDocs)];
                    System.arraycopy(mainScoreDocs, 0, reRankScoreDocs, 0, reRankScoreDocs.length);
                    mainDocs.scoreDocs = reRankScoreDocs;
                    Map<Integer, Float> scoreMap = AlfrescoReRankQParserPlugin.this.getScoreMap(mainDocs.scoreDocs, mainDocs.scoreDocs.length);
                    TopDocs rescoredDocs = new QueryRescorer(this.reRankQuery){

                        protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                            float score = firstPassScore;
                            if (secondPassMatches) {
                                score = (float)((double)score + ReRankCollector.this.reRankWeight * (double)secondPassScore);
                            }
                            return score;
                        }
                    }.rescore(this.searcher, mainDocs, mainDocs.scoreDocs.length);
                    Arrays.sort(rescoredDocs.scoreDocs, new BoostedComp(boostedDocs, mainDocs.scoreDocs, rescoredDocs.getMaxScore()));
                    howMany = Math.min(howMany, mainScoreDocs.length);
                    if (howMany == rescoredDocs.scoreDocs.length) {
                        if (this.scale) {
                            AlfrescoReRankQParserPlugin.this.scaleScores(rescoredDocs, scoreMap);
                        }
                        return rescoredDocs;
                    }
                    if (howMany > rescoredDocs.scoreDocs.length) {
                        ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                        System.arraycopy(mainScoreDocs, 0, scoreDocs, 0, scoreDocs.length);
                        System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, rescoredDocs.scoreDocs.length);
                        rescoredDocs.scoreDocs = scoreDocs;
                        if (this.scale) {
                            AlfrescoReRankQParserPlugin.this.scaleScores(rescoredDocs, scoreMap);
                        }
                        return rescoredDocs;
                    }
                    ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                    System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, howMany);
                    rescoredDocs.scoreDocs = scoreDocs;
                    if (this.scale) {
                        AlfrescoReRankQParserPlugin.this.scaleScores(rescoredDocs, scoreMap);
                    }
                    return rescoredDocs;
                }
                ScoreDoc[] mainScoreDocs = mainDocs.scoreDocs;
                ScoreDoc[] reRankScoreDocs = new ScoreDoc[Math.min(mainScoreDocs.length, this.reRankDocs)];
                System.arraycopy(mainScoreDocs, 0, reRankScoreDocs, 0, reRankScoreDocs.length);
                mainDocs.scoreDocs = reRankScoreDocs;
                Map<Integer, Float> scoreMap = AlfrescoReRankQParserPlugin.this.getScoreMap(mainDocs.scoreDocs, mainDocs.scoreDocs.length);
                TopDocs rescoredDocs = new QueryRescorer(this.reRankQuery){

                    protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                        float score = firstPassScore;
                        if (secondPassMatches) {
                            score = (float)((double)score + ReRankCollector.this.reRankWeight * (double)secondPassScore);
                        }
                        return score;
                    }
                }.rescore(this.searcher, mainDocs, mainDocs.scoreDocs.length);
                howMany = Math.min(howMany, mainScoreDocs.length);
                if (howMany == rescoredDocs.scoreDocs.length) {
                    if (this.scale) {
                        AlfrescoReRankQParserPlugin.this.scaleScores(rescoredDocs, scoreMap);
                    }
                    return rescoredDocs;
                }
                if (howMany > rescoredDocs.scoreDocs.length) {
                    ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                    System.arraycopy(mainScoreDocs, 0, scoreDocs, 0, scoreDocs.length);
                    System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, rescoredDocs.scoreDocs.length);
                    rescoredDocs.scoreDocs = scoreDocs;
                    if (this.scale) {
                        assert (scoreMap != null);
                        AlfrescoReRankQParserPlugin.this.scaleScores(rescoredDocs, scoreMap);
                    }
                    return rescoredDocs;
                }
                ScoreDoc[] scoreDocs = new ScoreDoc[howMany];
                System.arraycopy(rescoredDocs.scoreDocs, 0, scoreDocs, 0, howMany);
                rescoredDocs.scoreDocs = scoreDocs;
                if (this.scale) {
                    AlfrescoReRankQParserPlugin.this.scaleScores(rescoredDocs, scoreMap);
                }
                return rescoredDocs;
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, (Throwable)e);
            }
        }

        public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
            return this.mainCollector.getLeafCollector(context);
        }

        public boolean needsScores() {
            return true;
        }
    }

    private class ReRankWeight
    extends Weight {
        private Query reRankQuery;
        private IndexSearcher searcher;
        private Weight mainWeight;
        private double reRankWeight;

        public ReRankWeight(Query mainQuery, Query reRankQuery, double reRankWeight, IndexSearcher searcher) throws IOException {
            super(reRankQuery);
            this.reRankQuery = reRankQuery;
            this.searcher = searcher;
            this.reRankWeight = reRankWeight;
            this.mainWeight = mainQuery.createWeight(searcher, true);
        }

        public void extractTerms(Set<Term> terms) {
            this.mainWeight.extractTerms(terms);
        }

        public float getValueForNormalization() throws IOException {
            return this.mainWeight.getValueForNormalization();
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return this.mainWeight.scorer(context);
        }

        public void normalize(float norm, float topLevelBoost) {
            this.mainWeight.normalize(norm, topLevelBoost);
        }

        public Explanation explain(LeafReaderContext context, int doc) throws IOException {
            Explanation mainExplain = this.mainWeight.explain(context, doc);
            return new QueryRescorer(this.getQuery()){

                protected float combine(float firstPassScore, boolean secondPassMatches, float secondPassScore) {
                    float score = firstPassScore;
                    if (secondPassMatches) {
                        score = (float)((double)score + ReRankWeight.this.reRankWeight * (double)secondPassScore);
                    }
                    return score;
                }
            }.explain(this.searcher, mainExplain, context.docBase + doc);
        }
    }

    private class ReRankQuery
    extends RankQuery {
        private Query mainQuery = defaultQuery;
        private Query reRankQuery;
        private int reRankDocs;
        private int length;
        private double reRankWeight;
        private boolean scale;
        private Map<BytesRef, Integer> boostedPriority;

        public int hashCode() {
            return this.mainQuery.hashCode() + this.reRankQuery.hashCode() + (int)this.reRankWeight + this.reRankDocs + (this.scale ? 1 : 0);
        }

        public boolean equals(Object o) {
            if (o instanceof ReRankQuery) {
                ReRankQuery rrq = (ReRankQuery)((Object)o);
                return this.mainQuery.equals((Object)rrq.mainQuery) && this.reRankQuery.equals((Object)rrq.reRankQuery) && this.reRankWeight == rrq.reRankWeight && this.reRankDocs == rrq.reRankDocs && this.scale == rrq.scale;
            }
            return false;
        }

        public ReRankQuery(Query reRankQuery, int reRankDocs, double reRankWeight, int length, boolean scale) {
            this.reRankQuery = reRankQuery;
            this.reRankDocs = reRankDocs;
            this.reRankWeight = reRankWeight;
            this.length = length;
            this.scale = scale;
        }

        public RankQuery wrap(Query _mainQuery) {
            if (_mainQuery != null) {
                this.mainQuery = _mainQuery;
            }
            return this;
        }

        public MergeStrategy getMergeStrategy() {
            return null;
        }

        public TopDocsCollector getTopDocsCollector(int len, QueryCommand cmd, IndexSearcher searcher) throws IOException {
            SolrRequestInfo info;
            if (this.boostedPriority == null && (info = SolrRequestInfo.getRequestInfo()) != null) {
                Map context = info.getReq().getContext();
                this.boostedPriority = (Map)context.get("BOOSTED_PRIORITY");
            }
            return new ReRankCollector(this.reRankDocs, this.length, this.reRankQuery, this.reRankWeight, cmd, searcher, this.boostedPriority, this.scale);
        }

        public String toString(String s) {
            return "{!rerank mainQuery='" + this.mainQuery.toString() + "' reRankQuery='" + this.reRankQuery.toString() + "' reRankDocs=" + this.reRankDocs + " reRankWeigh=" + this.reRankWeight + "}";
        }

        public Query rewrite(IndexReader reader) throws IOException {
            Query q = this.mainQuery.rewrite(reader);
            if (q == this.mainQuery) {
                return this;
            }
            return this.clone().wrap(q);
        }

        public ReRankQuery clone() {
            ReRankQuery clonedQuery = new ReRankQuery(this.reRankQuery, this.reRankDocs, this.reRankWeight, this.length, this.scale);
            return clonedQuery;
        }

        public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
            return new ReRankWeight(this.mainQuery, this.reRankQuery, this.reRankWeight, searcher);
        }
    }
}

