/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.alfresco.solr.tracker.TrackerStats;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DelegatingCollector;

public class ContentSizeGroupingCollector
extends DelegatingCollector {
    ResponseBuilder rb;
    TrackerStats.IncrementalStats stats;
    String schemaFieldName;
    SchemaField schemaField;
    NumericDocValues numericDocValues;

    public ContentSizeGroupingCollector(ResponseBuilder rb, int scale, int buckets) {
        this.rb = rb;
        this.stats = new TrackerStats.IncrementalStats(scale, buckets, null);
        this.schemaFieldName = AlfrescoSolrDataModel.getInstance().mapProperty("content.size", AlfrescoSolrDataModel.FieldUse.FACET, rb.req);
        this.schemaField = rb.req.getSchema().getFieldOrNull(this.schemaFieldName);
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        super.doSetNextReader(context);
        if (this.schemaField != null && this.schemaField.getType().getNumericType() != null) {
            try {
                this.numericDocValues = context.reader().getNumericDocValues(this.schemaFieldName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void collect(int doc) throws IOException {
        if (this.numericDocValues != null) {
            long value = this.numericDocValues.get(doc);
            this.stats.add((double)value);
        }
        this.leafDelegate.collect(doc);
    }

    public void finish() throws IOException {
        NamedList analytics = new NamedList();
        this.rb.rsp.add("analytics", (Object)analytics);
        NamedList fieldCounts = new NamedList();
        analytics.add("contentSize()", (Object)fieldCounts);
        for (TrackerStats.Bucket bucket : this.stats.getHistogram()) {
            fieldCounts.add("[" + (long)Math.ceil(bucket.leftBoundary) + " TO " + (long)Math.ceil(bucket.rightBoundary) + ">", (Object)this.roundEven(bucket.countLeft + bucket.countRight));
        }
        if (this.delegate instanceof DelegatingCollector) {
            ((DelegatingCollector)this.delegate).finish();
        }
    }

    private long roundEven(double value) {
        BigDecimal bd = new BigDecimal(value);
        bd = bd.round(MathContext.DECIMAL64);
        return bd.longValue();
    }
}

