/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;

public class DocValuesCache {
    private static Map<String, WeakHashMap<Object, NumericDocValues>> cache = new HashMap<String, WeakHashMap<Object, NumericDocValues>>();

    public static synchronized NumericDocValues getNumericDocValues(String field, LeafReader reader) throws IOException {
        Object cacheKey;
        NumericDocValues cachedValues;
        WeakHashMap<Object, Object> fieldCache = cache.get(field);
        if (fieldCache == null) {
            fieldCache = new WeakHashMap();
            cache.put(field, fieldCache);
        }
        if ((cachedValues = (NumericDocValues)fieldCache.get(cacheKey = reader.getCoreCacheKey())) == null) {
            NumericDocValues fieldValues = reader.getNumericDocValues(field);
            if (fieldValues == null) {
                return null;
            }
            int maxDoc = reader.maxDoc();
            boolean longs = false;
            int[] intValues = new int[maxDoc];
            SettableDocValues settableValues = new IntValues(intValues);
            for (int i = 0; i < maxDoc; ++i) {
                long value = fieldValues.get(i);
                if (value > Integer.MAX_VALUE && !longs) {
                    longs = true;
                    settableValues = new LongValues(intValues);
                }
                ((SettableDocValues)settableValues).set(i, value);
            }
            fieldCache.put(cacheKey, (Object)settableValues);
            return settableValues;
        }
        return cachedValues;
    }

    private static class IntValues
    extends SettableDocValues {
        private int[] values;

        public IntValues(int[] values) {
            this.values = values;
        }

        @Override
        public void set(int index, long value) {
            this.values[index] = (int)value;
        }

        public long get(int index) {
            return this.values[index];
        }
    }

    private static class LongValues
    extends SettableDocValues {
        private long[] values;

        public LongValues(int[] ivalues) {
            this.values = new long[ivalues.length];
            for (int i = 0; i < ivalues.length; ++i) {
                this.values[i] = ivalues[i];
            }
        }

        @Override
        public void set(int index, long value) {
            this.values[index] = value;
        }

        public long get(int index) {
            return this.values[index];
        }
    }

    private static abstract class SettableDocValues
    extends NumericDocValues {
        private SettableDocValues() {
        }

        public abstract void set(int var1, long var2);
    }
}

