/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.HashSet;
import org.alfresco.solr.query.AbstractSolrCachingScorer;
import org.alfresco.solr.query.DocValuesCache;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.FixedBitSet;
import org.apache.solr.search.BitDocSet;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocSet;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.WrappedQuery;

public class SolrDenySetScorer2
extends AbstractSolrCachingScorer {
    SolrDenySetScorer2(Weight weight, DocSet in, LeafReaderContext context, SolrIndexSearcher searcher) {
        super(weight, in, context, searcher);
    }

    public static SolrDenySetScorer2 createDenySetScorer(Weight weight, LeafReaderContext context, SolrIndexSearcher searcher, String authorities, LeafReader reader) throws IOException {
        DocSet deniedDocSet = (DocSet)searcher.cacheLookup("alfrescoDeniedCache", (Object)authorities);
        if (deniedDocSet == null) {
            String[] auths = authorities.substring(1).split(authorities.substring(0, 1));
            deniedDocSet = new BitDocSet(new FixedBitSet(searcher.maxDoc()));
            BooleanQuery.Builder bQuery = new BooleanQuery.Builder();
            for (String current : auths) {
                bQuery.add((Query)new TermQuery(new Term("DENIED", current)), BooleanClause.Occur.SHOULD);
            }
            WrappedQuery wrapped = new WrappedQuery((Query)bQuery.build());
            wrapped.setCache(false);
            DocSet aclDocs = searcher.getDocSet((Query)wrapped);
            HashSet<Long> aclsFound = new HashSet<Long>(aclDocs.size());
            NumericDocValues aclDocValues = searcher.getSlowAtomicReader().getNumericDocValues("ACLID");
            DocIterator it = aclDocs.iterator();
            while (it.hasNext()) {
                int docID = it.nextDoc();
                long aclID = aclDocValues.get(docID);
                aclsFound.add(SolrDenySetScorer2.getLong(aclID));
            }
            if (aclsFound.size() > 0) {
                for (LeafReaderContext readerContext : searcher.getSlowAtomicReader().leaves()) {
                    int maxDoc = readerContext.reader().maxDoc();
                    NumericDocValues fieldValues = DocValuesCache.getNumericDocValues("ACLID", readerContext.reader());
                    if (fieldValues == null) continue;
                    for (int i = 0; i < maxDoc; ++i) {
                        long aclID = fieldValues.get(i);
                        Long key = SolrDenySetScorer2.getLong(aclID);
                        if (!aclsFound.contains(key)) continue;
                        deniedDocSet.add(readerContext.docBase + i);
                    }
                }
            }
            deniedDocSet = deniedDocSet.andNot(aclDocs);
            searcher.cacheInsert("alfrescoDeniedCache", (Object)authorities, (Object)deniedDocSet);
        }
        return new SolrDenySetScorer2(weight, deniedDocSet, context, searcher);
    }
}

