/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.query;

import java.io.IOException;
import java.util.Set;
import org.alfresco.solr.query.AbstractAuthorityQueryWeight;
import org.alfresco.solr.query.AbstractAuthoritySetQuery;
import org.alfresco.solr.query.SolrOwnerSetScorer;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexSearcher;

public class SolrOwnerSetQuery
extends AbstractAuthoritySetQuery {
    public SolrOwnerSetQuery(String authorities) {
        super(authorities);
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScore) throws IOException {
        if (!(searcher instanceof SolrIndexSearcher)) {
            throw new IllegalStateException("Must have a SolrIndexSearcher");
        }
        return new SolrOwnerSetQueryWeight((SolrIndexSearcher)searcher, this, this.authorities);
    }

    @Override
    public String toString(String field) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OWNERSET").append(':');
        stringBuilder.append(this.authorities);
        return stringBuilder.toString();
    }

    private class SolrOwnerSetQueryWeight
    extends AbstractAuthorityQueryWeight {
        public SolrOwnerSetQueryWeight(SolrIndexSearcher searcher, Query query, String authorities) throws IOException {
            super(searcher, false, query, "OWNERSET", authorities);
        }

        public Scorer scorer(LeafReaderContext context) throws IOException {
            return SolrOwnerSetScorer.createOwnerSetScorer(this, context, this.searcher, SolrOwnerSetQuery.this.authorities);
        }

        public void extractTerms(Set<Term> terms) {
            terms.add(new Term("OWNERSET", SolrOwnerSetQuery.this.authorities));
        }
    }
}

