/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.security;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.alfresco.solr.security.SecretSharedPropertyCollector;
import org.apache.solr.security.AuthenticationPlugin;

public class SecretSharedAuthPlugin
extends AuthenticationPlugin {
    private static final String SECURE_COMMS_NONE = "none";

    public boolean doAuthenticate(ServletRequest request, ServletResponse response, FilterChain chain) throws Exception {
        if (SecretSharedPropertyCollector.isCommsSecretShared()) {
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            if (Objects.equals(httpRequest.getHeader(SecretSharedPropertyCollector.getSecretHeader()), SecretSharedPropertyCollector.getSecret())) {
                chain.doFilter(request, response);
                return true;
            }
            String errorMessage = "Authentication failure: \"secret\" method has been selected, use the right request header with the secret word";
            this.setErrorResponse(response, errorMessage);
            return false;
        }
        if (SECURE_COMMS_NONE.equals(SecretSharedPropertyCollector.getCommsMethod()) && !SecretSharedPropertyCollector.isAllowUnauthenticatedSolrEndpoint()) {
            String errorMessage = "Authentication failure: \"alfresco.secureComms=none\" is no longer supported. Please use \"https\" or \"secret\" instead.";
            this.setErrorResponse(response, errorMessage);
            return false;
        }
        chain.doFilter(request, response);
        return true;
    }

    private void setErrorResponse(ServletResponse response, String errorMessage) throws IOException {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.sendError(403, errorMessage);
    }

    public void init(Map<String, Object> parameters) {
    }

    public void close() throws IOException {
    }
}

