/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Properties;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.tracker.ACLIDModRouter;
import org.alfresco.solr.tracker.ACLIDMurmurRouter;
import org.alfresco.solr.tracker.DBIDRangeRouter;
import org.alfresco.solr.tracker.DBIDRouter;
import org.alfresco.solr.tracker.DateMonthRouter;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.solr.tracker.DocRouterWithFallback;
import org.alfresco.solr.tracker.ExplicitShardIdWithDynamicPropertyRouter;
import org.alfresco.solr.tracker.ExplicitShardIdWithStaticPropertyRouter;
import org.alfresco.solr.tracker.PropertyRouter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocRouterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DocRouterFactory.class);
    public static final String SHARD_KEY_KEY = "shard.key";
    public static final String SHARD_RANGE_KEY = "shard.range";
    public static final String SHARD_DATE_GROUPING_KEY = "shard.date.grouping";
    public static final String SHARD_REGEX_KEY = "shard.regex";

    public static DocRouter getRouter(Properties properties, ShardMethodEnum method) {
        switch (method) {
            case DB_ID: {
                LOGGER.info("Sharding via DB_ID");
                return new DBIDRouter();
            }
            case DB_ID_RANGE: {
                if (!properties.containsKey(SHARD_RANGE_KEY)) {
                    throw new AlfrescoRuntimeException("DB_ID_RANGE sharding requires the shard.range property to be set.");
                }
                LOGGER.info("Sharding via DB_ID_RANGE");
                String[] pair = properties.getProperty(SHARD_RANGE_KEY).split("-");
                long start = Long.parseLong(pair[0]);
                long end = Long.parseLong(pair[1]);
                return new DBIDRangeRouter(start, end);
            }
            case ACL_ID: {
                LOGGER.info("Sharding via ACL_ID");
                return new ACLIDMurmurRouter();
            }
            case MOD_ACL_ID: {
                LOGGER.info("Sharding via MOD_ACL_ID");
                return new ACLIDModRouter();
            }
            case DATE: {
                LOGGER.info("Sharding via DATE");
                return new DateMonthRouter(properties.getProperty(SHARD_DATE_GROUPING_KEY, "1"));
            }
            case PROPERTY: {
                LOGGER.info("Sharding via PROPERTY");
                return new PropertyRouter(properties.getProperty(SHARD_REGEX_KEY, ""));
            }
            case LAST_REGISTERED_INDEXING_SHARD: {
                LOGGER.warn("Sharding via LAST_REGISTERED_INDEXING_SHARD: Note this is available at the moment as an Early Access/preview feature!");
                return new ExplicitShardIdWithStaticPropertyRouter();
            }
            case EXPLICIT_ID_FALLBACK_LRIS: {
                LOGGER.warn("Sharding via EXPLICIT_ID_FALLBACK_LRIS: Note the LRIS Router (which is part of this composite router) is available at the moment as an Early Access/preview feature!");
                return new DocRouterWithFallback(new ExplicitShardIdWithDynamicPropertyRouter(false), new ExplicitShardIdWithStaticPropertyRouter());
            }
            case EXPLICIT_ID: {
                LOGGER.info("Sharding via EXPLICIT_ID");
                return new DocRouterWithFallback(new ExplicitShardIdWithDynamicPropertyRouter(false), new DBIDRouter());
            }
        }
        LOGGER.warn("WARNING! Unknown/unsupported sharding method ({}). System will fallback to DB_ID", (Object)method);
        return new DBIDRouter();
    }
}

