/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.solr.BoundedDeque;
import org.alfresco.solr.InformationServer;
import org.alfresco.solr.NodeReport;
import org.alfresco.solr.TrackerState;
import org.alfresco.solr.adapters.IOpenBitSet;
import org.alfresco.solr.client.GetNodesParameters;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.client.SOLRAPIClient;
import org.alfresco.solr.client.Transaction;
import org.alfresco.solr.client.Transactions;
import org.alfresco.solr.tracker.AbstractWorker;
import org.alfresco.solr.tracker.ActivatableTracker;
import org.alfresco.solr.tracker.DBIDRangeRouter;
import org.alfresco.solr.tracker.IndexHealthReport;
import org.alfresco.solr.tracker.ModelTracker;
import org.alfresco.solr.tracker.Tracker;
import org.alfresco.util.Pair;
import org.apache.commons.codec.EncoderException;
import org.json.JSONException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetadataTracker
extends ActivatableTracker {
    protected static final Logger LOGGER = LoggerFactory.getLogger(MetadataTracker.class);
    private static final int METADATA_TRANSACTIONS_FOUND_QUEUE_SIZE = 100;
    private static final int DEFAULT_METADATA_TRACKER_MAX_PARALLELISM = 32;
    private static final int DEFAULT_TRANSACTION_DOCS_BATCH_SIZE = 2000;
    private static final int DEFAULT_MAX_NUMBER_OF_TRANSACTIONS = 2000;
    private static final int DEFAULT_NODE_BATCH_SIZE = 50;
    private static final String DEFAULT_INITIAL_TRANSACTION_RANGE = "0-2000";
    private static final long DEFAULT_METADATA_TRACKER_TIMESTEP = 3600000L;
    private int matadataTrackerParallelism;
    private int transactionDocsBatchSize;
    private int nodeBatchSize;
    private int maxNumberOfTransactions;
    private long timeStep;
    private final ConcurrentLinkedQueue<Long> transactionsToReindex = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Long> transactionsToIndex = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Long> transactionsToPurge = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Long> nodesToReindex = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Long> nodesToIndex = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Long> nodesToPurge = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<String> queriesToReindex = new ConcurrentLinkedQueue();
    private ForkJoinPool forkJoinPool;
    private static final Map<String, Semaphore> RUN_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();
    private static final Map<String, Semaphore> WRITE_LOCK_BY_CORE = new ConcurrentHashMap<String, Semaphore>();
    private boolean nextTxCommitTimeServiceAvailable = false;
    private boolean txIntervalCommitTimeServiceAvailable = false;
    private boolean cascadeTrackerEnabled = true;
    private Pair<Long, Long> minTxnIdRange;

    @Override
    public Semaphore getWriteLock() {
        return WRITE_LOCK_BY_CORE.get(this.coreName);
    }

    @Override
    public Semaphore getRunLock() {
        return RUN_LOCK_BY_CORE.get(this.coreName);
    }

    public MetadataTracker(Properties p, SOLRAPIClient client, String coreName, InformationServer informationServer) {
        this(p, client, coreName, informationServer, false);
    }

    public MetadataTracker(Properties p, SOLRAPIClient client, String coreName, InformationServer informationServer, boolean checkRepoServicesAvailability) {
        super(p, client, coreName, informationServer, Tracker.Type.METADATA);
        this.transactionDocsBatchSize = Integer.parseInt(p.getProperty("alfresco.transactionDocsBatchSize", String.valueOf(2000)));
        this.nodeBatchSize = Integer.parseInt(p.getProperty("alfresco.nodeBatchSize", String.valueOf(50)));
        this.maxNumberOfTransactions = Integer.parseInt(p.getProperty("alfresco.metadata.tracker.maxNumberOfTransactions", String.valueOf(2000)));
        this.matadataTrackerParallelism = Integer.parseInt(p.getProperty("alfresco.metadata.tracker.maxParallelism", String.valueOf(32)));
        this.timeStep = Long.parseLong(p.getProperty("alfresco.metadata.tracker.timestep", String.valueOf(3600000L)));
        String[] minTxninitialRangeString = p.getProperty("solr.initial.transaction.range", DEFAULT_INITIAL_TRANSACTION_RANGE).split("-");
        this.cascadeTrackerEnabled = informationServer.cascadeTrackingEnabled();
        this.minTxnIdRange = new Pair((Object)Long.valueOf(minTxninitialRangeString[0]), (Object)Long.valueOf(minTxninitialRangeString[1]));
        this.forkJoinPool = new ForkJoinPool(this.matadataTrackerParallelism);
        RUN_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
        WRITE_LOCK_BY_CORE.put(coreName, new Semaphore(1, true));
        if (checkRepoServicesAvailability) {
            try {
                client.getNextTxCommitTime(coreName, Long.valueOf(0L));
                this.nextTxCommitTimeServiceAvailable = true;
            }
            catch (NoSuchMethodException e) {
                LOGGER.warn("nextTxCommitTimeService is not available. Upgrade your ACS Repository version in order to use this feature: {} ", (Object)e.getMessage());
            }
            catch (Exception e) {
                LOGGER.error("Checking nextTxCommitTimeService failed.", (Throwable)e);
            }
            if (this.shardMethod.equals((Object)ShardMethodEnum.DB_ID_RANGE)) {
                try {
                    client.getTxIntervalCommitTime(coreName, Long.valueOf(0L), Long.valueOf(0L));
                    this.txIntervalCommitTimeServiceAvailable = true;
                }
                catch (NoSuchMethodException e) {
                    LOGGER.warn("txIntervalCommitTimeServiceAvailable is not available. Upgrade your ACS Repository version to use this feature with DB_ID_RANGE sharding: {} ", (Object)e.getMessage());
                }
                catch (Exception e) {
                    LOGGER.error("Checking txIntervalCommitTimeServiceAvailable failed.", (Throwable)e);
                }
            }
        }
    }

    MetadataTracker() {
        super(Tracker.Type.METADATA);
    }

    @Override
    protected void doTrack(String iterationId) throws AuthenticationException, IOException, JSONException {
        ModelTracker modelTracker = this.infoSrv.getAdminHandler().getTrackerRegistry().getModelTracker();
        if (modelTracker != null && modelTracker.hasModels()) {
            this.trackRepository();
        } else {
            this.invalidateState();
        }
    }

    @Override
    public void maintenance() throws Exception {
        this.purgeTransactions();
        this.purgeNodes();
        this.reindexTransactions();
        this.reindexNodes();
        this.reindexNodesByQuery();
        this.indexTransactions();
        this.indexNodes();
    }

    @Override
    public boolean hasMaintenance() {
        return this.transactionsToReindex.size() > 0 || this.transactionsToIndex.size() > 0 || this.transactionsToPurge.size() > 0 || this.nodesToReindex.size() > 0 || this.nodesToIndex.size() > 0 || this.nodesToPurge.size() > 0 || this.queriesToReindex.size() > 0;
    }

    private void trackRepository() throws IOException, AuthenticationException, JSONException {
        this.checkShutdown();
        TrackerState state = super.getTrackerState();
        if (state.getTrackerCycles() == 0) {
            this.checkRepoAndIndexConsistency(state);
        }
        if (this.docRouter instanceof DBIDRangeRouter) {
            DBIDRangeRouter dbidRangeRouter = (DBIDRangeRouter)this.docRouter;
            long indexCap = this.infoSrv.getIndexCap();
            long endRange = dbidRangeRouter.getEndRange();
            assert (indexCap == -1L || indexCap >= endRange);
            if (indexCap > endRange) {
                dbidRangeRouter.setExpanded(true);
                dbidRangeRouter.setEndRange(indexCap);
            }
            dbidRangeRouter.setInitialized(true);
        }
        this.checkShutdown();
        this.trackTransactions();
    }

    private void checkRepoAndIndexConsistency(TrackerState state) throws AuthenticationException, IOException, JSONException {
        Transactions firstTransactions = null;
        if (state.getLastGoodTxCommitTimeInIndex() == 0L) {
            state.setCheckedLastTransactionTime(true);
            state.setCheckedFirstTransactionTime(true);
            LOGGER.info("No transactions found - no verification required");
            firstTransactions = this.client.getTransactions(null, (Long)this.minTxnIdRange.getFirst(), null, (Long)this.minTxnIdRange.getSecond(), 1);
            if (!firstTransactions.getTransactions().isEmpty()) {
                Transaction firstTransaction = (Transaction)firstTransactions.getTransactions().get(0);
                long firstTransactionCommitTime = firstTransaction.getCommitTimeMs();
                state.setLastGoodTxCommitTimeInIndex(firstTransactionCommitTime);
                this.setLastTxCommitTimeAndTxIdInTrackerState(firstTransactions);
            }
        }
        if (!state.isCheckedFirstTransactionTime()) {
            long minCommitTime = 0L;
            if (this.docRouter instanceof DBIDRangeRouter && this.txIntervalCommitTimeServiceAvailable) {
                try {
                    DBIDRangeRouter dbIdRangeRouter = (DBIDRangeRouter)this.docRouter;
                    Pair commitTimes = this.client.getTxIntervalCommitTime(this.coreName, Long.valueOf(dbIdRangeRouter.getStartRange()), Long.valueOf(dbIdRangeRouter.getEndRange()));
                    minCommitTime = (Long)commitTimes.getFirst();
                }
                catch (NoSuchMethodException e) {
                    LOGGER.warn("txIntervalCommitTimeServiceAvailable is not available. If you are using DB_ID_RANGE shard method, upgrade your ACS Repository version in order to use the skip transactions feature: {} ", (Object)e.getMessage());
                }
            }
            if (minCommitTime != -1L && !(firstTransactions = this.client.getTransactions(Long.valueOf(minCommitTime), (Long)this.minTxnIdRange.getFirst(), null, (Long)this.minTxnIdRange.getSecond(), 1)).getTransactions().isEmpty()) {
                Transaction firstTransaction = (Transaction)firstTransactions.getTransactions().get(0);
                long firstTxId = firstTransaction.getId();
                long firstTransactionCommitTime = firstTransaction.getCommitTimeMs();
                int setSize = this.infoSrv.getTxDocsSize(Long.toString(firstTxId), Long.toString(firstTransactionCommitTime));
                if (setSize == 0) {
                    LOGGER.error("First transaction was not found with the correct timestamp.");
                    LOGGER.error("SOLR has successfully connected to your repository however the SOLR indexes and repository database do not match.");
                    LOGGER.error("If this is a new or rebuilt database your SOLR indexes also need to be re-built to match the database.");
                    LOGGER.error("You can also check your SOLR connection details in solrcore.properties.");
                    throw new AlfrescoRuntimeException("Initial transaction not found with correct timestamp");
                }
                if (setSize == 1) {
                    state.setCheckedFirstTransactionTime(true);
                    LOGGER.info("Verified first transaction and timestamp in index");
                } else {
                    LOGGER.warn("Duplicate initial transaction found with correct timestamp");
                }
            }
        }
        if (!state.isCheckedLastTransactionTime()) {
            if (firstTransactions == null) {
                firstTransactions = this.client.getTransactions(null, (Long)this.minTxnIdRange.getFirst(), null, (Long)this.minTxnIdRange.getSecond(), 1);
            }
            this.setLastTxCommitTimeAndTxIdInTrackerState(firstTransactions);
            Long maxTxnCommitTimeInRepo = firstTransactions.getMaxTxnCommitTime();
            Long maxTxnIdInRepo = firstTransactions.getMaxTxnId();
            if (maxTxnCommitTimeInRepo != null && maxTxnIdInRepo != null) {
                Transaction maxTxInIndex = this.infoSrv.getMaxTransactionIdAndCommitTimeInIndex();
                if (maxTxInIndex.getCommitTimeMs() > maxTxnCommitTimeInRepo) {
                    LOGGER.error("Last transaction was found in index with timestamp later than that of repository.");
                    LOGGER.error("Max Tx In Index: " + maxTxInIndex.getId() + ", In Repo: " + maxTxnIdInRepo);
                    LOGGER.error("Max Tx Commit Time In Index: " + maxTxInIndex.getCommitTimeMs() + ", In Repo: " + maxTxnCommitTimeInRepo);
                    LOGGER.error("SOLR has successfully connected to your repository  however the SOLR indexes and repository database do not match.");
                    LOGGER.error("If this is a new or rebuilt database your SOLR indexes also need to be re-built to match the database.");
                    LOGGER.error("You can also check your SOLR connection details in solrcore.properties.");
                    throw new AlfrescoRuntimeException("Last transaction found in index with incorrect timestamp");
                }
                state.setCheckedLastTransactionTime(true);
                LOGGER.info("Verified last transaction timestamp in index less than or equal to that of repository.");
            }
        }
    }

    private void indexTransactions() throws IOException, AuthenticationException, JSONException {
        long startElapsed = System.nanoTime();
        int docCount = 0;
        boolean requiresCommit = false;
        while (this.transactionsToIndex.peek() != null) {
            Long transactionId = this.transactionsToIndex.poll();
            if (transactionId == null) continue;
            Transactions transactions = this.client.getTransactions(null, transactionId, null, Long.valueOf(transactionId + 1L), 1);
            if (transactions.getTransactions().size() > 0 && transactionId.equals(((Transaction)transactions.getTransactions().get(0)).getId())) {
                Transaction info = (Transaction)transactions.getTransactions().get(0);
                GetNodesParameters gnp = new GetNodesParameters();
                ArrayList<Long> txs = new ArrayList<Long>();
                txs.add(info.getId());
                gnp.setTransactionIds(txs);
                gnp.setStoreProtocol(this.storeRef.getProtocol());
                gnp.setStoreIdentifier(this.storeRef.getIdentifier());
                this.updateShardProperty();
                this.shardProperty.ifPresent(arg_0 -> ((GetNodesParameters)gnp).setShardProperty(arg_0));
                gnp.setCoreName(this.coreName);
                List nodes = this.client.getNodes(gnp, (int)info.getUpdates());
                for (Node node : nodes) {
                    ++docCount;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug(node.toString());
                    }
                    this.infoSrv.indexNode(node, false);
                    this.checkShutdown();
                }
                this.infoSrv.indexTransaction(info, false);
                LOGGER.info("INDEX ACTION - Transaction {} has been indexed", (Object)transactionId);
                requiresCommit = true;
                this.trackerStats.addTxDocs(nodes.size());
                continue;
            }
            LOGGER.info("INDEX ACTION - Transaction {} was not found in database, it has NOT been reindexed", (Object)transactionId);
        }
        if (requiresCommit) {
            this.checkShutdown();
            long endElapsed = System.nanoTime();
            this.trackerStats.addElapsedNodeTime(docCount, endElapsed - startElapsed);
        }
    }

    private void indexNodes() throws IOException, AuthenticationException, JSONException {
        boolean requiresCommit = false;
        while (this.nodesToIndex.peek() != null) {
            Long nodeId = this.nodesToIndex.poll();
            if (nodeId != null) {
                Node node = new Node();
                node.setId(nodeId.longValue());
                node.setStatus(Node.SolrApiNodeStatus.UNKNOWN);
                node.setTxnId(Long.MAX_VALUE);
                this.infoSrv.indexNode(node, false);
                LOGGER.info("INDEX ACTION - Node {} has been reindexed", (Object)node.getId());
                requiresCommit = true;
            }
            this.checkShutdown();
        }
        if (requiresCommit) {
            this.checkShutdown();
        }
    }

    private void reindexTransactions() throws IOException, AuthenticationException, JSONException {
        long startElapsed = System.nanoTime();
        int docCount = 0;
        while (this.transactionsToReindex.peek() != null) {
            Long transactionId = this.transactionsToReindex.poll();
            if (transactionId != null) {
                this.infoSrv.deleteByTransactionId(transactionId);
                Transactions transactions = this.client.getTransactions(null, transactionId, null, Long.valueOf(transactionId + 1L), 1);
                if (transactions.getTransactions().size() > 0 && transactionId.equals(((Transaction)transactions.getTransactions().get(0)).getId())) {
                    Transaction info = (Transaction)transactions.getTransactions().get(0);
                    this.infoSrv.dirtyTransaction(info.getId());
                    GetNodesParameters gnp = new GetNodesParameters();
                    ArrayList<Long> txs = new ArrayList<Long>();
                    txs.add(info.getId());
                    gnp.setTransactionIds(txs);
                    gnp.setStoreProtocol(this.storeRef.getProtocol());
                    gnp.setStoreIdentifier(this.storeRef.getIdentifier());
                    gnp.setCoreName(this.coreName);
                    List nodes = this.client.getNodes(gnp, (int)info.getUpdates());
                    for (Node node : this.filterNodes(nodes)) {
                        ++docCount;
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug(node.toString());
                        }
                        this.infoSrv.indexNode(node, true);
                        this.checkShutdown();
                    }
                    this.infoSrv.indexTransaction(info, true);
                    LOGGER.info("REINDEX ACTION - Transaction {} has been reindexed", (Object)transactionId);
                } else {
                    LOGGER.info("REINDEX ACTION - Transaction {} was not found in database, it has NOT been reindexed", (Object)transactionId);
                }
            }
            if ((long)docCount <= this.batchCount || this.infoSrv.getRegisteredSearcherCount() >= this.getMaxLiveSearchers()) continue;
            this.checkShutdown();
            long endElapsed = System.nanoTime();
            this.trackerStats.addElapsedNodeTime(docCount, endElapsed - startElapsed);
            startElapsed = endElapsed;
            docCount = 0;
        }
        if (docCount > 0) {
            this.checkShutdown();
            long endElapsed = System.nanoTime();
            this.trackerStats.addElapsedNodeTime(docCount, endElapsed - startElapsed);
        }
    }

    private void reindexNodes() throws IOException, AuthenticationException, JSONException {
        while (this.nodesToReindex.peek() != null) {
            Long nodeId = this.nodesToReindex.poll();
            if (nodeId != null) {
                Node node = new Node();
                node.setId(nodeId.longValue());
                node.setStatus(Node.SolrApiNodeStatus.UNKNOWN);
                node.setTxnId(Long.MAX_VALUE);
                for (Node n : this.filterNodes(List.of(node))) {
                    this.infoSrv.indexNode(n, true);
                    LOGGER.info("REINDEX ACTION - Node {} has been reindexed", (Object)n.getId());
                }
            }
            this.checkShutdown();
        }
    }

    private void reindexNodesByQuery() throws IOException, AuthenticationException, JSONException {
        boolean requiresCommit = false;
        while (this.queriesToReindex.peek() != null) {
            String query = this.queriesToReindex.poll();
            if (query != null) {
                this.infoSrv.reindexNodeByQuery(query);
                LOGGER.info("REINDEX ACTION - Nodes from query {} have been reindexed", (Object)query);
                requiresCommit = true;
            }
            this.checkShutdown();
        }
        if (requiresCommit) {
            this.checkShutdown();
        }
    }

    private List<Node> filterNodes(List<Node> nodes) {
        ArrayList<Node> filteredList = new ArrayList<Node>(nodes.size());
        for (Node node : nodes) {
            if (this.docRouter.routeNode(this.shardCount, this.shardInstance, node).booleanValue()) {
                filteredList.add(node);
                continue;
            }
            if (!this.cascadeTrackerEnabled) continue;
            if (node.getStatus() == Node.SolrApiNodeStatus.UPDATED) {
                Node doCascade = new Node();
                doCascade.setAclId(node.getAclId());
                doCascade.setId(node.getId());
                doCascade.setNodeRef(node.getNodeRef());
                doCascade.setStatus(Node.SolrApiNodeStatus.NON_SHARD_UPDATED);
                doCascade.setTenant(node.getTenant());
                doCascade.setTxnId(node.getTxnId());
                filteredList.add(doCascade);
                continue;
            }
            Node doDelete = new Node();
            doDelete.setAclId(node.getAclId());
            doDelete.setId(node.getId());
            doDelete.setNodeRef(node.getNodeRef());
            doDelete.setStatus(Node.SolrApiNodeStatus.NON_SHARD_DELETED);
            doDelete.setTenant(node.getTenant());
            doDelete.setTxnId(node.getTxnId());
            filteredList.add(doDelete);
        }
        return filteredList;
    }

    private void purgeTransactions() throws IOException, JSONException {
        boolean requiresCommit = false;
        while (this.transactionsToPurge.peek() != null) {
            Long transactionId = this.transactionsToPurge.poll();
            if (transactionId != null) {
                this.infoSrv.deleteByTransactionId(transactionId);
                requiresCommit = true;
                LOGGER.info("PURGE ACTION - Purged transactionId {}", (Object)transactionId);
            }
            this.checkShutdown();
        }
        if (requiresCommit) {
            this.checkShutdown();
        }
    }

    private void purgeNodes() throws IOException, JSONException {
        while (this.nodesToPurge.peek() != null) {
            Long nodeId = this.nodesToPurge.poll();
            if (nodeId != null) {
                this.infoSrv.deleteByNodeId(nodeId);
                LOGGER.info("PURGE ACTION - Purged nodeId {}", (Object)nodeId);
            }
            this.checkShutdown();
        }
    }

    protected Long getTxFromCommitTime(BoundedDeque<Transaction> txnsFound, long lastGoodTxCommitTimeInIndex) {
        if (txnsFound.size() > 0) {
            return ((Transaction)txnsFound.getLast()).getCommitTimeMs();
        }
        return lastGoodTxCommitTimeInIndex;
    }

    private boolean alreadyFoundTransactions(BoundedDeque<Transaction> txnsFound, Transactions transactions) {
        if (txnsFound.size() == 0) {
            return false;
        }
        if (transactions.getTransactions().size() == 1) {
            return ((Transaction)transactions.getTransactions().get(0)).getId() == ((Transaction)txnsFound.getLast()).getId();
        }
        HashSet alreadyFound = new HashSet(txnsFound.getDeque());
        for (Transaction txn : transactions.getTransactions()) {
            if (alreadyFound.contains(txn)) continue;
            return false;
        }
        return true;
    }

    protected Transactions getSomeTransactions(BoundedDeque<Transaction> txnsFound, Long fromCommitTime, long timeStep, int maxResults, long endTime) throws AuthenticationException, IOException, JSONException, EncoderException, NoSuchMethodException {
        Transactions transactions;
        long startTime;
        long l = startTime = fromCommitTime == null ? 0L : fromCommitTime;
        if (startTime == 0L) {
            return this.client.getTransactions(Long.valueOf(startTime), null, Long.valueOf(startTime + timeStep), null, maxResults);
        }
        do {
            Long nextTxCommitTime;
            transactions = this.client.getTransactions(Long.valueOf(startTime), null, Long.valueOf(startTime + timeStep), null, maxResults);
            if (!this.nextTxCommitTimeServiceAvailable || transactions.getTransactions().size() != 0 || (nextTxCommitTime = this.client.getNextTxCommitTime(this.coreName, Long.valueOf(startTime += timeStep))) == -1L) continue;
            LOGGER.info("{}-[CORE {}] Advancing transactions from {} to {}", new Object[]{Thread.currentThread().getId(), this.coreName, startTime, nextTxCommitTime});
            transactions = this.client.getTransactions(nextTxCommitTime, null, Long.valueOf(nextTxCommitTime + timeStep), null, maxResults);
        } while (transactions.getTransactions().size() == 0 && startTime < endTime || transactions.getTransactions().size() > 0 && this.alreadyFoundTransactions(txnsFound, transactions));
        return transactions;
    }

    private Transactions getDBIDRangeTransactions(Long fromCommitTime, BoundedDeque<Transaction> txnsFound) throws NoSuchMethodException, AuthenticationException, IOException, JSONException, EncoderException {
        boolean shardOutOfRange = false;
        DBIDRangeRouter dbIdRangeRouter = (DBIDRangeRouter)this.docRouter;
        Pair commitTimes = this.client.getTxIntervalCommitTime(this.coreName, Long.valueOf(dbIdRangeRouter.getStartRange()), Long.valueOf(dbIdRangeRouter.getEndRange()));
        Long shardMinCommitTime = (Long)commitTimes.getFirst();
        Long shardMaxCommitTime = (Long)commitTimes.getSecond();
        if (shardMinCommitTime == -1L) {
            LOGGER.debug("{}-[CORE {}] [DB_ID_RANGE] No nodes in range [{}-{}] exist in the repository. Indexing only latest transaction.", new Object[]{Thread.currentThread().getId(), this.coreName, dbIdRangeRouter.getStartRange(), dbIdRangeRouter.getEndRange()});
            shardOutOfRange = true;
        }
        if (fromCommitTime > shardMaxCommitTime) {
            LOGGER.debug("{}-[CORE {}] [DB_ID_RANGE] Last commit time is greater that max commit time in in range [{}-{}]. Indexing only latest transaction if necessary.", new Object[]{Thread.currentThread().getId(), this.coreName, dbIdRangeRouter.getStartRange(), dbIdRangeRouter.getEndRange()});
            shardOutOfRange = true;
        }
        if (fromCommitTime < shardMinCommitTime) {
            LOGGER.debug("{}-[CORE {}] [DB_ID_RANGE] Skipping transactions from {} to {}", new Object[]{Thread.currentThread().getId(), this.coreName, fromCommitTime, shardMinCommitTime});
            fromCommitTime = shardMinCommitTime;
        }
        Transactions transactions = this.getSomeTransactions(txnsFound, fromCommitTime, this.timeStep, this.maxNumberOfTransactions, this.state.getTimeToStopIndexing());
        if (shardOutOfRange) {
            Transaction latestTransaction = new Transaction();
            latestTransaction.setCommitTimeMs(transactions.getMaxTxnCommitTime().longValue());
            latestTransaction.setId(transactions.getMaxTxnId().longValue());
            if (this.isTransactionToBeIndexed(latestTransaction)) {
                transactions = new Transactions(Collections.singletonList(latestTransaction), transactions.getMaxTxnCommitTime(), transactions.getMaxTxnId());
                LOGGER.debug("{}:{}-[CORE {}] [DB_ID_RANGE] Latest transaction to be indexed {}", new Object[]{Thread.currentThread().getId(), this.coreName, latestTransaction});
            } else {
                return new Transactions(Collections.emptyList(), Long.valueOf(0L), Long.valueOf(0L));
            }
        }
        return transactions;
    }

    boolean isTransactionToBeIndexed(Transaction transaction) {
        try {
            boolean isInIndex;
            boolean bl = isInIndex = transaction.getCommitTimeMs() <= this.state.getLastIndexedTxCommitTime() && this.infoSrv.txnInIndex(transaction.getId(), true);
            if (LOGGER.isTraceEnabled() && isInIndex) {
                LOGGER.trace("{}-[CORE {}] Skipping Transaction Id {} as it was already indexed", new Object[]{Thread.currentThread().getId(), this.coreName, transaction.getId()});
            }
            return !isInIndex;
        }
        catch (IOException e) {
            LOGGER.warn("{}-[CORE {}] Error catched while checking if Transaction Id {} was in index", new Object[]{Thread.currentThread().getId(), this.coreName, transaction.getId(), e});
            return true;
        }
    }

    protected void trackTransactions() throws IOException, JSONException {
        Transactions transactions;
        long startElapsed = System.nanoTime();
        BoundedDeque txnsFound = new BoundedDeque(100);
        int totalUpdatedDocs = 0;
        LOGGER.info("{}-[CORE {}] Starting metadata tracker execution", (Object)Thread.currentThread().getId(), (Object)this.coreName);
        do {
            try {
                this.getWriteLock().acquire();
                this.state = this.getTrackerState();
                Long fromCommitTime = this.getTxFromCommitTime((BoundedDeque<Transaction>)txnsFound, this.state.getLastGoodTxCommitTimeInIndex());
                transactions = this.docRouter instanceof DBIDRangeRouter && this.txIntervalCommitTimeServiceAvailable ? this.getDBIDRangeTransactions(fromCommitTime, (BoundedDeque<Transaction>)txnsFound) : this.getSomeTransactions((BoundedDeque<Transaction>)txnsFound, fromCommitTime, this.timeStep, this.maxNumberOfTransactions, this.state.getTimeToStopIndexing());
                long idTrackerCycle = System.currentTimeMillis();
                if (transactions.getTransactions().size() > 0) {
                    LOGGER.info("{}:{}-[CORE {}] Found {} transactions after lastTxCommitTime {}, transactions from {} to {}", new Object[]{Thread.currentThread().getId(), idTrackerCycle, this.coreName, transactions.getTransactions().size(), fromCommitTime, transactions.getTransactions().get(0), transactions.getTransactions().get(transactions.getTransactions().size() - 1)});
                } else {
                    LOGGER.info("{}:{}-[CORE {}] No transaction found after lastTxCommitTime {}", new Object[]{Thread.currentThread().getId(), idTrackerCycle, this.coreName, txnsFound.size() > 0 ? ((Transaction)txnsFound.getLast()).getCommitTimeMs() : this.state.getLastIndexedTxCommitTime()});
                }
                if (transactions.getTransactions().stream().anyMatch(transaction -> transaction.getCommitTimeMs() > this.state.getTimeToStopIndexing())) break;
                AtomicInteger counterTransaction = new AtomicInteger();
                Collection<List<Transaction>> txBatches = transactions.getTransactions().stream().peek(arg_0 -> ((BoundedDeque)txnsFound).add(arg_0)).filter(this::isTransactionToBeIndexed).collect(Collectors.groupingBy(transaction -> counterTransaction.getAndAdd((int)(transaction.getDeletes() + transaction.getUpdates())) / this.transactionDocsBatchSize)).values();
                ArrayList<List<Node>> nodeBatches = new ArrayList<List<Node>>();
                for (List<Transaction> batch : txBatches) {
                    long idTxBatch = System.currentTimeMillis();
                    nodeBatches.addAll(this.buildBatchOfTransactions(batch, idTrackerCycle, idTxBatch));
                }
                AtomicInteger counterBatch = new AtomicInteger(0);
                long idThread = Thread.currentThread().getId();
                totalUpdatedDocs += ((Integer)((ForkJoinTask)this.forkJoinPool.submit(() -> nodeBatches.parallelStream().map(batch -> {
                    int count = counterBatch.addAndGet(1);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("{}:{}:{}-[CORE {}] indexing {} nodes ...", new Object[]{idThread, idTrackerCycle, count, this.coreName, batch.size()});
                    }
                    new NodeIndexWorker((List<Node>)batch, this.infoSrv, idThread, idTrackerCycle, count).run();
                    return batch.size();
                }).reduce(0, Integer::sum))).get()).intValue();
                for (List<Transaction> batch : txBatches) {
                    batch.forEach(arg_0 -> ((BoundedDeque)txnsFound).add(arg_0));
                    this.indexTransactionsAfterWorker(batch);
                    long endElapsed = System.nanoTime();
                    this.trackerStats.addElapsedNodeTime(totalUpdatedDocs, endElapsed - startElapsed);
                    startElapsed = endElapsed;
                }
                this.setLastTxCommitTimeAndTxIdInTrackerState(transactions);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            finally {
                this.getWriteLock().release();
            }
        } while (transactions.getTransactions().size() > 0);
        LOGGER.info("{}-[CORE {}] Tracked {} DOCs", new Object[]{Thread.currentThread().getId(), this.coreName, totalUpdatedDocs});
    }

    private void setLastTxCommitTimeAndTxIdInTrackerState(Transactions transactions) {
        Long maxTxnId;
        Long maxTxnCommitTime = transactions.getMaxTxnCommitTime();
        if (maxTxnCommitTime != null) {
            this.state.setLastTxCommitTimeOnServer(maxTxnCommitTime.longValue());
        }
        if ((maxTxnId = transactions.getMaxTxnId()) != null) {
            this.state.setLastTxIdOnServer(maxTxnId.longValue());
        }
    }

    private void indexTransactionsAfterWorker(List<Transaction> txsIndexed) throws IOException {
        for (Transaction tx : txsIndexed) {
            this.infoSrv.indexTransaction(tx, true);
            if (tx.getCommitTimeMs() > this.state.getLastIndexedTxCommitTime() || tx.getCommitTimeMs() == this.state.getLastIndexedTxCommitTime() && tx.getId() > this.state.getLastIndexedTxId()) {
                this.state.setLastIndexedTxCommitTime(tx.getCommitTimeMs());
                this.state.setLastIndexedTxId(tx.getId());
            }
            this.trackerStats.addTxDocs((int)(tx.getDeletes() + tx.getUpdates()));
        }
        txsIndexed.clear();
    }

    private List<List<Node>> buildBatchOfTransactions(List<Transaction> txBatch, long idTrackerCycle, long idTxBatch) throws AuthenticationException, IOException, JSONException, ExecutionException, InterruptedException {
        ArrayList<Long> txIds = new ArrayList<Long>();
        for (Transaction tx : txBatch) {
            if (tx.getUpdates() <= 0L && tx.getDeletes() <= 0L) continue;
            txIds.add(tx.getId());
        }
        if (txIds.size() == 0) {
            return Collections.emptyList();
        }
        GetNodesParameters gnp = new GetNodesParameters();
        gnp.setTransactionIds(txIds);
        gnp.setStoreProtocol(this.storeRef.getProtocol());
        gnp.setStoreIdentifier(this.storeRef.getIdentifier());
        this.updateShardProperty();
        this.shardProperty.ifPresent(arg_0 -> ((GetNodesParameters)gnp).setShardProperty(arg_0));
        gnp.setCoreName(this.coreName);
        List nodes = this.client.getNodes(gnp, Integer.MAX_VALUE);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("{}:{}:{}-[CORE {}] Indexing {} Nodes from Transactions: {}", new Object[]{Thread.currentThread().getId(), idTrackerCycle, idTxBatch, this.coreName, nodes.size(), txIds});
        }
        return Lists.partition((List)nodes, (int)this.nodeBatchSize);
    }

    @Override
    public NodeReport checkNode(Long dbid) {
        NodeReport nodeReport = super.checkNode(dbid);
        GetNodesParameters parameters = new GetNodesParameters();
        parameters.setFromNodeId(dbid);
        parameters.setToNodeId(dbid);
        try {
            List dbnodes = this.client.getNodes(parameters, 1);
            if (dbnodes.size() == 1) {
                Node dbnode = (Node)dbnodes.get(0);
                nodeReport.setDbNodeStatus(dbnode.getStatus());
                nodeReport.setDbTx(Long.valueOf(dbnode.getTxnId()));
            } else {
                nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
                nodeReport.setDbTx(Long.valueOf(-1L));
            }
        }
        catch (IOException e) {
            nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
            nodeReport.setDbTx(Long.valueOf(-2L));
        }
        catch (JSONException e) {
            nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
            nodeReport.setDbTx(Long.valueOf(-3L));
        }
        catch (AuthenticationException e1) {
            nodeReport.setDbNodeStatus(Node.SolrApiNodeStatus.UNKNOWN);
            nodeReport.setDbTx(Long.valueOf(-4L));
        }
        return nodeReport;
    }

    public NodeReport checkNode(Node node) {
        return this.checkNode(node.getId());
    }

    public List<Node> getFullNodesForDbTransaction(Long txid) {
        try {
            GetNodesParameters gnp = new GetNodesParameters();
            ArrayList<Long> txs = new ArrayList<Long>();
            txs.add(txid);
            gnp.setTransactionIds(txs);
            gnp.setStoreProtocol(this.storeRef.getProtocol());
            gnp.setStoreIdentifier(this.storeRef.getIdentifier());
            gnp.setCoreName(this.coreName);
            return this.client.getNodes(gnp, Integer.MAX_VALUE);
        }
        catch (IOException | AuthenticationException | JSONException e) {
            throw new AlfrescoRuntimeException("Failed to get nodes", e);
        }
    }

    public IndexHealthReport checkIndex(Long toTx, Long fromTime, Long toTime) throws IOException, AuthenticationException, JSONException, EncoderException, NoSuchMethodException {
        Transactions transactions;
        long firstTransactionCommitTime = 0L;
        Transactions firstTransactions = this.client.getTransactions(null, (Long)this.minTxnIdRange.getFirst(), null, (Long)this.minTxnIdRange.getSecond(), 1);
        if (firstTransactions.getTransactions().size() > 0) {
            Transaction firstTransaction = (Transaction)firstTransactions.getTransactions().get(0);
            firstTransactionCommitTime = firstTransaction.getCommitTimeMs();
        }
        IOpenBitSet txIdsInDb = this.infoSrv.getOpenBitSetInstance();
        long lastTxCommitTime = firstTransactionCommitTime;
        if (fromTime != null) {
            lastTxCommitTime = fromTime;
        }
        long maxTxId = 0L;
        Long minTxId = null;
        BoundedDeque txnsFound = new BoundedDeque(100);
        long endTime = System.currentTimeMillis() + this.infoSrv.getHoleRetention();
        block0: do {
            transactions = this.getSomeTransactions((BoundedDeque<Transaction>)txnsFound, lastTxCommitTime, this.timeStep, this.maxNumberOfTransactions, endTime);
            for (Transaction info : transactions.getTransactions()) {
                if (toTime != null && info.getCommitTimeMs() > toTime || toTx != null && info.getId() > toTx) break block0;
                if (minTxId == null) {
                    minTxId = info.getId();
                }
                if (maxTxId < info.getId()) {
                    maxTxId = info.getId();
                }
                lastTxCommitTime = info.getCommitTimeMs();
                txIdsInDb.set(info.getId());
                txnsFound.add((Object)info);
            }
        } while (transactions.getTransactions().size() > 0);
        return this.infoSrv.reportIndexTransactions(minTxId, txIdsInDb, maxTxId);
    }

    public void addTransactionToPurge(Long txId) {
        this.transactionsToPurge.offer(txId);
    }

    public void addNodeToPurge(Long nodeId) {
        this.nodesToPurge.offer(nodeId);
    }

    public void addTransactionToReindex(Long txId) {
        this.transactionsToReindex.offer(txId);
    }

    public void addNodeToReindex(Long nodeId) {
        this.nodesToReindex.offer(nodeId);
    }

    public void addTransactionToIndex(Long txId) {
        this.transactionsToIndex.offer(txId);
    }

    @Override
    protected void clearScheduledMaintenanceWork() {
        this.logAndClear(this.transactionsToIndex, "Transactions to be indexed");
        this.logAndClear(this.nodesToIndex, "Nodes to be indexed");
        this.logAndClear(this.transactionsToReindex, "Transactions to be re-indexed");
        this.logAndClear(this.nodesToReindex, "Nodes to be re-indexed");
        this.logAndClear(this.transactionsToPurge, "Transactions to be purged");
        this.logAndClear(this.nodesToPurge, "Nodes to be purged");
    }

    public void addNodeToIndex(Long nodeId) {
        this.nodesToIndex.offer(nodeId);
    }

    @Override
    public void invalidateState() {
        super.invalidateState();
        this.infoSrv.clearProcessedTransactions();
    }

    public void addQueryToReindex(String query) {
        this.queriesToReindex.offer(query);
    }

    class NodeIndexWorker
    extends AbstractWorker {
        InformationServer infoServer;
        List<Node> nodes;
        long idThread;
        long idTrackerCycle;
        int idWorker;
        protected Logger LOGGER = LoggerFactory.getLogger(MetadataTracker.class);

        NodeIndexWorker(List<Node> nodes, InformationServer infoServer, long idThread, long idTrackerCycle, int idWorker) {
            this.infoServer = infoServer;
            this.nodes = nodes;
            this.idThread = idThread;
            this.idTrackerCycle = idTrackerCycle;
            this.idWorker = idWorker;
        }

        @Override
        protected void doWork() throws IOException, AuthenticationException, JSONException {
            List<Node> filteredNodes = MetadataTracker.this.filterNodes(this.nodes);
            if (filteredNodes.size() > 0) {
                this.infoServer.indexNodes(filteredNodes, true);
            }
            if (this.LOGGER.isTraceEnabled()) {
                this.LOGGER.trace("{}:{}:{}-[CORE {}] ...indexed", new Object[]{this.idThread, this.idTrackerCycle, this.idWorker, MetadataTracker.this.coreName});
            }
        }

        @Override
        protected void onFail(Throwable failCausedBy) {
            MetadataTracker.this.setRollback(true, failCausedBy);
        }
    }
}

