/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.index.shard.ShardMethodEnum;
import org.alfresco.service.namespace.QName;
import org.alfresco.solr.client.Acl;
import org.alfresco.solr.client.Node;
import org.alfresco.solr.tracker.DocRouter;
import org.alfresco.solr.tracker.DocRouterFactory;
import org.apache.solr.common.util.Hash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyRouter
implements DocRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyRouter.class);
    Pattern pattern;
    String propertyRegEx;
    DocRouter fallback = DocRouterFactory.getRouter(null, ShardMethodEnum.DB_ID);

    public PropertyRouter(String propertyRegEx) {
        if (propertyRegEx != null && propertyRegEx.trim().length() > 0) {
            this.propertyRegEx = propertyRegEx;
            this.pattern = Pattern.compile(propertyRegEx.trim());
        } else {
            this.propertyRegEx = "";
        }
    }

    @Override
    public Boolean routeAcl(int shardCount, int shardInstance, Acl acl) {
        return true;
    }

    @Override
    public Boolean routeNode(int shardCount, int shardInstance, Node node) {
        if (shardCount <= 1) {
            return true;
        }
        String shardBy = node.getShardPropertyValue();
        if (shardBy != null && this.pattern != null) {
            try {
                Matcher matcher = this.pattern.matcher(shardBy);
                shardBy = matcher.find() && !matcher.group(1).isEmpty() ? matcher.group(1) : null;
            }
            catch (IndexOutOfBoundsException | NullPointerException exc) {
                LOGGER.debug("Regex matched, but group 1 not found, so falling back to DBID sharding.");
                shardBy = null;
            }
        }
        if (shardBy == null || shardBy.isEmpty()) {
            LOGGER.debug("Property not found or regex not matched, so falling back to DBID sharding.");
            return this.fallback.routeNode(shardCount, shardInstance, node);
        }
        return Math.abs(Hash.murmurhash3_x86_32((CharSequence)shardBy, (int)0, (int)shardBy.length(), (int)66)) % shardCount == shardInstance;
    }

    @Override
    public Map<String, String> getProperties(Optional<QName> shardProperty) {
        return shardProperty.map(QName::getPrefixString).map(prefix -> Map.of("shard.key", prefix, "shard.regex", this.propertyRegEx)).orElse(Collections.emptyMap());
    }
}

