/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.solr.tracker;

import java.util.Collection;
import java.util.Properties;
import org.alfresco.solr.AlfrescoCoreAdminHandler;
import org.alfresco.solr.tracker.Tracker;
import org.alfresco.solr.tracker.TrackerJob;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.impl.matchers.GroupMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrTrackerScheduler {
    private static final String DEFAULT_CRON = "0/10 * * * * ? *";
    public static final String SOLR_JOB_GROUP = "Solr";
    protected static final Logger log = LoggerFactory.getLogger(SolrTrackerScheduler.class);
    protected Scheduler scheduler;

    public SolrTrackerScheduler(AlfrescoCoreAdminHandler adminHandler) {
        try {
            StdSchedulerFactory factory = new StdSchedulerFactory();
            Properties properties = new Properties();
            properties.setProperty("org.quartz.scheduler.instanceName", ((Object)((Object)adminHandler)).toString());
            properties.setProperty("org.quartz.threadPool.class", "org.quartz.simpl.SimpleThreadPool");
            properties.setProperty("org.quartz.threadPool.threadCount", "40");
            properties.setProperty("org.quartz.threadPool.makeThreadsDaemons", "true");
            properties.setProperty("org.quartz.scheduler.makeSchedulerThreadDaemon", "true");
            properties.setProperty("org.quartz.jobStore.class", "org.quartz.simpl.RAMJobStore");
            properties.setProperty("org.quartz.scheduler.skipUpdateCheck", "true");
            factory.initialize(properties);
            this.scheduler = factory.getScheduler();
            this.scheduler.start();
        }
        catch (SchedulerException e) {
            this.logError("SolrTrackerScheduler", e);
        }
    }

    private void logError(String jobType, Throwable e) {
        log.error("Failed to schedule " + jobType + " Job.", e);
    }

    private String getCron(Properties props, String cronType) {
        String cron = props.getProperty(cronType);
        return cron == null ? props.getProperty("alfresco.cron", DEFAULT_CRON) : cron;
    }

    public void schedule(Tracker tracker, String coreName, Properties props) {
        String jobName = this.getJobName(tracker, coreName);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.put("TRACKER", (Object)tracker);
        JobDetail job = JobBuilder.newJob(TrackerJob.class).withIdentity(jobName, SOLR_JOB_GROUP).withDescription(jobName).setJobData(jobDataMap).build();
        try {
            String cron;
            switch (tracker.getType()) {
                case ACL: {
                    cron = this.getCron(props, "alfresco.acl.tracker.cron");
                    break;
                }
                case MODEL: {
                    cron = this.getCron(props, "alfresco.model.tracker.cron");
                    break;
                }
                case CONTENT: {
                    cron = this.getCron(props, "alfresco.content.tracker.cron");
                    break;
                }
                case METADATA: {
                    cron = this.getCron(props, "alfresco.metadata.tracker.cron");
                    break;
                }
                case CASCADE: {
                    cron = this.getCron(props, "alfresco.cascade.tracker.cron");
                    break;
                }
                case COMMIT: {
                    cron = this.getCron(props, "alfresco.commit.tracker.cron");
                    break;
                }
                case NODE_STATE_PUBLISHER: {
                    cron = this.getCron(props, "alfresco.nodestate.tracker.cron");
                    break;
                }
                default: {
                    cron = props.getProperty("alfresco.cron", DEFAULT_CRON);
                }
            }
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(jobName, SOLR_JOB_GROUP).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)cron)).build();
            log.info("Scheduling job " + jobName);
            this.scheduler.scheduleJob(job, trigger);
        }
        catch (SchedulerException e) {
            this.logError("Tracker", e);
        }
    }

    protected String getJobName(Tracker tracker, String coreName) {
        return tracker.getClass().getSimpleName() + "-" + coreName;
    }

    public void shutdown() throws SchedulerException {
        this.scheduler.shutdown(false);
    }

    public void deleteTrackerJobs(String coreName, Collection<Tracker> trackers) throws SchedulerException {
        for (Tracker tracker : trackers) {
            this.deleteTrackerJob(coreName, tracker);
        }
    }

    public void deleteJobForTrackerInstance(String coreName, Tracker tracker) {
        String jobName = this.getJobName(tracker, coreName);
        JobDetail detail = null;
        try {
            Tracker jobTracker;
            detail = this.scheduler.getJobDetail(new JobKey(jobName, SOLR_JOB_GROUP));
            if (detail != null && tracker == (jobTracker = (Tracker)detail.getJobDataMap().get((Object)"TRACKER"))) {
                this.scheduler.deleteJob(new JobKey(jobName, SOLR_JOB_GROUP));
            }
        }
        catch (SchedulerException e) {
            log.error("Unable to delete a tracker job " + jobName, (Throwable)e);
        }
    }

    public void deleteTrackerJob(String coreName, Tracker tracker) throws SchedulerException {
        String jobName = this.getJobName(tracker, coreName);
        this.scheduler.deleteJob(new JobKey(jobName, SOLR_JOB_GROUP));
    }

    public boolean isShutdown() throws SchedulerException {
        return this.scheduler.isShutdown();
    }

    public void pauseAll() throws SchedulerException {
        this.scheduler.pauseAll();
    }

    public int getJobsCount() throws SchedulerException {
        return this.scheduler.getJobKeys(GroupMatcher.jobGroupEquals((String)SOLR_JOB_GROUP)).size();
    }
}

