/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.ExitableDirectoryReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.Version;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CloseHook;
import org.apache.solr.core.PluginInfo;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.handler.component.DebugComponent;
import org.apache.solr.handler.component.FacetComponent;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.SearchComponent;
import org.apache.solr.handler.component.ShardHandler;
import org.apache.solr.handler.component.ShardHandlerFactory;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BasicResultContext;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.DocIterator;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrQueryTimeoutImpl;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.RTimerTree;
import org.apache.solr.util.SolrPluginUtils;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.noggit.ObjectBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoSearchHandler
extends RequestHandlerBase
implements SolrCoreAware,
PluginInfoInitialized {
    static final String INIT_COMPONENTS = "components";
    static final String INIT_FIRST_COMPONENTS = "first-components";
    static final String INIT_LAST_COMPONENTS = "last-components";
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected volatile List<SearchComponent> components;
    private ShardHandlerFactory shardHandlerFactory;
    private PluginInfo shfInfo;
    private SolrCore core;
    public static final String FACET_COUNTS_KEY = "facet_counts";
    public static final String FACET_CONTEXT_KEY = "_facet.context";

    protected List<String> getDefaultComponents() {
        ArrayList<String> names = new ArrayList<String>(8);
        names.add("query");
        names.add("facet");
        names.add("facet_module");
        names.add("mlt");
        names.add("highlight");
        names.add("stats");
        names.add("debug");
        names.add("expand");
        return names;
    }

    public void init(PluginInfo info) {
        this.init(info.initArgs);
        for (PluginInfo child : info.children) {
            if (!"shardHandlerFactory".equals(child.type)) continue;
            this.shfInfo = child;
            break;
        }
    }

    public void inform(SolrCore core) {
        this.core = core;
        HashSet missing = new HashSet();
        List c = (List)this.initArgs.get(INIT_COMPONENTS);
        missing.addAll(core.getSearchComponents().checkContains((Collection)c));
        List first = (List)this.initArgs.get(INIT_FIRST_COMPONENTS);
        missing.addAll(core.getSearchComponents().checkContains((Collection)first));
        List last = (List)this.initArgs.get(INIT_LAST_COMPONENTS);
        missing.addAll(core.getSearchComponents().checkContains((Collection)last));
        if (!missing.isEmpty()) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Missing SearchComponents named : " + String.valueOf(missing));
        }
        if (c != null && (first != null || last != null)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "First/Last components only valid if you do not declare 'components'");
        }
        if (this.shfInfo == null) {
            this.shardHandlerFactory = core.getCoreContainer().getShardHandlerFactory();
        } else {
            this.shardHandlerFactory = (ShardHandlerFactory)core.createInitInstance(this.shfInfo, ShardHandlerFactory.class, null, null);
            core.addCloseHook(new CloseHook(){

                public void preClose(SolrCore core) {
                    AlfrescoSearchHandler.this.shardHandlerFactory.close();
                }

                public void postClose(SolrCore core) {
                }
            });
        }
    }

    private void initComponents() {
        Object declaredComponents = this.initArgs.get(INIT_COMPONENTS);
        List first = (List)this.initArgs.get(INIT_FIRST_COMPONENTS);
        List last = (List)this.initArgs.get(INIT_LAST_COMPONENTS);
        List list = null;
        boolean makeDebugLast = true;
        if (declaredComponents == null) {
            list = this.getDefaultComponents();
            if (first != null) {
                List clist = first;
                clist.addAll(list);
                list = clist;
            }
            if (last != null) {
                list.addAll(last);
            }
        } else {
            list = (List)declaredComponents;
            if (first != null || last != null) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "First/Last components only valid if you do not declare 'components'");
            }
            makeDebugLast = false;
        }
        ArrayList<SearchComponent> components = new ArrayList<SearchComponent>(list.size());
        DebugComponent dbgCmp = null;
        for (String c : list) {
            SearchComponent comp = this.core.getSearchComponent(c);
            if (comp instanceof DebugComponent && makeDebugLast) {
                dbgCmp = (DebugComponent)comp;
                continue;
            }
            components.add(comp);
            log.debug("Adding  component:" + String.valueOf(comp));
        }
        if (makeDebugLast && dbgCmp != null) {
            components.add((SearchComponent)dbgCmp);
            log.debug("Adding  debug component:" + String.valueOf(dbgCmp));
        }
        this.components = components;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<SearchComponent> getComponents() {
        List<SearchComponent> result = this.components;
        if (result == null) {
            AlfrescoSearchHandler alfrescoSearchHandler = this;
            synchronized (alfrescoSearchHandler) {
                if (this.components == null) {
                    this.initComponents();
                }
                result = this.components;
            }
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readJsonIntoContent(SolrQueryRequest req) throws IOException {
        JSONObject json;
        SolrParams solrParams = req.getParams();
        String jsonFacet = solrParams.get("json.facet");
        if (jsonFacet != null) {
            Object o = ObjectBuilder.fromJSON((String)jsonFacet);
            json = new HashMap();
            json.put("facet", o);
            req.setJSON((Map)json);
        }
        Iterable streams = req.getContentStreams();
        json = (JSONObject)req.getContext().get("ALFRESCO_JSON");
        if (json != null) return;
        if (streams != null) {
            try {
                BufferedReader reader = null;
                for (ContentStream stream : streams) {
                    reader = new BufferedReader(new InputStreamReader(stream.getStream(), "UTF-8"));
                }
                if (reader == null) return;
                json = new JSONObject(new JSONTokener(reader));
                req.getContext().put("ALFRESCO_JSON", json);
                return;
            }
            catch (JSONException reader) {
                return;
            }
            catch (IOException e) {
                throw new AlfrescoRuntimeException("IO Error parsing query parameters", (Throwable)e);
            }
        } else {
            if (req.getParams().get("ALFRESCO_JSON") == null) return;
            req.getContext().put("ALFRESCO_JSON", new JSONObject(req.getParams().get("ALFRESCO_JSON")));
        }
    }

    private ShardHandler getAndPrepShardHandler(SolrQueryRequest req, ResponseBuilder rb) {
        ShardHandler shardHandler = null;
        rb.isDistrib = req.getParams().getBool("distrib", req.getCore().getCoreContainer().isZooKeeperAware());
        if (!rb.isDistrib) {
            String shards = req.getParams().get("shards");
            boolean bl = rb.isDistrib = shards != null && shards.indexOf(47) > 0;
        }
        if (rb.isDistrib) {
            shardHandler = this.shardHandlerFactory.getShardHandler();
            shardHandler.prepDistributed(rb);
            if (!rb.isDistrib) {
                shardHandler = null;
            }
        }
        return shardHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        this.readJsonIntoContent(req);
        List<SearchComponent> components = this.getComponents();
        ResponseBuilder rb = new ResponseBuilder(req, rsp, components);
        if (rb.requestInfo != null) {
            rb.requestInfo.setResponseBuilder(rb);
        }
        boolean dbg = req.getParams().getBool("debugQuery", false);
        rb.setDebug(dbg);
        if (!dbg) {
            SolrPluginUtils.getDebugInterests((String[])req.getParams().getParams("debug"), (ResponseBuilder)rb);
        }
        RTimerTree timer = rb.isDebug() ? req.getRequestTimer() : null;
        ShardHandler shardHandler1 = this.getAndPrepShardHandler(req, rb);
        if (timer == null) {
            for (SearchComponent searchComponent : components) {
                searchComponent.prepare(rb);
            }
        } else {
            RTimerTree subt = timer.sub("prepare");
            for (SearchComponent searchComponent : components) {
                rb.setTimer((RTimer)subt.sub(searchComponent.getName()));
                searchComponent.prepare(rb);
                rb.getTimer().stop();
            }
            subt.stop();
        }
        if (!rb.isDistrib) {
            long timeAllowed = req.getParams().getLong("timeAllowed", -1L);
            if (timeAllowed > 0L) {
                SolrQueryTimeoutImpl.set((Long)timeAllowed);
            }
            try {
                if (!rb.isDebug()) {
                    for (SearchComponent c : components) {
                        c.process(rb);
                    }
                } else {
                    RTimerTree rTimerTree = timer.sub("process");
                    for (SearchComponent c : components) {
                        rb.setTimer((RTimer)rTimerTree.sub(c.getName()));
                        c.process(rb);
                        rb.getTimer().stop();
                    }
                    rTimerTree.stop();
                    if (rb.isDebugTimings()) {
                        rb.addDebugInfo("timing", (Object)timer.asNamedList());
                    }
                }
            }
            catch (ExitableDirectoryReader.ExitingReaderException exitingReaderException) {
                log.warn("Query: " + req.getParamString() + "; " + exitingReaderException.getMessage());
                SolrDocumentList r = (SolrDocumentList)rb.rsp.getValues().get("response");
                if (r == null) {
                    r = new SolrDocumentList();
                }
                r.setNumFound(0L);
                rb.rsp.add("response", (Object)r);
                if (rb.isDebug()) {
                    NamedList debug = new NamedList();
                    debug.add("explain", (Object)new NamedList());
                    rb.rsp.add("debug", (Object)debug);
                }
                rb.rsp.getResponseHeader().add("partialResults", (Object)Boolean.TRUE);
            }
            finally {
                SolrQueryTimeoutImpl.reset();
            }
            if (req.getParams().getBool("alfresco.getSolrDocumentList", false)) {
                NamedList namedList = rsp.getValues();
                ResultContext response = (ResultContext)namedList.get("response");
                SolrDocumentList newResponse = new SolrDocumentList();
                DocList docs = response.getDocList();
                DocIterator it = docs.iterator();
                while (it.hasNext()) {
                    newResponse.add((Object)this.toSolrDocument(req.getSearcher().doc(it.nextDoc()), req.getSchema()));
                }
                namedList.add("responseSolrDocumentList", (Object)newResponse);
            }
        } else {
            if (rb.outgoing == null) {
                rb.outgoing = new LinkedList();
            }
            rb.finished = new ArrayList();
            int nextStage = 0;
            do {
                rb.stage = nextStage;
                nextStage = ResponseBuilder.STAGE_DONE;
                for (SearchComponent searchComponent : components) {
                    nextStage = Math.min(nextStage, searchComponent.distributedProcess(rb));
                }
                while (rb.outgoing.size() > 0) {
                    ShardResponse shardResponse;
                    while (rb.outgoing.size() > 0) {
                        ShardRequest shardRequest = (ShardRequest)rb.outgoing.remove(0);
                        shardRequest.actualShards = shardRequest.shards;
                        if (shardRequest.actualShards == ShardRequest.ALL_SHARDS) {
                            shardRequest.actualShards = rb.shards;
                        }
                        shardRequest.responses = new ArrayList(shardRequest.actualShards.length);
                        for (String shard : shardRequest.actualShards) {
                            String shardQt;
                            ModifiableSolrParams params = new ModifiableSolrParams((SolrParams)shardRequest.params);
                            params.remove("shards");
                            params.set("distrib", new String[]{"false"});
                            params.remove("indent");
                            params.remove("echoParams");
                            params.set("isShard", true);
                            params.set("shards.purpose", shardRequest.purpose);
                            params.set("shard.url", new String[]{shard});
                            if (req.getContext().get("ALFRESCO_JSON") != null) {
                                params.set("ALFRESCO_JSON", new String[]{req.getContext().get("ALFRESCO_JSON").toString()});
                            }
                            if (rb.requestInfo != null) {
                                params.set("NOW", new String[]{Long.toString(rb.requestInfo.getNOW().getTime())});
                            }
                            if ((shardQt = params.get("shards.qt")) != null) {
                                params.set("qt", new String[]{shardQt});
                            } else if (req.getCore().getSolrConfig().luceneMatchVersion.onOrAfter(Version.LATEST)) {
                                String reqPath = (String)req.getContext().get("path");
                                if (!"/select".equals(reqPath)) {
                                    params.set("qt", new String[]{reqPath});
                                }
                            } else {
                                params.remove("qt");
                            }
                            shardHandler1.submit(shardRequest, shard, params);
                        }
                    }
                    boolean bl = rb.req.getParams().getBool("shards.tolerant", false);
                    while (rb.outgoing.size() == 0 && (shardResponse = bl ? shardHandler1.takeCompletedIncludingErrors() : shardHandler1.takeCompletedOrError()) != null) {
                        if (shardResponse.getException() != null) {
                            if (!bl) {
                                shardHandler1.cancelAll();
                                if (shardResponse.getException() instanceof SolrException) {
                                    throw (SolrException)shardResponse.getException();
                                }
                                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, shardResponse.getException());
                            }
                            if (rsp.getResponseHeader().get("partialResults") == null) {
                                rsp.getResponseHeader().add("partialResults", (Object)Boolean.TRUE);
                            }
                        }
                        rb.finished.add(shardResponse.getShardRequest());
                        for (SearchComponent c : components) {
                            c.handleResponses(rb, shardResponse.getShardRequest());
                        }
                    }
                }
                for (SearchComponent searchComponent : components) {
                    searchComponent.finishStage(rb);
                }
            } while (nextStage != Integer.MAX_VALUE);
        }
        if (!rb.isDistrib && req.getParams().getBool("shards.info", false) && rb.shortCircuitedURL != null) {
            SimpleOrderedMap shardInfo = new SimpleOrderedMap();
            SimpleOrderedMap simpleOrderedMap = new SimpleOrderedMap();
            if (rsp.getException() != null) {
                void var10_38;
                Exception exception = rsp.getException();
                if (exception instanceof SolrServerException) {
                    Throwable throwable = ((SolrServerException)exception).getRootCause();
                } else if (exception.getCause() != null) {
                    Throwable throwable = exception.getCause();
                }
                simpleOrderedMap.add("error", (Object)var10_38.toString());
                StringWriter trace = new StringWriter();
                var10_38.printStackTrace(new PrintWriter(trace));
                simpleOrderedMap.add("trace", (Object)trace.toString());
            } else {
                simpleOrderedMap.add("numFound", (Object)rb.getResults().docList.matches());
                simpleOrderedMap.add("maxScore", (Object)Float.valueOf(rb.getResults().docList.maxScore()));
            }
            simpleOrderedMap.add("shardAddress", (Object)rb.shortCircuitedURL);
            simpleOrderedMap.add("time", (Object)req.getRequestTimer().getTime());
            int n = rb.shortCircuitedURL.indexOf("://");
            String shardInfoName = n != -1 ? rb.shortCircuitedURL.substring(n + 3) : rb.shortCircuitedURL;
            shardInfo.add(shardInfoName, (Object)simpleOrderedMap);
            rsp.getValues().add("shards.info", (Object)shardInfo);
        }
        AlfrescoSearchHandler.removeFacetQueriesWithCountZero(rsp);
    }

    public static void removeFacetQueriesWithCountZero(SolrQueryResponse rsp) {
        NamedList facetQueries;
        NamedList facetCounts = (NamedList)rsp.getValues().get(FACET_COUNTS_KEY);
        if (facetCounts != null && (facetQueries = (NamedList)facetCounts.get("facet_queries")) != null) {
            ArrayList keyCountsToRemove = new ArrayList();
            facetQueries.forEach(facetQuery -> {
                if ((Integer)facetQuery.getValue() == 0) {
                    keyCountsToRemove.add((String)facetQuery.getKey());
                }
            });
            if (!keyCountsToRemove.isEmpty()) {
                keyCountsToRemove.forEach(key -> facetQueries.remove(key));
                ((NamedList)rsp.getValues().get(FACET_COUNTS_KEY)).remove("facet_queries");
                ((NamedList)rsp.getValues().get(FACET_COUNTS_KEY)).add("facet_queries", (Object)facetQueries);
                BasicResultContext result = (BasicResultContext)rsp.getResponse();
                FacetComponent.FacetContext facetContext = (FacetComponent.FacetContext)result.getRequest().getContext().get(FACET_CONTEXT_KEY);
                facetContext.getAllQueryFacets().removeIf(queryFacet -> keyCountsToRemove.contains(queryFacet.getKey()));
                result.getRequest().getContext().put(FACET_CONTEXT_KEY, facetContext);
                log.debug("In SOLR query '" + String.valueOf(result.getRequest()) + "', Facet Queries results having labels " + String.valueOf(keyCountsToRemove) + " have been removed from results");
            }
        }
    }

    public String getDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search using components: ");
        if (this.components != null) {
            for (SearchComponent c : this.components) {
                sb.append(c.getName());
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public final SolrDocument toSolrDocument(Document doc, IndexSchema schema) {
        SolrDocument out = new SolrDocument();
        for (IndexableField f : doc) {
            Object existing = out.get((Object)f.name());
            if (existing == null) {
                SchemaField sf = schema.getFieldOrNull(f.name());
                if (sf != null && sf.multiValued()) {
                    ArrayList<IndexableField> vals = new ArrayList<IndexableField>();
                    vals.add(f);
                    out.setField(f.name(), vals);
                    continue;
                }
                out.setField(f.name(), (Object)f);
                continue;
            }
            out.addField(f.name(), (Object)f);
        }
        return out;
    }
}

