/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.alfresco.solr.AlfrescoSolrDataModel;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.lucene.search.highlight.WeightedSpanTermExtractor;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.SolrCore;
import org.apache.solr.highlight.DefaultSolrHighlighter;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.DocList;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.util.plugin.PluginInfoInitialized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlfrescoSolrHighlighter
extends DefaultSolrHighlighter
implements PluginInfoInitialized {
    private static final Logger LOGGER = LoggerFactory.getLogger(AlfrescoSolrHighlighter.class);
    private final Predicate<NamedList<Object>> notNullAndNotEmpty = response -> response != null && response.size() > 0;

    public AlfrescoSolrHighlighter(SolrCore core) {
        super(core);
    }

    protected Highlighter getHighlighter(Query query, String requestFieldname, SolrQueryRequest request) {
        String schemaFieldName = AlfrescoSolrDataModel.getInstance().mapProperty(requestFieldname, AlfrescoSolrDataModel.FieldUse.HIGHLIGHT, request);
        Highlighter highlighter = new Highlighter(this.getFormatter(requestFieldname, request.getParams()), this.getEncoder(requestFieldname, request.getParams()), this.getQueryScorer(query, schemaFieldName, request));
        highlighter.setTextFragmenter(this.getFragmenter(requestFieldname, request.getParams()));
        return highlighter;
    }

    protected QueryScorer getSpanQueryScorer(Query query, String requestFieldname, TokenStream tokenStream, SolrQueryRequest request) {
        String localFieldName = requestFieldname.substring(requestFieldname.lastIndexOf("}") + 1);
        String schemaFieldName = AlfrescoSolrDataModel.getInstance().mapProperty(localFieldName, AlfrescoSolrDataModel.FieldUse.FTS, request);
        if (!schemaFieldName.contains("_t@{")) {
            schemaFieldName = AlfrescoSolrDataModel.getInstance().mapProperty(localFieldName, AlfrescoSolrDataModel.FieldUse.FTS, request, 1);
        }
        QueryScorer scorer = new QueryScorer(query, request.getParams().getFieldBool(requestFieldname, "hl.requireFieldMatch", false) ? schemaFieldName : null){

            protected WeightedSpanTermExtractor newTermExtractor(String defaultField) {
                return new WeightedSpanTermExtractor(defaultField){

                    protected void extractWeightedTerms(Map<String, WeightedSpanTerm> terms, Query query, float boost) throws IOException {
                        super.extractWeightedTerms(terms, query, boost);
                        List<WeightedSpanTerm> termsWithoutLocale = terms.values().stream().peek(term -> term.setTerm(this.withoutLocalePrefixMarker(term.getTerm()))).collect(Collectors.toList());
                        terms.clear();
                        termsWithoutLocale.forEach(term -> terms.put(term.getTerm(), (WeightedSpanTerm)term));
                    }
                };
            }

            private String withoutLocalePrefixMarker(String text) {
                int endIndexOfMarker;
                if (text == null) {
                    return null;
                }
                int startIndexOfMarker = text.indexOf("{");
                if (startIndexOfMarker == 0 && (endIndexOfMarker = text.indexOf("}")) != -1 && text.length() > endIndexOfMarker + 1) {
                    return text.substring(endIndexOfMarker + 1);
                }
                return text;
            }
        };
        scorer.setExpandMultiTermQuery(request.getParams().getBool("hl.highlightMultiTerm", true));
        boolean defaultPayloads = true;
        try {
            Terms terms = request.getSearcher().getSlowAtomicReader().fields().terms(schemaFieldName);
            if (terms != null) {
                defaultPayloads = terms.hasPayloads();
            }
        }
        catch (IOException e) {
            LOGGER.error("Couldn't check for existence of payloads", (Throwable)e);
        }
        scorer.setUsePayloads(request.getParams().getFieldBool(requestFieldname, "hl.payloads", defaultPayloads));
        return scorer;
    }

    public NamedList<Object> doHighlighting(DocList docs, Query query, SolrQueryRequest request, String[] defaultFields) throws IOException {
        String idFieldName = request.getSchema().getUniqueKeyField().getName();
        Set<String> idFields = Set.of(idFieldName, "DBID");
        SolrParams originalRequestParameters = request.getParams();
        List<String> highlightFields = Arrays.stream(super.getHighlightFields(query, request, defaultFields)).collect(Collectors.toList());
        Map<String, String> mappings = this.withDebug(this.createInitialFieldMappings(request, highlightFields));
        Iterable iterable = () -> ((DocList)docs).iterator();
        Map<String, DocumentIdentifiers> identifiers = StreamSupport.stream(iterable.spliterator(), false).map(docid -> this.identifiersEntry(request.getSearcher(), (int)docid, idFields, idFieldName)).filter(Objects::nonNull).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        request.setParams(this.rewrite(originalRequestParameters, mappings, String.join((CharSequence)",", mappings.keySet())));
        NamedList highlightingResponse = super.doHighlighting(docs, query, request, defaultFields);
        SimpleOrderedMap response = new SimpleOrderedMap();
        highlightingResponse.forEach(arg_0 -> this.lambda$doHighlighting$4(identifiers, mappings, (NamedList)response, arg_0));
        return response;
    }

    private void detectAndRemoveLocalePrefix(Map.Entry<String, Object> highlightFieldEntry) {
        int pos;
        String[] snippets;
        if (highlightFieldEntry.getValue() instanceof String[] && (snippets = (String[])highlightFieldEntry.getValue()) != null && snippets.length > 0 && snippets[0] != null && snippets[0].charAt(0) == '\u0000' && (pos = snippets[0].indexOf(0, 1)) != -1) {
            snippets[0] = snippets[0].substring(pos + 1);
        }
    }

    private AbstractMap.SimpleEntry<String, DocumentIdentifiers> identifiersEntry(SolrIndexSearcher searcher, int docid, Set<String> idFields, String idFieldName) {
        try {
            Document doc = searcher.doc(docid, idFields);
            String solrId = doc.get(idFieldName);
            return new AbstractMap.SimpleEntry<String, DocumentIdentifiers>(solrId, new DocumentIdentifiers(solrId, doc.get("DBID")));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void rewriteLocalFieldParameters(ModifiableSolrParams newParams, SolrParams previousParams, String fieldName, String schemaFieldName) {
        this.rewriteHighlightFieldOptions(newParams, previousParams, "hl.simple.pre", fieldName, schemaFieldName);
        this.rewriteHighlightFieldOptions(newParams, previousParams, "hl.simple.post", fieldName, schemaFieldName);
        this.rewriteHighlightFieldOptions(newParams, previousParams, "hl.fragsize", fieldName, schemaFieldName);
        this.rewriteHighlightFieldOptions(newParams, previousParams, "hl.mergeContiguous", fieldName, schemaFieldName);
        this.rewriteHighlightFieldOptions(newParams, previousParams, "hl.snippets", fieldName, schemaFieldName);
    }

    private void rewriteHighlightFieldOptions(ModifiableSolrParams fixed, SolrParams params, String paramName, String oldField, String newField) {
        Iterator it = params.getParameterNamesIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.startsWith("f.")) continue;
            if (name.endsWith("." + paramName)) {
                String source = name.substring(2, name.length() - paramName.length() - 1);
                if (source.equals(oldField)) {
                    fixed.set("f." + newField + "." + paramName, params.getParams(name));
                    continue;
                }
                fixed.set(name, params.getParams(name));
                continue;
            }
            fixed.set(name, params.getParams(name));
        }
    }

    private SolrParams rewrite(SolrParams params, Map<String, String> mappings, String fields) {
        ModifiableSolrParams rewrittenParams = new ModifiableSolrParams(params).set("hl.fl", new String[]{fields});
        mappings.forEach((key, value) -> this.rewriteLocalFieldParameters(rewrittenParams, params, (String)value, (String)key));
        return rewrittenParams;
    }

    private Map<String, String> withDebug(Map<String, String> mappings) {
        if (LOGGER.isDebugEnabled()) {
            mappings.forEach((solrField, requestField) -> LOGGER.debug("Request field {} has been mapped to {}", requestField, solrField));
        }
        return mappings;
    }

    private Map<String, String> createInitialFieldMappings(SolrQueryRequest request, List<String> requestedHighlightFields) {
        return requestedHighlightFields.stream().map(requestFieldName -> new AbstractMap.SimpleEntry<String, String>(AlfrescoSolrDataModel.getInstance().mapProperty((String)requestFieldName, AlfrescoSolrDataModel.FieldUse.HIGHLIGHT, request), (String)requestFieldName)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (prev, next) -> next, HashMap::new));
    }

    private /* synthetic */ void lambda$doHighlighting$4(Map identifiers, Map mappings, NamedList response, Map.Entry entry) {
        String id = (String)entry.getKey();
        NamedList documentHighlighting = (NamedList)entry.getValue();
        SimpleOrderedMap renamedDocumentHighlighting = new SimpleOrderedMap();
        if (this.notNullAndNotEmpty.test((NamedList<Object>)documentHighlighting)) {
            Optional.ofNullable((DocumentIdentifiers)identifiers.get(id)).map(DocumentIdentifiers::dbid).ifPresent(arg_0 -> AlfrescoSolrHighlighter.lambda$doHighlighting$2((NamedList)renamedDocumentHighlighting, arg_0));
        }
        documentHighlighting.forEach(arg_0 -> this.lambda$doHighlighting$3(mappings, (NamedList)renamedDocumentHighlighting, arg_0));
        response.add(id, (Object)renamedDocumentHighlighting);
    }

    private /* synthetic */ void lambda$doHighlighting$3(Map mappings, NamedList renamedDocumentHighlighting, Map.Entry fieldEntry) {
        this.detectAndRemoveLocalePrefix(fieldEntry);
        String solrFieldName = (String)fieldEntry.getKey();
        String requestFieldName = (String)mappings.get(solrFieldName);
        renamedDocumentHighlighting.add(requestFieldName, fieldEntry.getValue());
    }

    private static /* synthetic */ void lambda$doHighlighting$2(NamedList renamedDocumentHighlighting, String dbid) {
        renamedDocumentHighlighting.add("DBID", (Object)dbid);
    }

    private static class DocumentIdentifiers {
        final String solrId;
        final String dbid;

        private DocumentIdentifiers(String solrId, String dbid) {
            this.solrId = solrId;
            this.dbid = dbid;
        }

        String dbid() {
            return this.dbid;
        }

        public boolean equals(Object obj) {
            return obj instanceof DocumentIdentifiers && ((DocumentIdentifiers)obj).solrId.equals(this.solrId);
        }

        public int hashCode() {
            return Objects.hash(this.solrId);
        }
    }
}

