/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.resource;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.carrot2.util.StreamUtils;
import org.carrot2.util.resource.IResource;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Commit;

@Root(name="file-resource")
@JsonAutoDetect(creatorVisibility=JsonAutoDetect.Visibility.NONE, fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public final class FileResource
implements IResource {
    private Path file;
    @Attribute(name="absolute-path")
    private String info;

    FileResource() {
    }

    @Deprecated
    public FileResource(File file) {
        this(file.toPath());
    }

    public FileResource(Path file) {
        this.file = file;
        this.info = file.toAbsolutePath().toString();
    }

    @Override
    public InputStream open() throws IOException {
        return StreamUtils.prefetch(Files.newInputStream(this.file, new OpenOption[0]));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FileResource) {
            return ((FileResource)obj).file.equals(this.file);
        }
        return false;
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public String toString() {
        return this.info;
    }

    @Commit
    void afterDeserialization() {
        this.file = Paths.get(this.info, new String[0]);
    }

    @JsonIgnore
    @Deprecated
    public File getFile() {
        return this.file.toFile();
    }

    public String getFileName() {
        Path p = this.file.getFileName();
        if (p != null) {
            return p.toString();
        }
        return this.file.toString();
    }

    @JsonProperty
    private String getAbsolutePath() {
        return this.info;
    }

    public static FileResource valueOf(String path) {
        try {
            Path p = Paths.get(path, new String[0]);
            if (Files.exists(p, new LinkOption[0])) {
                return new FileResource(p);
            }
            return null;
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    public Path getPath() {
        return this.file;
    }
}

