/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.solr.common.SolrException;
import org.apache.solr.core.PluginBag;
import org.apache.solr.core.SolrResourceLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemClassLoader
extends ClassLoader
implements AutoCloseable,
ResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean allJarsLoaded = false;
    private final SolrResourceLoader parentLoader;
    private List<PluginBag.RuntimeLib> libs = new ArrayList<PluginBag.RuntimeLib>();
    private Map<String, Class> classCache = new HashMap<String, Class>();

    public MemClassLoader(List<PluginBag.RuntimeLib> libs, SolrResourceLoader resourceLoader) {
        this.parentLoader = resourceLoader;
        this.libs = libs;
    }

    public synchronized void loadJars() {
        if (this.allJarsLoaded) {
            return;
        }
        for (PluginBag.RuntimeLib lib : this.libs) {
            try {
                lib.loadJar();
                lib.verify();
            }
            catch (Exception exception) {
                if (exception instanceof SolrException) {
                    throw (SolrException)((Object)exception);
                }
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Atleast one runtimeLib could not be loaded", (Throwable)exception);
            }
        }
        this.allJarsLoaded = true;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (!this.allJarsLoaded) {
            this.loadJars();
        }
        try {
            return this.parentLoader.findClass(name, Object.class);
        }
        catch (Exception e) {
            return this.loadFromRuntimeLibs(name);
        }
    }

    private synchronized Class<?> loadFromRuntimeLibs(String name) throws ClassNotFoundException {
        Class<?> result = this.classCache.get(name);
        if (result != null) {
            return result;
        }
        AtomicReference<String> jarName = new AtomicReference<String>();
        ByteBuffer buf = null;
        try {
            buf = this.getByteBuffer(name, jarName);
        }
        catch (Exception e) {
            throw new ClassNotFoundException("class could not be loaded " + name, e);
        }
        if (buf == null) {
            throw new ClassNotFoundException("Class not found :" + name);
        }
        ProtectionDomain defaultDomain = null;
        try {
            defaultDomain = new ProtectionDomain(new CodeSource(new URL("http://localhost/.system/blob/" + jarName.get()), (Certificate[])null), null);
        }
        catch (MalformedURLException mue) {
            throw new ClassNotFoundException("Unexpected exception ", mue);
        }
        log.info("Defining_class {} from runtime jar {} ", (Object)name, jarName);
        result = this.defineClass(name, buf.array(), buf.arrayOffset(), buf.limit(), defaultDomain);
        this.classCache.put(name, result);
        return result;
    }

    private ByteBuffer getByteBuffer(String name, AtomicReference<String> jarName) throws Exception {
        if (!this.allJarsLoaded) {
            this.loadJars();
        }
        String path = name.replace('.', '/').concat(".class");
        ByteBuffer buf = null;
        for (PluginBag.RuntimeLib lib : this.libs) {
            try {
                buf = lib.getFileContent(path);
                if (buf == null) continue;
                jarName.set(lib.getName());
                break;
            }
            catch (Exception exp) {
                throw new ClassNotFoundException("Unable to load class :" + name, exp);
            }
        }
        return buf;
    }

    @Override
    public void close() throws Exception {
        for (PluginBag.RuntimeLib lib : this.libs) {
            try {
                lib.close();
            }
            catch (Exception exception) {}
        }
    }

    public InputStream openResource(String resource) throws IOException {
        AtomicReference<String> jarName = new AtomicReference<String>();
        try {
            ByteBuffer buf = this.getByteBuffer(resource, jarName);
            if (buf == null) {
                throw new IOException("Resource could not be found " + resource);
            }
        }
        catch (Exception e) {
            throw new IOException("Resource could not be found " + resource, e);
        }
        return null;
    }

    public <T> Class<? extends T> findClass(String cname, Class<T> expectedType) {
        if (!this.allJarsLoaded) {
            this.loadJars();
        }
        try {
            return this.findClass(cname).asSubclass(expectedType);
        }
        catch (Exception e) {
            if (e instanceof SolrException) {
                throw (SolrException)((Object)e);
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "error loading class " + cname, (Throwable)e);
        }
    }

    public <T> T newInstance(String cname, Class<T> expectedType) {
        try {
            return this.findClass(cname, expectedType).newInstance();
        }
        catch (SolrException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "error instantiating class :" + cname, (Throwable)e);
        }
    }
}

