/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.store.Directory;
import org.apache.solr.cloud.ZkController;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.params.CoreAdminParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.DirectoryFactory;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.snapshots.SolrSnapshotMetaDataManager;
import org.apache.solr.handler.admin.BackupCoreOp;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.handler.admin.CreateSnapshotOp;
import org.apache.solr.handler.admin.DeleteSnapshotOp;
import org.apache.solr.handler.admin.InvokeOp;
import org.apache.solr.handler.admin.LukeRequestHandler;
import org.apache.solr.handler.admin.MergeIndexesOp;
import org.apache.solr.handler.admin.PrepRecoveryOp;
import org.apache.solr.handler.admin.RequestApplyUpdatesOp;
import org.apache.solr.handler.admin.RequestSyncShardOp;
import org.apache.solr.handler.admin.RestoreCoreOp;
import org.apache.solr.handler.admin.SplitOp;
import org.apache.solr.handler.admin.StatusOp;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.UpdateLog;
import org.apache.solr.util.NumberUtils;
import org.apache.solr.util.PropertiesUtil;
import org.apache.solr.util.RefCounted;
import org.apache.solr.util.TestInjection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CoreAdminOperation
extends Enum<CoreAdminOperation>
implements CoreAdminHandler.CoreAdminOp {
    public static final /* enum */ CoreAdminOperation CREATE_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.CREATE, it -> {
        assert (TestInjection.injectRandomDelayInCoreCreation());
        SolrParams params = it.req.getParams();
        CoreAdminOperation.log().info("core create command {}", (Object)params);
        String coreName = params.required().get("name");
        Map<String, String> coreParams = CoreAdminHandler.buildCoreParams(params);
        CoreContainer coreContainer = it.handler.coreContainer;
        Path instancePath = coreContainer.getCoreRootDirectory().resolve(coreName);
        String instanceDir = it.req.getParams().get("instanceDir");
        if (instanceDir == null) {
            instanceDir = it.req.getParams().get("property.instanceDir");
        }
        if (instanceDir != null) {
            instanceDir = PropertiesUtil.substituteProperty(instanceDir, coreContainer.getContainerProperties());
            instancePath = coreContainer.getCoreRootDirectory().resolve(instanceDir).normalize();
        }
        boolean newCollection = params.getBool("newCollection", false);
        coreContainer.create(coreName, instancePath, coreParams, newCollection);
        it.rsp.add("core", coreName);
    });
    public static final /* enum */ CoreAdminOperation UNLOAD_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.UNLOAD, it -> {
        SolrParams params = it.req.getParams();
        String cname = params.get("core");
        boolean deleteIndexDir = params.getBool("deleteIndex", false);
        boolean deleteDataDir = params.getBool("deleteDataDir", false);
        boolean deleteInstanceDir = params.getBool("deleteInstanceDir", false);
        it.handler.coreContainer.unload(cname, deleteIndexDir, deleteDataDir, deleteInstanceDir);
        assert (TestInjection.injectNonExistentCoreExceptionAfterUnload(cname));
    });
    public static final /* enum */ CoreAdminOperation RELOAD_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.RELOAD, it -> {
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        try {
            it.handler.coreContainer.reload(cname);
        }
        catch (Exception ex) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error handling 'reload' action", (Throwable)ex);
        }
    });
    public static final /* enum */ CoreAdminOperation STATUS_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.STATUS, new StatusOp());
    public static final /* enum */ CoreAdminOperation SWAP_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.SWAP, it -> {
        SolrParams params = it.req.getParams();
        String cname = params.get("core");
        String other = params.required().get("other");
        it.handler.coreContainer.swap(cname, other);
    });
    public static final /* enum */ CoreAdminOperation RENAME_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.RENAME, it -> {
        SolrParams params = it.req.getParams();
        String name = params.get("other");
        String cname = params.get("core");
        if (cname.equals(name)) {
            return;
        }
        it.handler.coreContainer.rename(cname, name);
    });
    public static final /* enum */ CoreAdminOperation MERGEINDEXES_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.MERGEINDEXES, new MergeIndexesOp());
    public static final /* enum */ CoreAdminOperation SPLIT_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.SPLIT, new SplitOp());
    public static final /* enum */ CoreAdminOperation PREPRECOVERY_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.PREPRECOVERY, new PrepRecoveryOp());
    public static final /* enum */ CoreAdminOperation REQUESTRECOVERY_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REQUESTRECOVERY, it -> {
        block7: {
            SolrParams params = it.req.getParams();
            String cname = params.get("core", "");
            CoreAdminOperation.log().info("It has been requested that we recover: core=" + cname);
            try (SolrCore core = it.handler.coreContainer.getCore(cname);){
                if (core != null) {
                    core.getUpdateHandler().getSolrCoreState().doRecovery(it.handler.coreContainer, core.getCoreDescriptor());
                    break block7;
                }
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to locate core " + cname);
            }
        }
    });
    public static final /* enum */ CoreAdminOperation REQUESTSYNCSHARD_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REQUESTSYNCSHARD, new RequestSyncShardOp());
    public static final /* enum */ CoreAdminOperation REQUESTBUFFERUPDATES_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REQUESTBUFFERUPDATES, it -> {
        SolrParams params = it.req.getParams();
        String cname = params.get("name", "");
        CoreAdminOperation.log().info("Starting to buffer updates on core:" + cname);
        try (SolrCore core = it.handler.coreContainer.getCore(cname);){
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Core [" + cname + "] does not exist");
            }
            UpdateLog updateLog = core.getUpdateHandler().getUpdateLog();
            if (updateLog.getState() != UpdateLog.State.ACTIVE) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Core " + cname + " not in active state");
            }
            updateLog.bufferUpdates();
            it.rsp.add("core", cname);
            it.rsp.add("status", "BUFFERING");
        }
        catch (Throwable e) {
            if (e instanceof SolrException) {
                throw (SolrException)e;
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Could not start buffering updates", e);
        }
        finally {
            if (it.req != null) {
                it.req.close();
            }
        }
    });
    public static final /* enum */ CoreAdminOperation REQUESTAPPLYUPDATES_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REQUESTAPPLYUPDATES, new RequestApplyUpdatesOp());
    public static final /* enum */ CoreAdminOperation REQUESTSTATUS_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REQUESTSTATUS, it -> {
        SolrParams params = it.req.getParams();
        String requestId = params.get("requestid");
        CoreAdminOperation.log().info("Checking request status for : " + requestId);
        if (it.handler.getRequestStatusMap(CoreAdminHandler.RUNNING).containsKey(requestId)) {
            it.rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.RUNNING);
        } else if (it.handler.getRequestStatusMap(CoreAdminHandler.COMPLETED).containsKey(requestId)) {
            it.rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.COMPLETED);
            it.rsp.add(CoreAdminHandler.RESPONSE, it.handler.getRequestStatusMap(CoreAdminHandler.COMPLETED).get(requestId).getRspObject());
        } else if (it.handler.getRequestStatusMap(CoreAdminHandler.FAILED).containsKey(requestId)) {
            it.rsp.add(CoreAdminHandler.RESPONSE_STATUS, CoreAdminHandler.FAILED);
            it.rsp.add(CoreAdminHandler.RESPONSE, it.handler.getRequestStatusMap(CoreAdminHandler.FAILED).get(requestId).getRspObject());
        } else {
            it.rsp.add(CoreAdminHandler.RESPONSE_STATUS, "notfound");
            it.rsp.add(CoreAdminHandler.RESPONSE_MESSAGE, "No task found in running, completed or failed tasks");
        }
    });
    public static final /* enum */ CoreAdminOperation OVERSEEROP_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.OVERSEEROP, it -> {
        ZkController zkController = it.handler.coreContainer.getZkController();
        if (zkController != null) {
            String op = it.req.getParams().get("op");
            String electionNode = it.req.getParams().get("electionNode");
            if (electionNode != null) {
                zkController.rejoinOverseerElection(electionNode, "rejoinAtHead".equals(op));
            } else {
                CoreAdminOperation.log().info("electionNode is required param");
            }
        }
    });
    public static final /* enum */ CoreAdminOperation REJOINLEADERELECTION_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.REJOINLEADERELECTION, it -> {
        ZkController zkController = it.handler.coreContainer.getZkController();
        if (zkController != null) {
            zkController.rejoinShardLeaderElection(it.req.getParams());
        } else {
            CoreAdminOperation.log().warn("zkController is null in CoreAdminHandler.handleRequestInternal:REJOINLEADERELECTION. No action taken.");
        }
    });
    public static final /* enum */ CoreAdminOperation INVOKE_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.INVOKE, new InvokeOp());
    public static final /* enum */ CoreAdminOperation FORCEPREPAREFORLEADERSHIP_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.FORCEPREPAREFORLEADERSHIP, it -> {
        SolrParams params = it.req.getParams();
        CoreAdminOperation.log().info("I have been forcefully prepare myself for leadership.");
        ZkController zkController = it.handler.coreContainer.getZkController();
        if (zkController == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Only valid for SolrCloud");
        }
        String cname = params.get("core");
        if (cname == null) {
            throw new IllegalArgumentException("core is required");
        }
        try (SolrCore core = it.handler.coreContainer.getCore(cname);){
            if (core != null) {
                core.getCoreDescriptor().getCloudDescriptor().setLastPublished(Replica.State.ACTIVE);
                CoreAdminOperation.log().info("Setting the last published state for this core, {}, to {}", (Object)core.getName(), (Object)Replica.State.ACTIVE);
            } else {
                SolrException.log((Logger)CoreAdminOperation.log(), (String)("Could not find core: " + cname));
            }
        }
    });
    public static final /* enum */ CoreAdminOperation BACKUPCORE_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.BACKUPCORE, new BackupCoreOp());
    public static final /* enum */ CoreAdminOperation RESTORECORE_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.RESTORECORE, new RestoreCoreOp());
    public static final /* enum */ CoreAdminOperation CREATESNAPSHOT_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.CREATESNAPSHOT, new CreateSnapshotOp());
    public static final /* enum */ CoreAdminOperation DELETESNAPSHOT_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.DELETESNAPSHOT, new DeleteSnapshotOp());
    public static final /* enum */ CoreAdminOperation LISTSNAPSHOTS_OP = new CoreAdminOperation(CoreAdminParams.CoreAdminAction.LISTSNAPSHOTS, it -> {
        CoreContainer cc = it.handler.getCoreContainer();
        SolrParams params = it.req.getParams();
        String cname = params.required().get("core");
        try (SolrCore core = cc.getCore(cname);){
            if (core == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unable to locate core " + cname);
            }
            SolrSnapshotMetaDataManager mgr = core.getSnapshotMetaDataManager();
            NamedList result = new NamedList();
            for (String name : mgr.listSnapshots()) {
                Optional<SolrSnapshotMetaDataManager.SnapshotMetaData> metadata = mgr.getSnapshotMetaData(name);
                if (!metadata.isPresent()) continue;
                NamedList props = new NamedList();
                props.add("generation", (Object)String.valueOf(metadata.get().getGenerationNumber()));
                props.add("indexDirPath", (Object)metadata.get().getIndexDirPath());
                result.add(name, (Object)props);
            }
            it.rsp.add("snapshots", result);
        }
    });
    final CoreAdminParams.CoreAdminAction action;
    final CoreAdminHandler.CoreAdminOp fun;
    private static final Logger log;
    private static final /* synthetic */ CoreAdminOperation[] $VALUES;

    public static CoreAdminOperation[] values() {
        return (CoreAdminOperation[])$VALUES.clone();
    }

    public static CoreAdminOperation valueOf(String name) {
        return Enum.valueOf(CoreAdminOperation.class, name);
    }

    private CoreAdminOperation(CoreAdminParams.CoreAdminAction action, CoreAdminHandler.CoreAdminOp fun) {
        this.action = action;
        this.fun = fun;
    }

    static Logger log() {
        return log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static NamedList<Object> getCoreStatus(CoreContainer cores, String cname, boolean isIndexInfoNeeded) throws IOException {
        SimpleOrderedMap info;
        block18: {
            info = new SimpleOrderedMap();
            if (cores.isCoreLoading(cname)) {
                info.add("name", (Object)cname);
                info.add("isLoaded", (Object)"false");
                info.add("isLoading", (Object)"true");
            } else if (!cores.isLoaded(cname)) {
                CoreDescriptor desc = cores.getUnloadedCoreDescriptor(cname);
                if (desc != null) {
                    info.add("name", (Object)desc.getName());
                    info.add("instanceDir", (Object)desc.getInstanceDir());
                    String tmp = desc.getDataDir();
                    if (StringUtils.isNotBlank((CharSequence)tmp)) {
                        info.add("dataDir", (Object)tmp);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(tmp = desc.getConfigName()))) {
                        info.add("config", (Object)tmp);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(tmp = desc.getSchemaName()))) {
                        info.add("schema", (Object)tmp);
                    }
                    info.add("isLoaded", (Object)"false");
                }
            } else {
                try (SolrCore core = cores.getCore(cname);){
                    if (core == null) break block18;
                    info.add("name", (Object)core.getName());
                    info.add("instanceDir", (Object)core.getResourceLoader().getInstancePath().toString());
                    info.add("dataDir", (Object)CoreAdminHandler.normalizePath(core.getDataDir()));
                    info.add("config", (Object)core.getConfigResource());
                    info.add("schema", (Object)core.getSchemaResource());
                    info.add("startTime", (Object)core.getStartTimeStamp());
                    info.add("uptime", (Object)core.getUptimeMs());
                    if (cores.isZooKeeperAware()) {
                        info.add("lastPublished", (Object)core.getCoreDescriptor().getCloudDescriptor().getLastPublished().toString().toLowerCase(Locale.ROOT));
                        info.add("configVersion", (Object)core.getSolrConfig().getZnodeVersion());
                        SimpleOrderedMap cloudInfo = new SimpleOrderedMap();
                        cloudInfo.add("collection", (Object)core.getCoreDescriptor().getCloudDescriptor().getCollectionName());
                        cloudInfo.add("shard", (Object)core.getCoreDescriptor().getCloudDescriptor().getShardId());
                        cloudInfo.add("replica", (Object)core.getCoreDescriptor().getCloudDescriptor().getCoreNodeName());
                        info.add("cloud", (Object)cloudInfo);
                    }
                    if (!isIndexInfoNeeded) break block18;
                    RefCounted<SolrIndexSearcher> searcher = core.getSearcher();
                    try {
                        SimpleOrderedMap<Object> indexInfo = LukeRequestHandler.getIndexInfo(searcher.get().getIndexReader());
                        long size = CoreAdminOperation.getIndexSize(core);
                        indexInfo.add("sizeInBytes", (Object)size);
                        indexInfo.add("size", (Object)NumberUtils.readableSize(size));
                        info.add("index", indexInfo);
                    }
                    finally {
                        searcher.decref();
                    }
                }
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long getIndexSize(SolrCore core) {
        long size = 0L;
        try {
            Directory dir = core.getDirectoryFactory().get(core.getIndexDir(), DirectoryFactory.DirContext.DEFAULT, core.getSolrConfig().indexConfig.lockType);
            try {
                size = core.getDirectoryFactory().size(dir);
            }
            finally {
                core.getDirectoryFactory().release(dir);
            }
        }
        catch (IOException e) {
            SolrException.log((Logger)log, (String)"IO error while trying to get the size of the Directory", (Throwable)e);
        }
        return size;
    }

    @Override
    public void execute(CoreAdminHandler.CallInfo it) throws Exception {
        this.fun.execute(it);
    }

    static {
        $VALUES = new CoreAdminOperation[]{CREATE_OP, UNLOAD_OP, RELOAD_OP, STATUS_OP, SWAP_OP, RENAME_OP, MERGEINDEXES_OP, SPLIT_OP, PREPRECOVERY_OP, REQUESTRECOVERY_OP, REQUESTSYNCSHARD_OP, REQUESTBUFFERUPDATES_OP, REQUESTAPPLYUPDATES_OP, REQUESTSTATUS_OP, OVERSEEROP_OP, REJOINLEADERELECTION_OP, INVOKE_OP, FORCEPREPAREFORLEADERSHIP_OP, BACKUPCORE_OP, RESTORECORE_OP, CREATESNAPSHOT_OP, DELETESNAPSHOT_OP, LISTSNAPSHOTS_OP};
        log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    }
}

