/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.nio.charset.Charset;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.handler.component.AbstractStatsValues;
import org.apache.solr.handler.component.StatsField;

class StringStatsValues
extends AbstractStatsValues<String> {
    public StringStatsValues(StatsField statsField) {
        super(statsField);
    }

    @Override
    public long hash(String v) {
        return this.hasher.hashString((CharSequence)v, Charset.defaultCharset()).asLong();
    }

    @Override
    public void accumulate(int docID) {
        if (this.values.exists(docID)) {
            String value = this.values.strVal(docID);
            if (value != null) {
                this.accumulate(value, 1);
            } else {
                this.missing();
            }
        } else {
            this.missing();
        }
    }

    @Override
    protected void updateTypeSpecificStats(NamedList stv) {
    }

    @Override
    protected void updateTypeSpecificStats(String value, int count) {
    }

    @Override
    protected void updateMinMax(String min, String max) {
        if (this.computeMin) {
            this.min = StringStatsValues.min((String)this.min, min);
        }
        if (this.computeMax) {
            this.max = StringStatsValues.max((String)this.max, max);
        }
    }

    @Override
    protected void addTypeSpecificStats(NamedList<Object> res) {
    }

    private static String max(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        return str1.compareTo(str2) > 0 ? str1 : str2;
    }

    private static String min(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        return str1.compareTo(str2) < 0 ? str1 : str2;
    }
}

