/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.solr.search.facet.FacetRequest;

public abstract class FacetMerger {
    public abstract void merge(Object var1, Context var2);

    public Map<String, Object> getRefinement(Context mcontext) {
        return null;
    }

    public abstract void finish(Context var1);

    public abstract Object getMergedResult();

    public static class Context {
        final int numShards;
        private final BitSet sawShard = new BitSet();
        private Map<String, Integer> shardmap = new HashMap<String, Integer>();
        Object root;
        int maxBucket;
        int shardNum = -1;
        boolean bucketWasMissing;
        private Map<FacetRequest, Collection<String>> refineSubMap = new IdentityHashMap<FacetRequest, Collection<String>>(4);
        private Map<FacetRequest, Collection<String>> partialSubsMap = new IdentityHashMap<FacetRequest, Collection<String>>(4);

        public Context(int numShards) {
            this.numShards = numShards;
        }

        public void newShard(String shard) {
            Integer prev = this.shardmap.put(shard, ++this.shardNum);
            assert (prev == null);
            this.bucketWasMissing = false;
        }

        public void setShard(String shard) {
            this.shardNum = this.shardmap.get(shard);
        }

        public int getNewBucketNumber() {
            return this.maxBucket++;
        }

        public void setShardFlag(int bucketNum) {
            this.sawShard.set(bucketNum * this.numShards + this.shardNum);
        }

        public boolean getShardFlag(int bucketNum) {
            return this.sawShard.get(bucketNum * this.numShards + this.shardNum);
        }

        public boolean bucketWasMissing() {
            return this.bucketWasMissing;
        }

        public boolean setBucketWasMissing(boolean newVal) {
            boolean oldVal = this.bucketWasMissing();
            this.bucketWasMissing = newVal;
            return oldVal;
        }

        public Collection<String> getSubsWithRefinement(FacetRequest freq) {
            if (freq.getSubFacets().isEmpty()) {
                return Collections.emptyList();
            }
            Collection<String> subs = this.refineSubMap.get(freq);
            if (subs != null) {
                return subs;
            }
            for (Map.Entry<String, FacetRequest> entry : freq.subFacets.entrySet()) {
                Collection<String> childSubs = this.getSubsWithRefinement(entry.getValue());
                if (childSubs.size() <= 0 && entry.getValue().getRefineMethod() != FacetRequest.RefineMethod.SIMPLE) continue;
                if (subs == null) {
                    subs = new ArrayList<String>(freq.getSubFacets().size());
                }
                subs.add(entry.getKey());
            }
            if (subs == null) {
                subs = Collections.emptyList();
            }
            this.refineSubMap.put(freq, subs);
            return subs;
        }

        public Collection<String> getSubsWithPartial(FacetRequest freq) {
            if (freq.getSubFacets().isEmpty()) {
                return Collections.emptyList();
            }
            Collection<String> subs = this.partialSubsMap.get(freq);
            if (subs != null) {
                return subs;
            }
            subs = null;
            for (Map.Entry<String, FacetRequest> entry : freq.subFacets.entrySet()) {
                Collection<String> childSubs = this.getSubsWithPartial(entry.getValue());
                if (childSubs.size() <= 0 && !entry.getValue().returnsPartial()) continue;
                if (subs == null) {
                    subs = new ArrayList<String>(freq.getSubFacets().size());
                }
                subs.add(entry.getKey());
            }
            if (subs == null) {
                subs = Collections.emptyList();
            }
            this.partialSubsMap.put(freq, subs);
            return subs;
        }
    }
}

