/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.util.attribute;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.carrot2.shaded.guava.common.base.Predicate;
import org.carrot2.shaded.guava.common.base.Predicates;
import org.carrot2.shaded.guava.common.base.Throwables;
import org.carrot2.shaded.guava.common.collect.ImmutableSet;
import org.carrot2.shaded.guava.common.collect.Maps;
import org.carrot2.shaded.guava.common.collect.Sets;
import org.carrot2.shaded.guava.common.primitives.Primitives;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeBindingException;
import org.carrot2.util.attribute.AttributeTransformerFactory;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.BindableDescriptorBuilder;
import org.carrot2.util.attribute.BindableUtils;
import org.carrot2.util.attribute.IAssignable;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Output;
import org.carrot2.util.attribute.Pair;
import org.carrot2.util.attribute.Required;
import org.carrot2.util.attribute.constraint.ConstraintValidator;
import org.carrot2.util.attribute.constraint.ConstraintViolationException;
import org.carrot2.util.attribute.constraint.ImplementingClasses;

public class AttributeBinder {
    private static final Predicate<Field> CONSISTENCY_CHECKS = Predicates.and((Predicate)new ConsistencyCheckRequiredAnnotations(), (Predicate)new ConsistencyCheckImplementingClasses());

    @SafeVarargs
    public static Map<String, Object> set(Object object, Map<String, Object> values, Class<? extends Annotation> ... filteringAnnotations) throws InstantiationException, AttributeBindingException {
        return AttributeBinder.set(object, values, true, filteringAnnotations);
    }

    @SafeVarargs
    public static <T> Map<String, Object> set(T object, Map<String, Object> values, boolean checkRequired, Class<? extends Annotation> ... filteringAnnotations) throws InstantiationException, AttributeBindingException {
        return AttributeBinder.set(object, values, checkRequired, filteringAnnotations.length > 0 ? new AllAnnotationsPresentPredicate(filteringAnnotations) : Predicates.alwaysTrue());
    }

    public static Map<String, Object> set(Object object, Map<String, Object> values, boolean checkRequired, Predicate<Field> predicate) throws InstantiationException, AttributeBindingException {
        AttributeBinderActionBind attributeBinderActionBind = new AttributeBinderActionBind(values, checkRequired, AttributeTransformerFromString.INSTANCE, AttributeTransformerFactory.INSTANCE);
        IAttributeBinderAction[] actions = new IAttributeBinderAction[]{attributeBinderActionBind};
        AttributeBinder.bind(object, actions, predicate);
        return attributeBinderActionBind.remainingValues;
    }

    @SafeVarargs
    public static void get(Object object, Map<String, Object> values, Class<? extends Annotation> ... filteringAnnotations) throws InstantiationException, AttributeBindingException {
        IAttributeBinderAction[] actions = new IAttributeBinderAction[]{new AttributeBinderActionCollect(values, new IAttributeTransformer[0])};
        AttributeBinder.bind(object, actions, filteringAnnotations);
    }

    @SafeVarargs
    public static void bind(Object object, IAttributeBinderAction[] attributeBinderActions, Class<? extends Annotation> ... filteringAnnotations) throws InstantiationException, AttributeBindingException {
        AttributeBinder.bind(object, attributeBinderActions, filteringAnnotations.length > 0 ? new AllAnnotationsPresentPredicate(filteringAnnotations) : Predicates.alwaysTrue());
    }

    public static void bind(Object object, IAttributeBinderAction[] attributeBinderActions, Predicate<Field> predicate) throws InstantiationException, AttributeBindingException {
        AttributeBinder.bind(new HashSet<Object>(), new BindingTracker(), 0, object, attributeBinderActions, (Predicate<Field>)Predicates.and(CONSISTENCY_CHECKS, predicate), Bindable.class);
    }

    static void bind(Object object, IAttributeBinderAction[] attributeBinderActions, Predicate<Field> predicate, Class<? extends Annotation> markerAnnotation) throws InstantiationException, AttributeBindingException {
        AttributeBinder.bind(new HashSet<Object>(), new BindingTracker(), 0, object, attributeBinderActions, predicate, markerAnnotation);
    }

    private static void bind(Set<Object> boundObjects, BindingTracker bindingTracker, int level, Object object, IAttributeBinderAction[] attributeBinderActions, Predicate<Field> predicate, Class<? extends Annotation> markerAnnotation) throws InstantiationException, AttributeBindingException {
        if (object.getClass().getAnnotation(markerAnnotation) == null) {
            throw new IllegalArgumentException("Class: " + object.getClass().getName() + " is not bindable, @" + markerAnnotation.getSimpleName() + " expected.");
        }
        boundObjects.add(object);
        Collection<Field> fieldSet = BindableUtils.getFieldsFromHierarchy(object.getClass(), markerAnnotation);
        for (Field field : fieldSet) {
            Object value = null;
            if (Modifier.isStatic(field.getModifiers())) continue;
            if (!Modifier.isPublic(field.getModifiers())) {
                if (field.getAnnotation(Attribute.class) != null) {
                    throw AttributeBindingException.createWithNoKey("Non-public attribute fields are no longer supported: " + field.getDeclaringClass().getName() + "#" + field.getName());
                }
                if (predicate.apply((Object)field)) {
                    throw AttributeBindingException.createWithNoKey("Non-public fields are no longer supported: " + field.getDeclaringClass().getName() + "#" + field.getName());
                }
                assert (BindableDescriptorBuilder.noHiddenBindables(field, object, markerAnnotation));
                continue;
            }
            try {
                value = field.get(object);
            }
            catch (IllegalAccessException e) {
                throw AttributeBindingException.createWithNoKey("Non-accessible field: " + object.getClass().getName() + "#" + field.getName(), e);
            }
            catch (Exception e) {
                throw AttributeBindingException.createWithNoKey("Could not get field value " + object.getClass().getName() + "#" + field.getName());
            }
            if (predicate.apply((Object)field)) {
                try {
                    for (int i = 0; i < attributeBinderActions.length; ++i) {
                        attributeBinderActions[i].performAction(bindingTracker, level, object, field, value, predicate);
                    }
                    value = field.get(object);
                }
                catch (ConstraintViolationException e) {
                    throw AttributeBindingException.createWithNoKey(e.getMessage(), e);
                }
                catch (AttributeBindingException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw AttributeBindingException.createWithNoKey("Could not get field value " + object.getClass().getName() + "#" + field.getName(), e);
                }
            }
            if (value == null || value.getClass().getAnnotation(markerAnnotation) == null) continue;
            if (boundObjects.contains(value)) {
                throw new UnsupportedOperationException("Circular references are not supported");
            }
            AttributeBinder.bind(boundObjects, bindingTracker, level + 1, value, attributeBinderActions, predicate, markerAnnotation);
        }
    }

    public static final class BindingTracker {
        private Map<String, Integer> bindingLevel = Maps.newHashMap();
        private Set<Pair<Object, String>> boundInstances = Sets.newHashSet();

        boolean canBind(Object instance, String key, int level) {
            boolean canBind;
            Pair<Object, String> pair = new Pair<Object, String>(instance, key);
            if (this.boundInstances.contains(pair)) {
                throw AttributeBindingException.createWithNoKey("Collecting values of multiple attributes with the same key (" + key + ") in the same instance of class (" + instance.getClass().getName() + ") is not allowed");
            }
            this.boundInstances.add(pair);
            Integer boundAtLevel = this.bindingLevel.get(key);
            boolean bl = canBind = boundAtLevel == null || boundAtLevel != null && boundAtLevel > level;
            if (canBind) {
                this.bindingLevel.put(key, level);
            }
            return canBind;
        }
    }

    static final class ConsistencyCheckImplementingClasses
    implements Predicate<Field> {
        static Set<Class<?>> ALLOWED_PLAIN_TYPES = ImmutableSet.of(File.class);
        static Set<Class<?>> ALLOWED_ASSIGNABLE_TYPES = ImmutableSet.of(Enum.class, IAssignable.class, Collection.class, Map.class);

        ConsistencyCheckImplementingClasses() {
        }

        public boolean apply(Field field) {
            if (field.getAnnotation(Input.class) == null) {
                return true;
            }
            Class attributeType = Primitives.wrap(field.getType());
            if (Modifier.isFinal(attributeType.getModifiers())) {
                return true;
            }
            if (!ALLOWED_PLAIN_TYPES.contains(attributeType) && !ConsistencyCheckImplementingClasses.isAllowedAssignableType(attributeType) && field.getAnnotation(ImplementingClasses.class) == null) {
                throw new IllegalArgumentException("Non-primitive typed attribute " + field.getDeclaringClass().getName() + "#" + field.getName() + " must have the @" + ImplementingClasses.class.getSimpleName() + " constraint.");
            }
            return true;
        }

        private static boolean isAllowedAssignableType(Class<?> attributeType) {
            for (Class<?> clazz : ALLOWED_ASSIGNABLE_TYPES) {
                if (!clazz.isAssignableFrom(attributeType)) continue;
                return true;
            }
            return false;
        }
    }

    static final class ConsistencyCheckRequiredAnnotations
    implements Predicate<Field> {
        ConsistencyCheckRequiredAnnotations() {
        }

        public boolean apply(Field field) {
            boolean hasBindingDirection;
            boolean hasAttribute = field.getAnnotation(Attribute.class) != null;
            boolean bl = hasBindingDirection = field.getAnnotation(Input.class) != null || field.getAnnotation(Output.class) != null;
            if (hasAttribute) {
                if (!hasBindingDirection) {
                    throw new IllegalArgumentException("Define binding direction annotation (@" + Input.class.getSimpleName() + " or @" + Output.class.getSimpleName() + ") for field " + field.getClass().getName() + "#" + field.getName());
                }
            } else if (hasBindingDirection) {
                throw new IllegalArgumentException("Binding  direction defined for a field (" + field.getClass() + "#" + field.getName() + ") that does not have an @" + Attribute.class.getSimpleName() + " annotation");
            }
            return hasAttribute;
        }
    }

    public static class AttributeBinderActionCollect
    implements IAttributeBinderAction {
        private final Map<String, Object> values;
        final IAttributeTransformer[] transformers;

        public AttributeBinderActionCollect(Map<String, Object> values, IAttributeTransformer ... transformers) {
            this.values = values;
            this.transformers = transformers;
        }

        @Override
        public void performAction(BindingTracker bindingTracker, int level, Object object, Field field, Object value, Predicate<Field> predicate) throws InstantiationException {
            String key = BindableUtils.getKey(field);
            try {
                for (IAttributeTransformer transformer : this.transformers) {
                    value = transformer.transform(value, key, field);
                }
                if (bindingTracker.canBind(object, key, level)) {
                    this.values.put(key, value);
                }
            }
            catch (Exception e) {
                throw new AttributeBindingException(key, "Could not get field value " + object.getClass().getName() + "#" + field.getName(), e);
            }
        }
    }

    public static class AttributeBinderActionBind
    implements IAttributeBinderAction {
        private final Map<String, Object> values;
        public final Map<String, Object> remainingValues;
        private final boolean checkRequired;
        private final IAttributeTransformer[] transformers;

        public AttributeBinderActionBind(Map<String, Object> values, boolean checkRequired, IAttributeTransformer ... transformers) {
            this.values = values;
            this.checkRequired = checkRequired;
            this.transformers = transformers;
            this.remainingValues = Maps.newHashMap(values);
        }

        @Override
        public void performAction(BindingTracker bindingTracker, int level, Object object, Field field, Object value, Predicate<Field> predicate) throws InstantiationException {
            Annotation[] unmetConstraints;
            boolean required = field.getAnnotation(Required.class) != null && this.checkRequired;
            Object currentValue = value;
            String key = BindableUtils.getKey(field);
            if (!this.values.containsKey(key)) {
                if (currentValue == null && required) {
                    throw new AttributeBindingException(key, "No value for required attribute: " + key + " (" + field.getDeclaringClass().getName() + "#" + field.getName() + ")");
                }
                return;
            }
            value = this.values.get(key);
            if (required && value == null) {
                throw new AttributeBindingException(key, "Not allowed to set required attribute to null: " + key);
            }
            for (IAttributeTransformer transformer : this.transformers) {
                value = transformer.transform(value, key, field);
            }
            if (Class.class.isInstance(value) && !field.getType().equals(Class.class)) {
                Class clazz = (Class)value;
                try {
                    value = clazz.newInstance();
                    if (clazz.isAnnotationPresent(Bindable.class)) {
                        AttributeBinder.set(value, this.values, false, predicate);
                    }
                }
                catch (Throwable e) {
                    String message = null;
                    if (e instanceof IllegalAccessException || e instanceof InstantiationException) {
                        message = this.detailedExceptionInfo(clazz);
                    }
                    InstantiationException ie = new InstantiationException("Could not create instance of class: " + clazz.getName() + " for attribute " + key + (message != null ? ": " + message : ""));
                    ie.initCause(e);
                    throw ie;
                }
            }
            if (value != null && (unmetConstraints = ConstraintValidator.isMet(value, field.getAnnotations())).length > 0) {
                throw new ConstraintViolationException(key, value, unmetConstraints);
            }
            try {
                field.set(object, value);
            }
            catch (Exception e) {
                throw new AttributeBindingException(key, "Could not assign field " + object.getClass().getName() + "#" + field.getName() + " with value " + value, e);
            }
            this.remainingValues.remove(key);
        }

        private String detailedExceptionInfo(Class<?> clazz) {
            if (!Modifier.isPublic(clazz.getModifiers())) {
                return "Class " + clazz.getName() + " is not public.";
            }
            if (clazz.isMemberClass() && !Modifier.isStatic(clazz.getModifiers())) {
                return "Nested class " + clazz.getName() + " is not static.";
            }
            try {
                clazz.getConstructor(new Class[0]);
            }
            catch (Exception e) {
                return "Class " + clazz.getName() + " must have a public parameterless constructor.";
            }
            return null;
        }
    }

    public static class AttributeTransformerFromString
    implements IAttributeTransformer {
        public static final AttributeTransformerFromString INSTANCE = new AttributeTransformerFromString();

        private AttributeTransformerFromString() {
        }

        @Override
        public Object transform(Object value, String key, Field field) {
            if (!(value instanceof String)) {
                return value;
            }
            String stringValue = (String)value;
            Class fieldType = Primitives.wrap(field.getType());
            if (String.class.equals((Object)fieldType)) {
                return stringValue;
            }
            Object convertedValue = null;
            convertedValue = this.callValueOf(stringValue, fieldType);
            if (convertedValue != null) {
                return convertedValue;
            }
            ImplementingClasses implementingClasses = field.getAnnotation(ImplementingClasses.class);
            if (implementingClasses != null) {
                Class<?>[] classes;
                for (Class<?> toClass : classes = implementingClasses.classes()) {
                    convertedValue = this.callValueOf(stringValue, toClass);
                    if (convertedValue == null) continue;
                    return convertedValue;
                }
            }
            if (implementingClasses != null && field.getType().isAssignableFrom(String.class) && ConstraintValidator.isMet(stringValue, implementingClasses).length == 0) {
                return stringValue;
            }
            try {
                return Class.forName(stringValue, true, Thread.currentThread().getContextClassLoader());
            }
            catch (SecurityException securityException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            return stringValue;
        }

        private Object callValueOf(String stringValue, Class<?> fieldType) {
            try {
                Method valueOfMethod = fieldType.getMethod("valueOf", String.class);
                return valueOfMethod.invoke(null, stringValue);
            }
            catch (NoSuchMethodException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("No access to valueOf() method in: " + fieldType.getName());
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof NumberFormatException) {
                    return null;
                }
                throw Throwables.propagate((Throwable)target);
            }
        }
    }

    public static interface IAttributeTransformer {
        public Object transform(Object var1, String var2, Field var3);
    }

    public static interface IAttributeBinderAction {
        public void performAction(BindingTracker var1, int var2, Object var3, Field var4, Object var5, Predicate<Field> var6) throws InstantiationException;
    }

    public static class AllAnnotationsPresentPredicate
    implements Predicate<Field> {
        private final Class<? extends Annotation>[] filteringAnnotations;

        @SafeVarargs
        public AllAnnotationsPresentPredicate(Class<? extends Annotation> ... filteringAnnotations) {
            this.filteringAnnotations = filteringAnnotations;
        }

        public boolean apply(Field field) {
            for (Class<? extends Annotation> annotation : this.filteringAnnotations) {
                if (field.getAnnotation(annotation) != null) continue;
                return false;
            }
            return true;
        }
    }
}

