/*
 * Decompiled with CFR 0.152.
 */
package org.carrot2.text.preprocessing.filter;

import org.carrot2.core.attribute.Processing;
import org.carrot2.text.linguistic.ILexicalData;
import org.carrot2.text.preprocessing.LabelFormatter;
import org.carrot2.text.preprocessing.PreprocessingContext;
import org.carrot2.text.preprocessing.filter.SingleLabelFilterBase;
import org.carrot2.util.attribute.Attribute;
import org.carrot2.util.attribute.AttributeLevel;
import org.carrot2.util.attribute.Bindable;
import org.carrot2.util.attribute.Group;
import org.carrot2.util.attribute.Input;
import org.carrot2.util.attribute.Label;
import org.carrot2.util.attribute.Level;

@Bindable(prefix="StopLabelFilter")
public class StopLabelFilter
extends SingleLabelFilterBase {
    @Input
    @Processing
    @Attribute
    @Label(value="Remove stop labels")
    @Level(value=AttributeLevel.BASIC)
    @Group(value="Labels")
    public boolean enabled = true;
    public final LabelFormatter labelFormatter = new LabelFormatter();
    public ILexicalData lexicalData;

    @Override
    public void filter(PreprocessingContext context, boolean[] acceptedStems, boolean[] acceptedPhrases) {
        this.lexicalData = context.language.getLexicalData();
        super.filter(context, acceptedStems, acceptedPhrases);
    }

    @Override
    public boolean acceptPhrase(PreprocessingContext context, int phraseIndex) {
        String formatedLabel = this.labelFormatter.format(context, phraseIndex + context.allWords.image.length);
        return !this.lexicalData.isStopLabel(formatedLabel);
    }

    @Override
    public boolean acceptWord(PreprocessingContext context, int wordIndex) {
        String formattedLabel = this.labelFormatter.format(context, wordIndex);
        return !this.lexicalData.isStopLabel(formattedLabel);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }
}

