/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.opencmis.dictionary;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.opencmis.dictionary.AbstractTypeDefinitionWrapper;
import org.alfresco.opencmis.dictionary.BasePropertyDefintionWrapper;
import org.alfresco.opencmis.dictionary.CMISDictionaryRegistry;
import org.alfresco.opencmis.dictionary.PropertyDefinitionWrapper;
import org.alfresco.opencmis.dictionary.TypeDefinitionWrapper;
import org.alfresco.opencmis.mapping.CMISMapping;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.QName;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;

public abstract class ShadowTypeDefinitionWrapper
extends AbstractTypeDefinitionWrapper {
    private static final long serialVersionUID = 1L;

    @Override
    public List<TypeDefinitionWrapper> connectParentAndSubTypes(CMISMapping cmisMapping, CMISDictionaryRegistry registry, DictionaryService dictionaryService) {
        String parentTypeId = this.typeDef.getParentTypeId();
        if (parentTypeId != null) {
            this.parent = registry.getTypeDefByTypeId(parentTypeId);
            if (registry.getTenant() != null && this.parent != null && registry.getTypeDefByTypeId(parentTypeId, false) == null) {
                registry.addChild(this.parent.getTypeId(), this);
            }
        } else {
            if (!this.isBaseType()) {
                throw new AlfrescoRuntimeException("Type " + this.typeDef.getId() + " has no parent!");
            }
            this.parent = null;
        }
        LinkedList<TypeDefinitionWrapper> children = new LinkedList<TypeDefinitionWrapper>();
        Collection<QName> childrenNames = dictionaryService.getSubTypes(cmisMapping.getAlfrescoClass(this.getAlfrescoName()), false);
        for (QName childName : childrenNames) {
            if (!cmisMapping.isValidCmisObject(this.getBaseTypeId(), childName)) continue;
            TypeDefinitionWrapper child = registry.getTypeDefByQName(childName);
            if (child == null) {
                throw new AlfrescoRuntimeException("Failed to retrieve sub type for type id " + childName + " for parent type " + this.getAlfrescoName() + "!");
            }
            children.add(child);
        }
        return children;
    }

    @Override
    public void resolveInheritance(CMISMapping cmisMapping, CMISDictionaryRegistry registry, DictionaryService dictionaryService) {
        if (this.parent != null) {
            for (PropertyDefinitionWrapper propDef : this.parent.getProperties(false)) {
                if (this.propertiesById.containsKey(propDef.getPropertyId())) continue;
                org.alfresco.service.cmr.dictionary.PropertyDefinition alfrescoPropDef = dictionaryService.getProperty(propDef.getOwningType().getAlfrescoName(), propDef.getAlfrescoName());
                PropertyDefinition<?> propertyDefintion = this.createPropertyDefinition(cmisMapping, propDef.getPropertyId(), alfrescoPropDef.getName(), dictionaryService, alfrescoPropDef, true);
                if (propertyDefintion == null) continue;
                this.registerProperty(new BasePropertyDefintionWrapper(propertyDefintion, alfrescoPropDef.getName(), propDef.getOwningType(), propDef.getPropertyAccessor(), propDef.getPropertyLuceneBuilder()));
            }
        }
        List<TypeDefinitionWrapper> children = registry.getChildren(this.typeDef.getId());
        for (TypeDefinitionWrapper child : children) {
            if (!(child instanceof AbstractTypeDefinitionWrapper)) continue;
            ((AbstractTypeDefinitionWrapper)child).resolveInheritance(cmisMapping, registry, dictionaryService);
        }
    }
}

