/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.zip.CRC32;
import org.alfresco.repo.dictionary.CompiledModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Aspect;
import org.alfresco.repo.dictionary.M2Class;
import org.alfresco.repo.dictionary.M2Constraint;
import org.alfresco.repo.dictionary.M2DataType;
import org.alfresco.repo.dictionary.M2Namespace;
import org.alfresco.repo.dictionary.M2Type;
import org.alfresco.repo.dictionary.NamespaceDAO;
import org.alfresco.service.cmr.dictionary.DictionaryException;
import org.alfresco.service.cmr.dictionary.ModelDefinition;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallable;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallable;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

public class M2Model
implements IUnmarshallable,
IMarshallable {
    private static final String ERR_PARSE_FAILURE = "d_dictionary.model.err.parse.failure";
    private static final String ERR_CREATE_M2MODEL_FAILURE = "d_dictionary.model.err.create_m2model.failure";
    private String name = null;
    private String description = null;
    private String author = null;
    private Date published = null;
    private String version;
    private String analyserResourceBundleName = null;
    private List<M2Namespace> namespaces = new ArrayList<M2Namespace>();
    private List<M2Namespace> imports = new ArrayList<M2Namespace>();
    private List<M2DataType> dataTypes = new ArrayList<M2DataType>();
    private List<M2Type> types = new ArrayList<M2Type>();
    private List<M2Aspect> aspects = new ArrayList<M2Aspect>();
    private List<M2Constraint> constraints = new ArrayList<M2Constraint>();
    public static final String JiBX_bindingList = "|org.alfresco.repo.dictionary.JiBX_defaultFactory|";

    M2Model() {
    }

    public static M2Model createModel(String name) {
        M2Model model = new M2Model();
        model.name = name;
        return model;
    }

    public static M2Model createModel(InputStream xml) {
        return M2Model.createModel("default", xml);
    }

    public static M2Model createModel(String bindingName, InputStream xml) {
        try {
            IBindingFactory factory = BindingDirectory.getFactory((String)bindingName, M2Model.class);
            IUnmarshallingContext context = factory.createUnmarshallingContext();
            Object obj = context.unmarshalDocument(xml, null);
            return (M2Model)obj;
        }
        catch (JiBXException e) {
            throw new DictionaryException(ERR_PARSE_FAILURE, e);
        }
    }

    public void toXML(OutputStream xml) {
        this.toXML(null, xml);
    }

    public void toXML(ModelDefinition.XMLBindingType bindingType, OutputStream xml) {
        try {
            String bindingName;
            if (bindingType == null) {
                bindingType = ModelDefinition.XMLBindingType.DEFAULT;
            }
            IBindingFactory factory = (bindingName = bindingType.toString()) != null ? BindingDirectory.getFactory((String)bindingName, M2Model.class) : BindingDirectory.getFactory((String)"default", M2Model.class);
            IMarshallingContext context = factory.createMarshallingContext();
            context.setIndent(4);
            context.marshalDocument((Object)this, "UTF-8", null, xml);
        }
        catch (JiBXException e) {
            throw new DictionaryException(ERR_CREATE_M2MODEL_FAILURE, e);
        }
    }

    public long getChecksum(ModelDefinition.XMLBindingType bindingType) {
        final CRC32 crc = new CRC32();
        this.toXML(bindingType, new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                crc.update(b);
            }
        });
        return crc.getValue();
    }

    public CompiledModel compile(DictionaryDAO dictionaryDAO, NamespaceDAO namespaceDAO, boolean enableConstraintClassLoading) {
        CompiledModel compiledModel = new CompiledModel(this, dictionaryDAO, namespaceDAO, enableConstraintClassLoading);
        return compiledModel;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public Date getPublishedDate() {
        return this.published;
    }

    public void setPublishedDate(Date published) {
        this.published = published;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public M2Type createType(String name) {
        M2Type type = new M2Type();
        type.setName(name);
        this.types.add(type);
        return type;
    }

    public void removeType(String name) {
        M2Type type = this.getType(name);
        if (type != null) {
            this.types.remove(type);
        }
    }

    public List<M2Type> getTypes() {
        return Collections.unmodifiableList(this.types);
    }

    public M2Type getType(String name) {
        for (M2Type candidate : this.types) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public M2Aspect createAspect(String name) {
        M2Aspect aspect = new M2Aspect();
        aspect.setName(name);
        this.aspects.add(aspect);
        return aspect;
    }

    public void removeAspect(String name) {
        M2Aspect aspect = this.getAspect(name);
        if (aspect != null) {
            this.aspects.remove(aspect);
        }
    }

    public List<M2Aspect> getAspects() {
        return Collections.unmodifiableList(this.aspects);
    }

    public M2Aspect getAspect(String name) {
        for (M2Aspect candidate : this.aspects) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public M2DataType createPropertyType(String name) {
        M2DataType type = new M2DataType();
        type.setName(name);
        this.dataTypes.add(type);
        return type;
    }

    public void removePropertyType(String name) {
        M2DataType type = this.getPropertyType(name);
        if (type != null) {
            this.dataTypes.remove(name);
        }
    }

    public List<M2DataType> getPropertyTypes() {
        return Collections.unmodifiableList(this.dataTypes);
    }

    public M2DataType getPropertyType(String name) {
        for (M2DataType candidate : this.dataTypes) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public M2Namespace createNamespace(String uri, String prefix) {
        M2Namespace namespace = new M2Namespace();
        namespace.setUri(uri);
        namespace.setPrefix(prefix);
        this.namespaces.add(namespace);
        return namespace;
    }

    public void removeNamespace(String uri) {
        M2Namespace namespace = this.getNamespace(uri);
        if (namespace != null) {
            this.namespaces.remove(namespace);
        }
    }

    public List<M2Namespace> getNamespaces() {
        return Collections.unmodifiableList(this.namespaces);
    }

    public M2Namespace getNamespace(String uri) {
        for (M2Namespace candidate : this.namespaces) {
            if (!candidate.getUri().equals(uri)) continue;
            return candidate;
        }
        return null;
    }

    public M2Namespace createImport(String uri, String prefix) {
        M2Namespace namespace = new M2Namespace();
        namespace.setUri(uri);
        namespace.setPrefix(prefix);
        this.imports.add(namespace);
        return namespace;
    }

    public void removeImport(String uri) {
        M2Namespace namespace = this.getImport(uri);
        if (namespace != null) {
            this.imports.remove(namespace);
        }
    }

    public List<M2Namespace> getImports() {
        return Collections.unmodifiableList(this.imports);
    }

    public M2Namespace getImport(String uri) {
        for (M2Namespace candidate : this.imports) {
            if (!candidate.getUri().equals(uri)) continue;
            return candidate;
        }
        return null;
    }

    public List<M2Constraint> getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public M2Constraint getConstraint(String name) {
        for (M2Constraint candidate : this.constraints) {
            if (!candidate.getName().equals(name)) continue;
            return candidate;
        }
        return null;
    }

    public M2Constraint createConstraint(String name, String type) {
        M2Constraint constraint = new M2Constraint();
        constraint.setName(name);
        constraint.setType(type);
        this.constraints.add(constraint);
        return constraint;
    }

    public void removeConstraint(String name) {
        M2Constraint constraint = this.getConstraint(name);
        if (constraint != null) {
            this.constraints.remove(constraint);
        }
    }

    public static List createList() {
        return new ArrayList();
    }

    public void setConfigProperties(Properties configProperties) {
        if (this.types != null) {
            for (M2Class m2Class : this.types) {
                m2Class.setConfigProperties(configProperties);
            }
        }
        if (this.aspects != null) {
            for (M2Class m2Class : this.aspects) {
                m2Class.setConfigProperties(configProperties);
            }
        }
    }

    public /* synthetic */ void JiBX_access_store_name_1_0(String arg1) {
        this.name = arg1;
    }

    public /* synthetic */ void JiBX_access_store_description_1_0(String arg1) {
        this.description = arg1;
    }

    public /* synthetic */ void JiBX_access_store_author_1_0(String arg1) {
        this.author = arg1;
    }

    public /* synthetic */ void JiBX_access_store_published_1_0(Date arg1) {
        this.published = arg1;
    }

    public /* synthetic */ void JiBX_access_store_version_1_0(String arg1) {
        this.version = arg1;
    }

    public /* synthetic */ void JiBX_access_store_analyserResourceBundleName_1_0(String arg1) {
        this.analyserResourceBundleName = arg1;
    }

    public /* synthetic */ List JiBX_access_load_imports_1_0() {
        return this.imports;
    }

    public /* synthetic */ void JiBX_access_store_imports_1_0(List arg1) {
        this.imports = arg1;
    }

    public /* synthetic */ List JiBX_access_load_namespaces_1_0() {
        return this.namespaces;
    }

    public /* synthetic */ void JiBX_access_store_namespaces_1_0(List arg1) {
        this.namespaces = arg1;
    }

    public /* synthetic */ List JiBX_access_load_dataTypes_1_0() {
        return this.dataTypes;
    }

    public /* synthetic */ void JiBX_access_store_dataTypes_1_0(List arg1) {
        this.dataTypes = arg1;
    }

    public /* synthetic */ List JiBX_access_load_constraints_1_0() {
        return this.constraints;
    }

    public /* synthetic */ void JiBX_access_store_constraints_1_0(List arg1) {
        this.constraints = arg1;
    }

    public /* synthetic */ List JiBX_access_load_types_1_0() {
        return this.types;
    }

    public /* synthetic */ void JiBX_access_store_types_1_0(List arg1) {
        this.types = arg1;
    }

    public /* synthetic */ List JiBX_access_load_aspects_1_0() {
        return this.aspects;
    }

    public /* synthetic */ void JiBX_access_store_aspects_1_0(List arg1) {
        this.aspects = arg1;
    }

    public /* synthetic */ void unmarshal(IUnmarshallingContext arg1) throws JiBXException {
        Object object = arg1.getUnmarshaller("org.alfresco.repo.dictionary.M2Model").unmarshal((Object)this, arg1);
    }

    public /* synthetic */ String JiBX_getName() {
        return "org.alfresco.repo.dictionary.M2Model";
    }

    public /* synthetic */ String JiBX_access_load_name_1_0() {
        return this.name;
    }

    public /* synthetic */ String JiBX_access_load_description_1_0() {
        return this.description;
    }

    public /* synthetic */ String JiBX_access_load_author_1_0() {
        return this.author;
    }

    public /* synthetic */ Date JiBX_access_load_published_1_0() {
        return this.published;
    }

    public /* synthetic */ String JiBX_access_load_version_1_0() {
        return this.version;
    }

    public /* synthetic */ String JiBX_access_load_analyserResourceBundleName_1_0() {
        return this.analyserResourceBundleName;
    }

    public /* synthetic */ void marshal(IMarshallingContext arg1) throws JiBXException {
        arg1.getMarshaller("org.alfresco.repo.dictionary.M2Model").marshal((Object)this, arg1);
    }
}

