/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.search.adaptor.QueryParserExpressionAdaptor;
import org.alfresco.repo.search.impl.querymodel.Column;
import org.alfresco.repo.search.impl.querymodel.Constraint;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Order;
import org.alfresco.repo.search.impl.querymodel.Ordering;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.Selector;
import org.alfresco.repo.search.impl.querymodel.Source;
import org.alfresco.repo.search.impl.querymodel.impl.BaseQuery;
import org.alfresco.repo.search.impl.querymodel.impl.SimpleConstraint;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilder;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.QueryBuilderContext;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.util.Pair;

public class LuceneQuery<Q, S, E extends Throwable>
extends BaseQuery
implements LuceneQueryBuilder<Q, S, E> {
    public LuceneQuery(List<Column> columns, Source source, Constraint constraint, List<Ordering> orderings) {
        super(columns, source, constraint, orderings);
    }

    @Override
    public Q buildQuery(Set<String> selectors, QueryBuilderContext<Q, S, E> luceneContext, FunctionEvaluationContext functionContext) throws E {
        Constraint constraint;
        QueryParserExpressionAdaptor<Q, E> expressionBuilder = luceneContext.getLuceneQueryParserAdaptor().getExpressionAdaptor();
        boolean must = false;
        boolean must_not = false;
        ArrayList<Pair> queriestoConjoin = new ArrayList<Pair>();
        if (selectors != null) {
            for (String selector : selectors) {
                Selector current = this.getSource().getSelector(selector);
                if (current instanceof LuceneQueryBuilderComponent) {
                    LuceneQueryBuilderComponent luceneQueryBuilderComponent = (LuceneQueryBuilderComponent)((Object)current);
                    Q selectorQuery = luceneQueryBuilderComponent.addComponent(selectors, null, luceneContext, functionContext);
                    queriestoConjoin.add(new Pair((Object)new SimpleConstraint(Constraint.Occur.MANDATORY), selectorQuery));
                    if (selectorQuery == null) continue;
                    expressionBuilder.addRequired(selectorQuery);
                    must = true;
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        if ((constraint = this.getConstraint()) != null) {
            if (constraint instanceof LuceneQueryBuilderComponent) {
                LuceneQueryBuilderComponent luceneQueryBuilderComponent = (LuceneQueryBuilderComponent)((Object)constraint);
                Q constraintQuery = luceneQueryBuilderComponent.addComponent(selectors, null, luceneContext, functionContext);
                queriestoConjoin.add(new Pair((Object)constraint, constraintQuery));
                if (constraintQuery != null) {
                    switch (constraint.getOccur()) {
                        case DEFAULT: 
                        case MANDATORY: {
                            expressionBuilder.addRequired(constraintQuery, constraint.getBoost());
                            must = true;
                            break;
                        }
                        case OPTIONAL: {
                            expressionBuilder.addOptional(constraintQuery, constraint.getBoost());
                            break;
                        }
                        case EXCLUDE: {
                            expressionBuilder.addExcluded(constraintQuery, constraint.getBoost());
                            must_not = true;
                        }
                    }
                }
            } else {
                throw new UnsupportedOperationException();
            }
        }
        if (!must && must_not) {
            expressionBuilder.addRequired(luceneContext.getLuceneQueryParserAdaptor().getMatchAllNodesQuery());
        }
        return expressionBuilder.getQuery();
    }

    @Override
    public S buildSort(Set<String> selectors, QueryBuilderContext<Q, S, E> luceneContext, FunctionEvaluationContext functionContext) throws E {
        if (this.getOrderings() == null || this.getOrderings().size() == 0) {
            return null;
        }
        return luceneContext.getLuceneQueryParserAdaptor().buildSort(this.getOrderings(), functionContext);
    }

    @Override
    public List<SearchParameters.SortDefinition> buildSortDefinitions(Set<String> selectors, QueryBuilderContext<Q, S, E> luceneContext, FunctionEvaluationContext functionContext) {
        if (this.getOrderings() == null || this.getOrderings().size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<SearchParameters.SortDefinition> definitions = new ArrayList<SearchParameters.SortDefinition>(this.getOrderings().size());
        for (Ordering ordering : this.getOrderings()) {
            if (ordering.getColumn().getFunction().getName().equals("PropertyAccessor")) {
                PropertyArgument property = (PropertyArgument)ordering.getColumn().getFunctionArguments().get("Property");
                if (property == null) {
                    throw new IllegalStateException();
                }
                String propertyName = property.getPropertyName();
                String fieldName = functionContext.getLuceneFieldName(propertyName);
                definitions.add(new SearchParameters.SortDefinition(SearchParameters.SortDefinition.SortType.FIELD, fieldName, ordering.getOrder() == Order.ASCENDING));
                continue;
            }
            if (!ordering.getColumn().getFunction().getName().equals("Score")) continue;
            definitions.add(new SearchParameters.SortDefinition(SearchParameters.SortDefinition.SortType.SCORE, null, ordering.getOrder() == Order.ASCENDING));
        }
        return definitions;
    }
}

