/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.alfresco.service.cmr.search.IntervalSet;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.I18NUtil;

public class SearchDateConversion {
    public static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");

    public static Pair<Date, Integer> parseDateString(String dateString) {
        try {
            Pair result = CachingDateFormat.lenientParse((String)dateString, (int)1);
            return result;
        }
        catch (ParseException e) {
            SimpleDateFormat oldDf = CachingDateFormat.getDateFormat();
            try {
                Date date = oldDf.parse(dateString);
                return new Pair((Object)date, (Object)13);
            }
            catch (ParseException ee) {
                if (dateString.equalsIgnoreCase("min")) {
                    Calendar cal = Calendar.getInstance(I18NUtil.getLocale());
                    cal.set(1, cal.getMinimum(1));
                    cal.set(6, cal.getMinimum(6));
                    cal.set(11, cal.getMinimum(11));
                    cal.set(12, cal.getMinimum(12));
                    cal.set(13, cal.getMinimum(13));
                    cal.set(14, cal.getMinimum(14));
                    return new Pair((Object)cal.getTime(), (Object)14);
                }
                if (dateString.equalsIgnoreCase("now")) {
                    return new Pair((Object)new Date(), (Object)14);
                }
                if (dateString.equalsIgnoreCase("today")) {
                    Calendar cal = Calendar.getInstance(I18NUtil.getLocale());
                    cal.setTime(new Date());
                    cal.set(11, cal.getMinimum(11));
                    cal.set(12, cal.getMinimum(12));
                    cal.set(13, cal.getMinimum(13));
                    cal.set(14, cal.getMinimum(14));
                    return new Pair((Object)cal.getTime(), (Object)5);
                }
                if (dateString.equalsIgnoreCase("max")) {
                    Calendar cal = Calendar.getInstance(I18NUtil.getLocale());
                    cal.set(1, cal.getMaximum(1));
                    cal.set(6, cal.getMaximum(6));
                    cal.set(11, cal.getMaximum(11));
                    cal.set(12, cal.getMaximum(12));
                    cal.set(13, cal.getMaximum(13));
                    cal.set(14, cal.getMaximum(14));
                    return new Pair((Object)cal.getTime(), (Object)14);
                }
                return null;
            }
        }
    }

    public static String getDateEnd(Pair<Date, Integer> dateAndResolution) {
        Calendar cal = Calendar.getInstance(I18NUtil.getLocale());
        cal.setTime((Date)dateAndResolution.getFirst());
        switch ((Integer)dateAndResolution.getSecond()) {
            case 1: {
                cal.set(2, cal.getActualMaximum(2));
            }
            case 2: {
                cal.set(5, cal.getActualMaximum(5));
            }
            case 5: {
                cal.set(11, cal.getActualMaximum(11));
            }
            case 11: {
                cal.set(12, cal.getActualMaximum(12));
            }
            case 12: {
                cal.set(13, cal.getActualMaximum(13));
            }
            case 13: {
                cal.set(14, cal.getActualMaximum(14));
            }
        }
        SimpleDateFormat formatter = CachingDateFormat.getSolrDatetimeFormat();
        formatter.setTimeZone(UTC_TIMEZONE);
        return formatter.format(cal.getTime());
    }

    public static String getDateStart(Pair<Date, Integer> dateAndResolution) {
        Calendar cal = Calendar.getInstance(I18NUtil.getLocale());
        cal.setTime((Date)dateAndResolution.getFirst());
        switch ((Integer)dateAndResolution.getSecond()) {
            case 1: {
                cal.set(2, cal.getActualMinimum(2));
            }
            case 2: {
                cal.set(5, cal.getActualMinimum(5));
            }
            case 5: {
                cal.set(11, cal.getActualMinimum(11));
            }
            case 11: {
                cal.set(12, cal.getActualMinimum(12));
            }
            case 12: {
                cal.set(13, cal.getActualMinimum(13));
            }
            case 13: {
                cal.set(14, cal.getActualMinimum(14));
            }
        }
        SimpleDateFormat formatter = CachingDateFormat.getSolrDatetimeFormat();
        formatter.setTimeZone(UTC_TIMEZONE);
        return formatter.format(cal.getTime());
    }

    public static IntervalSet parseDateInterval(IntervalSet theSet, boolean isDate) {
        if (isDate) {
            String start;
            Pair<Date, Integer> dateAndResolution1 = SearchDateConversion.parseDateString(theSet.getStart());
            Pair<Date, Integer> dateAndResolution2 = SearchDateConversion.parseDateString(theSet.getEnd());
            String string = dateAndResolution1 == null ? theSet.getStart() : (start = theSet.isStartInclusive() ? SearchDateConversion.getDateStart(dateAndResolution1) : SearchDateConversion.getDateEnd(dateAndResolution1));
            String end = dateAndResolution2 == null ? theSet.getEnd() : (theSet.isEndInclusive() ? SearchDateConversion.getDateEnd(dateAndResolution2) : SearchDateConversion.getDateStart(dateAndResolution2));
            return new IntervalSet(start, end, theSet.getLabel(), theSet.isStartInclusive(), theSet.isEndInclusive());
        }
        return theSet;
    }
}

