/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import org.alfresco.repo.search.MLAnalysisMode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PackedTokenAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;

public class MLTokenDuplicator
extends TokenStream {
    private static Log s_logger = LogFactory.getLog(MLTokenDuplicator.class);
    TokenStream source;
    Locale locale;
    Iterator<PackedTokenAttributeImpl> it;
    HashSet<String> prefixes;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    private final TypeAttribute typeAtt = (TypeAttribute)this.addAttribute(TypeAttribute.class);
    private final PositionIncrementAttribute posIncAtt = (PositionIncrementAttribute)this.addAttribute(PositionIncrementAttribute.class);
    private boolean done = false;

    public MLTokenDuplicator(TokenStream source, Locale locale, Reader reader, MLAnalysisMode mlAnalysisMode) {
        this.source = source;
        this.locale = locale;
        Set locales = MLAnalysisMode.getLocales((MLAnalysisMode)mlAnalysisMode, (Locale)locale, (boolean)false);
        this.prefixes = new HashSet(locales.size());
        for (Locale toAdd : locales) {
            String localeString = toAdd.toString();
            if (localeString.length() == 0) {
                this.prefixes.add("");
                continue;
            }
            StringBuilder builder = new StringBuilder(16);
            builder.append("{").append(localeString).append("}");
            this.prefixes.add(builder.toString());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Locale " + String.valueOf(locale) + " using " + String.valueOf(mlAnalysisMode) + " is " + String.valueOf(this.prefixes)));
        }
    }

    public MLTokenDuplicator(Locale locale, MLAnalysisMode mlAnalysisMode) {
        this.locale = locale;
        Set locales = MLAnalysisMode.getLocales((MLAnalysisMode)mlAnalysisMode, (Locale)locale, (boolean)false);
        this.prefixes = new HashSet(locales.size());
        for (Locale toAdd : locales) {
            String localeString = toAdd.toString();
            if (localeString.length() == 0) {
                this.prefixes.add("");
                continue;
            }
            StringBuilder builder = new StringBuilder(16);
            builder.append("{").append(localeString).append("}");
            this.prefixes.add(builder.toString());
        }
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Locale " + String.valueOf(locale) + " using " + String.valueOf(mlAnalysisMode) + " is " + String.valueOf(this.prefixes)));
        }
    }

    public void close() throws IOException {
        this.source.close();
        super.close();
    }

    public void reset() throws IOException {
        this.source.reset();
        super.reset();
    }

    public void end() throws IOException {
        this.source.end();
        super.end();
    }

    private PackedTokenAttributeImpl next() throws IOException {
        PackedTokenAttributeImpl t = null;
        if (this.it == null) {
            this.it = this.buildIterator();
        }
        if (this.it == null) {
            return null;
        }
        if (this.it.hasNext()) {
            t = this.it.next();
            return t;
        }
        this.it = null;
        t = this.next();
        return t;
    }

    private Iterator<PackedTokenAttributeImpl> buildIterator() throws IOException {
        if (!this.done && this.source.incrementToken()) {
            CharTermAttribute cta = (CharTermAttribute)this.source.getAttribute(CharTermAttribute.class);
            OffsetAttribute offsetAtt = (OffsetAttribute)this.source.getAttribute(OffsetAttribute.class);
            TypeAttribute typeAtt = null;
            if (this.source.hasAttribute(TypeAttribute.class)) {
                typeAtt = (TypeAttribute)this.source.getAttribute(TypeAttribute.class);
            }
            PositionIncrementAttribute posIncAtt = null;
            if (this.source.hasAttribute(PositionIncrementAttribute.class)) {
                posIncAtt = (PositionIncrementAttribute)this.source.getAttribute(PositionIncrementAttribute.class);
            }
            PackedTokenAttributeImpl token = new PackedTokenAttributeImpl();
            token.setEmpty().append((CharSequence)new String(cta.buffer()), 0, cta.length());
            token.setOffset(offsetAtt.startOffset(), offsetAtt.endOffset());
            if (typeAtt != null) {
                token.setType(typeAtt.type());
            }
            if (posIncAtt != null) {
                token.setPositionIncrement(posIncAtt.getPositionIncrement());
            }
            return this.buildIterator(token);
        }
        this.done = true;
        return this.buildIterator(null);
    }

    public Iterator<PackedTokenAttributeImpl> buildIterator(PackedTokenAttributeImpl token) {
        if (token == null) {
            return null;
        }
        ArrayList<PackedTokenAttributeImpl> tokens = new ArrayList<PackedTokenAttributeImpl>(this.prefixes.size());
        for (String prefix : this.prefixes) {
            PackedTokenAttributeImpl newToken = new PackedTokenAttributeImpl();
            newToken.setEmpty().append(prefix + this.termText(token));
            newToken.setOffset(token.startOffset(), token.endOffset());
            newToken.setType(token.type());
            if (tokens.size() == 0) {
                newToken.setPositionIncrement(token.getPositionIncrement());
            } else {
                newToken.setPositionIncrement(0);
            }
            tokens.add(newToken);
        }
        return tokens.iterator();
    }

    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        PackedTokenAttributeImpl next = this.next();
        if (next == null) {
            return false;
        }
        this.termAtt.copyBuffer(next.buffer(), 0, next.length());
        this.offsetAtt.setOffset(next.startOffset(), next.endOffset());
        this.typeAtt.setType(next.type());
        this.posIncAtt.setPositionIncrement(next.getPositionIncrement());
        return true;
    }

    private String termText(PackedTokenAttributeImpl token) {
        return new String(token.buffer(), 0, token.length());
    }
}

